/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.support.v4.view.TintableBackgroundView;
import android.view.View;
import android.view.ViewParent;
import java.lang.reflect.Field;

class ViewCompatBase {
    private static final String TAG = "ViewCompatBase";
    private static Field sMinHeightField;
    private static boolean sMinHeightFieldFetched;
    private static Field sMinWidthField;
    private static boolean sMinWidthFieldFetched;

    ViewCompatBase() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ColorStateList getBackgroundTintList(View view) {
        if (!(view instanceof TintableBackgroundView)) return null;
        return ((TintableBackgroundView)view).getSupportBackgroundTintList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PorterDuff.Mode getBackgroundTintMode(View view) {
        if (!(view instanceof TintableBackgroundView)) return null;
        return ((TintableBackgroundView)view).getSupportBackgroundTintMode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getMinimumHeight(View view) {
        if (!sMinHeightFieldFetched) {
            try {
                sMinHeightField = View.class.getDeclaredField("mMinHeight");
                sMinHeightField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            sMinHeightFieldFetched = true;
        }
        if (sMinHeightField == null) return 0;
        try {
            return (Integer)sMinHeightField.get(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getMinimumWidth(View view) {
        if (!sMinWidthFieldFetched) {
            try {
                sMinWidthField = View.class.getDeclaredField("mMinWidth");
                sMinWidthField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            sMinWidthFieldFetched = true;
        }
        if (sMinWidthField == null) return 0;
        try {
            return (Integer)sMinWidthField.get(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isAttachedToWindow(View view) {
        if (view.getWindowToken() == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isLaidOut(View view) {
        if (view.getWidth() <= 0) return false;
        if (view.getHeight() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void offsetLeftAndRight(View view, int n2) {
        block4: {
            block3: {
                int n3 = view.getLeft();
                view.offsetLeftAndRight(n2);
                if (n2 == 0) break block3;
                ViewParent viewParent = view.getParent();
                if (!(viewParent instanceof View)) break block4;
                n2 = Math.abs(n2);
                ((View)viewParent).invalidate(n3 - n2, view.getTop(), n3 + view.getWidth() + n2, view.getBottom());
            }
            return;
        }
        view.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void offsetTopAndBottom(View view, int n2) {
        block4: {
            block3: {
                int n3 = view.getTop();
                view.offsetTopAndBottom(n2);
                if (n2 == 0) break block3;
                ViewParent viewParent = view.getParent();
                if (!(viewParent instanceof View)) break block4;
                n2 = Math.abs(n2);
                ((View)viewParent).invalidate(view.getLeft(), n3 - n2, view.getRight(), n3 + view.getHeight() + n2);
            }
            return;
        }
        view.invalidate();
    }

    static void setBackgroundTintList(View view, ColorStateList colorStateList) {
        if (view instanceof TintableBackgroundView) {
            ((TintableBackgroundView)view).setSupportBackgroundTintList(colorStateList);
        }
    }

    static void setBackgroundTintMode(View view, PorterDuff.Mode mode) {
        if (view instanceof TintableBackgroundView) {
            ((TintableBackgroundView)view).setSupportBackgroundTintMode(mode);
        }
    }
}

