/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.DrawableRes;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final int INVALID_POINTER = -1;
    private static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE = false;
    private static final Interpolator sInterpolator;
    private static final ViewPositionComparator sPositionComparator;
    private int mActivePointerId = -1;
    private PagerAdapter mAdapter;
    private OnAdapterChangeListener mAdapterChangeListener;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    private int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mExpectedAdapterCount;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsScrollStarted;
    private boolean mIsUnableToDrag;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffectCompat mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private OnPageChangeListener mOnPageChangeListener;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private int mPageMargin;
    private PageTransformer mPageTransformer;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffectCompat mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private Method mSetChildrenDrawingOrderEnabled;
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        LAYOUT_ATTRS = new int[]{16842931};
        COMPARATOR = new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return itemInfo.position - itemInfo2.position;
            }
        };
        sInterpolator = new Interpolator(){

            public float getInterpolation(float f2) {
                return (f2 -= 1.0f) * (f2 * f2 * f2 * f2) + 1.0f;
            }
        };
        sPositionComparator = new ViewPositionComparator();
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new Runnable(){

            @Override
            public void run() {
                ViewPager.this.setScrollState(0);
                ViewPager.this.populate();
            }
        };
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initViewPager();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculatePageOffsets(ItemInfo itemInfo, int n2, ItemInfo itemInfo2) {
        float f2;
        int n3;
        int n4;
        float f3;
        float f4;
        int n5;
        int n6;
        block12: {
            block15: {
                block14: {
                    block13: {
                        n6 = this.mAdapter.getCount();
                        n5 = this.getClientWidth();
                        f4 = n5 > 0 ? (float)this.mPageMargin / (float)n5 : 0.0f;
                        if (itemInfo2 == null) break block12;
                        n5 = itemInfo2.position;
                        if (n5 >= itemInfo.position) break block13;
                        f3 = itemInfo2.offset + itemInfo2.widthFactor + f4;
                        ++n5;
                        n4 = 0;
                        break block14;
                    }
                    if (n5 <= itemInfo.position) break block12;
                    n4 = this.mItems.size() - 1;
                    f3 = itemInfo2.offset;
                    --n5;
                    break block15;
                }
                while (n5 <= itemInfo.position && n4 < this.mItems.size()) {
                    itemInfo2 = this.mItems.get(n4);
                    while (true) {
                        n3 = n5;
                        f2 = f3;
                        if (n5 <= itemInfo2.position) break;
                        n3 = n5;
                        f2 = f3;
                        if (n4 >= this.mItems.size() - 1) break;
                        itemInfo2 = this.mItems.get(++n4);
                    }
                    while (n3 < itemInfo2.position) {
                        f2 += this.mAdapter.getPageWidth(n3) + f4;
                        ++n3;
                    }
                    itemInfo2.offset = f2;
                    f3 = f2 + (itemInfo2.widthFactor + f4);
                    n5 = n3 + 1;
                }
                break block12;
            }
            while (n5 >= itemInfo.position && n4 >= 0) {
                itemInfo2 = this.mItems.get(n4);
                while (true) {
                    n3 = n5;
                    f2 = f3;
                    if (n5 >= itemInfo2.position) break;
                    n3 = n5;
                    f2 = f3;
                    if (n4 <= 0) break;
                    itemInfo2 = this.mItems.get(--n4);
                }
                while (n3 > itemInfo2.position) {
                    f2 -= this.mAdapter.getPageWidth(n3) + f4;
                    --n3;
                }
                itemInfo2.offset = f3 = f2 - (itemInfo2.widthFactor + f4);
                n5 = n3 - 1;
            }
        }
        n3 = this.mItems.size();
        f2 = itemInfo.offset;
        n5 = itemInfo.position - 1;
        f3 = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f3;
        f3 = itemInfo.position == n6 - 1 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f3;
        f3 = f2;
        for (n4 = n2 - 1; n4 >= 0; --n5, --n4) {
            itemInfo2 = this.mItems.get(n4);
            while (n5 > itemInfo2.position) {
                f3 -= this.mAdapter.getPageWidth(n5) + f4;
                --n5;
            }
            itemInfo2.offset = f3 -= itemInfo2.widthFactor + f4;
            if (itemInfo2.position != 0) continue;
            this.mFirstOffset = f3;
        }
        f3 = itemInfo.offset + itemInfo.widthFactor + f4;
        n4 = itemInfo.position + 1;
        n5 = n2 + 1;
        n2 = n4;
        while (true) {
            if (n5 >= n3) {
                this.mNeedCalculatePageOffsets = false;
                return;
            }
            itemInfo = this.mItems.get(n5);
            while (n2 < itemInfo.position) {
                f3 = this.mAdapter.getPageWidth(n2) + f4 + f3;
                ++n2;
            }
            if (itemInfo.position == n6 - 1) {
                this.mLastOffset = itemInfo.widthFactor + f3 - 1.0f;
            }
            itemInfo.offset = f3;
            f3 += itemInfo.widthFactor + f4;
            ++n2;
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void completeScroll(boolean bl2) {
        int n2;
        int n3;
        int n4 = this.mScrollState == 2 ? 1 : 0;
        if (n4 != 0) {
            this.setScrollingCacheEnabled(false);
            n3 = !this.mScroller.isFinished() ? 1 : 0;
            if (n3 != 0) {
                this.mScroller.abortAnimation();
                n3 = this.getScrollX();
                int n5 = this.getScrollY();
                n2 = this.mScroller.getCurrX();
                int n6 = this.mScroller.getCurrY();
                if (n3 != n2 || n5 != n6) {
                    this.scrollTo(n2, n6);
                    if (n2 != n3) {
                        this.pageScrolled(n2);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        n2 = 0;
        n3 = n4;
        for (n4 = n2; n4 < this.mItems.size(); ++n4) {
            ItemInfo itemInfo = this.mItems.get(n4);
            if (!itemInfo.scrolling) continue;
            itemInfo.scrolling = false;
            n3 = 1;
        }
        if (n3 == 0) return;
        if (bl2) {
            ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
            return;
        }
        this.mEndScrollRunnable.run();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int determineTargetPage(int n2, float f2, int n3, int n4) {
        if (Math.abs(n4) > this.mFlingDistance && Math.abs(n3) > this.mMinimumVelocity) {
            if (n3 <= 0) {
                ++n2;
            }
        } else {
            float f3 = n2 >= this.mCurItem ? 0.4f : 0.6f;
            n2 = (int)(f3 + ((float)n2 + f2));
        }
        n3 = n2;
        if (this.mItems.size() <= 0) return n3;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(this.mItems.size() - 1);
        return Math.max(itemInfo.position, Math.min(n2, itemInfo2.position));
    }

    private void dispatchOnPageScrolled(int n2, float f2, int n3) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(n2, f2, n3);
        }
        if (this.mOnPageChangeListeners != null) {
            int n4 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageScrolled(n2, f2, n3);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(n2, f2, n3);
        }
    }

    private void dispatchOnPageSelected(int n2) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n2);
        }
        if (this.mOnPageChangeListeners != null) {
            int n3 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageSelected(n2);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n2);
        }
    }

    private void dispatchOnScrollStateChanged(int n2) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(n2);
        }
        if (this.mOnPageChangeListeners != null) {
            int n3 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageScrollStateChanged(n2);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrollStateChanged(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enableLayers(boolean bl2) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = bl2 ? 2 : 0;
            ViewCompat.setLayerType(this.getChildAt(n3), n4, null);
            ++n3;
        }
        return;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        } else {
            rect.left = view.getLeft();
            rect.right = view.getRight();
            rect.top = view.getTop();
            rect.bottom = view.getBottom();
            for (view = view.getParent(); view instanceof ViewGroup && view != this; rect.left += view.getLeft(), rect.right += view.getRight(), rect.top += view.getTop(), rect.bottom += view.getBottom(), view = view.getParent()) {
                view = (ViewGroup)view;
            }
        }
        return rect;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ItemInfo infoForCurrentScrollPosition() {
        int n2 = this.getClientWidth();
        float f2 = n2 > 0 ? (float)this.getScrollX() / (float)n2 : 0.0f;
        float f3 = n2 > 0 ? (float)this.mPageMargin / (float)n2 : 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n3 = -1;
        n2 = 0;
        boolean bl2 = true;
        ItemInfo itemInfo = null;
        while (true) {
            ItemInfo itemInfo2 = itemInfo;
            if (n2 >= this.mItems.size()) return itemInfo2;
            ItemInfo itemInfo3 = this.mItems.get(n2);
            if (!bl2 && itemInfo3.position != n3 + 1) {
                itemInfo3 = this.mTempItem;
                itemInfo3.offset = f4 + f5 + f3;
                itemInfo3.position = n3 + 1;
                itemInfo3.widthFactor = this.mAdapter.getPageWidth(itemInfo3.position);
                --n2;
            }
            f5 = itemInfo3.offset;
            f4 = itemInfo3.widthFactor;
            if (!bl2) {
                itemInfo2 = itemInfo;
                if (!(f2 >= f5)) return itemInfo2;
            }
            if (f2 < f4 + f5 + f3) return itemInfo3;
            if (n2 == this.mItems.size() - 1) {
                return itemInfo3;
            }
            n3 = itemInfo3.position;
            f4 = itemInfo3.widthFactor;
            bl2 = false;
            ++n2;
            itemInfo = itemInfo3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGutterDrag(float f2, float f3) {
        if (f2 < (float)this.mGutterSize) {
            if (f3 > 0.0f) return true;
        }
        if (!(f2 > (float)(this.getWidth() - this.mGutterSize))) return false;
        if (!(f3 < 0.0f)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionIndex(motionEvent);
        if (MotionEventCompat.getPointerId(motionEvent, n2) == this.mActivePointerId) {
            n2 = n2 == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX(motionEvent, n2);
            this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n2);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pageScrolled(int n2) {
        boolean bl2 = false;
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return bl2;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (this.mCalledSuper) return bl2;
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        int n3 = this.getClientWidth();
        int n4 = this.mPageMargin;
        float f2 = (float)this.mPageMargin / (float)n3;
        int n5 = itemInfo.position;
        f2 = ((float)n2 / (float)n3 - itemInfo.offset) / (itemInfo.widthFactor + f2);
        n2 = (int)((float)(n4 + n3) * f2);
        this.mCalledSuper = false;
        this.onPageScrolled(n5, f2, n2);
        if (this.mCalledSuper) return true;
        throw new IllegalStateException("onPageScrolled did not call superclass implementation");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean performDrag(float f2) {
        boolean bl2;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        float f3 = this.mLastMotionX;
        this.mLastMotionX = f2;
        float f4 = (float)this.getScrollX() + (f3 - f2);
        int n2 = this.getClientWidth();
        f2 = (float)n2 * this.mFirstOffset;
        f3 = n2;
        float f5 = this.mLastOffset;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(this.mItems.size() - 1);
        if (itemInfo.position != 0) {
            f2 = itemInfo.offset * (float)n2;
            bl2 = false;
        } else {
            bl2 = true;
        }
        if (itemInfo2.position != this.mAdapter.getCount() - 1) {
            f3 = itemInfo2.offset * (float)n2;
            bl3 = false;
        } else {
            f3 *= f5;
        }
        if (f4 < f2) {
            f3 = f2;
            if (bl2) {
                bl5 = this.mLeftEdge.onPull(Math.abs(f2 - f4) / (float)n2);
                f3 = f2;
            }
        } else if (f4 > f3) {
            bl5 = bl4;
            if (bl3) {
                bl5 = this.mRightEdge.onPull(Math.abs(f4 - f3) / (float)n2);
            }
        } else {
            f3 = f4;
        }
        this.mLastMotionX += f3 - (float)((int)f3);
        this.scrollTo((int)f3, this.getScrollY());
        this.pageScrolled((int)f3);
        return bl5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        if (n3 > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
                return;
            }
            int n6 = this.getPaddingLeft();
            int n7 = this.getPaddingRight();
            int n8 = this.getPaddingLeft();
            int n9 = this.getPaddingRight();
            float f2 = (float)this.getScrollX() / (float)(n3 - n8 - n9 + n5);
            this.scrollTo((int)((float)(n2 - n6 - n7 + n4) * f2), this.getScrollY());
            return;
        }
        ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
        float f3 = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
        if ((n2 = (int)(f3 * (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()))) == this.getScrollX()) return;
        this.completeScroll(false);
        this.scrollTo(n2, this.getScrollY());
    }

    private void removeNonDecorViews() {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            int n3 = n2;
            if (!((LayoutParams)this.getChildAt((int)n2).getLayoutParams()).isDecor) {
                this.removeViewAt(n2);
                n3 = n2 - 1;
            }
            n2 = n3 + 1;
        }
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl2) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(bl2);
        }
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        return this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollToItem(int n2, boolean bl2, int n3, boolean bl3) {
        int n4;
        ItemInfo itemInfo = this.infoForPosition(n2);
        if (itemInfo != null) {
            float f2 = this.getClientWidth();
            n4 = (int)(Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset)) * f2);
        } else {
            n4 = 0;
        }
        if (bl2) {
            this.smoothScrollTo(n4, 0, n3);
            if (!bl3) return;
            this.dispatchOnPageSelected(n2);
            return;
        }
        if (bl3) {
            this.dispatchOnPageSelected(n2);
        }
        this.completeScroll(false);
        this.scrollTo(n4, 0);
        this.pageScrolled(n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setScrollState(int n2) {
        if (this.mScrollState == n2) {
            return;
        }
        this.mScrollState = n2;
        if (this.mPageTransformer != null) {
            boolean bl2 = n2 != 0;
            this.enableLayers(bl2);
        }
        this.dispatchOnScrollStateChanged(n2);
    }

    private void setScrollingCacheEnabled(boolean bl2) {
        if (this.mScrollingCacheEnabled != bl2) {
            this.mScrollingCacheEnabled = bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = this.getChildAt(i2);
                this.mDrawingOrderedChildren.add(view);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 == 262144) {
            if (n4 != arrayList.size()) return;
        }
        if (!this.isFocusable()) {
            return;
        }
        if ((n3 & 1) == 1 && this.isInTouchMode()) {
            if (!this.isFocusableInTouchMode()) return;
        }
        if (arrayList == null) return;
        arrayList.add((View)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo addNewItem(int n2, int n3) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n2;
        itemInfo.object = this.mAdapter.instantiateItem(this, n2);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n2);
        if (n3 < 0 || n3 >= this.mItems.size()) {
            this.mItems.add(itemInfo);
            return itemInfo;
        }
        this.mItems.add(n3, itemInfo);
        return itemInfo;
    }

    public void addOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(onPageChangeListener);
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        layoutParams2.isDecor |= view instanceof Decor;
        if (this.mInLayout) {
            if (layoutParams2 != null && layoutParams2.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams2.needsMeasure = true;
            this.addViewInLayout(view, n2, layoutParams);
            return;
        }
        super.addView(view, n2, layoutParams);
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrowScroll(int var1_1) {
        block14: {
            block12: {
                block15: {
                    block17: {
                        block9: {
                            block16: {
                                block10: {
                                    block11: {
                                        var2_2 = this.findFocus();
                                        if (var2_2 == this) {
                                            var3_3 = null;
lbl4:
                                            // 3 sources

                                            while (true) {
                                                var2_2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, var3_3, var1_1);
                                                if (var2_2 == null || var2_2 == var3_3) break block9;
                                                if (var1_1 != 17) break block10;
                                                var4_5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                                                var5_4 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var3_3).left;
                                                if (var3_3 != null && var4_5 >= var5_4) {
                                                    var6_7 = this.pageLeft();
lbl12:
                                                    // 7 sources

                                                    while (true) {
                                                        if (var6_7) {
                                                            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)var1_1));
                                                        }
                                                        return var6_7;
                                                    }
                                                }
                                                break block11;
                                                break;
                                            }
                                        }
                                        if (var2_2 == null) break block12;
                                        var3_3 = var2_2.getParent();
                                        while (var3_3 instanceof ViewGroup) {
                                            block13: {
                                                if (var3_3 == this) {
                                                    var5_4 = 1;
lbl22:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var5_4 != 0) break block12;
                                                        var7_8 = new StringBuilder();
                                                        var7_8.append(var2_2.getClass().getSimpleName());
                                                        var3_3 = var2_2.getParent();
                                                        while (var3_3 instanceof ViewGroup) {
                                                            var7_8.append(" => ").append(var3_3.getClass().getSimpleName());
                                                            var3_3 = var3_3.getParent();
                                                        }
                                                        break block13;
                                                        break;
                                                    }
                                                }
                                                var3_3 = var3_3.getParent();
                                                continue;
                                            }
                                            Log.e((String)"ViewPager", (String)("arrowScroll tried to find focus based on non-child current focused view " + var7_8.toString()));
                                            var3_3 = null;
                                            ** GOTO lbl4
                                        }
                                        break block14;
                                    }
                                    var6_7 = var2_2.requestFocus();
                                    ** GOTO lbl12
                                }
                                if (var1_1 != 66) break block15;
                                var5_4 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                                var4_6 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var3_3).left;
                                if (var3_3 == null || var5_4 > var4_6) break block16;
                                var6_7 = this.pageRight();
                                ** GOTO lbl12
                            }
                            var6_7 = var2_2.requestFocus();
                            ** GOTO lbl12
                        }
                        if (var1_1 != 17 && var1_1 != 1) break block17;
                        var6_7 = this.pageLeft();
                        ** GOTO lbl12
                    }
                    if (var1_1 != 66 && var1_1 != 2) break block15;
                    var6_7 = this.pageRight();
                    ** GOTO lbl12
                }
                var6_7 = false;
                ** while (true)
            }
            var3_3 = var2_2;
            ** while (true)
        }
        var5_4 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean beginFakeDrag() {
        boolean bl2 = false;
        if (this.mIsBeingDragged) {
            return bl2;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        boolean bl3 = true;
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = viewGroup.getChildCount() - 1; i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return bl3;
            }
        }
        if (!bl2) return false;
        bl2 = bl3;
        if (ViewCompat.canScrollHorizontally(view, -n2)) return bl2;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canScrollHorizontally(int n2) {
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.mAdapter == null) {
            return bl4;
        }
        int n3 = this.getClientWidth();
        int n4 = this.getScrollX();
        if (n2 < 0) {
            if (n4 <= (int)((float)n3 * this.mFirstOffset)) return false;
            return bl3;
        }
        if (n2 <= 0) return bl4;
        if (n4 >= (int)((float)n3 * this.mLastOffset)) return false;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) return false;
        if (!super.checkLayoutParams(layoutParams)) return false;
        return true;
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n2 = this.getScrollX();
            int n3 = this.getScrollY();
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                this.scrollTo(n4, n5);
                if (!this.pageScrolled(n4)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n5);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        int n2;
        this.mExpectedAdapterCount = n2 = this.mAdapter.getCount();
        int n3 = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < n2 ? 1 : 0;
        int n4 = this.mCurItem;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3;
        n3 = n4;
        n4 = n5;
        n5 = n6;
        while (true) {
            int n8;
            block8: {
                block10: {
                    block11: {
                        block6: {
                            ItemInfo itemInfo;
                            block9: {
                                block7: {
                                    if (n5 >= this.mItems.size()) break block6;
                                    itemInfo = this.mItems.get(n5);
                                    n6 = this.mAdapter.getItemPosition(itemInfo.object);
                                    if (n6 != -1) break block7;
                                    n6 = n5;
                                    n8 = n4;
                                    n5 = n7;
                                    n4 = n3;
                                    n3 = n8;
                                    n7 = n6;
                                    break block8;
                                }
                                if (n6 != -2) break block9;
                                this.mItems.remove(n5);
                                n7 = n5 - 1;
                                n5 = n4;
                                if (n4 == 0) {
                                    this.mAdapter.startUpdate(this);
                                    n5 = 1;
                                }
                                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
                                if (this.mCurItem != itemInfo.position) break block10;
                                n4 = Math.max(0, Math.min(this.mCurItem, n2 - 1));
                                n3 = n5;
                                n5 = 1;
                                break block8;
                            }
                            if (itemInfo.position == n6) break block11;
                            if (itemInfo.position == this.mCurItem) {
                                n3 = n6;
                            }
                            itemInfo.position = n6;
                            n6 = n3;
                            n8 = 1;
                            n7 = n5;
                            n3 = n4;
                            n4 = n6;
                            n5 = n8;
                            break block8;
                        }
                        if (n4 != 0) {
                            this.mAdapter.finishUpdate(this);
                        }
                        Collections.sort(this.mItems, COMPARATOR);
                        if (n7 != 0) {
                            n5 = this.getChildCount();
                            for (n4 = 0; n4 < n5; ++n4) {
                                LayoutParams layoutParams = (LayoutParams)this.getChildAt(n4).getLayoutParams();
                                if (layoutParams.isDecor) continue;
                                layoutParams.widthFactor = 0.0f;
                            }
                            this.setCurrentItemInternal(n3, false, true);
                            this.requestLayout();
                        }
                        return;
                    }
                    n8 = n5;
                    n6 = n3;
                    n5 = n7;
                    n7 = n8;
                    n3 = n4;
                    n4 = n6;
                    break block8;
                }
                n4 = n3;
                n6 = 1;
                n3 = n5;
                n5 = n6;
            }
            n6 = n5;
            n8 = n4;
            n5 = n7 + 1;
            n4 = n3;
            n3 = n8;
            n7 = n6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (super.dispatchKeyEvent(keyEvent)) return true;
        if (!this.executeKeyEvent(keyEvent)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl2 = false;
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n2 = this.getChildCount();
        int n3 = 0;
        while (true) {
            ItemInfo itemInfo;
            boolean bl3 = bl2;
            if (n3 >= n2) return bl3;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
            ++n3;
        }
    }

    float distanceInfluenceForSnapDuration(float f2) {
        return (float)Math.sin((float)((double)(f2 - 0.5f) * 0.4712389167638204));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n2 = 0;
        int n3 = 0;
        int n4 = ViewCompat.getOverScrollMode((View)this);
        if (n4 == 0 || n4 == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            if (!this.mLeftEdge.isFinished()) {
                n2 = canvas.save();
                n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                n3 = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n4 + this.getPaddingTop()), this.mFirstOffset * (float)n3);
                this.mLeftEdge.setSize(n4, n3);
                n3 = 0 | this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n2);
            }
            n2 = n3;
            if (!this.mRightEdge.isFinished()) {
                n4 = canvas.save();
                int n5 = this.getWidth();
                n2 = this.getHeight();
                int n6 = this.getPaddingTop();
                int n7 = this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(this.mLastOffset + 1.0f) * (float)n5);
                this.mRightEdge.setSize(n2 - n6 - n7, n5);
                n2 = n3 | this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n4);
            }
        } else {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        }
        if (n2 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        if (this.mAdapter != null) {
            Object object = this.mVelocityTracker;
            object.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
            int n2 = (int)VelocityTrackerCompat.getXVelocity(object, this.mActivePointerId);
            this.mPopulatePending = true;
            int n3 = this.getClientWidth();
            int n4 = this.getScrollX();
            object = this.infoForCurrentScrollPosition();
            this.setCurrentItemInternal(this.determineTargetPage(object.position, ((float)n4 / (float)n3 - object.offset) / object.widthFactor, n2, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n2);
        }
        this.endDrag();
        this.mFakeDragging = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (keyEvent.getAction() != 0) return bl3;
        switch (keyEvent.getKeyCode()) {
            default: {
                return bl2;
            }
            case 21: {
                return this.arrowScroll(17);
            }
            case 22: {
                return this.arrowScroll(66);
            }
            case 61: 
        }
        bl3 = bl2;
        if (Build.VERSION.SDK_INT < 11) return bl3;
        if (KeyEventCompat.hasNoModifiers(keyEvent)) {
            return this.arrowScroll(2);
        }
        bl3 = bl2;
        if (!KeyEventCompat.hasModifiers(keyEvent, 1)) return bl3;
        return this.arrowScroll(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fakeDragBy(float f2) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        if (this.mAdapter == null) {
            return;
        }
        this.mLastMotionX += f2;
        float f3 = (float)this.getScrollX() - f2;
        int n2 = this.getClientWidth();
        float f4 = n2;
        f2 = this.mFirstOffset;
        float f5 = n2;
        float f6 = this.mLastOffset;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(this.mItems.size() - 1);
        f2 = itemInfo.position != 0 ? itemInfo.offset * (float)n2 : f4 * f2;
        f5 = itemInfo2.position != this.mAdapter.getCount() - 1 ? itemInfo2.offset * (float)n2 : (f5 *= f6);
        if (!(f3 < f2)) {
            f2 = f3 > f5 ? f5 : f3;
        }
        this.mLastMotionX += f2 - (float)((int)f2);
        this.scrollTo((int)f2, this.getScrollY());
        this.pageScrolled((int)f2);
        long l2 = SystemClock.uptimeMillis();
        itemInfo2 = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l2, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement((MotionEvent)itemInfo2);
        itemInfo2.recycle();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        int n4 = n3;
        if (this.mDrawingOrder == 2) {
            n4 = n2 - 1 - n3;
        }
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n4).getLayoutParams()).childIndex;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForAnyChild(View object) {
        void var1_4;
        void var1_2;
        ViewParent viewParent;
        while ((viewParent = var1_2.getParent()) != this) {
            if (viewParent == null || !(viewParent instanceof View)) {
                Object var1_3 = null;
                return var1_4;
            }
            View view = (View)viewParent;
        }
        ItemInfo itemInfo = this.infoForChild((View)var1_2);
        return var1_4;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForChild(View object) {
        void var1_3;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject((View)object, itemInfo.object)) continue;
            ItemInfo itemInfo2 = itemInfo;
            return var1_3;
        }
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForPosition(int n2) {
        int n3 = 0;
        while (n3 < this.mItems.size()) {
            ItemInfo itemInfo = this.mItems.get(n3);
            if (itemInfo.position == n2) {
                return itemInfo;
            }
            ++n3;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
        this.mMinimumVelocity = (int)(400.0f * f2);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffectCompat(context);
        this.mRightEdge = new EdgeEffectCompat(context);
        this.mFlingDistance = (int)(25.0f * f2);
        this.mCloseEnough = (int)(2.0f * f2);
        this.mDefaultGutterSize = (int)(16.0f * f2);
        ViewCompat.setAccessibilityDelegate((View)this, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new OnApplyWindowInsetsListener(){
            private final Rect mTempRect = new Rect();

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WindowInsetsCompat onApplyWindowInsets(View object, WindowInsetsCompat windowInsetsCompat) {
                if (((WindowInsetsCompat)(object = ViewCompat.onApplyWindowInsets((View)object, windowInsetsCompat))).isConsumed()) {
                    return object;
                }
                Rect rect = this.mTempRect;
                rect.left = ((WindowInsetsCompat)object).getSystemWindowInsetLeft();
                rect.top = ((WindowInsetsCompat)object).getSystemWindowInsetTop();
                rect.right = ((WindowInsetsCompat)object).getSystemWindowInsetRight();
                rect.bottom = ((WindowInsetsCompat)object).getSystemWindowInsetBottom();
                int n2 = 0;
                int n3 = ViewPager.this.getChildCount();
                while (n2 < n3) {
                    windowInsetsCompat = ViewCompat.dispatchApplyWindowInsets(ViewPager.this.getChildAt(n2), (WindowInsetsCompat)object);
                    rect.left = Math.min(windowInsetsCompat.getSystemWindowInsetLeft(), rect.left);
                    rect.top = Math.min(windowInsetsCompat.getSystemWindowInsetTop(), rect.top);
                    rect.right = Math.min(windowInsetsCompat.getSystemWindowInsetRight(), rect.right);
                    rect.bottom = Math.min(windowInsetsCompat.getSystemWindowInsetBottom(), rect.bottom);
                    ++n2;
                }
                return ((WindowInsetsCompat)object).replaceSystemWindowInsets(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n2 = this.getScrollX();
            int n3 = this.getWidth();
            float f2 = (float)this.mPageMargin / (float)n3;
            Object object = this.mItems.get(0);
            float f3 = ((ItemInfo)object).offset;
            int n4 = this.mItems.size();
            int n5 = this.mItems.get((int)(n4 - 1)).position;
            int n6 = 0;
            for (int i2 = ((ItemInfo)object).position; i2 < n5; ++i2) {
                float f4;
                while (i2 > ((ItemInfo)object).position && n6 < n4) {
                    object = this.mItems;
                    object = (ItemInfo)((ArrayList)object).get(++n6);
                }
                if (i2 == ((ItemInfo)object).position) {
                    f4 = (((ItemInfo)object).offset + ((ItemInfo)object).widthFactor) * (float)n3;
                    f3 = ((ItemInfo)object).offset + ((ItemInfo)object).widthFactor + f2;
                } else {
                    float f5 = this.mAdapter.getPageWidth(i2);
                    f4 = (f3 + f5) * (float)n3;
                    f3 += f5 + f2;
                }
                if ((float)this.mPageMargin + f4 > (float)n2) {
                    this.mMarginDrawable.setBounds(Math.round(f4), this.mTopPageBounds, Math.round((float)this.mPageMargin + f4), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f4 > (float)(n2 + n3)) break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onInterceptTouchEvent(MotionEvent var1_1) {
        block14: {
            block15: {
                var2_2 = false;
                var3_3 = var1_1.getAction() & 255;
                if (var3_3 == 3 || var3_3 == 1) {
                    this.resetTouch();
                    var4_4 = var2_2;
lbl7:
                    // 5 sources

                    return var4_4;
                }
                if (var3_3 == 0) break block14;
                if (!this.mIsBeingDragged) break block15;
                var4_4 = true;
                ** GOTO lbl7
            }
            var4_4 = var2_2;
            if (this.mIsUnableToDrag) ** GOTO lbl7
        }
        switch (var3_3) lbl-1000:
        // 5 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    }
                    this.mVelocityTracker.addMovement(var1_1);
                    var4_4 = this.mIsBeingDragged;
                    ** GOTO lbl7
                    break;
                }
            }
            case 2: {
                var3_3 = this.mActivePointerId;
                if (var3_3 == -1) ** GOTO lbl-1000
                var3_3 = MotionEventCompat.findPointerIndex(var1_1, var3_3);
                var5_5 = MotionEventCompat.getX(var1_1, var3_3);
                var6_6 = var5_5 - this.mLastMotionX;
                var7_8 = Math.abs(var6_6);
                var8_9 = MotionEventCompat.getY(var1_1, var3_3);
                var9_10 = Math.abs(var8_9 - this.mInitialMotionY);
                if (var6_6 != 0.0f && !this.isGutterDrag(this.mLastMotionX, var6_6) && this.canScroll((View)this, false, (int)var6_6, (int)var5_5, (int)var8_9)) {
                    this.mLastMotionX = var5_5;
                    this.mLastMotionY = var8_9;
                    this.mIsUnableToDrag = true;
                    var4_4 = var2_2;
                    ** continue;
                }
                if (!(var7_8 > (float)this.mTouchSlop) || !(0.5f * var7_8 > var9_10)) ** GOTO lbl56
                this.mIsBeingDragged = true;
                this.requestParentDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                if (!(var6_6 > 0.0f)) ** GOTO lbl54
                var6_6 = this.mInitialMotionX + (float)this.mTouchSlop;
lbl46:
                // 2 sources

                while (true) {
                    this.mLastMotionX = var6_6;
                    this.mLastMotionY = var8_9;
                    this.setScrollingCacheEnabled(true);
lbl50:
                    // 3 sources

                    while (true) {
                        if (this.mIsBeingDragged && this.performDrag(var5_5)) {
                            ViewCompat.postInvalidateOnAnimation((View)this);
                        }
                        ** GOTO lbl-1000
                        break;
                    }
                    break;
                }
lbl54:
                // 1 sources

                var6_6 = this.mInitialMotionX - (float)this.mTouchSlop;
                ** continue;
lbl56:
                // 1 sources

                if (!(var9_10 > (float)this.mTouchSlop)) ** GOTO lbl50
                this.mIsUnableToDrag = true;
                ** continue;
            }
            case 0: {
                this.mInitialMotionX = var6_7 = var1_1.getX();
                this.mLastMotionX = var6_7;
                this.mInitialMotionY = var6_7 = var1_1.getY();
                this.mLastMotionY = var6_7;
                this.mActivePointerId = MotionEventCompat.getPointerId(var1_1, 0);
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState != 2 || Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) <= this.mCloseEnough) ** GOTO lbl77
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mIsBeingDragged = true;
                this.requestParentDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                ** GOTO lbl-1000
lbl77:
                // 1 sources

                this.completeScroll(false);
                this.mIsBeingDragged = false;
                ** GOTO lbl-1000
            }
            case 6: 
        }
        this.onSecondaryPointerUp(var1_1);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = this.getChildCount();
        int n7 = n4 - n2;
        int n8 = n5 - n3;
        n3 = this.getPaddingLeft();
        n2 = this.getPaddingTop();
        int n9 = this.getPaddingRight();
        n4 = this.getPaddingBottom();
        int n10 = this.getScrollX();
        int n11 = 0;
        int n12 = 0;
        while (true) {
            int n13;
            block16: {
                block15: {
                    LayoutParams layoutParams;
                    View view;
                    block14: {
                        int n14;
                        if (n12 >= n6) break block14;
                        view = this.getChildAt(n12);
                        if (view.getVisibility() == 8) break block15;
                        layoutParams = (LayoutParams)view.getLayoutParams();
                        if (!layoutParams.isDecor) break block15;
                        n5 = layoutParams.gravity;
                        int n15 = layoutParams.gravity;
                        switch (n5 & 7) {
                            default: {
                                n5 = n3;
                                n13 = n3;
                                break;
                            }
                            case 3: {
                                n13 = view.getMeasuredWidth();
                                n5 = n3;
                                n13 += n3;
                                break;
                            }
                            case 1: {
                                n5 = Math.max((n7 - view.getMeasuredWidth()) / 2, n3);
                                n13 = n3;
                                break;
                            }
                            case 5: {
                                n13 = view.getMeasuredWidth();
                                n5 = n9 + view.getMeasuredWidth();
                                n14 = n7 - n9 - n13;
                                n9 = n5;
                                n13 = n3;
                                n5 = n14;
                            }
                        }
                        switch (n15 & 0x70) {
                            default: {
                                n14 = n2;
                                n3 = n2;
                                n2 = n4;
                                n4 = n14;
                                break;
                            }
                            case 48: {
                                n14 = view.getMeasuredHeight();
                                n3 = n4;
                                n14 += n2;
                                n4 = n2;
                                n2 = n3;
                                n3 = n14;
                                break;
                            }
                            case 16: {
                                n14 = Math.max((n8 - view.getMeasuredHeight()) / 2, n2);
                                n3 = n2;
                                n2 = n4;
                                n4 = n14;
                                break;
                            }
                            case 80: {
                                n14 = n8 - n4 - view.getMeasuredHeight();
                                n15 = view.getMeasuredHeight();
                                n3 = n2;
                                n2 = n4 + n15;
                                n4 = n14;
                            }
                        }
                        view.layout(n5 += n10, n4, view.getMeasuredWidth() + n5, view.getMeasuredHeight() + n4);
                        n5 = n9;
                        n4 = n13;
                        n9 = n2;
                        n2 = ++n11;
                        break block16;
                    }
                    n9 = n7 - n3 - n9;
                    for (n5 = 0; n5 < n6; ++n5) {
                        ItemInfo itemInfo;
                        view = this.getChildAt(n5);
                        if (view.getVisibility() == 8) continue;
                        layoutParams = (LayoutParams)view.getLayoutParams();
                        if (layoutParams.isDecor || (itemInfo = this.infoForChild(view)) == null) continue;
                        float f2 = n9;
                        n13 = (int)(itemInfo.offset * f2) + n3;
                        if (layoutParams.needsMeasure) {
                            layoutParams.needsMeasure = false;
                            f2 = n9;
                            view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)(layoutParams.widthFactor * f2)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n8 - n2 - n4), (int)0x40000000));
                        }
                        view.layout(n13, n2, view.getMeasuredWidth() + n13, view.getMeasuredHeight() + n2);
                    }
                    this.mTopPageBounds = n2;
                    this.mBottomPageBounds = n8 - n4;
                    this.mDecorChildCount = n11;
                    if (this.mFirstLayout) {
                        this.scrollToItem(this.mCurItem, false, 0, false);
                    }
                    this.mFirstLayout = false;
                    return;
                }
                n5 = n11;
                n11 = n2;
                n13 = n3;
                n2 = n5;
                n5 = n9;
                n9 = n4;
                n3 = n11;
                n4 = n13;
            }
            ++n12;
            n13 = n4;
            n11 = n2;
            n2 = n3;
            n4 = n9;
            n9 = n5;
            n3 = n13;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block12: {
            block9: {
                block10: {
                    this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)var1_1), ViewPager.getDefaultSize((int)0, (int)var2_2));
                    var1_1 = this.getMeasuredWidth();
                    this.mGutterSize = Math.min(var1_1 / 10, this.mDefaultGutterSize);
                    var1_1 = var1_1 - this.getPaddingLeft() - this.getPaddingRight();
                    var2_2 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
                    var3_3 = this.getChildCount();
                    block0: for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                        block11: {
                            block13: {
                                block15: {
                                    block14: {
                                        var5_5 = this.getChildAt(var4_4);
                                        var6_6 = var1_1;
                                        var7_7 = var2_2;
                                        if (var5_5.getVisibility() == 8) ** GOTO lbl45
                                        var8_8 = (LayoutParams)var5_5.getLayoutParams();
                                        var6_6 = var1_1;
                                        var7_7 = var2_2;
                                        if (var8_8 == null) ** GOTO lbl45
                                        var6_6 = var1_1;
                                        var7_7 = var2_2;
                                        if (!var8_8.isDecor) ** GOTO lbl45
                                        var7_7 = var8_8.gravity & 7;
                                        var9_9 = var8_8.gravity & 112;
                                        var10_10 = -2147483648;
                                        var6_6 = -2147483648;
                                        if (var9_9 != 48 && var9_9 != 80) break block14;
                                        var9_9 = 1;
lbl25:
                                        // 2 sources

                                        while (var7_7 == 3 || var7_7 == 5) {
                                            var11_11 = true;
lbl27:
                                            // 2 sources

                                            while (var9_9 != 0) {
                                                var7_7 = 0x40000000;
lbl29:
                                                // 3 sources

                                                while (var8_8.width != -2) {
                                                    var10_10 = 0x40000000;
                                                    if (var8_8.width == -1) break block9;
                                                    var7_7 = var8_8.width;
lbl33:
                                                    // 3 sources

                                                    while (true) {
                                                        if (var8_8.height == -2) break block10;
                                                        var6_6 = var12_12 = 0x40000000;
                                                        if (var8_8.height == -1) break block10;
                                                        var13_13 = var8_8.height;
                                                        var6_6 = var12_12;
                                                        var12_12 = var13_13;
lbl40:
                                                        // 2 sources

                                                        while (true) {
                                                            var5_5.measure(View.MeasureSpec.makeMeasureSpec((int)var7_7, (int)var10_10), View.MeasureSpec.makeMeasureSpec((int)var12_12, (int)var6_6));
                                                            if (var9_9 == 0) break block11;
                                                            var7_7 = var2_2 - var5_5.getMeasuredHeight();
                                                            var6_6 = var1_1;
lbl45:
                                                            // 6 sources

                                                            while (true) {
                                                                var1_1 = var6_6;
                                                                var2_2 = var7_7;
                                                                continue block0;
                                                                break;
                                                            }
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                }
                                                break block12;
                                            }
                                            break block13;
                                        }
                                        break block15;
                                    }
                                    var9_9 = 0;
                                    ** GOTO lbl25
                                }
                                var11_11 = false;
                                ** GOTO lbl27
                            }
                            var7_7 = var10_10;
                            if (!var11_11) ** GOTO lbl29
                            var6_6 = 0x40000000;
                            var7_7 = var10_10;
                            ** GOTO lbl29
                        }
                        var6_6 = var1_1;
                        var7_7 = var2_2;
                        if (!var11_11) ** GOTO lbl45
                        var6_6 = var1_1 - var5_5.getMeasuredWidth();
                        var7_7 = var2_2;
                        ** continue;
                    }
                    this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var1_1, (int)0x40000000);
                    this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var2_2, (int)0x40000000);
                    this.mInLayout = true;
                    this.populate();
                    this.mInLayout = false;
                    var7_7 = this.getChildCount();
                    for (var2_2 = 0; var2_2 < var7_7; ++var2_2) {
                        var5_5 = this.getChildAt(var2_2);
                        if (var5_5.getVisibility() == 8 || (var8_8 = (LayoutParams)var5_5.getLayoutParams()) != null && var8_8.isDecor) continue;
                        var14_14 = var1_1;
                        var5_5.measure(View.MeasureSpec.makeMeasureSpec((int)((int)(var8_8.widthFactor * var14_14)), (int)0x40000000), this.mChildHeightMeasureSpec);
                    }
                    return;
                }
                var12_12 = var2_2;
                ** while (true)
            }
            var7_7 = var1_1;
            ** GOTO lbl33
        }
        var10_10 = var7_7;
        var7_7 = var1_1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @CallSuper
    protected void onPageScrolled(int n2, float f2, int n3) {
        int n4;
        if (this.mDecorChildCount > 0) {
            int n5 = this.getScrollX();
            n4 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = this.getWidth();
            int n8 = this.getChildCount();
            for (int i2 = 0; i2 < n8; ++i2) {
                int n9;
                int n10;
                View view = this.getChildAt(i2);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor) {
                    n10 = n4;
                    n9 = n6;
                } else {
                    int n11;
                    switch (layoutParams.gravity & 7) {
                        default: {
                            n10 = n4;
                            n9 = n6;
                            n6 = n4;
                            n4 = n9;
                            break;
                        }
                        case 3: {
                            n10 = view.getWidth();
                            n9 = n10 + n4;
                            n10 = n4;
                            n4 = n6;
                            n6 = n9;
                            break;
                        }
                        case 1: {
                            n10 = Math.max((n7 - view.getMeasuredWidth()) / 2, n4);
                            n9 = n4;
                            n4 = n6;
                            n6 = n9;
                            break;
                        }
                        case 5: {
                            n10 = n7 - n6 - view.getMeasuredWidth();
                            n11 = view.getMeasuredWidth();
                            n9 = n4;
                            n4 = n6 + n11;
                            n6 = n9;
                        }
                    }
                    n11 = n10 + n5 - view.getLeft();
                    n9 = n4;
                    n10 = n6;
                    if (n11 != 0) {
                        view.offsetLeftAndRight(n11);
                        n9 = n4;
                        n10 = n6;
                    }
                }
                n4 = n10;
                n6 = n9;
            }
        }
        this.dispatchOnPageScrolled(n2, f2, n3);
        if (this.mPageTransformer != null) {
            n3 = this.getScrollX();
            n4 = this.getChildCount();
            for (n2 = 0; n2 < n4; ++n2) {
                View view = this.getChildAt(n2);
                if (((LayoutParams)view.getLayoutParams()).isDecor) continue;
                f2 = (float)(view.getLeft() - n3) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage(view, f2);
            }
        }
        this.mCalledSuper = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        boolean bl2 = true;
        int n4 = -1;
        int n5 = this.getChildCount();
        if ((n2 & 2) != 0) {
            n4 = 1;
            n3 = 0;
        } else {
            n3 = n5 - 1;
            n5 = -1;
        }
        while (n3 != n5) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n2, rect)) {
                return bl2;
            }
            n3 += n4;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        SavedState savedState = (SavedState)((Object)object);
        super.onRestoreInstanceState(savedState.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(savedState.adapterState, savedState.loader);
            this.setCurrentItemInternal(savedState.position, false, true);
            return;
        }
        this.mRestoredCurItem = savedState.position;
        this.mRestoredAdapterState = savedState.adapterState;
        this.mRestoredClassLoader = savedState.loader;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.position = this.mCurItem;
        if (this.mAdapter != null) {
            savedState.adapterState = this.mAdapter.saveState();
        }
        return savedState;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            this.recomputeScrollPosition(n2, n4, this.mPageMargin, this.mPageMargin);
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl2 = false;
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null) return false;
        if (this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        boolean bl3 = bl2;
        int n2 = Integer.MIN_VALUE;
        block9: do {
            switch (n2 == Integer.MIN_VALUE ? motionEvent.getAction() & 0xFF : n2) {
                default: {
                    bl3 = bl2;
                    break;
                }
                case 0: {
                    float f2;
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mInitialMotionX = f2 = motionEvent.getX();
                    this.mLastMotionX = f2;
                    this.mInitialMotionY = f2 = motionEvent.getY();
                    this.mLastMotionY = f2;
                    this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                    bl3 = bl2;
                    break;
                }
                case 2: {
                    if (!this.mIsBeingDragged) {
                        int n3 = MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId);
                        if (n3 == -1) {
                            bl3 = this.resetTouch();
                            break;
                        }
                        float f3 = MotionEventCompat.getX(motionEvent, n3);
                        float f4 = Math.abs(f3 - this.mLastMotionX);
                        float f5 = MotionEventCompat.getY(motionEvent, n3);
                        float f6 = Math.abs(f5 - this.mLastMotionY);
                        if (f4 > (float)this.mTouchSlop && f4 > f6) {
                            this.mIsBeingDragged = true;
                            this.requestParentDisallowInterceptTouchEvent(true);
                            f3 = f3 - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                            this.mLastMotionX = f3;
                            this.mLastMotionY = f5;
                            this.setScrollState(1);
                            this.setScrollingCacheEnabled(true);
                            ViewParent viewParent = this.getParent();
                            if (viewParent != null) {
                                viewParent.requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    }
                    bl3 = bl2;
                    n2 = 4;
                    if (!this.mIsBeingDragged) continue block9;
                    bl3 = false | this.performDrag(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)));
                    break;
                }
                case 1: {
                    bl3 = bl2;
                    n2 = 4;
                    if (!this.mIsBeingDragged) continue block9;
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int n4 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                    this.mPopulatePending = true;
                    int n5 = this.getClientWidth();
                    int n6 = this.getScrollX();
                    ItemInfo itemInfo = this.infoForCurrentScrollPosition();
                    float f7 = (float)this.mPageMargin / (float)n5;
                    this.setCurrentItemInternal(this.determineTargetPage(itemInfo.position, ((float)n6 / (float)n5 - itemInfo.offset) / (itemInfo.widthFactor + f7), n4, (int)(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)) - this.mInitialMotionX)), true, true, n4);
                    bl3 = this.resetTouch();
                    break;
                }
                case 3: {
                    bl3 = bl2;
                    n2 = 4;
                    if (!this.mIsBeingDragged) continue block9;
                    this.scrollToItem(this.mCurItem, true, 0, false);
                    bl3 = this.resetTouch();
                    break;
                }
                case 5: {
                    int n7 = MotionEventCompat.getActionIndex(motionEvent);
                    this.mLastMotionX = MotionEventCompat.getX(motionEvent, n7);
                    this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n7);
                    bl3 = bl2;
                }
                case 4: {
                    break;
                }
                case 6: {
                    this.onSecondaryPointerUp(motionEvent);
                    this.mLastMotionX = MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId));
                    bl3 = bl2;
                }
            }
            break;
        } while (true);
        if (!bl3) return true;
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pageLeft() {
        boolean bl2 = true;
        if (this.mCurItem <= 0) return false;
        this.setCurrentItem(this.mCurItem - 1, true);
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pageRight() {
        boolean bl2 = true;
        if (this.mAdapter == null) return false;
        if (this.mCurItem >= this.mAdapter.getCount() - 1) return false;
        this.setCurrentItem(this.mCurItem + 1, true);
        return bl2;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate(int n2) {
        void var6_47;
        void var6_21;
        int n3;
        Object object;
        Object object2;
        block50: {
            int n4;
            block47: {
                float f2;
                void var6_13;
                int n5;
                void var6_11;
                int n6;
                int n7;
                int n8;
                block46: {
                    if (this.mCurItem != n2) {
                        object2 = this.infoForPosition(this.mCurItem);
                        this.mCurItem = n2;
                    } else {
                        object2 = null;
                    }
                    if (this.mAdapter == null) {
                        this.sortChildDrawingOrder();
                        return;
                    }
                    if (this.mPopulatePending) {
                        this.sortChildDrawingOrder();
                        return;
                    }
                    if (this.getWindowToken() == null) return;
                    this.mAdapter.startUpdate(this);
                    n2 = this.mOffscreenPageLimit;
                    n8 = Math.max(0, this.mCurItem - n2);
                    n7 = this.mAdapter.getCount();
                    n6 = Math.min(n7 - 1, n2 + this.mCurItem);
                    if (n7 != this.mExpectedAdapterCount) {
                        void var6_7;
                        try {
                            String string2 = this.getResources().getResourceName(this.getId());
                            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n7 + " Pager id: " + (String)var6_7 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                        }
                        catch (Resources.NotFoundException notFoundException) {
                            String string3 = Integer.toHexString(this.getId());
                            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n7 + " Pager id: " + (String)var6_7 + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
                        }
                    }
                    for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                        ItemInfo itemInfo = this.mItems.get(n2);
                        if (itemInfo.position < this.mCurItem) continue;
                        if (itemInfo.position != this.mCurItem) break;
                        break block46;
                    }
                    Object var6_51 = null;
                }
                object = var6_11 == null && n7 > 0 ? this.addNewItem(this.mCurItem, n2) : var6_11;
                if (object == null) break block50;
                int n9 = n2 - 1;
                if (n9 >= 0) {
                    ItemInfo itemInfo = this.mItems.get(n9);
                } else {
                    Object var6_24 = null;
                }
                float f3 = (n5 = this.getClientWidth()) <= 0 ? 0.0f : 2.0f - object.widthFactor + (float)this.getPaddingLeft() / (float)n5;
                n3 = this.mCurItem;
                float f4 = 0.0f;
                int n10 = n3 - 1;
                n4 = n2;
                void var15_60 = var6_13;
                while (true) {
                    void var6_28;
                    block48: {
                        block52: {
                            block53: {
                                block51: {
                                    if (n10 < 0) break block51;
                                    if (!(f4 >= f3) || n10 >= n8) break block52;
                                    if (var15_60 != null) break block53;
                                }
                                f2 = object.widthFactor;
                                n2 = n4 + 1;
                                if (f2 < 2.0f) {
                                    if (n2 < this.mItems.size()) {
                                        ItemInfo itemInfo = this.mItems.get(n2);
                                    } else {
                                        Object var6_34 = null;
                                    }
                                    f3 = n5 <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)n5 + 2.0f;
                                    n3 = this.mCurItem;
                                    ++n3;
                                    break;
                                }
                                break block47;
                            }
                            void var6_25 = var15_60;
                            n2 = n9;
                            f2 = f4;
                            n3 = n4;
                            if (n10 != var15_60.position) break block48;
                            void var6_26 = var15_60;
                            n2 = n9;
                            f2 = f4;
                            n3 = n4;
                            if (!var15_60.scrolling) {
                                this.mItems.remove(n9);
                                this.mAdapter.destroyItem(this, n10, var15_60.object);
                                n2 = n9 - 1;
                                n3 = n4 - 1;
                                if (n2 >= 0) {
                                    ItemInfo itemInfo = this.mItems.get(n2);
                                    f2 = f4;
                                    break block48;
                                } else {
                                    Object var6_29 = null;
                                    f2 = f4;
                                }
                            }
                            break block48;
                        }
                        if (var15_60 != null && n10 == var15_60.position) {
                            f2 = f4 + var15_60.widthFactor;
                            n2 = n9 - 1;
                            if (n2 >= 0) {
                                ItemInfo itemInfo = this.mItems.get(n2);
                                n3 = n4;
                            } else {
                                Object var6_31 = null;
                                n3 = n4;
                            }
                        } else {
                            f2 = f4 + this.addNewItem((int)n10, (int)(n9 + 1)).widthFactor;
                            n3 = n4 + 1;
                            if (n9 >= 0) {
                                ItemInfo itemInfo = this.mItems.get(n9);
                                n2 = n9;
                            } else {
                                Object var6_33 = null;
                                n2 = n9;
                            }
                        }
                    }
                    --n10;
                    var15_60 = var6_28;
                    n9 = n2;
                    f4 = f2;
                    n4 = n3;
                }
                while (n3 < n7) {
                    void var6_17;
                    if (f2 >= f3 && n3 > n6) {
                        if (var6_17 == null) break;
                        if (n3 == var6_17.position && !var6_17.scrolling) {
                            this.mItems.remove(n2);
                            this.mAdapter.destroyItem(this, n3, var6_17.object);
                            if (n2 < this.mItems.size()) {
                                ItemInfo itemInfo = this.mItems.get(n2);
                            } else {
                                Object var6_36 = null;
                            }
                        }
                    } else if (var6_17 != null && n3 == var6_17.position) {
                        f4 = var6_17.widthFactor;
                        if (++n2 < this.mItems.size()) {
                            ItemInfo itemInfo = this.mItems.get(n2);
                        } else {
                            Object var6_39 = null;
                        }
                        f2 += f4;
                    } else {
                        ItemInfo itemInfo = this.addNewItem(n3, n2);
                        f4 = itemInfo.widthFactor;
                        if (++n2 < this.mItems.size()) {
                            ItemInfo itemInfo2 = this.mItems.get(n2);
                        } else {
                            Object var6_43 = null;
                        }
                        f2 += f4;
                    }
                    ++n3;
                }
            }
            this.calculatePageOffsets((ItemInfo)object, n4, (ItemInfo)object2);
        }
        object2 = this.mAdapter;
        n2 = this.mCurItem;
        if (object != null) {
            Object object3 = object.object;
        } else {
            Object var6_44 = null;
        }
        ((PagerAdapter)object2).setPrimaryItem(this, n2, (Object)var6_21);
        this.mAdapter.finishUpdate(this);
        n3 = this.getChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = this.getChildAt(n2);
            LayoutParams layoutParams = (LayoutParams)object2.getLayoutParams();
            layoutParams.childIndex = n2;
            if (layoutParams.isDecor || layoutParams.widthFactor != 0.0f || (object2 = this.infoForChild((View)object2)) == null) continue;
            layoutParams.widthFactor = ((ItemInfo)object2).widthFactor;
            layoutParams.position = ((ItemInfo)object2).position;
        }
        this.sortChildDrawingOrder();
        if (!this.hasFocus()) return;
        View view = this.findFocus();
        if (view != null) {
            ItemInfo itemInfo = this.infoForAnyChild(view);
        } else {
            Object var6_50 = null;
        }
        if (var6_47 != null) {
            if (var6_47.position == this.mCurItem) return;
        }
        n2 = 0;
        while (n2 < this.getChildCount()) {
            object2 = this.getChildAt(n2);
            ItemInfo itemInfo = this.infoForChild((View)object2);
            if (itemInfo != null && itemInfo.position == this.mCurItem) {
                if (object2.requestFocus(2)) return;
            }
            ++n2;
        }
    }

    public void removeOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(onPageChangeListener);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
            return;
        }
        super.removeView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(PagerAdapter pagerAdapter) {
        Object object;
        if (this.mAdapter != null) {
            this.mAdapter.setViewPagerObserver(null);
            this.mAdapter.startUpdate(this);
            for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
                object = this.mItems.get(i2);
                this.mAdapter.destroyItem(this, ((ItemInfo)object).position, ((ItemInfo)object).object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        object = this.mAdapter;
        this.mAdapter = pagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean bl2 = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!bl2) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if (this.mAdapterChangeListener != null && object != pagerAdapter) {
            this.mAdapterChangeListener.onAdapterChanged((PagerAdapter)object, pagerAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setChildrenDrawingOrderEnabledCompat(boolean bl2) {
        if (Build.VERSION.SDK_INT < 7) return;
        if (this.mSetChildrenDrawingOrderEnabled == null) {
            try {
                this.mSetChildrenDrawingOrderEnabled = ViewGroup.class.getDeclaredMethod("setChildrenDrawingOrderEnabled", Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)TAG, (String)"Can't find setChildrenDrawingOrderEnabled", (Throwable)noSuchMethodException);
            }
        }
        try {
            this.mSetChildrenDrawingOrderEnabled.invoke((Object)this, bl2);
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error changing children drawing order", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        boolean bl2 = !this.mFirstLayout;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    public void setCurrentItem(int n2, boolean bl2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl2, false);
    }

    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3) {
        this.setCurrentItemInternal(n2, bl2, bl3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCurrentItemInternal(int n2, boolean bl2, boolean bl3, int n3) {
        int n4;
        boolean bl4 = false;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!bl3 && this.mCurItem == n2 && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (n2 < 0) {
            n4 = 0;
        } else {
            n4 = n2;
            if (n2 >= this.mAdapter.getCount()) {
                n4 = this.mAdapter.getCount() - 1;
            }
        }
        if (n4 > this.mCurItem + (n2 = this.mOffscreenPageLimit) || n4 < this.mCurItem - n2) {
            for (n2 = 0; n2 < this.mItems.size(); ++n2) {
                this.mItems.get((int)n2).scrolling = true;
            }
        }
        bl3 = bl4;
        if (this.mCurItem != n4) {
            bl3 = true;
        }
        if (!this.mFirstLayout) {
            this.populate(n4);
            this.scrollToItem(n4, bl2, n3, bl3);
            return;
        }
        this.mCurItem = n4;
        if (bl3) {
            this.dispatchOnPageSelected(n4);
        }
        this.requestLayout();
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        OnPageChangeListener onPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = onPageChangeListener;
        return onPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n2) {
        int n3 = n2;
        if (n2 < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n2 + " too small; defaulting to " + 1));
            n3 = 1;
        }
        if (n3 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n3;
            this.populate();
        }
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        this.mAdapterChangeListener = onAdapterChangeListener;
    }

    @Deprecated
    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setPageMargin(int n2) {
        int n3 = this.mPageMargin;
        this.mPageMargin = n2;
        int n4 = this.getWidth();
        this.recomputeScrollPosition(n4, n4, n2, n3);
        this.requestLayout();
    }

    public void setPageMarginDrawable(@DrawableRes int n2) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl2 = drawable2 == null;
        this.setWillNotDraw(bl2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageTransformer(boolean bl2, PageTransformer pageTransformer) {
        int n2 = 1;
        if (Build.VERSION.SDK_INT < 11) return;
        boolean bl3 = pageTransformer != null;
        boolean bl4 = this.mPageTransformer != null;
        boolean bl5 = bl3 != bl4;
        this.mPageTransformer = pageTransformer;
        this.setChildrenDrawingOrderEnabledCompat(bl3);
        if (bl3) {
            if (bl2) {
                n2 = 2;
            }
            this.mDrawingOrder = n2;
        } else {
            this.mDrawingOrder = 0;
        }
        if (bl5) {
            this.populate();
        }
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void smoothScrollTo(int n2, int n3, int n4) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n5 = this.mScroller != null && !this.mScroller.isFinished() ? 1 : 0;
        if (n5 != 0) {
            n5 = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
            this.setScrollingCacheEnabled(false);
        } else {
            n5 = this.getScrollX();
        }
        int n6 = this.getScrollY();
        int n7 = n2 - n5;
        if (n7 == 0 && (n3 -= n6) == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        n2 = this.getClientWidth();
        int n8 = n2 / 2;
        float f2 = Math.min(1.0f, (float)Math.abs(n7) * 1.0f / (float)n2);
        float f3 = n8;
        float f4 = n8;
        f2 = this.distanceInfluenceForSnapDuration(f2);
        n4 = Math.abs(n4);
        if (n4 > 0) {
            n2 = Math.round(1000.0f * Math.abs((f4 * f2 + f3) / (float)n4)) * 4;
        } else {
            f3 = n2;
            f4 = this.mAdapter.getPageWidth(this.mCurItem);
            n2 = (int)(((float)Math.abs(n7) / (f3 * f4 + (float)this.mPageMargin) + 1.0f) * 100.0f);
        }
        n2 = Math.min(n2, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(n5, n6, n7, n3, n2);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 != this.mMarginDrawable) return false;
        return true;
    }

    static interface Decor {
    }

    static class ItemInfo {
        Object object;
        float offset;
        int position;
        boolean scrolling;
        float widthFactor;

        ItemInfo() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int childIndex;
        public int gravity;
        public boolean isDecor;
        boolean needsMeasure;
        int position;
        float widthFactor = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = context.getInteger(0, 48);
            context.recycle();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean canScroll() {
            boolean bl2 = true;
            if (ViewPager.this.mAdapter == null) return false;
            if (ViewPager.this.mAdapter.getCount() <= 1) return false;
            return bl2;
        }

        @Override
        public void onInitializeAccessibilityEvent(View object, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent((View)object, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ViewPager.class.getName());
            object = AccessibilityEventCompat.asRecord(accessibilityEvent);
            ((AccessibilityRecordCompat)object).setScrollable(this.canScroll());
            if (accessibilityEvent.getEventType() == 4096 && ViewPager.this.mAdapter != null) {
                ((AccessibilityRecordCompat)object).setItemCount(ViewPager.this.mAdapter.getCount());
                ((AccessibilityRecordCompat)object).setFromIndex(ViewPager.this.mCurItem);
                ((AccessibilityRecordCompat)object).setToIndex(ViewPager.this.mCurItem);
            }
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName(ViewPager.class.getName());
            accessibilityNodeInfoCompat.setScrollable(this.canScroll());
            if (ViewPager.this.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean performAccessibilityAction(View view, int n2, Bundle bundle) {
            boolean bl2 = true;
            if (super.performAccessibilityAction(view, n2, bundle)) {
                return bl2;
            }
            switch (n2) {
                default: {
                    return false;
                }
                case 4096: {
                    if (!ViewPager.this.canScrollHorizontally(1)) return false;
                    ViewPager.this.setCurrentItem(ViewPager.this.mCurItem + 1);
                    return bl2;
                }
                case 8192: 
            }
            if (!ViewPager.this.canScrollHorizontally(-1)) return false;
            ViewPager.this.setCurrentItem(ViewPager.this.mCurItem - 1);
            return bl2;
        }
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(PagerAdapter var1, PagerAdapter var2);
    }

    public static interface OnPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator(new ParcelableCompatCreatorCallbacks<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        });
        Parcelable adapterState;
        ClassLoader loader;
        int position;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel);
            ClassLoader classLoader2 = classLoader;
            if (classLoader == null) {
                classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader2);
            this.loader = classLoader2;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.position);
            parcel.writeParcelable(this.adapterState, n2);
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrollStateChanged(int n2) {
        }

        @Override
        public void onPageScrolled(int n2, float f2, int n3) {
        }

        @Override
        public void onPageSelected(int n2) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(View object, View object2) {
            void var2_3;
            LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
            LayoutParams layoutParams2 = (LayoutParams)var2_3.getLayoutParams();
            if (layoutParams.isDecor == layoutParams2.isDecor) return layoutParams.position - layoutParams2.position;
            if (!layoutParams.isDecor) return -1;
            return 1;
        }
    }
}

