/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityWindowInfoCompatApi21;

public class AccessibilityWindowInfoCompat {
    private static final AccessibilityWindowInfoImpl IMPL;
    public static final int TYPE_ACCESSIBILITY_OVERLAY = 4;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_INPUT_METHOD = 2;
    public static final int TYPE_SYSTEM = 3;
    private static final int UNDEFINED = -1;
    private Object mInfo;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 21) {
            IMPL = new AccessibilityWindowInfoApi21Impl();
            return;
        }
        IMPL = new AccessibilityWindowInfoStubImpl();
    }

    private AccessibilityWindowInfoCompat(Object object) {
        this.mInfo = object;
    }

    public static AccessibilityWindowInfoCompat obtain() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityWindowInfoCompat obtain(AccessibilityWindowInfoCompat accessibilityWindowInfoCompat) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain(accessibilityWindowInfoCompat.mInfo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String typeToString(int n2) {
        switch (n2) {
            default: {
                return "<UNKNOWN>";
            }
            case 1: {
                return "TYPE_APPLICATION";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 3: {
                return "TYPE_SYSTEM";
            }
            case 4: 
        }
        return "TYPE_ACCESSIBILITY_OVERLAY";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AccessibilityWindowInfoCompat wrapNonNullInstance(Object object) {
        if (object == null) return null;
        return new AccessibilityWindowInfoCompat(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl2 = true;
        if (this == object) {
            return bl2;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AccessibilityWindowInfoCompat)object;
        if (this.mInfo == null) {
            if (((AccessibilityWindowInfoCompat)object).mInfo == null) return bl2;
            return false;
        }
        if (this.mInfo.equals(((AccessibilityWindowInfoCompat)object).mInfo)) return bl2;
        return false;
    }

    public void getBoundsInScreen(Rect rect) {
        IMPL.getBoundsInScreen(this.mInfo, rect);
    }

    public AccessibilityWindowInfoCompat getChild(int n2) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, n2));
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public int getId() {
        return IMPL.getId(this.mInfo);
    }

    public int getLayer() {
        return IMPL.getLayer(this.mInfo);
    }

    public AccessibilityWindowInfoCompat getParent() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public AccessibilityNodeInfoCompat getRoot() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getRoot(this.mInfo));
    }

    public int getType() {
        return IMPL.getType(this.mInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        if (this.mInfo != null) return this.mInfo.hashCode();
        return 0;
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public boolean isActive() {
        return IMPL.isActive(this.mInfo);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = new Rect();
        this.getBoundsInScreen((Rect)object);
        stringBuilder.append("AccessibilityWindowInfo[");
        stringBuilder.append("id=").append(this.getId());
        stringBuilder.append(", type=").append(AccessibilityWindowInfoCompat.typeToString(this.getType()));
        stringBuilder.append(", layer=").append(this.getLayer());
        stringBuilder.append(", bounds=").append(object);
        stringBuilder.append(", focused=").append(this.isFocused());
        stringBuilder.append(", active=").append(this.isActive());
        object = stringBuilder.append(", hasParent=");
        boolean bl3 = this.getParent() != null;
        ((StringBuilder)object).append(bl3);
        object = stringBuilder.append(", hasChildren=");
        bl3 = this.getChildCount() > 0 ? bl2 : false;
        ((StringBuilder)object).append(bl3);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static class AccessibilityWindowInfoApi21Impl
    extends AccessibilityWindowInfoStubImpl {
        private AccessibilityWindowInfoApi21Impl() {
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
            AccessibilityWindowInfoCompatApi21.getBoundsInScreen(object, rect);
        }

        @Override
        public Object getChild(Object object, int n2) {
            return AccessibilityWindowInfoCompatApi21.getChild(object, n2);
        }

        @Override
        public int getChildCount(Object object) {
            return AccessibilityWindowInfoCompatApi21.getChildCount(object);
        }

        @Override
        public int getId(Object object) {
            return AccessibilityWindowInfoCompatApi21.getId(object);
        }

        @Override
        public int getLayer(Object object) {
            return AccessibilityWindowInfoCompatApi21.getLayer(object);
        }

        @Override
        public Object getParent(Object object) {
            return AccessibilityWindowInfoCompatApi21.getParent(object);
        }

        @Override
        public Object getRoot(Object object) {
            return AccessibilityWindowInfoCompatApi21.getRoot(object);
        }

        @Override
        public int getType(Object object) {
            return AccessibilityWindowInfoCompatApi21.getType(object);
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return AccessibilityWindowInfoCompatApi21.isAccessibilityFocused(object);
        }

        @Override
        public boolean isActive(Object object) {
            return AccessibilityWindowInfoCompatApi21.isActive(object);
        }

        @Override
        public boolean isFocused(Object object) {
            return AccessibilityWindowInfoCompatApi21.isFocused(object);
        }

        @Override
        public Object obtain() {
            return AccessibilityWindowInfoCompatApi21.obtain();
        }

        @Override
        public Object obtain(Object object) {
            return AccessibilityWindowInfoCompatApi21.obtain(object);
        }

        @Override
        public void recycle(Object object) {
            AccessibilityWindowInfoCompatApi21.recycle(object);
        }
    }

    private static interface AccessibilityWindowInfoImpl {
        public void getBoundsInScreen(Object var1, Rect var2);

        public Object getChild(Object var1, int var2);

        public int getChildCount(Object var1);

        public int getId(Object var1);

        public int getLayer(Object var1);

        public Object getParent(Object var1);

        public Object getRoot(Object var1);

        public int getType(Object var1);

        public boolean isAccessibilityFocused(Object var1);

        public boolean isActive(Object var1);

        public boolean isFocused(Object var1);

        public Object obtain();

        public Object obtain(Object var1);

        public void recycle(Object var1);
    }

    private static class AccessibilityWindowInfoStubImpl
    implements AccessibilityWindowInfoImpl {
        private AccessibilityWindowInfoStubImpl() {
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public Object getChild(Object object, int n2) {
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            return 0;
        }

        @Override
        public int getId(Object object) {
            return -1;
        }

        @Override
        public int getLayer(Object object) {
            return -1;
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public Object getRoot(Object object) {
            return null;
        }

        @Override
        public int getType(Object object) {
            return -1;
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return true;
        }

        @Override
        public boolean isActive(Object object) {
            return true;
        }

        @Override
        public boolean isFocused(Object object) {
            return true;
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(Object object) {
            return null;
        }

        @Override
        public void recycle(Object object) {
        }
    }
}

