/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.animation;

import android.view.animation.Interpolator;

abstract class LookupTableInterpolator
implements Interpolator {
    private final float mStepSize;
    private final float[] mValues;

    public LookupTableInterpolator(float[] fArray) {
        this.mValues = fArray;
        this.mStepSize = 1.0f / (float)(this.mValues.length - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getInterpolation(float f2) {
        float f3 = 1.0f;
        if (f2 >= 1.0f) {
            return f3;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        int n2 = Math.min((int)((float)(this.mValues.length - 1) * f2), this.mValues.length - 2);
        f3 = (f2 - (float)n2 * this.mStepSize) / this.mStepSize;
        f2 = this.mValues[n2];
        return (this.mValues[n2 + 1] - this.mValues[n2]) * f3 + f2;
    }
}

