/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.os.Build;
import android.support.v4.widget.PopupWindowCompatApi21;
import android.support.v4.widget.PopupWindowCompatApi23;
import android.support.v4.widget.PopupWindowCompatGingerbread;
import android.support.v4.widget.PopupWindowCompatKitKat;
import android.view.View;
import android.widget.PopupWindow;

public final class PopupWindowCompat {
    static final PopupWindowImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 23) {
            IMPL = new Api23PopupWindowImpl();
            return;
        }
        if (n2 >= 21) {
            IMPL = new Api21PopupWindowImpl();
            return;
        }
        if (n2 >= 19) {
            IMPL = new KitKatPopupWindowImpl();
            return;
        }
        if (n2 >= 9) {
            IMPL = new GingerbreadPopupWindowImpl();
            return;
        }
        IMPL = new BasePopupWindowImpl();
    }

    private PopupWindowCompat() {
    }

    public static boolean getOverlapAnchor(PopupWindow popupWindow) {
        return IMPL.getOverlapAnchor(popupWindow);
    }

    public static int getWindowLayoutType(PopupWindow popupWindow) {
        return IMPL.getWindowLayoutType(popupWindow);
    }

    public static void setOverlapAnchor(PopupWindow popupWindow, boolean bl2) {
        IMPL.setOverlapAnchor(popupWindow, bl2);
    }

    public static void setWindowLayoutType(PopupWindow popupWindow, int n2) {
        IMPL.setWindowLayoutType(popupWindow, n2);
    }

    public static void showAsDropDown(PopupWindow popupWindow, View view, int n2, int n3, int n4) {
        IMPL.showAsDropDown(popupWindow, view, n2, n3, n4);
    }

    static class Api21PopupWindowImpl
    extends KitKatPopupWindowImpl {
        Api21PopupWindowImpl() {
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi21.getOverlapAnchor(popupWindow);
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean bl2) {
            PopupWindowCompatApi21.setOverlapAnchor(popupWindow, bl2);
        }
    }

    static class Api23PopupWindowImpl
    extends Api21PopupWindowImpl {
        Api23PopupWindowImpl() {
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getOverlapAnchor(popupWindow);
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getWindowLayoutType(popupWindow);
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean bl2) {
            PopupWindowCompatApi23.setOverlapAnchor(popupWindow, bl2);
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int n2) {
            PopupWindowCompatApi23.setWindowLayoutType(popupWindow, n2);
        }
    }

    static class BasePopupWindowImpl
    implements PopupWindowImpl {
        BasePopupWindowImpl() {
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return false;
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return 0;
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean bl2) {
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int n2) {
        }

        @Override
        public void showAsDropDown(PopupWindow popupWindow, View view, int n2, int n3, int n4) {
            popupWindow.showAsDropDown(view, n2, n3);
        }
    }

    static class GingerbreadPopupWindowImpl
    extends BasePopupWindowImpl {
        GingerbreadPopupWindowImpl() {
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return PopupWindowCompatGingerbread.getWindowLayoutType(popupWindow);
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int n2) {
            PopupWindowCompatGingerbread.setWindowLayoutType(popupWindow, n2);
        }
    }

    static class KitKatPopupWindowImpl
    extends GingerbreadPopupWindowImpl {
        KitKatPopupWindowImpl() {
        }

        @Override
        public void showAsDropDown(PopupWindow popupWindow, View view, int n2, int n3, int n4) {
            PopupWindowCompatKitKat.showAsDropDown(popupWindow, view, n2, n3, n4);
        }
    }

    static interface PopupWindowImpl {
        public boolean getOverlapAnchor(PopupWindow var1);

        public int getWindowLayoutType(PopupWindow var1);

        public void setOverlapAnchor(PopupWindow var1, boolean var2);

        public void setWindowLayoutType(PopupWindow var1, int var2);

        public void showAsDropDown(PopupWindow var1, View var2, int var3, int var4, int var5);
    }
}

