/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.SystemClock;
import android.support.v4.app.NotificationBuilderWithBuilderAccessor;
import android.support.v4.app.NotificationCompatBase;
import android.support.v7.appcompat.R;
import android.widget.RemoteViews;
import java.text.NumberFormat;
import java.util.List;

class NotificationCompatImplBase {
    static final int MAX_MEDIA_BUTTONS = 5;
    static final int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;

    NotificationCompatImplBase() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static RemoteViews applyStandardTemplate(Context context, CharSequence object, CharSequence charSequence, CharSequence charSequence2, int n2, Bitmap bitmap, CharSequence charSequence3, boolean bl2, long l2, int n3, boolean bl3) {
        RemoteViews remoteViews = new RemoteViews(context.getPackageName(), n3);
        n3 = 0;
        int n4 = 0;
        if (bitmap != null && Build.VERSION.SDK_INT >= 16) {
            remoteViews.setViewVisibility(R.id.icon, 0);
            remoteViews.setImageViewBitmap(R.id.icon, bitmap);
        } else {
            remoteViews.setViewVisibility(R.id.icon, 8);
        }
        if (object != null) {
            remoteViews.setTextViewText(R.id.title, (CharSequence)object);
        }
        if (charSequence != null) {
            remoteViews.setTextViewText(R.id.text, charSequence);
            n3 = 1;
        }
        if (charSequence2 != null) {
            remoteViews.setTextViewText(R.id.info, charSequence2);
            remoteViews.setViewVisibility(R.id.info, 0);
            n2 = 1;
        } else if (n2 > 0) {
            if (n2 > context.getResources().getInteger(R.integer.status_bar_notification_info_maxnum)) {
                remoteViews.setTextViewText(R.id.info, (CharSequence)context.getResources().getString(R.string.status_bar_notification_info_overflow));
            } else {
                object = NumberFormat.getIntegerInstance();
                remoteViews.setTextViewText(R.id.info, (CharSequence)((NumberFormat)object).format(n2));
            }
            remoteViews.setViewVisibility(R.id.info, 0);
            n2 = 1;
        } else {
            remoteViews.setViewVisibility(R.id.info, 8);
            n2 = n3;
        }
        n3 = n4;
        if (charSequence3 != null) {
            n3 = n4;
            if (Build.VERSION.SDK_INT >= 16) {
                remoteViews.setTextViewText(R.id.text, charSequence3);
                if (charSequence != null) {
                    remoteViews.setTextViewText(R.id.text2, charSequence);
                    remoteViews.setViewVisibility(R.id.text2, 0);
                    n3 = 1;
                } else {
                    remoteViews.setViewVisibility(R.id.text2, 8);
                    n3 = n4;
                }
            }
        }
        if (n3 != 0 && Build.VERSION.SDK_INT >= 16) {
            if (bl3) {
                float f2 = context.getResources().getDimensionPixelSize(R.dimen.notification_subtext_size);
                remoteViews.setTextViewTextSize(R.id.text, 0, f2);
            }
            remoteViews.setViewPadding(R.id.line1, 0, 0, 0, 0);
        }
        if (l2 != 0L) {
            if (bl2) {
                remoteViews.setViewVisibility(R.id.chronometer, 0);
                remoteViews.setLong(R.id.chronometer, "setBase", SystemClock.elapsedRealtime() - System.currentTimeMillis() + l2);
                remoteViews.setBoolean(R.id.chronometer, "setStarted", true);
            } else {
                remoteViews.setViewVisibility(R.id.time, 0);
                remoteViews.setLong(R.id.time, "setTime", l2);
            }
        }
        n3 = R.id.line3;
        n2 = n2 != 0 ? 0 : 8;
        remoteViews.setViewVisibility(n3, n2);
        return remoteViews;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends NotificationCompatBase.Action> RemoteViews generateBigContentView(Context context, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n2, Bitmap bitmap, CharSequence charSequence4, boolean bl2, long l2, List<T> list, boolean bl3, PendingIntent pendingIntent) {
        int n3 = Math.min(list.size(), 5);
        charSequence2 = NotificationCompatImplBase.applyStandardTemplate(context, charSequence, charSequence2, charSequence3, n2, bitmap, charSequence4, bl2, l2, NotificationCompatImplBase.getBigLayoutResource(n3), false);
        charSequence2.removeAllViews(R.id.media_actions);
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                charSequence = NotificationCompatImplBase.generateMediaActionButton(context, (NotificationCompatBase.Action)list.get(n2));
                charSequence2.addView(R.id.media_actions, (RemoteViews)charSequence);
            }
        }
        if (bl3) {
            charSequence2.setViewVisibility(R.id.cancel_action, 0);
            charSequence2.setInt(R.id.cancel_action, "setAlpha", context.getResources().getInteger(R.integer.cancel_button_image_alpha));
            charSequence2.setOnClickPendingIntent(R.id.cancel_action, pendingIntent);
            return charSequence2;
        }
        charSequence2.setViewVisibility(R.id.cancel_action, 8);
        return charSequence2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T extends NotificationCompatBase.Action> RemoteViews generateContentView(Context context, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n2, Bitmap bitmap, CharSequence charSequence4, boolean bl2, long l2, List<T> list, int[] nArray, boolean bl3, PendingIntent pendingIntent) {
        charSequence = NotificationCompatImplBase.applyStandardTemplate(context, charSequence, charSequence2, charSequence3, n2, bitmap, charSequence4, bl2, l2, R.layout.notification_template_media, true);
        int n3 = list.size();
        n2 = nArray == null ? 0 : Math.min(nArray.length, 3);
        charSequence.removeAllViews(R.id.media_actions);
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 >= n3) {
                    throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", i2, n3 - 1));
                }
                charSequence2 = NotificationCompatImplBase.generateMediaActionButton(context, (NotificationCompatBase.Action)list.get(nArray[i2]));
                charSequence.addView(R.id.media_actions, (RemoteViews)charSequence2);
            }
        }
        if (bl3) {
            charSequence.setViewVisibility(R.id.end_padder, 8);
            charSequence.setViewVisibility(R.id.cancel_action, 0);
            charSequence.setOnClickPendingIntent(R.id.cancel_action, pendingIntent);
            charSequence.setInt(R.id.cancel_action, "setAlpha", context.getResources().getInteger(R.integer.cancel_button_image_alpha));
            return charSequence;
        }
        charSequence.setViewVisibility(R.id.end_padder, 0);
        charSequence.setViewVisibility(R.id.cancel_action, 8);
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static RemoteViews generateMediaActionButton(Context context, NotificationCompatBase.Action action) {
        boolean bl2 = action.getActionIntent() == null;
        context = new RemoteViews(context.getPackageName(), R.layout.notification_media_action);
        context.setImageViewResource(R.id.action0, action.getIcon());
        if (!bl2) {
            context.setOnClickPendingIntent(R.id.action0, action.getActionIntent());
        }
        if (Build.VERSION.SDK_INT >= 15) {
            context.setContentDescription(R.id.action0, action.getTitle());
        }
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getBigLayoutResource(int n2) {
        if (n2 > 3) return R.layout.notification_template_big_media;
        return R.layout.notification_template_big_media_narrow;
    }

    public static <T extends NotificationCompatBase.Action> void overrideBigContentView(Notification notification, Context context, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n2, Bitmap bitmap, CharSequence charSequence4, boolean bl2, long l2, List<T> list, boolean bl3, PendingIntent pendingIntent) {
        notification.bigContentView = NotificationCompatImplBase.generateBigContentView(context, charSequence, charSequence2, charSequence3, n2, bitmap, charSequence4, bl2, l2, list, bl3, pendingIntent);
        if (bl3) {
            notification.flags |= 2;
        }
    }

    public static <T extends NotificationCompatBase.Action> void overrideContentView(NotificationBuilderWithBuilderAccessor notificationBuilderWithBuilderAccessor, Context context, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n2, Bitmap bitmap, CharSequence charSequence4, boolean bl2, long l2, List<T> list, int[] nArray, boolean bl3, PendingIntent pendingIntent) {
        context = NotificationCompatImplBase.generateContentView(context, charSequence, charSequence2, charSequence3, n2, bitmap, charSequence4, bl2, l2, list, nArray, bl3, pendingIntent);
        notificationBuilderWithBuilderAccessor.getBuilder().setContent((RemoteViews)context);
        if (bl3) {
            notificationBuilderWithBuilderAccessor.getBuilder().setOngoing(true);
        }
    }
}

