/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.os.TraceCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.recyclerview.R;
import android.support.v7.widget.AdapterHelper;
import android.support.v7.widget.ChildHelper;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.RecyclerViewAccessibilityDelegate;
import android.support.v7.widget.ViewInfoStore;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecyclerView
extends ViewGroup
implements NestedScrollingChild,
ScrollingView {
    static final boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC;
    private static final boolean DEBUG = false;
    static final boolean DISPATCH_TEMP_DETACH = false;
    private static final boolean FORCE_INVALIDATE_DISPLAY_LIST;
    public static final int HORIZONTAL = 0;
    private static final int INVALID_POINTER = -1;
    public static final int INVALID_TYPE = -1;
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE;
    private static final int MAX_SCROLL_DURATION = 2000;
    private static final int[] NESTED_SCROLLING_ATTRS;
    public static final long NO_ID = -1L;
    public static final int NO_POSITION = -1;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "RecyclerView";
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    private static final String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    private static final String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    private static final String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    private static final String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    private static final String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    private static final String TRACE_SCROLL_TAG = "RV Scroll";
    public static final int VERTICAL = 1;
    private static final Interpolator sQuinticInterpolator;
    private RecyclerViewAccessibilityDelegate mAccessibilityDelegate;
    private final AccessibilityManager mAccessibilityManager;
    private OnItemTouchListener mActiveOnItemTouchListener;
    private Adapter mAdapter;
    AdapterHelper mAdapterHelper;
    private boolean mAdapterUpdateDuringMeasure;
    private EdgeEffectCompat mBottomGlow;
    private ChildDrawingOrderCallback mChildDrawingOrderCallback;
    ChildHelper mChildHelper;
    private boolean mClipToPadding;
    private boolean mDataSetHasChangedAfterLayout;
    private int mEatRequestLayout;
    private int mEatenAccessibilityChangeFlags;
    private boolean mFirstLayoutComplete;
    private boolean mHasFixedSize;
    private boolean mIgnoreMotionEventTillDown;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private boolean mIsAttached;
    ItemAnimator mItemAnimator;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener;
    private Runnable mItemAnimatorRunner;
    private final ArrayList<ItemDecoration> mItemDecorations;
    boolean mItemsAddedOrRemoved;
    boolean mItemsChanged;
    private int mLastTouchX;
    private int mLastTouchY;
    @VisibleForTesting
    LayoutManager mLayout;
    private boolean mLayoutFrozen;
    private int mLayoutOrScrollCounter;
    private boolean mLayoutRequestEaten;
    private EdgeEffectCompat mLeftGlow;
    private final int mMaxFlingVelocity;
    private final int mMinFlingVelocity;
    private final int[] mMinMaxLayoutPositions;
    private final int[] mNestedOffsets;
    private final RecyclerViewDataObserver mObserver;
    private List<OnChildAttachStateChangeListener> mOnChildAttachStateListeners;
    private final ArrayList<OnItemTouchListener> mOnItemTouchListeners;
    private SavedState mPendingSavedState;
    private final boolean mPostUpdatesOnAnimation;
    private boolean mPostedAnimatorRunner;
    final Recycler mRecycler;
    private RecyclerListener mRecyclerListener;
    private EdgeEffectCompat mRightGlow;
    private final int[] mScrollConsumed;
    private float mScrollFactor;
    private OnScrollListener mScrollListener;
    private List<OnScrollListener> mScrollListeners;
    private final int[] mScrollOffset;
    private int mScrollPointerId;
    private int mScrollState;
    private NestedScrollingChildHelper mScrollingChildHelper;
    final State mState;
    private final Rect mTempRect;
    private EdgeEffectCompat mTopGlow;
    private int mTouchSlop;
    private final Runnable mUpdateChildViewsRunnable;
    private VelocityTracker mVelocityTracker;
    private final ViewFlinger mViewFlinger;
    private final ViewInfoStore.ProcessCallback mViewInfoProcessCallback;
    final ViewInfoStore mViewInfoStore;

    /*
     * Enabled aggressive block sorting
     */
    static {
        NESTED_SCROLLING_ATTRS = new int[]{16843830};
        boolean bl2 = Build.VERSION.SDK_INT == 18 || Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 20;
        FORCE_INVALIDATE_DISPLAY_LIST = bl2;
        bl2 = Build.VERSION.SDK_INT >= 23;
        ALLOW_SIZE_IN_UNSPECIFIED_SPEC = bl2;
        LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
        sQuinticInterpolator = new Interpolator(){

            public float getInterpolation(float f2) {
                return (f2 -= 1.0f) * (f2 * f2 * f2 * f2) + 1.0f;
            }
        };
    }

    public RecyclerView(Context context) {
        this(context, null);
    }

    public RecyclerView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RecyclerView(Context context, @Nullable AttributeSet attributeSet, int n2) {
        boolean bl2 = true;
        super(context, attributeSet, n2);
        this.mObserver = new RecyclerViewDataObserver();
        this.mRecycler = new Recycler();
        this.mViewInfoStore = new ViewInfoStore();
        this.mUpdateChildViewsRunnable = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (!RecyclerView.this.mFirstLayoutComplete || RecyclerView.this.isLayoutRequested()) {
                    return;
                }
                if (RecyclerView.this.mLayoutFrozen) {
                    RecyclerView.access$302(RecyclerView.this, true);
                    return;
                }
                RecyclerView.this.consumePendingUpdateOperations();
            }
        };
        this.mTempRect = new Rect();
        this.mItemDecorations = new ArrayList();
        this.mOnItemTouchListeners = new ArrayList();
        this.mEatRequestLayout = 0;
        this.mDataSetHasChangedAfterLayout = false;
        this.mLayoutOrScrollCounter = 0;
        this.mItemAnimator = new DefaultItemAnimator();
        this.mScrollState = 0;
        this.mScrollPointerId = -1;
        this.mScrollFactor = Float.MIN_VALUE;
        this.mViewFlinger = new ViewFlinger();
        this.mState = new State();
        this.mItemsAddedOrRemoved = false;
        this.mItemsChanged = false;
        this.mItemAnimatorListener = new ItemAnimatorRestoreListener();
        this.mPostedAnimatorRunner = false;
        this.mMinMaxLayoutPositions = new int[2];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.mNestedOffsets = new int[2];
        this.mItemAnimatorRunner = new Runnable(){

            @Override
            public void run() {
                if (RecyclerView.this.mItemAnimator != null) {
                    RecyclerView.this.mItemAnimator.runPendingAnimations();
                }
                RecyclerView.access$602(RecyclerView.this, false);
            }
        };
        this.mViewInfoProcessCallback = new ViewInfoStore.ProcessCallback(){

            @Override
            public void processAppeared(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo, ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                RecyclerView.this.animateAppearance(viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            @Override
            public void processDisappeared(ViewHolder viewHolder, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo, @Nullable ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                RecyclerView.this.mRecycler.unscrapView(viewHolder);
                RecyclerView.this.animateDisappearance(viewHolder, itemHolderInfo, itemHolderInfo2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processPersistent(ViewHolder viewHolder, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo2) {
                viewHolder.setIsRecyclable(false);
                if (RecyclerView.this.mDataSetHasChangedAfterLayout) {
                    if (!RecyclerView.this.mItemAnimator.animateChange(viewHolder, viewHolder, itemHolderInfo, itemHolderInfo2)) return;
                    RecyclerView.this.postAnimationRunner();
                    return;
                }
                if (!RecyclerView.this.mItemAnimator.animatePersistence(viewHolder, itemHolderInfo, itemHolderInfo2)) return;
                RecyclerView.this.postAnimationRunner();
            }

            @Override
            public void unused(ViewHolder viewHolder) {
                RecyclerView.this.mLayout.removeAndRecycleView(viewHolder.itemView, RecyclerView.this.mRecycler);
            }
        };
        this.setScrollContainer(true);
        this.setFocusableInTouchMode(true);
        boolean bl3 = Build.VERSION.SDK_INT >= 16;
        this.mPostUpdatesOnAnimation = bl3;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        bl3 = ViewCompat.getOverScrollMode((View)this) == 2;
        this.setWillNotDraw(bl3);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
        this.initAdapterManager();
        this.initChildrenHelper();
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this));
        bl3 = bl2;
        if (attributeSet != null) {
            viewConfiguration = context.obtainStyledAttributes(attributeSet, R.styleable.RecyclerView, n2, 0);
            String string2 = viewConfiguration.getString(R.styleable.RecyclerView_layoutManager);
            viewConfiguration.recycle();
            this.createLayoutManager(context, string2, attributeSet, n2, 0);
            bl3 = bl2;
            if (Build.VERSION.SDK_INT >= 21) {
                context = context.obtainStyledAttributes(attributeSet, NESTED_SCROLLING_ATTRS, n2, 0);
                bl3 = context.getBoolean(0, true);
                context.recycle();
            }
        }
        this.setNestedScrollingEnabled(bl3);
    }

    static /* synthetic */ boolean access$302(RecyclerView recyclerView, boolean bl2) {
        recyclerView.mLayoutRequestEaten = bl2;
        return bl2;
    }

    static /* synthetic */ void access$3200(RecyclerView recyclerView) {
        recyclerView.onEnterLayoutOrScroll();
    }

    static /* synthetic */ void access$3300(RecyclerView recyclerView) {
        recyclerView.repositionShadowingViews();
    }

    static /* synthetic */ void access$3400(RecyclerView recyclerView) {
        recyclerView.onExitLayoutOrScroll();
    }

    static /* synthetic */ ArrayList access$3600(RecyclerView recyclerView) {
        return recyclerView.mItemDecorations;
    }

    static /* synthetic */ void access$3700(RecyclerView recyclerView, int n2, int n3) {
        recyclerView.considerReleasingGlowsOnScroll(n2, n3);
    }

    static /* synthetic */ boolean access$3800(RecyclerView recyclerView) {
        return recyclerView.awakenScrollBars();
    }

    static /* synthetic */ boolean access$4502(RecyclerView recyclerView, boolean bl2) {
        recyclerView.mAdapterUpdateDuringMeasure = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$4600() {
        return FORCE_INVALIDATE_DISPLAY_LIST;
    }

    static /* synthetic */ void access$4700(RecyclerView recyclerView, ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo) {
        recyclerView.recordAnimationInfoIfBouncedHiddenView(viewHolder, itemHolderInfo);
    }

    static /* synthetic */ ViewFlinger access$5900(RecyclerView recyclerView) {
        return recyclerView.mViewFlinger;
    }

    static /* synthetic */ boolean access$602(RecyclerView recyclerView, boolean bl2) {
        recyclerView.mPostedAnimatorRunner = bl2;
        return bl2;
    }

    static /* synthetic */ void access$6200(RecyclerView recyclerView, int n2) {
        recyclerView.jumpToPositionForSmoothScroller(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addAnimatingView(ViewHolder viewHolder) {
        View view = viewHolder.itemView;
        boolean bl2 = view.getParent() == this;
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
        if (viewHolder.isTmpDetached()) {
            this.mChildHelper.attachViewToParent(view, -1, view.getLayoutParams(), true);
            return;
        }
        if (!bl2) {
            this.mChildHelper.addView(view, true);
            return;
        }
        this.mChildHelper.hide(view);
    }

    private void animateAppearance(@NonNull ViewHolder viewHolder, @Nullable ItemAnimator.ItemHolderInfo itemHolderInfo, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        viewHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateAppearance(viewHolder, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    private void animateChange(@NonNull ViewHolder viewHolder, @NonNull ViewHolder viewHolder2, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo2, boolean bl2, boolean bl3) {
        viewHolder.setIsRecyclable(false);
        if (bl2) {
            this.addAnimatingView(viewHolder);
        }
        if (viewHolder != viewHolder2) {
            if (bl3) {
                this.addAnimatingView(viewHolder2);
            }
            viewHolder.mShadowedHolder = viewHolder2;
            this.addAnimatingView(viewHolder);
            this.mRecycler.unscrapView(viewHolder);
            viewHolder2.setIsRecyclable(false);
            viewHolder2.mShadowingHolder = viewHolder;
        }
        if (this.mItemAnimator.animateChange(viewHolder, viewHolder2, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    private void animateDisappearance(@NonNull ViewHolder viewHolder, @NonNull ItemAnimator.ItemHolderInfo itemHolderInfo, @Nullable ItemAnimator.ItemHolderInfo itemHolderInfo2) {
        this.addAnimatingView(viewHolder);
        viewHolder.setIsRecyclable(false);
        if (this.mItemAnimator.animateDisappearance(viewHolder, itemHolderInfo, itemHolderInfo2)) {
            this.postAnimationRunner();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canReuseUpdatedViewHolder(ViewHolder viewHolder) {
        if (this.mItemAnimator == null) return true;
        if (!this.mItemAnimator.canReuseUpdatedViewHolder(viewHolder, viewHolder.getUnmodifiedPayloads())) return false;
        return true;
    }

    private void cancelTouch() {
        this.resetTouch();
        this.setScrollState(0);
    }

    private void considerReleasingGlowsOnScroll(int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (this.mLeftGlow != null) {
            bl3 = bl2;
            if (!this.mLeftGlow.isFinished()) {
                bl3 = bl2;
                if (n2 > 0) {
                    bl3 = this.mLeftGlow.onRelease();
                }
            }
        }
        bl2 = bl3;
        if (this.mRightGlow != null) {
            bl2 = bl3;
            if (!this.mRightGlow.isFinished()) {
                bl2 = bl3;
                if (n2 < 0) {
                    bl2 = bl3 | this.mRightGlow.onRelease();
                }
            }
        }
        bl3 = bl2;
        if (this.mTopGlow != null) {
            bl3 = bl2;
            if (!this.mTopGlow.isFinished()) {
                bl3 = bl2;
                if (n3 > 0) {
                    bl3 = bl2 | this.mTopGlow.onRelease();
                }
            }
        }
        bl2 = bl3;
        if (this.mBottomGlow != null) {
            bl2 = bl3;
            if (!this.mBottomGlow.isFinished()) {
                bl2 = bl3;
                if (n3 < 0) {
                    bl2 = bl3 | this.mBottomGlow.onRelease();
                }
            }
        }
        if (bl2) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consumePendingUpdateOperations() {
        if (!this.mFirstLayoutComplete) {
            return;
        }
        if (this.mDataSetHasChangedAfterLayout) {
            TraceCompat.beginSection(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
            this.dispatchLayout();
            TraceCompat.endSection();
            return;
        }
        if (!this.mAdapterHelper.hasPendingUpdates()) return;
        if (this.mAdapterHelper.hasAnyUpdateTypes(4) && !this.mAdapterHelper.hasAnyUpdateTypes(11)) {
            TraceCompat.beginSection(TRACE_HANDLE_ADAPTER_UPDATES_TAG);
            this.eatRequestLayout();
            this.mAdapterHelper.preProcess();
            if (!this.mLayoutRequestEaten) {
                if (this.hasUpdatedView()) {
                    this.dispatchLayout();
                } else {
                    this.mAdapterHelper.consumePostponedUpdates();
                }
            }
            this.resumeRequestLayout(true);
            TraceCompat.endSection();
            return;
        }
        if (!this.mAdapterHelper.hasPendingUpdates()) return;
        TraceCompat.beginSection(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
        this.dispatchLayout();
        TraceCompat.endSection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void createLayoutManager(Context object, String object2, AttributeSet attributeSet, int n2, int n3) {
        if (object2 == null) return;
        if (((String)(object2 = ((String)object2).trim())).length() == 0) return;
        String string2 = this.getFullClassName((Context)object, (String)object2);
        try {
            Object object3;
            object2 = this.isInEditMode() ? this.getClass().getClassLoader() : object.getClassLoader();
            Class<LayoutManager> clazz = ((ClassLoader)object2).loadClass(string2).asSubclass(LayoutManager.class);
            try {
                object3 = clazz.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                object2 = new Object[]{object, attributeSet, n2, n3};
                object = object3;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object = clazz.getConstructor(new Class[0]);
                    object2 = null;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    noSuchMethodException2.initCause(noSuchMethodException);
                    object3 = new StringBuilder();
                    IllegalStateException illegalStateException = new IllegalStateException(((StringBuilder)object3).append(attributeSet.getPositionDescription()).append(": Error creating LayoutManager ").append(string2).toString(), noSuchMethodException2);
                    throw illegalStateException;
                }
            }
            ((Constructor)object).setAccessible(true);
            this.setLayoutManager((LayoutManager)((Constructor)object).newInstance((Object[])object2));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Unable to find LayoutManager " + string2, classNotFoundException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + string2, invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Cannot access non-public constructor " + string2, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Class is not a LayoutManager " + string2, classCastException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean didChildRangeChange(int n2, int n3) {
        boolean bl2 = false;
        if (this.mChildHelper.getChildCount() == 0) {
            if (n2 != 0) return true;
            if (n3 == 0) return bl2;
            return true;
        }
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mMinMaxLayoutPositions[0] != n2) return true;
        if (this.mMinMaxLayoutPositions[1] == n3) return bl2;
        return true;
    }

    private void dispatchChildAttached(View view) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
        this.onChildAttachedToWindow(view);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewAttachedToWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            for (int i2 = this.mOnChildAttachStateListeners.size() - 1; i2 >= 0; --i2) {
                this.mOnChildAttachStateListeners.get(i2).onChildViewAttachedToWindow(view);
            }
        }
    }

    private void dispatchChildDetached(View view) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
        this.onChildDetachedFromWindow(view);
        if (this.mAdapter != null && viewHolder != null) {
            this.mAdapter.onViewDetachedFromWindow(viewHolder);
        }
        if (this.mOnChildAttachStateListeners != null) {
            for (int i2 = this.mOnChildAttachStateListeners.size() - 1; i2 >= 0; --i2) {
                this.mOnChildAttachStateListeners.get(i2).onChildViewDetachedFromWindow(view);
            }
        }
    }

    private void dispatchContentChangedIfNecessary() {
        int n2 = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (n2 != 0 && this.isAccessibilityEnabled()) {
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
            accessibilityEvent.setEventType(2048);
            AccessibilityEventCompat.setContentChangeTypes(accessibilityEvent, n2);
            this.sendAccessibilityEventUnchecked(accessibilityEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchLayoutStep1() {
        ItemAnimator.ItemHolderInfo itemHolderInfo;
        int n2;
        int n3;
        boolean bl2 = true;
        this.mState.assertLayoutStep(1);
        State.access$2202(this.mState, false);
        this.eatRequestLayout();
        this.mViewInfoStore.clear();
        this.onEnterLayoutOrScroll();
        this.processAdapterUpdatesAndSetAnimationFlags();
        Object object = this.mState;
        if (!this.mState.mRunSimpleAnimations || !this.mItemsChanged) {
            bl2 = false;
        }
        State.access$2702((State)object, bl2);
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        State.access$2402(this.mState, this.mState.mRunPredictiveAnimations);
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.mRunSimpleAnimations) {
            n3 = this.mChildHelper.getChildCount();
            for (n2 = 0; n2 < n3; ++n2) {
                object = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n2));
                if (((ViewHolder)object).shouldIgnore() || ((ViewHolder)object).isInvalid() && !this.mAdapter.hasStableIds()) continue;
                itemHolderInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, (ViewHolder)object, ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)object), ((ViewHolder)object).getUnmodifiedPayloads());
                this.mViewInfoStore.addToPreLayout((ViewHolder)object, itemHolderInfo);
                if (!this.mState.mTrackOldChangeHolders || !((ViewHolder)object).isUpdated() || ((ViewHolder)object).isRemoved() || ((ViewHolder)object).shouldIgnore() || ((ViewHolder)object).isInvalid()) continue;
                long l2 = this.getChangedHolderKey((ViewHolder)object);
                this.mViewInfoStore.addToOldChangeHolders(l2, (ViewHolder)object);
            }
        }
        if (!this.mState.mRunPredictiveAnimations) {
            this.clearOldPositions();
        } else {
            this.saveOldPositions();
            bl2 = this.mState.mStructureChanged;
            State.access$1802(this.mState, false);
            this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
            State.access$1802(this.mState, bl2);
            for (n2 = 0; n2 < this.mChildHelper.getChildCount(); ++n2) {
                object = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n2));
                if (((ViewHolder)object).shouldIgnore() || this.mViewInfoStore.isInPreLayout((ViewHolder)object)) continue;
                int n4 = ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)object);
                bl2 = ((ViewHolder)object).hasAnyOfTheFlags(8192);
                n3 = n4;
                if (!bl2) {
                    n3 = n4 | 0x1000;
                }
                itemHolderInfo = this.mItemAnimator.recordPreLayoutInformation(this.mState, (ViewHolder)object, n3, ((ViewHolder)object).getUnmodifiedPayloads());
                if (bl2) {
                    this.recordAnimationInfoIfBouncedHiddenView((ViewHolder)object, itemHolderInfo);
                    continue;
                }
                this.mViewInfoStore.addToAppearedInPreLayoutHolders((ViewHolder)object, itemHolderInfo);
            }
            this.clearOldPositions();
        }
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
        State.access$2102(this.mState, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchLayoutStep2() {
        this.eatRequestLayout();
        this.onEnterLayoutOrScroll();
        this.mState.assertLayoutStep(6);
        this.mAdapterHelper.consumeUpdatesInOnePass();
        this.mState.mItemCount = this.mAdapter.getItemCount();
        State.access$1702(this.mState, 0);
        State.access$2402(this.mState, false);
        this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
        State.access$1802(this.mState, false);
        this.mPendingSavedState = null;
        State state = this.mState;
        boolean bl2 = this.mState.mRunSimpleAnimations && this.mItemAnimator != null;
        State.access$2502(state, bl2);
        State.access$2102(this.mState, 4);
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchLayoutStep3() {
        this.mState.assertLayoutStep(4);
        this.eatRequestLayout();
        this.onEnterLayoutOrScroll();
        State.access$2102(this.mState, 1);
        if (this.mState.mRunSimpleAnimations) {
            for (int i2 = this.mChildHelper.getChildCount() - 1; i2 >= 0; --i2) {
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i2));
                if (viewHolder.shouldIgnore()) continue;
                long l2 = this.getChangedHolderKey(viewHolder);
                ItemAnimator.ItemHolderInfo itemHolderInfo = this.mItemAnimator.recordPostLayoutInformation(this.mState, viewHolder);
                ViewHolder viewHolder2 = this.mViewInfoStore.getFromOldChangeHolders(l2);
                if (viewHolder2 != null && !viewHolder2.shouldIgnore()) {
                    boolean bl2 = this.mViewInfoStore.isDisappearing(viewHolder2);
                    boolean bl3 = this.mViewInfoStore.isDisappearing(viewHolder);
                    if (bl2 && viewHolder2 == viewHolder) {
                        this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
                        continue;
                    }
                    ItemAnimator.ItemHolderInfo itemHolderInfo2 = this.mViewInfoStore.popFromPreLayout(viewHolder2);
                    this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
                    itemHolderInfo = this.mViewInfoStore.popFromPostLayout(viewHolder);
                    if (itemHolderInfo2 == null) {
                        this.handleMissingPreInfoForChangeError(l2, viewHolder, viewHolder2);
                        continue;
                    }
                    this.animateChange(viewHolder2, viewHolder, itemHolderInfo2, itemHolderInfo, bl2, bl3);
                    continue;
                }
                this.mViewInfoStore.addToPostLayout(viewHolder, itemHolderInfo);
            }
            this.mViewInfoStore.process(this.mViewInfoProcessCallback);
        }
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        State.access$2802(this.mState, this.mState.mItemCount);
        this.mDataSetHasChangedAfterLayout = false;
        State.access$2502(this.mState, false);
        State.access$2302(this.mState, false);
        LayoutManager.access$2602(this.mLayout, false);
        if (this.mRecycler.mChangedScrap != null) {
            this.mRecycler.mChangedScrap.clear();
        }
        this.onExitLayoutOrScroll();
        this.resumeRequestLayout(false);
        this.mViewInfoStore.clear();
        if (this.didChildRangeChange(this.mMinMaxLayoutPositions[0], this.mMinMaxLayoutPositions[1])) {
            this.dispatchOnScrolled(0, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean dispatchOnItemTouch(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        if (this.mActiveOnItemTouchListener != null) {
            if (n2 == 0) {
                this.mActiveOnItemTouchListener = null;
            } else {
                this.mActiveOnItemTouchListener.onTouchEvent(this, motionEvent);
                if (n2 != 3) {
                    if (n2 != 1) return true;
                }
                this.mActiveOnItemTouchListener = null;
                return true;
            }
        }
        if (n2 == 0) return false;
        int n3 = this.mOnItemTouchListeners.size();
        n2 = 0;
        while (n2 < n3) {
            OnItemTouchListener onItemTouchListener = this.mOnItemTouchListeners.get(n2);
            if (onItemTouchListener.onInterceptTouchEvent(this, motionEvent)) {
                this.mActiveOnItemTouchListener = onItemTouchListener;
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean dispatchOnItemTouchIntercept(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        if (n2 == 3 || n2 == 0) {
            this.mActiveOnItemTouchListener = null;
        }
        int n3 = this.mOnItemTouchListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            OnItemTouchListener onItemTouchListener = this.mOnItemTouchListeners.get(n4);
            if (onItemTouchListener.onInterceptTouchEvent(this, motionEvent) && n2 != 3) {
                this.mActiveOnItemTouchListener = onItemTouchListener;
                return true;
            }
            ++n4;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findMinMaxChildLayoutPositions(int[] nArray) {
        int n2 = this.mChildHelper.getChildCount();
        if (n2 == 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        while (true) {
            if (n5 >= n2) {
                nArray[0] = n3;
                nArray[1] = n4;
                return;
            }
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n5));
            if (!viewHolder.shouldIgnore()) {
                int n6 = viewHolder.getLayoutPosition();
                int n7 = n3;
                if (n6 < n3) {
                    n7 = n6;
                }
                if (n6 > n4) {
                    n4 = n6;
                    n3 = n7;
                } else {
                    n3 = n7;
                }
            }
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAdapterPositionFor(ViewHolder viewHolder) {
        if (viewHolder.hasAnyOfTheFlags(524)) return -1;
        if (viewHolder.isBound()) return this.mAdapterHelper.applyPendingUpdatesToPosition(viewHolder.mPosition);
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ViewHolder getChildViewHolderInt(View object) {
        void var0_2;
        if (object == null) {
            return var0_2;
        }
        ViewHolder viewHolder = ((LayoutParams)object.getLayoutParams()).mViewHolder;
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String getFullClassName(Context object, String string2) {
        void var1_3;
        void var2_6;
        if (var2_6.charAt(0) == '.') {
            String string3 = object.getPackageName() + (String)var2_6;
            return var1_3;
        }
        void var1_4 = var2_6;
        if (var2_6.contains(".")) return var1_3;
        String string4 = RecyclerView.class.getPackage().getName() + '.' + (String)var2_6;
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float getScrollFactor() {
        if (this.mScrollFactor != Float.MIN_VALUE) return this.mScrollFactor;
        TypedValue typedValue = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(16842829, typedValue, true)) return 0.0f;
        this.mScrollFactor = typedValue.getDimension(this.getContext().getResources().getDisplayMetrics());
        return this.mScrollFactor;
    }

    private NestedScrollingChildHelper getScrollingChildHelper() {
        if (this.mScrollingChildHelper == null) {
            this.mScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        }
        return this.mScrollingChildHelper;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleMissingPreInfoForChangeError(long l2, ViewHolder viewHolder, ViewHolder viewHolder2) {
        ViewHolder viewHolder3;
        int n2 = this.mChildHelper.getChildCount();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                Log.e((String)TAG, (String)("Problem while matching changed view holders with the newones. The pre-layout information for the change holder " + viewHolder2 + " cannot be found but it is necessary for " + viewHolder));
                return;
            }
            viewHolder3 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n3));
            if (viewHolder3 != viewHolder && this.getChangedHolderKey(viewHolder3) == l2) {
                if (this.mAdapter == null || !this.mAdapter.hasStableIds()) break;
                throw new IllegalStateException("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:" + viewHolder3 + " \n View Holder 2:" + viewHolder);
            }
            ++n3;
        }
        throw new IllegalStateException("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:" + viewHolder3 + " \n View Holder 2:" + viewHolder);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasUpdatedView() {
        boolean bl2 = false;
        int n2 = this.mChildHelper.getChildCount();
        int n3 = 0;
        while (true) {
            boolean bl3 = bl2;
            if (n3 >= n2) return bl3;
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(n3));
            if (viewHolder != null && !viewHolder.shouldIgnore() && viewHolder.isUpdated()) {
                return true;
            }
            ++n3;
        }
    }

    private void initChildrenHelper() {
        this.mChildHelper = new ChildHelper(new ChildHelper.Callback(){

            @Override
            public void addView(View view, int n2) {
                RecyclerView.this.addView(view, n2);
                RecyclerView.this.dispatchChildAttached(view);
            }

            @Override
            public void attachViewToParent(View view, int n2, ViewGroup.LayoutParams layoutParams) {
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
                if (viewHolder != null) {
                    if (!viewHolder.isTmpDetached() && !viewHolder.shouldIgnore()) {
                        throw new IllegalArgumentException("Called attach on a child which is not detached: " + viewHolder);
                    }
                    viewHolder.clearTmpDetachFlag();
                }
                RecyclerView.this.attachViewToParent(view, n2, layoutParams);
            }

            @Override
            public void detachViewFromParent(int n2) {
                Object object = this.getChildAt(n2);
                if (object != null && (object = RecyclerView.getChildViewHolderInt((View)object)) != null) {
                    if (((ViewHolder)object).isTmpDetached() && !((ViewHolder)object).shouldIgnore()) {
                        throw new IllegalArgumentException("called detach on an already detached child " + object);
                    }
                    ((ViewHolder)object).addFlags(256);
                }
                RecyclerView.this.detachViewFromParent(n2);
            }

            @Override
            public View getChildAt(int n2) {
                return RecyclerView.this.getChildAt(n2);
            }

            @Override
            public int getChildCount() {
                return RecyclerView.this.getChildCount();
            }

            @Override
            public ViewHolder getChildViewHolder(View view) {
                return RecyclerView.getChildViewHolderInt(view);
            }

            @Override
            public int indexOfChild(View view) {
                return RecyclerView.this.indexOfChild(view);
            }

            @Override
            public void onEnteredHiddenState(View object) {
                if ((object = RecyclerView.getChildViewHolderInt(object)) != null) {
                    ((ViewHolder)object).onEnteredHiddenState();
                }
            }

            @Override
            public void onLeftHiddenState(View object) {
                if ((object = RecyclerView.getChildViewHolderInt(object)) != null) {
                    ((ViewHolder)object).onLeftHiddenState();
                }
            }

            @Override
            public void removeAllViews() {
                int n2 = this.getChildCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    RecyclerView.this.dispatchChildDetached(this.getChildAt(i2));
                }
                RecyclerView.this.removeAllViews();
            }

            @Override
            public void removeViewAt(int n2) {
                View view = RecyclerView.this.getChildAt(n2);
                if (view != null) {
                    RecyclerView.this.dispatchChildDetached(view);
                }
                RecyclerView.this.removeViewAt(n2);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jumpToPositionForSmoothScroller(int n2) {
        if (this.mLayout == null) {
            return;
        }
        this.mLayout.scrollToPosition(n2);
        this.awakenScrollBars();
    }

    private void onEnterLayoutOrScroll() {
        ++this.mLayoutOrScrollCounter;
    }

    private void onExitLayoutOrScroll() {
        --this.mLayoutOrScrollCounter;
        if (this.mLayoutOrScrollCounter < 1) {
            this.mLayoutOrScrollCounter = 0;
            this.dispatchContentChangedIfNecessary();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onPointerUp(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionIndex(motionEvent);
        if (MotionEventCompat.getPointerId(motionEvent, n2) == this.mScrollPointerId) {
            int n3;
            n2 = n2 == 0 ? 1 : 0;
            this.mScrollPointerId = MotionEventCompat.getPointerId(motionEvent, n2);
            this.mLastTouchX = n3 = (int)(MotionEventCompat.getX(motionEvent, n2) + 0.5f);
            this.mInitialTouchX = n3;
            this.mLastTouchY = n2 = (int)(MotionEventCompat.getY(motionEvent, n2) + 0.5f);
            this.mInitialTouchY = n2;
        }
    }

    private void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            ViewCompat.postOnAnimation((View)this, this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean predictiveItemAnimationsEnabled() {
        if (this.mItemAnimator == null) return false;
        if (!this.mLayout.supportsPredictiveItemAnimations()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processAdapterUpdatesAndSetAnimationFlags() {
        boolean bl2 = true;
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.reset();
            this.markKnownViewsInvalid();
            this.mLayout.onItemsChanged(this);
        }
        if (this.predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.preProcess();
        } else {
            this.mAdapterHelper.consumeUpdatesInOnePass();
        }
        boolean bl3 = this.mItemsAddedOrRemoved || this.mItemsChanged;
        State state = this.mState;
        boolean bl4 = !(!this.mFirstLayoutComplete || this.mItemAnimator == null || !this.mDataSetHasChangedAfterLayout && !bl3 && !this.mLayout.mRequestedSimpleAnimations || this.mDataSetHasChangedAfterLayout && !this.mAdapter.hasStableIds());
        State.access$2502(state, bl4);
        state = this.mState;
        bl4 = this.mState.mRunSimpleAnimations && bl3 && !this.mDataSetHasChangedAfterLayout && this.predictiveItemAnimationsEnabled() ? bl2 : false;
        State.access$2302(state, bl4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void pullGlows(float f2, float f3, float f4, float f5) {
        boolean bl2;
        block13: {
            boolean bl3;
            block12: {
                block11: {
                    bl2 = true;
                    boolean bl4 = false;
                    if (f3 < 0.0f) {
                        this.ensureLeftGlow();
                        bl3 = bl4;
                        if (this.mLeftGlow.onPull(-f3 / (float)this.getWidth(), 1.0f - f4 / (float)this.getHeight())) {
                            bl3 = true;
                        }
                    } else {
                        bl3 = bl4;
                        if (f3 > 0.0f) {
                            this.ensureRightGlow();
                            bl3 = bl4;
                            if (this.mRightGlow.onPull(f3 / (float)this.getWidth(), f4 / (float)this.getHeight())) {
                                bl3 = true;
                            }
                        }
                    }
                    if (!(f5 < 0.0f)) break block11;
                    this.ensureTopGlow();
                    if (!this.mTopGlow.onPull(-f5 / (float)this.getHeight(), f2 / (float)this.getWidth())) break block12;
                    break block13;
                }
                if (!(f5 > 0.0f)) break block12;
                this.ensureBottomGlow();
                if (this.mBottomGlow.onPull(f5 / (float)this.getHeight(), 1.0f - f2 / (float)this.getWidth())) break block13;
            }
            bl2 = bl3;
        }
        if (bl2 || f3 != 0.0f || f5 != 0.0f) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void recordAnimationInfoIfBouncedHiddenView(ViewHolder viewHolder, ItemAnimator.ItemHolderInfo itemHolderInfo) {
        viewHolder.setFlags(0, 8192);
        if (this.mState.mTrackOldChangeHolders && viewHolder.isUpdated() && !viewHolder.isRemoved() && !viewHolder.shouldIgnore()) {
            long l2 = this.getChangedHolderKey(viewHolder);
            this.mViewInfoStore.addToOldChangeHolders(l2, viewHolder);
        }
        this.mViewInfoStore.addToPreLayout(viewHolder, itemHolderInfo);
    }

    private void releaseGlows() {
        boolean bl2 = false;
        if (this.mLeftGlow != null) {
            bl2 = this.mLeftGlow.onRelease();
        }
        boolean bl3 = bl2;
        if (this.mTopGlow != null) {
            bl3 = bl2 | this.mTopGlow.onRelease();
        }
        bl2 = bl3;
        if (this.mRightGlow != null) {
            bl2 = bl3 | this.mRightGlow.onRelease();
        }
        bl3 = bl2;
        if (this.mBottomGlow != null) {
            bl3 = bl2 | this.mBottomGlow.onRelease();
        }
        if (bl3) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean removeAnimatingView(View object) {
        this.eatRequestLayout();
        boolean bl2 = this.mChildHelper.removeViewIfHidden((View)object);
        if (bl2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(object);
            this.mRecycler.unscrapView(viewHolder);
            this.mRecycler.recycleViewHolderInternal(viewHolder);
        }
        boolean bl3 = !bl2;
        this.resumeRequestLayout(bl3);
        return bl2;
    }

    private void repositionShadowingViews() {
        int n2 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.mChildHelper.getChildAt(i2);
            ViewHolder viewHolder = this.getChildViewHolder(view);
            if (viewHolder == null || viewHolder.mShadowingHolder == null) continue;
            viewHolder = viewHolder.mShadowingHolder.itemView;
            int n3 = view.getLeft();
            int n4 = view.getTop();
            if (n3 == viewHolder.getLeft() && n4 == viewHolder.getTop()) continue;
            viewHolder.layout(n3, n4, viewHolder.getWidth() + n3, viewHolder.getHeight() + n4);
        }
    }

    private void resetTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.stopNestedScroll();
        this.releaseGlows();
    }

    private void setAdapterInternal(Adapter adapter, boolean bl2, boolean bl3) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!bl2 || bl3) {
            if (this.mItemAnimator != null) {
                this.mItemAnimator.endAnimations();
            }
            if (this.mLayout != null) {
                this.mLayout.removeAndRecycleAllViews(this.mRecycler);
                this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
            }
            this.mRecycler.clear();
        }
        this.mAdapterHelper.reset();
        Adapter adapter2 = this.mAdapter;
        this.mAdapter = adapter;
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
            adapter.onAttachedToRecyclerView(this);
        }
        if (this.mLayout != null) {
            this.mLayout.onAdapterChanged(adapter2, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(adapter2, this.mAdapter, bl2);
        State.access$1802(this.mState, true);
        this.markKnownViewsInvalid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDataSetChangedAfterLayout() {
        if (this.mDataSetHasChangedAfterLayout) {
            return;
        }
        this.mDataSetHasChangedAfterLayout = true;
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore()) continue;
            viewHolder.addFlags(512);
        }
        this.mRecycler.setAdapterPositionsAsUnknown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setScrollState(int n2) {
        if (n2 == this.mScrollState) {
            return;
        }
        this.mScrollState = n2;
        if (n2 != 2) {
            this.stopScrollersInternal();
        }
        this.dispatchOnScrollStateChanged(n2);
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.stop();
        if (this.mLayout != null) {
            this.mLayout.stopSmoothScroller();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void absorbGlows(int n2, int n3) {
        if (n2 < 0) {
            this.ensureLeftGlow();
            this.mLeftGlow.onAbsorb(-n2);
        } else if (n2 > 0) {
            this.ensureRightGlow();
            this.mRightGlow.onAbsorb(n2);
        }
        if (n3 < 0) {
            this.ensureTopGlow();
            this.mTopGlow.onAbsorb(-n3);
        } else if (n3 > 0) {
            this.ensureBottomGlow();
            this.mBottomGlow.onAbsorb(n3);
        }
        if (n2 != 0 || n3 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        if (this.mLayout == null || !this.mLayout.onAddFocusables(this, arrayList, n2, n3)) {
            super.addFocusables(arrayList, n2, n3);
        }
    }

    public void addItemDecoration(ItemDecoration itemDecoration) {
        this.addItemDecoration(itemDecoration, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addItemDecoration(ItemDecoration itemDecoration, int n2) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (n2 < 0) {
            this.mItemDecorations.add(itemDecoration);
        } else {
            this.mItemDecorations.add(n2, itemDecoration);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void addOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList<OnChildAttachStateChangeListener>();
        }
        this.mOnChildAttachStateListeners.add(onChildAttachStateChangeListener);
    }

    public void addOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListeners.add(onItemTouchListener);
    }

    public void addOnScrollListener(OnScrollListener onScrollListener) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList<OnScrollListener>();
        }
        this.mScrollListeners.add(onScrollListener);
    }

    void assertInLayoutOrScroll(String string2) {
        if (!this.isComputingLayout()) {
            if (string2 == null) {
                throw new IllegalStateException("Cannot call this method unless RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(string2);
        }
    }

    void assertNotInLayoutOrScroll(String string2) {
        if (this.isComputingLayout()) {
            if (string2 == null) {
                throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) return false;
        if (!this.mLayout.checkLayoutParams((LayoutParams)layoutParams)) return false;
        return true;
    }

    void clearOldPositions() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder.shouldIgnore()) continue;
            viewHolder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    public void clearOnChildAttachStateChangeListeners() {
        if (this.mOnChildAttachStateListeners != null) {
            this.mOnChildAttachStateListeners.clear();
        }
    }

    public void clearOnScrollListeners() {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeHorizontalScrollExtent() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollHorizontally()) return n2;
        return this.mLayout.computeHorizontalScrollExtent(this.mState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeHorizontalScrollOffset() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollHorizontally()) return n2;
        return this.mLayout.computeHorizontalScrollOffset(this.mState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeHorizontalScrollRange() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollHorizontally()) return n2;
        return this.mLayout.computeHorizontalScrollRange(this.mState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeVerticalScrollExtent() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollVertically()) return n2;
        return this.mLayout.computeVerticalScrollExtent(this.mState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeVerticalScrollOffset() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollVertically()) return n2;
        return this.mLayout.computeVerticalScrollOffset(this.mState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int computeVerticalScrollRange() {
        int n2 = 0;
        if (this.mLayout == null) {
            return n2;
        }
        if (!this.mLayout.canScrollVertically()) return n2;
        return this.mLayout.computeVerticalScrollRange(this.mState);
    }

    void defaultOnMeasure(int n2, int n3) {
        this.setMeasuredDimension(LayoutManager.chooseSize(n2, this.getPaddingLeft() + this.getPaddingRight(), ViewCompat.getMinimumWidth((View)this)), LayoutManager.chooseSize(n3, this.getPaddingTop() + this.getPaddingBottom(), ViewCompat.getMinimumHeight((View)this)));
    }

    /*
     * Enabled aggressive block sorting
     */
    void dispatchLayout() {
        if (this.mAdapter == null) {
            Log.e((String)TAG, (String)"No adapter attached; skipping layout");
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"No layout manager attached; skipping layout");
            return;
        }
        State.access$2202(this.mState, false);
        if (this.mState.mLayoutStep == 1) {
            this.dispatchLayoutStep1();
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else if (this.mAdapterHelper.hasUpdates() || this.mLayout.getWidth() != this.getWidth() || this.mLayout.getHeight() != this.getHeight()) {
            this.mLayout.setExactMeasureSpecsFrom(this);
            this.dispatchLayoutStep2();
        } else {
            this.mLayout.setExactMeasureSpecsFrom(this);
        }
        this.dispatchLayoutStep3();
    }

    @Override
    public boolean dispatchNestedFling(float f2, float f3, boolean bl2) {
        return this.getScrollingChildHelper().dispatchNestedFling(f2, f3, bl2);
    }

    @Override
    public boolean dispatchNestedPreFling(float f2, float f3) {
        return this.getScrollingChildHelper().dispatchNestedPreFling(f2, f3);
    }

    @Override
    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        return this.getScrollingChildHelper().dispatchNestedPreScroll(n2, n3, nArray, nArray2);
    }

    @Override
    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        return this.getScrollingChildHelper().dispatchNestedScroll(n2, n3, n4, n5, nArray);
    }

    void dispatchOnScrollStateChanged(int n2) {
        if (this.mLayout != null) {
            this.mLayout.onScrollStateChanged(n2);
        }
        this.onScrollStateChanged(n2);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(this, n2);
        }
        if (this.mScrollListeners != null) {
            for (int i2 = this.mScrollListeners.size() - 1; i2 >= 0; --i2) {
                this.mScrollListeners.get(i2).onScrollStateChanged(this, n2);
            }
        }
    }

    void dispatchOnScrolled(int n2, int n3) {
        int n4 = this.getScrollX();
        int n5 = this.getScrollY();
        this.onScrollChanged(n4, n5, n4, n5);
        this.onScrolled(n2, n3);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolled(this, n2, n3);
        }
        if (this.mScrollListeners != null) {
            for (n4 = this.mScrollListeners.size() - 1; n4 >= 0; --n4) {
                this.mScrollListeners.get(n4).onScrolled(this, n2, n3);
            }
        }
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        int n2;
        int n3;
        int n4 = 1;
        int n5 = 0;
        super.draw(canvas);
        int n6 = this.mItemDecorations.size();
        for (n3 = 0; n3 < n6; ++n3) {
            this.mItemDecorations.get(n3).onDrawOver(canvas, this, this.mState);
        }
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished()) {
            n2 = canvas.save();
            n3 = this.mClipToPadding ? this.getPaddingBottom() : 0;
            canvas.rotate(270.0f);
            canvas.translate((float)(n3 + -this.getHeight()), 0.0f);
            n6 = this.mLeftGlow != null && this.mLeftGlow.draw(canvas) ? 1 : 0;
            canvas.restoreToCount(n2);
        } else {
            n6 = 0;
        }
        n3 = n6;
        if (this.mTopGlow != null) {
            n3 = n6;
            if (!this.mTopGlow.isFinished()) {
                n2 = canvas.save();
                if (this.mClipToPadding) {
                    canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
                }
                n3 = this.mTopGlow != null && this.mTopGlow.draw(canvas) ? 1 : 0;
                n3 = n6 | n3;
                canvas.restoreToCount(n2);
            }
        }
        n6 = n3;
        if (this.mRightGlow != null) {
            n6 = n3;
            if (!this.mRightGlow.isFinished()) {
                n2 = canvas.save();
                int n7 = this.getWidth();
                n6 = this.mClipToPadding ? this.getPaddingTop() : 0;
                canvas.rotate(90.0f);
                canvas.translate((float)(-n6), (float)(-n7));
                n6 = this.mRightGlow != null && this.mRightGlow.draw(canvas) ? 1 : 0;
                n6 = n3 | n6;
                canvas.restoreToCount(n2);
            }
        }
        n3 = n6;
        if (this.mBottomGlow != null) {
            n3 = n6;
            if (!this.mBottomGlow.isFinished()) {
                n2 = canvas.save();
                canvas.rotate(180.0f);
                if (this.mClipToPadding) {
                    canvas.translate((float)(-this.getWidth() + this.getPaddingRight()), (float)(-this.getHeight() + this.getPaddingBottom()));
                } else {
                    canvas.translate((float)(-this.getWidth()), (float)(-this.getHeight()));
                }
                n3 = n5;
                if (this.mBottomGlow != null) {
                    n3 = n5;
                    if (this.mBottomGlow.draw(canvas)) {
                        n3 = 1;
                    }
                }
                n3 = n6 | n3;
                canvas.restoreToCount(n2);
            }
        }
        if (n3 == 0 && this.mItemAnimator != null && this.mItemDecorations.size() > 0 && this.mItemAnimator.isRunning()) {
            n3 = n4;
        }
        if (n3 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean drawChild(Canvas canvas, View view, long l2) {
        return super.drawChild(canvas, view, l2);
    }

    void eatRequestLayout() {
        ++this.mEatRequestLayout;
        if (this.mEatRequestLayout == 1 && !this.mLayoutFrozen) {
            this.mLayoutRequestEaten = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ensureBottomGlow() {
        if (this.mBottomGlow != null) {
            return;
        }
        this.mBottomGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            return;
        }
        this.mBottomGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ensureLeftGlow() {
        if (this.mLeftGlow != null) {
            return;
        }
        this.mLeftGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            return;
        }
        this.mLeftGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ensureRightGlow() {
        if (this.mRightGlow != null) {
            return;
        }
        this.mRightGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
            return;
        }
        this.mRightGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ensureTopGlow() {
        if (this.mTopGlow != null) {
            return;
        }
        this.mTopGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
            return;
        }
        this.mTopGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View findChildViewUnder(float f2, float f3) {
        int n2 = this.mChildHelper.getChildCount() - 1;
        while (n2 >= 0) {
            View view = this.mChildHelper.getChildAt(n2);
            float f4 = ViewCompat.getTranslationX(view);
            float f5 = ViewCompat.getTranslationY(view);
            if (f2 >= (float)view.getLeft() + f4 && f2 <= f4 + (float)view.getRight() && f3 >= (float)view.getTop() + f5 && f3 <= (float)view.getBottom() + f5) {
                return view;
            }
            --n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public View findContainingItemView(View view) {
        ViewParent viewParent = view.getParent();
        while (viewParent != null && viewParent != this && viewParent instanceof View) {
            view = (View)viewParent;
            viewParent = view.getParent();
        }
        if (viewParent != this) return null;
        return view;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ViewHolder findContainingViewHolder(View object) {
        void var1_4;
        View view = this.findContainingItemView((View)object);
        if (view == null) {
            return var1_4;
        }
        ViewHolder viewHolder = this.getChildViewHolder(view);
        return var1_4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ViewHolder findViewHolderForAdapterPosition(int n2) {
        ViewHolder viewHolder = null;
        if (this.mDataSetHasChangedAfterLayout) {
            return viewHolder;
        }
        int n3 = this.mChildHelper.getUnfilteredChildCount();
        int n4 = 0;
        while (true) {
            ViewHolder viewHolder2 = viewHolder;
            if (n4 >= n3) return viewHolder2;
            viewHolder2 = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n4));
            if (viewHolder2 != null && !viewHolder2.isRemoved() && this.getAdapterPositionFor(viewHolder2) == n2) {
                return viewHolder2;
            }
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ViewHolder findViewHolderForItemId(long l2) {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        int n3 = 0;
        while (n3 < n2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n3));
            if (viewHolder != null && viewHolder.getItemId() == l2) {
                return viewHolder;
            }
            ++n3;
        }
        return null;
    }

    public ViewHolder findViewHolderForLayoutPosition(int n2) {
        return this.findViewHolderForPosition(n2, false);
    }

    @Deprecated
    public ViewHolder findViewHolderForPosition(int n2) {
        return this.findViewHolderForPosition(n2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ViewHolder findViewHolderForPosition(int n2, boolean bl2) {
        int n3 = this.mChildHelper.getUnfilteredChildCount();
        int n4 = 0;
        while (n4 < n3) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n4));
            if (viewHolder != null && !viewHolder.isRemoved()) {
                if (bl2) {
                    if (viewHolder.mPosition == n2) {
                        return viewHolder;
                    }
                } else {
                    ViewHolder viewHolder2 = viewHolder;
                    if (viewHolder.getLayoutPosition() == n2) return viewHolder2;
                }
            }
            ++n4;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean fling(int n2, int n3) {
        int n4;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        block11: {
            block10: {
                block9: {
                    block8: {
                        bl5 = false;
                        if (this.mLayout == null) {
                            Log.e((String)TAG, (String)"Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
                            return bl5;
                        }
                        bl4 = bl5;
                        if (this.mLayoutFrozen) return bl4;
                        bl3 = this.mLayout.canScrollHorizontally();
                        bl2 = this.mLayout.canScrollVertically();
                        if (!bl3) break block8;
                        n4 = n2;
                        if (Math.abs(n2) >= this.mMinFlingVelocity) break block9;
                    }
                    n4 = 0;
                }
                if (!bl2) break block10;
                n2 = n3;
                if (Math.abs(n3) >= this.mMinFlingVelocity) break block11;
            }
            n2 = 0;
        }
        if (n4 == 0) {
            bl4 = bl5;
            if (n2 == 0) return bl4;
        }
        bl4 = bl5;
        if (this.dispatchNestedPreFling(n4, n2)) return bl4;
        bl3 = bl3 || bl2;
        this.dispatchNestedFling(n4, n2, bl3);
        bl4 = bl5;
        if (!bl3) return bl4;
        n3 = Math.max(-this.mMaxFlingVelocity, Math.min(n4, this.mMaxFlingVelocity));
        n2 = Math.max(-this.mMaxFlingVelocity, Math.min(n2, this.mMaxFlingVelocity));
        this.mViewFlinger.fling(n3, n2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View focusSearch(View view, int n2) {
        View view2 = this.mLayout.onInterceptFocusSearch(view, n2);
        if (view2 != null) {
            return view2;
        }
        View view3 = view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n2);
        if (view2 == null) {
            view3 = view2;
            if (this.mAdapter != null) {
                view3 = view2;
                if (this.mLayout != null) {
                    view3 = view2;
                    if (!this.isComputingLayout()) {
                        view3 = view2;
                        if (!this.mLayoutFrozen) {
                            this.eatRequestLayout();
                            view3 = this.mLayout.onFocusSearchFailed(view, n2, this.mRecycler, this.mState);
                            this.resumeRequestLayout(false);
                        }
                    }
                }
            }
        }
        view2 = view3;
        if (view3 != null) return view2;
        return super.focusSearch(view, n2);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateDefaultLayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(layoutParams);
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBaseline() {
        if (this.mLayout == null) return super.getBaseline();
        return this.mLayout.getBaseline();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getChangedHolderKey(ViewHolder viewHolder) {
        if (!this.mAdapter.hasStableIds()) return viewHolder.mPosition;
        return viewHolder.getItemId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getChildAdapterPosition(View object) {
        if ((object = RecyclerView.getChildViewHolderInt((View)object)) == null) return -1;
        return ((ViewHolder)object).getAdapterPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getChildDrawingOrder(int n2, int n3) {
        if (this.mChildDrawingOrderCallback != null) return this.mChildDrawingOrderCallback.onGetChildDrawingOrder(n2, n3);
        return super.getChildDrawingOrder(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getChildItemId(View object) {
        long l2;
        long l3 = l2 = -1L;
        if (this.mAdapter == null) return l3;
        if (!this.mAdapter.hasStableIds()) {
            return l2;
        }
        object = RecyclerView.getChildViewHolderInt((View)object);
        l3 = l2;
        if (object == null) return l3;
        return ((ViewHolder)object).getItemId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getChildLayoutPosition(View object) {
        if ((object = RecyclerView.getChildViewHolderInt((View)object)) == null) return -1;
        return ((ViewHolder)object).getLayoutPosition();
    }

    @Deprecated
    public int getChildPosition(View view) {
        return this.getChildAdapterPosition(view);
    }

    public ViewHolder getChildViewHolder(View view) {
        ViewParent viewParent = view.getParent();
        if (viewParent != null && viewParent != this) {
            throw new IllegalArgumentException("View " + view + " is not a direct child of " + this);
        }
        return RecyclerView.getChildViewHolderInt(view);
    }

    public RecyclerViewAccessibilityDelegate getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Rect getItemDecorInsetsForChild(View view) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (!layoutParams.mInsetsDirty) {
            return layoutParams.mDecorInsets;
        }
        Rect rect = layoutParams.mDecorInsets;
        rect.set(0, 0, 0, 0);
        int n2 = this.mItemDecorations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i2).getItemOffsets(this.mTempRect, view, this, this.mState);
            rect.left += this.mTempRect.left;
            rect.top += this.mTempRect.top;
            rect.right += this.mTempRect.right;
            rect.bottom += this.mTempRect.bottom;
        }
        layoutParams.mInsetsDirty = false;
        return rect;
    }

    public LayoutManager getLayoutManager() {
        return this.mLayout;
    }

    public int getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public RecycledViewPool getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    @Override
    public boolean hasNestedScrollingParent() {
        return this.getScrollingChildHelper().hasNestedScrollingParent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPendingAdapterUpdates() {
        if (!this.mFirstLayoutComplete) return true;
        if (this.mDataSetHasChangedAfterLayout) return true;
        if (!this.mAdapterHelper.hasPendingUpdates()) return false;
        return true;
    }

    void initAdapterManager() {
        this.mAdapterHelper = new AdapterHelper(new AdapterHelper.Callback(){

            /*
             * Enabled aggressive block sorting
             */
            void dispatchUpdate(AdapterHelper.UpdateOp updateOp) {
                switch (updateOp.cmd) {
                    case 1: {
                        RecyclerView.this.mLayout.onItemsAdded(RecyclerView.this, updateOp.positionStart, updateOp.itemCount);
                        return;
                    }
                    case 2: {
                        RecyclerView.this.mLayout.onItemsRemoved(RecyclerView.this, updateOp.positionStart, updateOp.itemCount);
                        return;
                    }
                    case 4: {
                        RecyclerView.this.mLayout.onItemsUpdated(RecyclerView.this, updateOp.positionStart, updateOp.itemCount, updateOp.payload);
                        return;
                    }
                    case 8: {
                        RecyclerView.this.mLayout.onItemsMoved(RecyclerView.this, updateOp.positionStart, updateOp.itemCount, 1);
                        return;
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public ViewHolder findViewHolder(int n2) {
                ViewHolder viewHolder = null;
                ViewHolder viewHolder2 = RecyclerView.this.findViewHolderForPosition(n2, true);
                if (viewHolder2 == null) {
                    return viewHolder;
                }
                if (RecyclerView.this.mChildHelper.isHidden(viewHolder2.itemView)) return viewHolder;
                return viewHolder2;
            }

            @Override
            public void markViewHoldersUpdated(int n2, int n3, Object object) {
                RecyclerView.this.viewRangeUpdate(n2, n3, object);
                RecyclerView.this.mItemsChanged = true;
            }

            @Override
            public void offsetPositionsForAdd(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForInsert(n2, n3);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void offsetPositionsForMove(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForMove(n2, n3);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void offsetPositionsForRemovingInvisible(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForRemove(n2, n3, true);
                RecyclerView.this.mItemsAddedOrRemoved = true;
                State.access$1712(RecyclerView.this.mState, n3);
            }

            @Override
            public void offsetPositionsForRemovingLaidOutOrNewView(int n2, int n3) {
                RecyclerView.this.offsetPositionRecordsForRemove(n2, n3, false);
                RecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void onDispatchFirstPass(AdapterHelper.UpdateOp updateOp) {
                this.dispatchUpdate(updateOp);
            }

            @Override
            public void onDispatchSecondPass(AdapterHelper.UpdateOp updateOp) {
                this.dispatchUpdate(updateOp);
            }
        });
    }

    void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isAccessibilityEnabled() {
        if (this.mAccessibilityManager == null) return false;
        if (!this.mAccessibilityManager.isEnabled()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAnimating() {
        if (this.mItemAnimator == null) return false;
        if (!this.mItemAnimator.isRunning()) return false;
        return true;
    }

    public boolean isAttachedToWindow() {
        return this.mIsAttached;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isComputingLayout() {
        if (this.mLayoutOrScrollCounter <= 0) return false;
        return true;
    }

    public boolean isLayoutFrozen() {
        return this.mLayoutFrozen;
    }

    @Override
    public boolean isNestedScrollingEnabled() {
        return this.getScrollingChildHelper().isNestedScrollingEnabled();
    }

    void markItemDecorInsetsDirty() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((LayoutParams)this.mChildHelper.getUnfilteredChildAt((int)i2).getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.markItemDecorInsetsDirty();
    }

    void markKnownViewsInvalid() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore()) continue;
            viewHolder.addFlags(6);
        }
        this.markItemDecorInsetsDirty();
        this.mRecycler.markKnownViewsInvalid();
    }

    public void offsetChildrenHorizontal(int n2) {
        int n3 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mChildHelper.getChildAt(i2).offsetLeftAndRight(n2);
        }
    }

    public void offsetChildrenVertical(int n2) {
        int n3 = this.mChildHelper.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mChildHelper.getChildAt(i2).offsetTopAndBottom(n2);
        }
    }

    void offsetPositionRecordsForInsert(int n2, int n3) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder == null || viewHolder.shouldIgnore() || viewHolder.mPosition < n2) continue;
            viewHolder.offsetPosition(n3, false);
            State.access$1802(this.mState, true);
        }
        this.mRecycler.offsetPositionRecordsForInsert(n2, n3);
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    void offsetPositionRecordsForMove(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.mChildHelper.getUnfilteredChildCount();
        if (n2 < n3) {
            n6 = -1;
            n5 = n3;
            n4 = n2;
        } else {
            n6 = 1;
            n5 = n2;
            n4 = n3;
        }
        int n8 = 0;
        while (true) {
            if (n8 >= n7) {
                this.mRecycler.offsetPositionRecordsForMove(n2, n3);
                this.requestLayout();
                return;
            }
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n8));
            if (viewHolder != null && viewHolder.mPosition >= n4 && viewHolder.mPosition <= n5) {
                if (viewHolder.mPosition == n2) {
                    viewHolder.offsetPosition(n3 - n2, false);
                } else {
                    viewHolder.offsetPosition(n6, false);
                }
                State.access$1802(this.mState, true);
            }
            ++n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void offsetPositionRecordsForRemove(int n2, int n3, boolean bl2) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        int n5 = 0;
        while (true) {
            if (n5 >= n4) {
                this.mRecycler.offsetPositionRecordsForRemove(n2, n3, bl2);
                this.requestLayout();
                return;
            }
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(n5));
            if (viewHolder != null && !viewHolder.shouldIgnore()) {
                if (viewHolder.mPosition >= n2 + n3) {
                    viewHolder.offsetPosition(-n3, bl2);
                    State.access$1802(this.mState, true);
                } else if (viewHolder.mPosition >= n2) {
                    viewHolder.flagRemovedAndOffsetPosition(n2 - 1, -n3, bl2);
                    State.access$1802(this.mState, true);
                }
            }
            ++n5;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        this.mIsAttached = true;
        this.mFirstLayoutComplete = false;
        if (this.mLayout != null) {
            this.mLayout.dispatchAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
    }

    public void onChildAttachedToWindow(View view) {
    }

    public void onChildDetachedFromWindow(View view) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        this.mFirstLayoutComplete = false;
        this.stopScroll();
        this.mIsAttached = false;
        if (this.mLayout != null) {
            this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
        }
        this.removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.onDetach();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n2 = this.mItemDecorations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mItemDecorations.get(i2).onDraw(canvas, this, this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mLayout == null) {
            return false;
        }
        if (this.mLayoutFrozen) return false;
        if ((MotionEventCompat.getSource(motionEvent) & 2) == 0) return false;
        if (motionEvent.getAction() != 8) return false;
        float f2 = this.mLayout.canScrollVertically() ? -MotionEventCompat.getAxisValue(motionEvent, 9) : 0.0f;
        float f3 = this.mLayout.canScrollHorizontally() ? MotionEventCompat.getAxisValue(motionEvent, 10) : 0.0f;
        if (f2 == 0.0f) {
            if (f3 == 0.0f) return false;
        }
        float f4 = this.getScrollFactor();
        this.scrollByInternal((int)(f3 * f4), (int)(f2 * f4), motionEvent);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent object) {
        boolean bl2;
        block18: {
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl3;
            int n6;
            block19: {
                n6 = -1;
                boolean bl4 = false;
                bl2 = true;
                if (this.mLayoutFrozen) {
                    return bl4;
                }
                if (this.dispatchOnItemTouchIntercept((MotionEvent)object)) {
                    this.cancelTouch();
                    return true;
                }
                bl3 = bl4;
                if (this.mLayout == null) return bl3;
                boolean bl5 = this.mLayout.canScrollHorizontally();
                bl3 = this.mLayout.canScrollVertically();
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(object);
                n5 = MotionEventCompat.getActionMasked(object);
                n4 = MotionEventCompat.getActionIndex(object);
                switch (n5) {
                    case 0: {
                        if (this.mIgnoreMotionEventTillDown) {
                            this.mIgnoreMotionEventTillDown = false;
                        }
                        this.mScrollPointerId = MotionEventCompat.getPointerId(object, 0);
                        this.mLastTouchX = n4 = (int)(object.getX() + 0.5f);
                        this.mInitialTouchX = n4;
                        this.mLastTouchY = n4 = (int)(object.getY() + 0.5f);
                        this.mInitialTouchY = n4;
                        if (this.mScrollState == 2) {
                            this.getParent().requestDisallowInterceptTouchEvent(true);
                            this.setScrollState(1);
                        }
                        int[] nArray = this.mNestedOffsets;
                        this.mNestedOffsets[1] = 0;
                        nArray[0] = 0;
                        n4 = bl5 ? 1 : 0;
                    }
                    case 5: {
                        this.mScrollPointerId = MotionEventCompat.getPointerId(object, n4);
                        this.mLastTouchX = n5 = (int)(MotionEventCompat.getX(object, n4) + 0.5f);
                        this.mInitialTouchX = n5;
                        this.mLastTouchY = n4 = (int)(MotionEventCompat.getY(object, n4) + 0.5f);
                        this.mInitialTouchY = n4;
                        break block18;
                    }
                    case 2: {
                        n5 = MotionEventCompat.findPointerIndex(object, this.mScrollPointerId);
                        if (n5 < 0) {
                            Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                            return bl4;
                        }
                        n4 = (int)(MotionEventCompat.getX(object, n5) + 0.5f);
                        n5 = (int)(MotionEventCompat.getY(object, n5) + 0.5f);
                        if (this.mScrollState == 1) break block18;
                        n3 = n5 - this.mInitialTouchY;
                        if (!bl5 || Math.abs(n4 -= this.mInitialTouchX) <= this.mTouchSlop) break;
                        n2 = this.mInitialTouchX;
                        n5 = this.mTouchSlop;
                        n4 = n4 < 0 ? -1 : 1;
                        this.mLastTouchX = n4 * n5 + n2;
                        n4 = 1;
                        break block19;
                    }
                    case 6: {
                        this.onPointerUp((MotionEvent)object);
                        break block18;
                    }
                    case 1: {
                        this.mVelocityTracker.clear();
                        this.stopNestedScroll();
                        break block18;
                    }
                    case 3: {
                        this.cancelTouch();
                        break block18;
                    }
                }
                n4 = 0;
            }
            n5 = n4;
            if (bl3) {
                n5 = n4;
                if (Math.abs(n3) > this.mTouchSlop) {
                    n2 = this.mInitialTouchY;
                    n5 = this.mTouchSlop;
                    n4 = n3 < 0 ? n6 : 1;
                    this.mLastTouchY = n2 + n4 * n5;
                    n5 = 1;
                }
            }
            if (n5 != 0) {
                this.setScrollState(1);
            }
            break block18;
            n5 = n4;
            if (bl3) {
                n5 = n4 | 2;
            }
            this.startNestedScroll(n5);
        }
        if (this.mScrollState != 1) return false;
        return bl2;
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        TraceCompat.beginSection(TRACE_ON_LAYOUT_TAG);
        this.dispatchLayout();
        TraceCompat.endSection();
        this.mFirstLayoutComplete = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        boolean bl2 = false;
        if (this.mLayout == null) {
            this.defaultOnMeasure(n2, n3);
            return;
        }
        if (this.mLayout.mAutoMeasure) {
            int n4 = View.MeasureSpec.getMode((int)n2);
            int n5 = View.MeasureSpec.getMode((int)n3);
            boolean bl3 = bl2;
            if (n4 == 0x40000000) {
                bl3 = bl2;
                if (n5 == 0x40000000) {
                    bl3 = true;
                }
            }
            this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
            if (bl3) return;
            if (this.mAdapter == null) return;
            if (this.mState.mLayoutStep == 1) {
                this.dispatchLayoutStep1();
            }
            this.mLayout.setMeasureSpecs(n2, n3);
            State.access$2202(this.mState, true);
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(n2, n3);
            if (!this.mLayout.shouldMeasureTwice()) return;
            this.mLayout.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
            State.access$2202(this.mState, true);
            this.dispatchLayoutStep2();
            this.mLayout.setMeasuredDimensionFromChildren(n2, n3);
            return;
        }
        if (this.mHasFixedSize) {
            this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
            return;
        }
        if (this.mAdapterUpdateDuringMeasure) {
            this.eatRequestLayout();
            this.processAdapterUpdatesAndSetAnimationFlags();
            if (this.mState.mRunPredictiveAnimations) {
                State.access$2402(this.mState, true);
            } else {
                this.mAdapterHelper.consumeUpdatesInOnePass();
                State.access$2402(this.mState, false);
            }
            this.mAdapterUpdateDuringMeasure = false;
            this.resumeRequestLayout(false);
        }
        this.mState.mItemCount = this.mAdapter != null ? this.mAdapter.getItemCount() : 0;
        this.eatRequestLayout();
        this.mLayout.onMeasure(this.mRecycler, this.mState, n2, n3);
        this.resumeRequestLayout(false);
        State.access$2402(this.mState, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        this.mPendingSavedState = (SavedState)parcelable;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        if (this.mLayout == null) return;
        if (this.mPendingSavedState.mLayoutState == null) return;
        this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSavedState != null) {
            savedState.copyFrom(this.mPendingSavedState);
            return savedState;
        }
        if (this.mLayout != null) {
            savedState.mLayoutState = this.mLayout.onSaveInstanceState();
            return savedState;
        }
        savedState.mLayoutState = null;
        return savedState;
    }

    public void onScrollStateChanged(int n2) {
    }

    public void onScrolled(int n2, int n3) {
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4 || n3 != n5) {
            this.invalidateGlows();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block33: {
            block32: {
                block31: {
                    block30: {
                        var2_2 = 0;
                        var4_4 = var3_3 = false;
                        if (this.mLayoutFrozen) break block30;
                        if (!this.mIgnoreMotionEventTillDown) break block31;
                        var4_4 = var3_3;
                    }
lbl7:
                    // 5 sources

                    return var4_4;
                }
                if (!this.dispatchOnItemTouch(var1_1 /* !! */ )) break block32;
                this.cancelTouch();
                var4_4 = true;
                ** GOTO lbl7
            }
            var4_4 = var3_3;
            if (this.mLayout == null) ** GOTO lbl7
            var5_5 = this.mLayout.canScrollHorizontally();
            var4_4 = this.mLayout.canScrollVertically();
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            var6_6 = MotionEvent.obtain((MotionEvent)var1_1 /* !! */ );
            var7_7 = MotionEventCompat.getActionMasked(var1_1 /* !! */ );
            var8_8 = MotionEventCompat.getActionIndex(var1_1 /* !! */ );
            if (var7_7 == 0) {
                var9_9 = this.mNestedOffsets;
                this.mNestedOffsets[1] = 0;
                var9_9[0] = 0;
            }
            var6_6.offsetLocation((float)this.mNestedOffsets[0], (float)this.mNestedOffsets[1]);
            var10_10 = var2_2;
            switch (var7_7) {
                default: {
                    var10_10 = var2_2;
                }
lbl33:
                // 10 sources

                case 4: {
                    if (var10_10 == 0) {
                        this.mVelocityTracker.addMovement(var6_6);
                    }
                    var6_6.recycle();
                    var4_4 = true;
                    ** GOTO lbl7
                }
                case 0: {
                    this.mScrollPointerId = MotionEventCompat.getPointerId(var1_1 /* !! */ , 0);
                    this.mLastTouchX = var10_10 = (int)(var1_1 /* !! */ .getX() + 0.5f);
                    this.mInitialTouchX = var10_10;
                    this.mLastTouchY = var10_10 = (int)(var1_1 /* !! */ .getY() + 0.5f);
                    this.mInitialTouchY = var10_10;
                    if (!var5_5) break block33;
                    var10_10 = 1;
lbl47:
                    // 2 sources

                    while (true) {
                        var8_8 = var10_10;
                        if (var4_4) {
                            var8_8 = var10_10 | 2;
                        }
                        this.startNestedScroll(var8_8);
                        var10_10 = var2_2;
                        ** GOTO lbl33
                        break;
                    }
                }
                case 5: {
                    this.mScrollPointerId = MotionEventCompat.getPointerId(var1_1 /* !! */ , var8_8);
                    this.mLastTouchX = var10_10 = (int)(MotionEventCompat.getX(var1_1 /* !! */ , var8_8) + 0.5f);
                    this.mInitialTouchX = var10_10;
                    this.mLastTouchY = var10_10 = (int)(MotionEventCompat.getY(var1_1 /* !! */ , var8_8) + 0.5f);
                    this.mInitialTouchY = var10_10;
                    var10_10 = var2_2;
                    ** GOTO lbl33
                }
                case 2: {
                    var10_10 = MotionEventCompat.findPointerIndex(var1_1 /* !! */ , this.mScrollPointerId);
                    if (var10_10 < 0) {
                        Log.e((String)"RecyclerView", (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                        var4_4 = var3_3;
                        ** continue;
                    }
                    var11_11 = (int)(MotionEventCompat.getX(var1_1 /* !! */ , var10_10) + 0.5f);
                    var12_12 = (int)(MotionEventCompat.getY(var1_1 /* !! */ , var10_10) + 0.5f);
                    var13_13 = this.mLastTouchX - var11_11;
                    var10_10 = var7_7 = this.mLastTouchY - var12_12;
                    var8_8 = var13_13;
                    if (this.dispatchNestedPreScroll(var13_13, var7_7, this.mScrollConsumed, this.mScrollOffset)) {
                        var8_8 = var13_13 - this.mScrollConsumed[0];
                        var10_10 = var7_7 - this.mScrollConsumed[1];
                        var6_6.offsetLocation((float)this.mScrollOffset[0], (float)this.mScrollOffset[1]);
                        var1_1 /* !! */  = (MotionEvent)this.mNestedOffsets;
                        var1_1 /* !! */ [0] = var1_1 /* !! */ [0] + this.mScrollOffset[0];
                        var1_1 /* !! */  = (MotionEvent)this.mNestedOffsets;
                        var1_1 /* !! */ [1] = var1_1 /* !! */ [1] + this.mScrollOffset[1];
                    }
                    var7_7 = var10_10;
                    var13_13 = var8_8;
                    if (this.mScrollState == 1) ** GOTO lbl108
                    if (!var5_5 || Math.abs(var8_8) <= this.mTouchSlop) break;
                    if (var8_8 <= 0) ** GOTO lbl121
                    var8_8 -= this.mTouchSlop;
lbl89:
                    // 2 sources

                    while (true) {
                        var7_7 = 1;
lbl91:
                        // 2 sources

                        while (true) {
                            var14_14 = var10_10;
                            var15_15 = var7_7;
                            if (!var4_4) ** GOTO lbl102
                            var14_14 = var10_10;
                            var15_15 = var7_7;
                            if (Math.abs(var10_10) <= this.mTouchSlop) ** GOTO lbl102
                            if (var10_10 <= 0) ** GOTO lbl123
                            var14_14 = var10_10 - this.mTouchSlop;
lbl100:
                            // 2 sources

                            while (true) {
                                var15_15 = 1;
lbl102:
                                // 3 sources

                                var7_7 = var14_14;
                                var13_13 = var8_8;
                                if (var15_15 != 0) {
                                    this.setScrollState(1);
                                    var13_13 = var8_8;
                                    var7_7 = var14_14;
                                }
lbl108:
                                // 4 sources

                                var10_10 = var2_2;
                                if (this.mScrollState != 1) ** GOTO lbl33
                                this.mLastTouchX = var11_11 - this.mScrollOffset[0];
                                this.mLastTouchY = var12_12 - this.mScrollOffset[1];
                                if (!var5_5) ** GOTO lbl125
lbl113:
                                // 2 sources

                                while (var4_4) lbl-1000:
                                // 2 sources

                                {
                                    while (true) {
                                        var10_10 = var2_2;
                                        if (!this.scrollByInternal(var13_13, var7_7, var6_6)) ** GOTO lbl33
                                        this.getParent().requestDisallowInterceptTouchEvent(true);
                                        var10_10 = var2_2;
                                        ** GOTO lbl33
                                        break;
                                    }
                                }
                                ** GOTO lbl127
                                break;
                            }
                            break;
                        }
                        break;
                    }
lbl121:
                    // 1 sources

                    var8_8 += this.mTouchSlop;
                    ** continue;
lbl123:
                    // 1 sources

                    var14_14 = var10_10 + this.mTouchSlop;
                    ** continue;
lbl125:
                    // 1 sources

                    var13_13 = 0;
                    ** GOTO lbl113
lbl127:
                    // 1 sources

                    var7_7 = 0;
                    ** continue;
                }
                case 6: {
                    this.onPointerUp(var1_1 /* !! */ );
                    var10_10 = var2_2;
                    ** GOTO lbl33
                }
                case 1: {
                    this.mVelocityTracker.addMovement(var6_6);
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    if (!var5_5) ** GOTO lbl147
                    var16_16 = -VelocityTrackerCompat.getXVelocity(this.mVelocityTracker, this.mScrollPointerId);
lbl138:
                    // 2 sources

                    while (var4_4) {
                        var17_17 = -VelocityTrackerCompat.getYVelocity(this.mVelocityTracker, this.mScrollPointerId);
lbl140:
                        // 2 sources

                        while (true) {
                            if (var16_16 == 0.0f && var17_17 == 0.0f || !this.fling((int)var16_16, (int)var17_17)) {
                                this.setScrollState(0);
                            }
                            this.resetTouch();
                            var10_10 = 1;
                            ** GOTO lbl33
                            break;
                        }
                    }
                    ** GOTO lbl149
lbl147:
                    // 1 sources

                    var16_16 = 0.0f;
                    ** GOTO lbl138
lbl149:
                    // 1 sources

                    var17_17 = 0.0f;
                    ** continue;
                }
                case 3: {
                    this.cancelTouch();
                    var10_10 = var2_2;
                    ** GOTO lbl33
                }
            }
            var7_7 = 0;
            ** while (true)
        }
        var10_10 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void removeDetachedView(View view, boolean bl2) {
        ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
        if (viewHolder != null) {
            if (viewHolder.isTmpDetached()) {
                viewHolder.clearTmpDetachFlag();
            } else if (!viewHolder.shouldIgnore()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + viewHolder);
            }
        }
        this.dispatchChildDetached(view);
        super.removeDetachedView(view, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeItemDecoration(ItemDecoration itemDecoration) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(itemDecoration);
        if (this.mItemDecorations.isEmpty()) {
            boolean bl2 = ViewCompat.getOverScrollMode((View)this) == 2;
            this.setWillNotDraw(bl2);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeOnChildAttachStateChangeListener(OnChildAttachStateChangeListener onChildAttachStateChangeListener) {
        if (this.mOnChildAttachStateListeners == null) {
            return;
        }
        this.mOnChildAttachStateListeners.remove(onChildAttachStateChangeListener);
    }

    public void removeOnItemTouchListener(OnItemTouchListener onItemTouchListener) {
        this.mOnItemTouchListeners.remove(onItemTouchListener);
        if (this.mActiveOnItemTouchListener == onItemTouchListener) {
            this.mActiveOnItemTouchListener = null;
        }
    }

    public void removeOnScrollListener(OnScrollListener onScrollListener) {
        if (this.mScrollListeners != null) {
            this.mScrollListeners.remove(onScrollListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestChildFocus(View view, View view2) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, view, view2) && view2 != null) {
            this.mTempRect.set(0, 0, view2.getWidth(), view2.getHeight());
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams instanceof LayoutParams) {
                LayoutParams layoutParams2 = (LayoutParams)layoutParams;
                if (!layoutParams2.mInsetsDirty) {
                    Rect rect = layoutParams2.mDecorInsets;
                    Rect rect2 = this.mTempRect;
                    rect2.left -= rect.left;
                    rect2 = this.mTempRect;
                    rect2.right += rect.right;
                    rect2 = this.mTempRect;
                    rect2.top -= rect.top;
                    rect2 = this.mTempRect;
                    int n2 = rect2.bottom;
                    rect2.bottom = rect.bottom + n2;
                }
            }
            this.offsetDescendantRectToMyCoords(view2, this.mTempRect);
            this.offsetRectIntoDescendantCoords(view, this.mTempRect);
            Rect rect = this.mTempRect;
            boolean bl2 = !this.mFirstLayoutComplete;
            this.requestChildRectangleOnScreen(view, rect, bl2);
        }
        super.requestChildFocus(view, view2);
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl2) {
        return this.mLayout.requestChildRectangleOnScreen(this, view, rect, bl2);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl2) {
        int n2 = this.mOnItemTouchListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mOnItemTouchListeners.get(i2).onRequestDisallowInterceptTouchEvent(bl2);
        }
        super.requestDisallowInterceptTouchEvent(bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requestLayout() {
        if (this.mEatRequestLayout == 0 && !this.mLayoutFrozen) {
            super.requestLayout();
            return;
        }
        this.mLayoutRequestEaten = true;
    }

    void resumeRequestLayout(boolean bl2) {
        if (this.mEatRequestLayout < 1) {
            this.mEatRequestLayout = 1;
        }
        if (!bl2) {
            this.mLayoutRequestEaten = false;
        }
        if (this.mEatRequestLayout == 1) {
            if (bl2 && this.mLayoutRequestEaten && !this.mLayoutFrozen && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            if (!this.mLayoutFrozen) {
                this.mLayoutRequestEaten = false;
            }
        }
        --this.mEatRequestLayout;
    }

    void saveOldPositions() {
        int n2 = this.mChildHelper.getUnfilteredChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i2));
            if (viewHolder.shouldIgnore()) continue;
            viewHolder.saveOldPosition();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void scrollBy(int n2, int n3) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutFrozen) return;
        boolean bl2 = this.mLayout.canScrollHorizontally();
        boolean bl3 = this.mLayout.canScrollVertically();
        if (!bl2) {
            if (!bl3) return;
        }
        if (!bl2) {
            n2 = 0;
        }
        if (!bl3) {
            n3 = 0;
        }
        this.scrollByInternal(n2, n3, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean scrollByInternal(int n2, int n3, MotionEvent object) {
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl2 = false;
        this.consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            this.eatRequestLayout();
            this.onEnterLayoutOrScroll();
            TraceCompat.beginSection(TRACE_SCROLL_TAG);
            if (n2 != 0) {
                n7 = this.mLayout.scrollHorizontallyBy(n2, this.mRecycler, this.mState);
                n6 = n2 - n7;
            } else {
                n7 = 0;
                n6 = 0;
            }
            if (n3 != 0) {
                n5 = this.mLayout.scrollVerticallyBy(n3, this.mRecycler, this.mState);
                n4 = n3 - n5;
            } else {
                n5 = 0;
                n4 = 0;
            }
            TraceCompat.endSection();
            this.repositionShadowingViews();
            this.onExitLayoutOrScroll();
            this.resumeRequestLayout(false);
            int n8 = n5;
            n5 = n4;
            n4 = n6;
            n6 = n8;
        } else {
            n6 = 0;
            n7 = 0;
            n5 = 0;
            n4 = 0;
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        if (this.dispatchNestedScroll(n7, n6, n4, n5, this.mScrollOffset)) {
            this.mLastTouchX -= this.mScrollOffset[0];
            this.mLastTouchY -= this.mScrollOffset[1];
            if (object != null) {
                object.offsetLocation((float)this.mScrollOffset[0], (float)this.mScrollOffset[1]);
            }
            int[] nArray = this.mNestedOffsets;
            nArray[0] = nArray[0] + this.mScrollOffset[0];
            int[] nArray2 = this.mNestedOffsets;
            nArray2[1] = nArray2[1] + this.mScrollOffset[1];
        } else if (ViewCompat.getOverScrollMode((View)this) != 2) {
            if (object != null) {
                this.pullGlows(object.getX(), n4, object.getY(), n5);
            }
            this.considerReleasingGlowsOnScroll(n2, n3);
        }
        if (n7 != 0 || n6 != 0) {
            this.dispatchOnScrolled(n7, n6);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        if (n7 != 0) return true;
        if (n6 == 0) return bl2;
        return true;
    }

    public void scrollTo(int n2, int n3) {
        Log.w((String)TAG, (String)"RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scrollToPosition(int n2) {
        if (this.mLayoutFrozen) {
            return;
        }
        this.stopScroll();
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.scrollToPosition(n2);
        this.awakenScrollBars();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (this.shouldDeferAccessibilityEvent(accessibilityEvent)) {
            return;
        }
        super.sendAccessibilityEventUnchecked(accessibilityEvent);
    }

    public void setAccessibilityDelegateCompat(RecyclerViewAccessibilityDelegate recyclerViewAccessibilityDelegate) {
        this.mAccessibilityDelegate = recyclerViewAccessibilityDelegate;
        ViewCompat.setAccessibilityDelegate((View)this, this.mAccessibilityDelegate);
    }

    public void setAdapter(Adapter adapter) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, false, true);
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setChildDrawingOrderCallback(ChildDrawingOrderCallback childDrawingOrderCallback) {
        if (childDrawingOrderCallback == this.mChildDrawingOrderCallback) {
            return;
        }
        this.mChildDrawingOrderCallback = childDrawingOrderCallback;
        boolean bl2 = this.mChildDrawingOrderCallback != null;
        this.setChildrenDrawingOrderEnabled(bl2);
    }

    public void setClipToPadding(boolean bl2) {
        if (bl2 != this.mClipToPadding) {
            this.invalidateGlows();
        }
        this.mClipToPadding = bl2;
        super.setClipToPadding(bl2);
        if (this.mFirstLayoutComplete) {
            this.requestLayout();
        }
    }

    public void setHasFixedSize(boolean bl2) {
        this.mHasFixedSize = bl2;
    }

    public void setItemAnimator(ItemAnimator itemAnimator) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
            this.mItemAnimator.setListener(null);
        }
        this.mItemAnimator = itemAnimator;
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    public void setItemViewCacheSize(int n2) {
        this.mRecycler.setViewCacheSize(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLayoutFrozen(boolean bl2) {
        block6: {
            block5: {
                if (bl2 == this.mLayoutFrozen) break block5;
                this.assertNotInLayoutOrScroll("Do not setLayoutFrozen in layout or scroll");
                if (bl2) break block6;
                this.mLayoutFrozen = false;
                if (this.mLayoutRequestEaten && this.mLayout != null && this.mAdapter != null) {
                    this.requestLayout();
                }
                this.mLayoutRequestEaten = false;
            }
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.onTouchEvent(MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0));
        this.mLayoutFrozen = true;
        this.mIgnoreMotionEventTillDown = true;
        this.stopScroll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLayoutManager(LayoutManager layoutManager) {
        if (layoutManager == this.mLayout) {
            return;
        }
        this.stopScroll();
        if (this.mLayout != null) {
            if (this.mIsAttached) {
                this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
            }
            this.mLayout.setRecyclerView(null);
        }
        this.mRecycler.clear();
        this.mChildHelper.removeAllViewsUnfiltered();
        this.mLayout = layoutManager;
        if (layoutManager != null) {
            if (layoutManager.mRecyclerView != null) {
                throw new IllegalArgumentException("LayoutManager " + layoutManager + " is already attached to a RecyclerView: " + layoutManager.mRecyclerView);
            }
            this.mLayout.setRecyclerView(this);
            if (this.mIsAttached) {
                this.mLayout.dispatchAttachedToWindow(this);
            }
        }
        this.requestLayout();
    }

    @Override
    public void setNestedScrollingEnabled(boolean bl2) {
        this.getScrollingChildHelper().setNestedScrollingEnabled(bl2);
    }

    @Deprecated
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mScrollListener = onScrollListener;
    }

    public void setRecycledViewPool(RecycledViewPool recycledViewPool) {
        this.mRecycler.setRecycledViewPool(recycledViewPool);
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        this.mRecyclerListener = recyclerListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScrollingTouchSlop(int n2) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        switch (n2) {
            default: {
                Log.w((String)TAG, (String)("setScrollingTouchSlop(): bad argument constant " + n2 + "; using default value"));
            }
            case 0: {
                this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
                return;
            }
            case 1: 
        }
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
    }

    public void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
        this.mRecycler.setViewCacheExtension(viewCacheExtension);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean shouldDeferAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl2 = false;
        int n2 = 0;
        if (!this.isComputingLayout()) return bl2;
        int n3 = accessibilityEvent != null ? AccessibilityEventCompat.getContentChangeTypes(accessibilityEvent) : 0;
        if (n3 == 0) {
            n3 = n2;
        }
        this.mEatenAccessibilityChangeFlags = n3 | this.mEatenAccessibilityChangeFlags;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void smoothScrollBy(int n2, int n3) {
        int n4 = 0;
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (this.mLayoutFrozen) return;
        if (!this.mLayout.canScrollHorizontally()) {
            n2 = 0;
        }
        if (!this.mLayout.canScrollVertically()) {
            n3 = n4;
        }
        if (n2 == 0) {
            if (n3 == 0) return;
        }
        this.mViewFlinger.smoothScrollBy(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void smoothScrollToPosition(int n2) {
        if (this.mLayoutFrozen) {
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.smoothScrollToPosition(this, this.mState, n2);
    }

    @Override
    public boolean startNestedScroll(int n2) {
        return this.getScrollingChildHelper().startNestedScroll(n2);
    }

    @Override
    public void stopNestedScroll() {
        this.getScrollingChildHelper().stopNestedScroll();
    }

    public void stopScroll() {
        this.setScrollState(0);
        this.stopScrollersInternal();
    }

    public void swapAdapter(Adapter adapter, boolean bl2) {
        this.setLayoutFrozen(false);
        this.setAdapterInternal(adapter, true, bl2);
        this.setDataSetChangedAfterLayout();
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    void viewRangeUpdate(int n2, int n3, Object object) {
        int n4 = this.mChildHelper.getUnfilteredChildCount();
        int n5 = 0;
        while (true) {
            if (n5 >= n4) {
                this.mRecycler.viewRangeUpdate(n2, n3);
                return;
            }
            View view = this.mChildHelper.getUnfilteredChildAt(n5);
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder != null && !viewHolder.shouldIgnore() && viewHolder.mPosition >= n2 && viewHolder.mPosition < n2 + n3) {
                viewHolder.addFlags(2);
                viewHolder.addChangePayload(object);
                ((LayoutParams)view.getLayoutParams()).mInsetsDirty = true;
            }
            ++n5;
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private boolean mHasStableIds = false;
        private final AdapterDataObservable mObservable = new AdapterDataObservable();

        public final void bindViewHolder(VH VH, int n2) {
            ((ViewHolder)VH).mPosition = n2;
            if (this.hasStableIds()) {
                ((ViewHolder)VH).mItemId = this.getItemId(n2);
            }
            ((ViewHolder)VH).setFlags(1, 519);
            TraceCompat.beginSection(RecyclerView.TRACE_BIND_VIEW_TAG);
            this.onBindViewHolder(VH, n2, ((ViewHolder)VH).getUnmodifiedPayloads());
            ((ViewHolder)VH).clearPayload();
            TraceCompat.endSection();
        }

        public final VH createViewHolder(ViewGroup object, int n2) {
            TraceCompat.beginSection(RecyclerView.TRACE_CREATE_VIEW_TAG);
            object = this.onCreateViewHolder((ViewGroup)object, n2);
            object.mItemViewType = n2;
            TraceCompat.endSection();
            return (VH)object;
        }

        public abstract int getItemCount();

        public long getItemId(int n2) {
            return -1L;
        }

        public int getItemViewType(int n2) {
            return 0;
        }

        public final boolean hasObservers() {
            return this.mObservable.hasObservers();
        }

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public final void notifyItemChanged(int n2) {
            this.mObservable.notifyItemRangeChanged(n2, 1);
        }

        public final void notifyItemChanged(int n2, Object object) {
            this.mObservable.notifyItemRangeChanged(n2, 1, object);
        }

        public final void notifyItemInserted(int n2) {
            this.mObservable.notifyItemRangeInserted(n2, 1);
        }

        public final void notifyItemMoved(int n2, int n3) {
            this.mObservable.notifyItemMoved(n2, n3);
        }

        public final void notifyItemRangeChanged(int n2, int n3) {
            this.mObservable.notifyItemRangeChanged(n2, n3);
        }

        public final void notifyItemRangeChanged(int n2, int n3, Object object) {
            this.mObservable.notifyItemRangeChanged(n2, n3, object);
        }

        public final void notifyItemRangeInserted(int n2, int n3) {
            this.mObservable.notifyItemRangeInserted(n2, n3);
        }

        public final void notifyItemRangeRemoved(int n2, int n3) {
            this.mObservable.notifyItemRangeRemoved(n2, n3);
        }

        public final void notifyItemRemoved(int n2) {
            this.mObservable.notifyItemRangeRemoved(n2, 1);
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        }

        public abstract void onBindViewHolder(VH var1, int var2);

        public void onBindViewHolder(VH VH, int n2, List<Object> list) {
            this.onBindViewHolder(VH, n2);
        }

        public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        }

        public boolean onFailedToRecycleView(VH VH) {
            return false;
        }

        public void onViewAttachedToWindow(VH VH) {
        }

        public void onViewDetachedFromWindow(VH VH) {
        }

        public void onViewRecycled(VH VH) {
        }

        public void registerAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            this.mObservable.registerObserver(adapterDataObserver);
        }

        public void setHasStableIds(boolean bl2) {
            if (this.hasObservers()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.mHasStableIds = bl2;
        }

        public void unregisterAdapterDataObserver(AdapterDataObserver adapterDataObserver) {
            this.mObservable.unregisterObserver(adapterDataObserver);
        }
    }

    static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        AdapterDataObservable() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasObservers() {
            if (this.mObservers.isEmpty()) return false;
            return true;
        }

        public void notifyChanged() {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onChanged();
            }
        }

        public void notifyItemMoved(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeMoved(n2, n3, 1);
            }
        }

        public void notifyItemRangeChanged(int n2, int n3) {
            this.notifyItemRangeChanged(n2, n3, null);
        }

        public void notifyItemRangeChanged(int n2, int n3, Object object) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeChanged(n2, n3, object);
            }
        }

        public void notifyItemRangeInserted(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeInserted(n2, n3);
            }
        }

        public void notifyItemRangeRemoved(int n2, int n3) {
            for (int i2 = this.mObservers.size() - 1; i2 >= 0; --i2) {
                ((AdapterDataObserver)this.mObservers.get(i2)).onItemRangeRemoved(n2, n3);
            }
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int n2, int n3) {
        }

        public void onItemRangeChanged(int n2, int n3, Object object) {
            this.onItemRangeChanged(n2, n3);
        }

        public void onItemRangeInserted(int n2, int n3) {
        }

        public void onItemRangeMoved(int n2, int n3, int n4) {
        }

        public void onItemRangeRemoved(int n2, int n3) {
        }
    }

    public static interface ChildDrawingOrderCallback {
        public int onGetChildDrawingOrder(int var1, int var2);
    }

    public static abstract class ItemAnimator {
        public static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        public static final int FLAG_CHANGED = 2;
        public static final int FLAG_INVALIDATED = 4;
        public static final int FLAG_MOVED = 2048;
        public static final int FLAG_REMOVED = 8;
        private long mAddDuration = 120L;
        private long mChangeDuration = 250L;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners = new ArrayList();
        private ItemAnimatorListener mListener = null;
        private long mMoveDuration = 250L;
        private long mRemoveDuration = 120L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static int buildAdapterChangeFlagsForAnimations(ViewHolder viewHolder) {
            int n2 = viewHolder.mFlags & 0xE;
            if (viewHolder.isInvalid()) {
                return 4;
            }
            int n3 = n2;
            if ((n2 & 4) != 0) return n3;
            int n4 = viewHolder.getOldPosition();
            int n5 = viewHolder.getAdapterPosition();
            n3 = n2;
            if (n4 == -1) return n3;
            n3 = n2;
            if (n5 == -1) return n3;
            n3 = n2;
            if (n4 == n5) return n3;
            return n2 | 0x800;
        }

        public abstract boolean animateAppearance(@NonNull ViewHolder var1, @Nullable ItemHolderInfo var2, @NonNull ItemHolderInfo var3);

        public abstract boolean animateChange(@NonNull ViewHolder var1, @NonNull ViewHolder var2, @NonNull ItemHolderInfo var3, @NonNull ItemHolderInfo var4);

        public abstract boolean animateDisappearance(@NonNull ViewHolder var1, @NonNull ItemHolderInfo var2, @Nullable ItemHolderInfo var3);

        public abstract boolean animatePersistence(@NonNull ViewHolder var1, @NonNull ItemHolderInfo var2, @NonNull ItemHolderInfo var3);

        public boolean canReuseUpdatedViewHolder(@NonNull ViewHolder viewHolder) {
            return true;
        }

        public boolean canReuseUpdatedViewHolder(@NonNull ViewHolder viewHolder, @NonNull List<Object> list) {
            return this.canReuseUpdatedViewHolder(viewHolder);
        }

        public final void dispatchAnimationFinished(ViewHolder viewHolder) {
            this.onAnimationFinished(viewHolder);
            if (this.mListener != null) {
                this.mListener.onAnimationFinished(viewHolder);
            }
        }

        public final void dispatchAnimationStarted(ViewHolder viewHolder) {
            this.onAnimationStarted(viewHolder);
        }

        public final void dispatchAnimationsFinished() {
            int n2 = this.mFinishedListeners.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mFinishedListeners.get(i2).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        public abstract void endAnimation(ViewHolder var1);

        public abstract void endAnimations();

        public long getAddDuration() {
            return this.mAddDuration;
        }

        public long getChangeDuration() {
            return this.mChangeDuration;
        }

        public long getMoveDuration() {
            return this.mMoveDuration;
        }

        public long getRemoveDuration() {
            return this.mRemoveDuration;
        }

        public abstract boolean isRunning();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isRunning(ItemAnimatorFinishedListener itemAnimatorFinishedListener) {
            boolean bl2;
            block4: {
                block3: {
                    bl2 = this.isRunning();
                    if (itemAnimatorFinishedListener == null) break block3;
                    if (bl2) break block4;
                    itemAnimatorFinishedListener.onAnimationsFinished();
                }
                return bl2;
            }
            this.mFinishedListeners.add(itemAnimatorFinishedListener);
            return bl2;
        }

        public ItemHolderInfo obtainHolderInfo() {
            return new ItemHolderInfo();
        }

        public void onAnimationFinished(ViewHolder viewHolder) {
        }

        public void onAnimationStarted(ViewHolder viewHolder) {
        }

        @NonNull
        public ItemHolderInfo recordPostLayoutInformation(@NonNull State state, @NonNull ViewHolder viewHolder) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        @NonNull
        public ItemHolderInfo recordPreLayoutInformation(@NonNull State state, @NonNull ViewHolder viewHolder, int n2, @NonNull List<Object> list) {
            return this.obtainHolderInfo().setFrom(viewHolder);
        }

        public abstract void runPendingAnimations();

        public void setAddDuration(long l2) {
            this.mAddDuration = l2;
        }

        public void setChangeDuration(long l2) {
            this.mChangeDuration = l2;
        }

        void setListener(ItemAnimatorListener itemAnimatorListener) {
            this.mListener = itemAnimatorListener;
        }

        public void setMoveDuration(long l2) {
            this.mMoveDuration = l2;
        }

        public void setRemoveDuration(long l2) {
            this.mRemoveDuration = l2;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AdapterChanges {
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        static interface ItemAnimatorListener {
            public void onAnimationFinished(ViewHolder var1);
        }

        public static class ItemHolderInfo {
            public int bottom;
            public int changeFlags;
            public int left;
            public int right;
            public int top;

            public ItemHolderInfo setFrom(ViewHolder viewHolder) {
                return this.setFrom(viewHolder, 0);
            }

            public ItemHolderInfo setFrom(ViewHolder viewHolder, int n2) {
                viewHolder = viewHolder.itemView;
                this.left = viewHolder.getLeft();
                this.top = viewHolder.getTop();
                this.right = viewHolder.getRight();
                this.bottom = viewHolder.getBottom();
                return this;
            }
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener {
        private ItemAnimatorRestoreListener() {
        }

        @Override
        public void onAnimationFinished(ViewHolder viewHolder) {
            viewHolder.setIsRecyclable(true);
            if (viewHolder.mShadowedHolder != null && viewHolder.mShadowingHolder == null) {
                viewHolder.mShadowedHolder = null;
            }
            viewHolder.mShadowingHolder = null;
            if (!viewHolder.shouldBeKeptAsChild() && !RecyclerView.this.removeAnimatingView(viewHolder.itemView) && viewHolder.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(viewHolder.itemView, false);
            }
        }
    }

    public static abstract class ItemDecoration {
        @Deprecated
        public void getItemOffsets(Rect rect, int n2, RecyclerView recyclerView) {
            rect.set(0, 0, 0, 0);
        }

        public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, State state) {
            this.getItemOffsets(rect, ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition(), recyclerView);
        }

        @Deprecated
        public void onDraw(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDraw(Canvas canvas, RecyclerView recyclerView, State state) {
            this.onDraw(canvas, recyclerView);
        }

        @Deprecated
        public void onDrawOver(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDrawOver(Canvas canvas, RecyclerView recyclerView, State state) {
            this.onDrawOver(canvas, recyclerView);
        }
    }

    public static abstract class LayoutManager {
        private boolean mAutoMeasure = false;
        ChildHelper mChildHelper;
        private int mHeight;
        private int mHeightMode;
        boolean mIsAttachedToWindow = false;
        private boolean mMeasurementCacheEnabled = true;
        RecyclerView mRecyclerView;
        private boolean mRequestedSimpleAnimations = false;
        @Nullable
        SmoothScroller mSmoothScroller;
        private int mWidth;
        private int mWidthMode;

        static /* synthetic */ boolean access$2602(LayoutManager layoutManager, boolean bl2) {
            layoutManager.mRequestedSimpleAnimations = bl2;
            return bl2;
        }

        static /* synthetic */ void access$6000(LayoutManager layoutManager, SmoothScroller smoothScroller) {
            layoutManager.onSmoothScrollerStopped(smoothScroller);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void addViewInt(View view, int n2, boolean bl2) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (bl2 || viewHolder.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(viewHolder);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(viewHolder);
            }
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (viewHolder.wasReturnedFromScrap() || viewHolder.isScrap()) {
                if (viewHolder.isScrap()) {
                    viewHolder.unScrap();
                } else {
                    viewHolder.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.attachViewToParent(view, n2, view.getLayoutParams(), false);
            } else if (view.getParent() == this.mRecyclerView) {
                int n3 = this.mChildHelper.indexOfChild(view);
                int n4 = n2;
                if (n2 == -1) {
                    n4 = this.mChildHelper.getChildCount();
                }
                if (n3 == -1) {
                    throw new IllegalStateException("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:" + this.mRecyclerView.indexOfChild(view));
                }
                if (n3 != n4) {
                    this.mRecyclerView.mLayout.moveView(n3, n4);
                }
            } else {
                this.mChildHelper.addView(view, n2, false);
                layoutParams.mInsetsDirty = true;
                if (this.mSmoothScroller != null && this.mSmoothScroller.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(view);
                }
            }
            if (layoutParams.mPendingInvalidate) {
                viewHolder.itemView.invalidate();
                layoutParams.mPendingInvalidate = false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int chooseSize(int n2, int n3, int n4) {
            int n5;
            int n6 = View.MeasureSpec.getMode((int)n2);
            n2 = n5 = View.MeasureSpec.getSize((int)n2);
            switch (n6) {
                default: {
                    n2 = Math.max(n3, n4);
                }
                case 0x40000000: {
                    return n2;
                }
                case -2147483648: 
            }
            return Math.min(n5, Math.max(n3, n4));
        }

        private void detachViewInternal(int n2, View view) {
            this.mChildHelper.detachViewFromParent(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static int getChildMeasureSpec(int n2, int n3, int n4, int n5, boolean bl2) {
            int n6 = 0;
            int n7 = 0;
            int n8 = Math.max(0, n2 - n4);
            if (bl2) {
                if (n5 >= 0) {
                    n2 = 0x40000000;
                    n4 = n5;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
                if (n5 == -1) {
                    switch (n3) {
                        default: {
                            n3 = 0;
                            n2 = n6;
                            break;
                        }
                        case -2147483648: 
                        case 0x40000000: {
                            n2 = n8;
                            break;
                        }
                        case 0: {
                            n3 = 0;
                            n2 = n6;
                        }
                    }
                    n4 = n2;
                    n2 = n3;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
                if (n5 == -2) {
                    n4 = 0;
                    n2 = n7;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
            } else {
                if (n5 >= 0) {
                    n2 = 0x40000000;
                    n4 = n5;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
                if (n5 == -1) {
                    n2 = n3;
                    n4 = n8;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
                if (n5 == -2) {
                    if (n3 != Integer.MIN_VALUE) {
                        n2 = n7;
                        n4 = n8;
                        if (n3 != 0x40000000) return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                    }
                    n2 = Integer.MIN_VALUE;
                    n4 = n8;
                    return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
                }
            }
            n4 = 0;
            n2 = n7;
            return View.MeasureSpec.makeMeasureSpec((int)n4, (int)n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Deprecated
        public static int getChildMeasureSpec(int n2, int n3, int n4, boolean bl2) {
            int n5 = 0x40000000;
            int n6 = Math.max(0, n2 - n3);
            if (bl2) {
                if (n4 >= 0) {
                    n2 = n4;
                    n3 = n5;
                    return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
                }
                n3 = 0;
                n2 = 0;
                return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
            }
            n3 = n5;
            n2 = n4;
            if (n4 >= 0) return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
            if (n4 == -1) {
                n2 = n6;
                n3 = n5;
                return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
            }
            if (n4 == -2) {
                n3 = Integer.MIN_VALUE;
                n2 = n6;
                return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
            }
            n3 = 0;
            n2 = 0;
            return View.MeasureSpec.makeMeasureSpec((int)n2, (int)n3);
        }

        public static Properties getProperties(Context context, AttributeSet attributeSet, int n2, int n3) {
            Properties properties = new /* Unavailable Anonymous Inner Class!! */;
            context = context.obtainStyledAttributes(attributeSet, R.styleable.RecyclerView, n2, n3);
            properties.orientation = context.getInt(R.styleable.RecyclerView_android_orientation, 1);
            properties.spanCount = context.getInt(R.styleable.RecyclerView_spanCount, 1);
            properties.reverseLayout = context.getBoolean(R.styleable.RecyclerView_reverseLayout, false);
            properties.stackFromEnd = context.getBoolean(R.styleable.RecyclerView_stackFromEnd, false);
            context.recycle();
            return properties;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isMeasurementUpToDate(int n2, int n3, int n4) {
            boolean bl2 = true;
            int n5 = View.MeasureSpec.getMode((int)n3);
            n3 = View.MeasureSpec.getSize((int)n3);
            if (n4 > 0 && n2 != n4) {
                return false;
            }
            boolean bl3 = bl2;
            switch (n5) {
                case 0: {
                    return bl3;
                }
                default: {
                    return false;
                }
                case -2147483648: {
                    bl3 = bl2;
                    if (n3 >= n2) return bl3;
                    return false;
                }
                case 0x40000000: 
            }
            bl3 = bl2;
            if (n3 == n2) return bl3;
            return false;
        }

        private void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void scrapOrRecycleView(Recycler recycler, int n2, View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.shouldIgnore()) {
                return;
            }
            if (viewHolder.isInvalid() && !viewHolder.isRemoved() && !this.mRecyclerView.mAdapter.hasStableIds()) {
                this.removeViewAt(n2);
                recycler.recycleViewHolderInternal(viewHolder);
                return;
            }
            this.detachViewAt(n2);
            recycler.scrapView(view);
            this.mRecyclerView.mViewInfoStore.onViewDetached(viewHolder);
        }

        public void addDisappearingView(View view) {
            this.addDisappearingView(view, -1);
        }

        public void addDisappearingView(View view, int n2) {
            this.addViewInt(view, n2, true);
        }

        public void addView(View view) {
            this.addView(view, -1);
        }

        public void addView(View view, int n2) {
            this.addViewInt(view, n2, false);
        }

        public void assertInLayoutOrScroll(String string2) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertInLayoutOrScroll(string2);
            }
        }

        public void assertNotInLayoutOrScroll(String string2) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.assertNotInLayoutOrScroll(string2);
            }
        }

        public void attachView(View view) {
            this.attachView(view, -1);
        }

        public void attachView(View view, int n2) {
            this.attachView(view, n2, (LayoutParams)view.getLayoutParams());
        }

        /*
         * Enabled aggressive block sorting
         */
        public void attachView(View view, int n2, LayoutParams layoutParams) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.addToDisappearedInLayout(viewHolder);
            } else {
                this.mRecyclerView.mViewInfoStore.removeFromDisappearedInLayout(viewHolder);
            }
            this.mChildHelper.attachViewToParent(view, n2, (ViewGroup.LayoutParams)layoutParams, viewHolder.isRemoved());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void calculateItemDecorationsForChild(View view, Rect rect) {
            if (this.mRecyclerView == null) {
                rect.set(0, 0, 0, 0);
                return;
            }
            rect.set(this.mRecyclerView.getItemDecorInsetsForChild(view));
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkLayoutParams(LayoutParams layoutParams) {
            if (layoutParams == null) return false;
            return true;
        }

        public int computeHorizontalScrollExtent(State state) {
            return 0;
        }

        public int computeHorizontalScrollOffset(State state) {
            return 0;
        }

        public int computeHorizontalScrollRange(State state) {
            return 0;
        }

        public int computeVerticalScrollExtent(State state) {
            return 0;
        }

        public int computeVerticalScrollOffset(State state) {
            return 0;
        }

        public int computeVerticalScrollRange(State state) {
            return 0;
        }

        public void detachAndScrapAttachedViews(Recycler recycler) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                this.scrapOrRecycleView(recycler, i2, this.getChildAt(i2));
            }
        }

        public void detachAndScrapView(View view, Recycler recycler) {
            this.scrapOrRecycleView(recycler, this.mChildHelper.indexOfChild(view), view);
        }

        public void detachAndScrapViewAt(int n2, Recycler recycler) {
            this.scrapOrRecycleView(recycler, n2, this.getChildAt(n2));
        }

        public void detachView(View view) {
            int n2 = this.mChildHelper.indexOfChild(view);
            if (n2 >= 0) {
                this.detachViewInternal(n2, view);
            }
        }

        public void detachViewAt(int n2) {
            this.detachViewInternal(n2, this.getChildAt(n2));
        }

        void dispatchAttachedToWindow(RecyclerView recyclerView) {
            this.mIsAttachedToWindow = true;
            this.onAttachedToWindow(recyclerView);
        }

        void dispatchDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            this.mIsAttachedToWindow = false;
            this.onDetachedFromWindow(recyclerView, recycler);
        }

        public void endAnimation(View view) {
            if (this.mRecyclerView.mItemAnimator != null) {
                this.mRecyclerView.mItemAnimator.endAnimation(RecyclerView.getChildViewHolderInt(view));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public View findContainingItemView(View view) {
            Object var2_2 = null;
            if (this.mRecyclerView == null) {
                return var2_2;
            }
            View view2 = this.mRecyclerView.findContainingItemView(view);
            view = var2_2;
            if (view2 == null) return view;
            view = var2_2;
            if (this.mChildHelper.isHidden(view2)) return view;
            return view2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public View findViewByPosition(int n2) {
            int n3 = this.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                View view = this.getChildAt(n4);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
                if (viewHolder != null && viewHolder.getLayoutPosition() == n2 && !viewHolder.shouldIgnore()) {
                    View view2 = view;
                    if (this.mRecyclerView.mState.isPreLayout()) return view2;
                    if (!viewHolder.isRemoved()) {
                        return view;
                    }
                }
                ++n4;
            }
            return null;
        }

        public abstract LayoutParams generateDefaultLayoutParams();

        public LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
            return new LayoutParams(context, attributeSet);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams object) {
            void var1_3;
            if (object instanceof LayoutParams) {
                LayoutParams layoutParams = new LayoutParams((LayoutParams)((Object)object));
                return var1_3;
            }
            if (object instanceof ViewGroup.MarginLayoutParams) {
                LayoutParams layoutParams = new LayoutParams((ViewGroup.MarginLayoutParams)object);
                return var1_3;
            }
            LayoutParams layoutParams = new LayoutParams((ViewGroup.LayoutParams)object);
            return var1_3;
        }

        public int getBaseline() {
            return -1;
        }

        public int getBottomDecorationHeight(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.bottom;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getChildAt(int n2) {
            if (this.mChildHelper == null) return null;
            return this.mChildHelper.getChildAt(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getChildCount() {
            if (this.mChildHelper == null) return 0;
            return this.mChildHelper.getChildCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean getClipToPadding() {
            if (this.mRecyclerView == null) return false;
            if (!this.mRecyclerView.mClipToPadding) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getColumnCountForAccessibility(Recycler recycler, State state) {
            int n2;
            int n3 = n2 = 1;
            if (this.mRecyclerView == null) return n3;
            if (this.mRecyclerView.mAdapter == null) {
                return n2;
            }
            n3 = n2;
            if (!this.canScrollHorizontally()) return n3;
            return this.mRecyclerView.mAdapter.getItemCount();
        }

        public int getDecoratedBottom(View view) {
            return view.getBottom() + this.getBottomDecorationHeight(view);
        }

        public int getDecoratedLeft(View view) {
            return view.getLeft() - this.getLeftDecorationWidth(view);
        }

        public int getDecoratedMeasuredHeight(View view) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            int n2 = view.getMeasuredHeight();
            int n3 = rect.top;
            return rect.bottom + (n2 + n3);
        }

        public int getDecoratedMeasuredWidth(View view) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            int n2 = view.getMeasuredWidth();
            int n3 = rect.left;
            return rect.right + (n2 + n3);
        }

        public int getDecoratedRight(View view) {
            return view.getRight() + this.getRightDecorationWidth(view);
        }

        public int getDecoratedTop(View view) {
            return view.getTop() - this.getTopDecorationHeight(view);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getFocusedChild() {
            View view = null;
            if (this.mRecyclerView == null) {
                return view;
            }
            View view2 = this.mRecyclerView.getFocusedChild();
            View view3 = view;
            if (view2 == null) return view3;
            view3 = view;
            if (this.mChildHelper.isHidden(view2)) return view3;
            return view2;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getHeightMode() {
            return this.mHeightMode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getItemCount() {
            if (this.mRecyclerView == null) return 0;
            Adapter adapter = this.mRecyclerView.getAdapter();
            if (adapter == null) return 0;
            return adapter.getItemCount();
        }

        public int getItemViewType(View view) {
            return RecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        public int getLayoutDirection() {
            return ViewCompat.getLayoutDirection((View)this.mRecyclerView);
        }

        public int getLeftDecorationWidth(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.left;
        }

        public int getMinimumHeight() {
            return ViewCompat.getMinimumHeight((View)this.mRecyclerView);
        }

        public int getMinimumWidth() {
            return ViewCompat.getMinimumWidth((View)this.mRecyclerView);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingBottom() {
            if (this.mRecyclerView == null) return 0;
            return this.mRecyclerView.getPaddingBottom();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingEnd() {
            if (this.mRecyclerView == null) return 0;
            return ViewCompat.getPaddingEnd((View)this.mRecyclerView);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingLeft() {
            if (this.mRecyclerView == null) return 0;
            return this.mRecyclerView.getPaddingLeft();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingRight() {
            if (this.mRecyclerView == null) return 0;
            return this.mRecyclerView.getPaddingRight();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingStart() {
            if (this.mRecyclerView == null) return 0;
            return ViewCompat.getPaddingStart((View)this.mRecyclerView);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getPaddingTop() {
            if (this.mRecyclerView == null) return 0;
            return this.mRecyclerView.getPaddingTop();
        }

        public int getPosition(View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        public int getRightDecorationWidth(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.right;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getRowCountForAccessibility(Recycler recycler, State state) {
            int n2;
            int n3 = n2 = 1;
            if (this.mRecyclerView == null) return n3;
            if (this.mRecyclerView.mAdapter == null) {
                return n2;
            }
            n3 = n2;
            if (!this.canScrollVertically()) return n3;
            return this.mRecyclerView.mAdapter.getItemCount();
        }

        public int getSelectionModeForAccessibility(Recycler recycler, State state) {
            return 0;
        }

        public int getTopDecorationHeight(View view) {
            return ((LayoutParams)view.getLayoutParams()).mDecorInsets.top;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getWidthMode() {
            return this.mWidthMode;
        }

        boolean hasFlexibleChildInBothOrientations() {
            boolean bl2 = false;
            int n2 = this.getChildCount();
            int n3 = 0;
            while (true) {
                block4: {
                    boolean bl3;
                    block3: {
                        bl3 = bl2;
                        if (n3 >= n2) break block3;
                        ViewGroup.LayoutParams layoutParams = this.getChildAt(n3).getLayoutParams();
                        if (layoutParams.width >= 0 || layoutParams.height >= 0) break block4;
                        bl3 = true;
                    }
                    return bl3;
                }
                ++n3;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasFocus() {
            if (this.mRecyclerView == null) return false;
            if (!this.mRecyclerView.hasFocus()) return false;
            return true;
        }

        public void ignoreView(View object) {
            if (object.getParent() != this.mRecyclerView || this.mRecyclerView.indexOfChild((View)object) == -1) {
                throw new IllegalArgumentException("View should be fully attached to be ignored");
            }
            object = RecyclerView.getChildViewHolderInt((View)object);
            ((ViewHolder)object).addFlags(128);
            this.mRecyclerView.mViewInfoStore.removeViewHolder((ViewHolder)object);
        }

        public boolean isAttachedToWindow() {
            return this.mIsAttachedToWindow;
        }

        public boolean isAutoMeasureEnabled() {
            return this.mAutoMeasure;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isFocused() {
            if (this.mRecyclerView == null) return false;
            if (!this.mRecyclerView.isFocused()) return false;
            return true;
        }

        public boolean isLayoutHierarchical(Recycler recycler, State state) {
            return false;
        }

        public boolean isMeasurementCacheEnabled() {
            return this.mMeasurementCacheEnabled;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isSmoothScrolling() {
            if (this.mSmoothScroller == null) return false;
            if (!this.mSmoothScroller.isRunning()) return false;
            return true;
        }

        public void layoutDecorated(View view, int n2, int n3, int n4, int n5) {
            Rect rect = ((LayoutParams)view.getLayoutParams()).mDecorInsets;
            view.layout(rect.left + n2, rect.top + n3, n4 - rect.right, n5 - rect.bottom);
        }

        public void measureChild(View view, int n2, int n3) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int n4 = rect.left;
            int n5 = rect.right;
            int n6 = rect.top;
            int n7 = rect.bottom;
            n2 = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), n4 + n5 + n2 + (this.getPaddingLeft() + this.getPaddingRight()), layoutParams.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(view, n2, n3 = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), n7 + n6 + n3 + (this.getPaddingTop() + this.getPaddingBottom()), layoutParams.height, this.canScrollVertically()), layoutParams)) {
                view.measure(n2, n3);
            }
        }

        public void measureChildWithMargins(View view, int n2, int n3) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int n4 = rect.left;
            int n5 = rect.right;
            int n6 = rect.top;
            int n7 = rect.bottom;
            n2 = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getWidthMode(), n4 + n5 + n2 + (this.getPaddingLeft() + this.getPaddingRight() + layoutParams.leftMargin + layoutParams.rightMargin), layoutParams.width, this.canScrollHorizontally());
            if (this.shouldMeasureChild(view, n2, n3 = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getHeightMode(), n7 + n6 + n3 + (this.getPaddingTop() + this.getPaddingBottom() + layoutParams.topMargin + layoutParams.bottomMargin), layoutParams.height, this.canScrollVertically()), layoutParams)) {
                view.measure(n2, n3);
            }
        }

        public void moveView(int n2, int n3) {
            View view = this.getChildAt(n2);
            if (view == null) {
                throw new IllegalArgumentException("Cannot move a child from non-existing index:" + n2);
            }
            this.detachViewAt(n2);
            this.attachView(view, n3);
        }

        public void offsetChildrenHorizontal(int n2) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenHorizontal(n2);
            }
        }

        public void offsetChildrenVertical(int n2) {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.offsetChildrenVertical(n2);
            }
        }

        public void onAdapterChanged(Adapter adapter, Adapter adapter2) {
        }

        public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> arrayList, int n2, int n3) {
            return false;
        }

        @CallSuper
        public void onAttachedToWindow(RecyclerView recyclerView) {
        }

        @Deprecated
        public void onDetachedFromWindow(RecyclerView recyclerView) {
        }

        @CallSuper
        public void onDetachedFromWindow(RecyclerView recyclerView, Recycler recycler) {
            this.onDetachedFromWindow(recyclerView);
        }

        @Nullable
        public View onFocusSearchFailed(View view, int n2, Recycler recycler, State state) {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onInitializeAccessibilityEvent(Recycler object, State state, AccessibilityEvent accessibilityEvent) {
            boolean bl2 = true;
            object = AccessibilityEventCompat.asRecord(accessibilityEvent);
            if (this.mRecyclerView == null) return;
            if (object == null) {
                return;
            }
            boolean bl3 = bl2;
            if (!ViewCompat.canScrollVertically((View)this.mRecyclerView, 1)) {
                bl3 = bl2;
                if (!ViewCompat.canScrollVertically((View)this.mRecyclerView, -1)) {
                    bl3 = bl2;
                    if (!ViewCompat.canScrollHorizontally((View)this.mRecyclerView, -1)) {
                        bl3 = ViewCompat.canScrollHorizontally((View)this.mRecyclerView, 1) ? bl2 : false;
                    }
                }
            }
            ((AccessibilityRecordCompat)object).setScrollable(bl3);
            if (this.mRecyclerView.mAdapter == null) return;
            ((AccessibilityRecordCompat)object).setItemCount(this.mRecyclerView.mAdapter.getItemCount());
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            this.onInitializeAccessibilityEvent(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, accessibilityEvent);
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            this.onInitializeAccessibilityNodeInfo(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, accessibilityNodeInfoCompat);
        }

        public void onInitializeAccessibilityNodeInfo(Recycler recycler, State state, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            if (ViewCompat.canScrollVertically((View)this.mRecyclerView, -1) || ViewCompat.canScrollHorizontally((View)this.mRecyclerView, -1)) {
                accessibilityNodeInfoCompat.addAction(8192);
                accessibilityNodeInfoCompat.setScrollable(true);
            }
            if (ViewCompat.canScrollVertically((View)this.mRecyclerView, 1) || ViewCompat.canScrollHorizontally((View)this.mRecyclerView, 1)) {
                accessibilityNodeInfoCompat.addAction(4096);
                accessibilityNodeInfoCompat.setScrollable(true);
            }
            accessibilityNodeInfoCompat.setCollectionInfo(AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain(this.getRowCountForAccessibility(recycler, state), this.getColumnCountForAccessibility(recycler, state), this.isLayoutHierarchical(recycler, state), this.getSelectionModeForAccessibility(recycler, state)));
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onInitializeAccessibilityNodeInfoForItem(Recycler recycler, State state, View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            int n2 = this.canScrollVertically() ? this.getPosition(view) : 0;
            int n3 = this.canScrollHorizontally() ? this.getPosition(view) : 0;
            accessibilityNodeInfoCompat.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(n2, 1, n3, 1, false, false));
        }

        void onInitializeAccessibilityNodeInfoForItem(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder != null && !viewHolder.isRemoved() && !this.mChildHelper.isHidden(viewHolder.itemView)) {
                this.onInitializeAccessibilityNodeInfoForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, accessibilityNodeInfoCompat);
            }
        }

        public View onInterceptFocusSearch(View view, int n2) {
            return null;
        }

        public void onItemsAdded(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsChanged(RecyclerView recyclerView) {
        }

        public void onItemsMoved(RecyclerView recyclerView, int n2, int n3, int n4) {
        }

        public void onItemsRemoved(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3, Object object) {
            this.onItemsUpdated(recyclerView, n2, n3);
        }

        public void onLayoutChildren(Recycler recycler, State state) {
            Log.e((String)RecyclerView.TAG, (String)"You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        public void onMeasure(Recycler recycler, State state, int n2, int n3) {
            this.mRecyclerView.defaultOnMeasure(n2, n3);
        }

        public boolean onRequestChildFocus(RecyclerView recyclerView, State state, View view, View view2) {
            return this.onRequestChildFocus(recyclerView, view, view2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public boolean onRequestChildFocus(RecyclerView recyclerView, View view, View view2) {
            if (this.isSmoothScrolling()) return true;
            if (!recyclerView.isComputingLayout()) return false;
            return true;
        }

        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onScrollStateChanged(int n2) {
        }

        boolean performAccessibilityAction(int n2, Bundle bundle) {
            return this.performAccessibilityAction(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, n2, bundle);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        public boolean performAccessibilityAction(Recycler var1_1, State var2_2, int var3_3, Bundle var4_4) {
            block8: {
                var5_5 = false;
                if (this.mRecyclerView == null) {
                    return var5_5;
                }
                switch (var3_3) {
                    default: {
                        var3_3 = 0;
                        var6_6 = 0;
                        break block8;
                    }
                    case 8192: {
                        var3_3 = ViewCompat.canScrollVertically((View)this.mRecyclerView, -1) != false ? -(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) : 0;
                    }
                    case 4096: {
                        var3_3 = ViewCompat.canScrollVertically((View)this.mRecyclerView, 1) != false ? this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() : 0;
                        var6_6 = var3_3;
                        if (!ViewCompat.canScrollHorizontally((View)this.mRecyclerView, 1)) ** GOTO lbl-1000
                        var7_8 = this.getWidth();
                        var8_9 = this.getPaddingLeft();
                        var9_10 = this.getPaddingRight();
                        var6_6 = var3_3;
                        var3_3 = var7_8 - var8_9 - var9_10;
                        break block8;
                    }
                }
                var6_6 = var3_3;
                if (ViewCompat.canScrollHorizontally((View)this.mRecyclerView, -1)) {
                    var7_7 = -(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
                    var6_6 = var3_3;
                    var3_3 = var7_7;
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = 0;
                }
            }
            if (var6_6 == 0) {
                if (var3_3 == 0) return var5_5;
            }
            this.mRecyclerView.scrollBy(var3_3, var6_6);
            return true;
        }

        public boolean performAccessibilityActionForItem(Recycler recycler, State state, View view, int n2, Bundle bundle) {
            return false;
        }

        boolean performAccessibilityActionForItem(View view, int n2, Bundle bundle) {
            return this.performAccessibilityActionForItem(this.mRecyclerView.mRecycler, this.mRecyclerView.mState, view, n2, bundle);
        }

        public void postOnAnimation(Runnable runnable) {
            if (this.mRecyclerView != null) {
                ViewCompat.postOnAnimation((View)this.mRecyclerView, runnable);
            }
        }

        public void removeAllViews() {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                this.mChildHelper.removeViewAt(i2);
            }
        }

        public void removeAndRecycleAllViews(Recycler recycler) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                if (RecyclerView.getChildViewHolderInt(this.getChildAt(i2)).shouldIgnore()) continue;
                this.removeAndRecycleViewAt(i2, recycler);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void removeAndRecycleScrapInt(Recycler recycler) {
            int n2 = recycler.getScrapCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                View view = recycler.getScrapViewAt(i2);
                ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
                if (viewHolder.shouldIgnore()) continue;
                viewHolder.setIsRecyclable(false);
                if (viewHolder.isTmpDetached()) {
                    this.mRecyclerView.removeDetachedView(view, false);
                }
                if (this.mRecyclerView.mItemAnimator != null) {
                    this.mRecyclerView.mItemAnimator.endAnimation(viewHolder);
                }
                viewHolder.setIsRecyclable(true);
                recycler.quickRecycleScrapView(view);
            }
            recycler.clearScrap();
            if (n2 > 0) {
                this.mRecyclerView.invalidate();
            }
        }

        public void removeAndRecycleView(View view, Recycler recycler) {
            this.removeView(view);
            recycler.recycleView(view);
        }

        public void removeAndRecycleViewAt(int n2, Recycler recycler) {
            View view = this.getChildAt(n2);
            this.removeViewAt(n2);
            recycler.recycleView(view);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean removeCallbacks(Runnable runnable) {
            if (this.mRecyclerView == null) return false;
            return this.mRecyclerView.removeCallbacks(runnable);
        }

        public void removeDetachedView(View view) {
            this.mRecyclerView.removeDetachedView(view, false);
        }

        public void removeView(View view) {
            this.mChildHelper.removeView(view);
        }

        public void removeViewAt(int n2) {
            if (this.getChildAt(n2) != null) {
                this.mChildHelper.removeViewAt(n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean bl2) {
            int n2 = this.getPaddingLeft();
            int n3 = this.getPaddingTop();
            int n4 = this.getWidth() - this.getPaddingRight();
            int n5 = this.getHeight();
            int n6 = this.getPaddingBottom();
            int n7 = view.getLeft() + rect.left - view.getScrollX();
            int n8 = view.getTop() + rect.top - view.getScrollY();
            int n9 = n7 + rect.width();
            int n10 = rect.height();
            int n11 = Math.min(0, n7 - n2);
            int n12 = Math.min(0, n8 - n3);
            int n13 = Math.max(0, n9 - n4);
            n10 = Math.max(0, n8 + n10 - (n5 - n6));
            if (this.getLayoutDirection() == 1) {
                n11 = n13 != 0 ? n13 : Math.max(n11, n9 - n4);
            } else if (n11 == 0) {
                n11 = Math.min(n7 - n2, n13);
            }
            if (n12 == 0) {
                n12 = Math.min(n8 - n3, n10);
            }
            if (n11 == 0 && n12 == 0) {
                return false;
            }
            if (bl2) {
                recyclerView.scrollBy(n11, n12);
                return true;
            } else {
                recyclerView.smoothScrollBy(n11, n12);
            }
            return true;
        }

        public void requestLayout() {
            if (this.mRecyclerView != null) {
                this.mRecyclerView.requestLayout();
            }
        }

        public void requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        public int scrollHorizontallyBy(int n2, Recycler recycler, State state) {
            return 0;
        }

        public void scrollToPosition(int n2) {
        }

        public int scrollVerticallyBy(int n2, Recycler recycler, State state) {
            return 0;
        }

        public void setAutoMeasureEnabled(boolean bl2) {
            this.mAutoMeasure = bl2;
        }

        void setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            this.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec((int)recyclerView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)recyclerView.getHeight(), (int)0x40000000));
        }

        void setMeasureSpecs(int n2, int n3) {
            this.mWidth = View.MeasureSpec.getSize((int)n2);
            this.mWidthMode = View.MeasureSpec.getMode((int)n2);
            if (this.mWidthMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mWidth = 0;
            }
            this.mHeight = View.MeasureSpec.getSize((int)n3);
            this.mHeightMode = View.MeasureSpec.getMode((int)n3);
            if (this.mHeightMode == 0 && !ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mHeight = 0;
            }
        }

        public void setMeasuredDimension(int n2, int n3) {
            this.mRecyclerView.setMeasuredDimension(n2, n3);
        }

        public void setMeasuredDimension(Rect rect, int n2, int n3) {
            int n4 = rect.width();
            int n5 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = rect.height();
            int n8 = this.getPaddingTop();
            int n9 = this.getPaddingBottom();
            this.setMeasuredDimension(LayoutManager.chooseSize(n2, n4 + n5 + n6, this.getMinimumWidth()), LayoutManager.chooseSize(n3, n7 + n8 + n9, this.getMinimumHeight()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void setMeasuredDimensionFromChildren(int n2, int n3) {
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            int n6 = this.getChildCount();
            if (n6 == 0) {
                this.mRecyclerView.defaultOnMeasure(n2, n3);
                return;
            }
            int n7 = Integer.MIN_VALUE;
            int n8 = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < n6; ++i2) {
                View view = this.getChildAt(i2);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n9 = this.getDecoratedLeft(view) - layoutParams.leftMargin;
                int n10 = this.getDecoratedRight(view);
                int n11 = layoutParams.rightMargin + n10;
                int n12 = this.getDecoratedTop(view) - layoutParams.topMargin;
                n10 = this.getDecoratedBottom(view);
                n10 = layoutParams.bottomMargin + n10;
                if (n9 < n8) {
                    n8 = n9;
                }
                if (n11 > n7) {
                    n7 = n11;
                }
                if (n12 < n4) {
                    n4 = n12;
                }
                if (n10 <= n5) continue;
                n5 = n10;
            }
            this.mRecyclerView.mTempRect.set(n8, n4, n7, n5);
            this.setMeasuredDimension(this.mRecyclerView.mTempRect, n2, n3);
        }

        public void setMeasurementCacheEnabled(boolean bl2) {
            this.mMeasurementCacheEnabled = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        void setRecyclerView(RecyclerView recyclerView) {
            if (recyclerView == null) {
                this.mRecyclerView = null;
                this.mChildHelper = null;
                this.mWidth = 0;
                this.mHeight = 0;
            } else {
                this.mRecyclerView = recyclerView;
                this.mChildHelper = recyclerView.mChildHelper;
                this.mWidth = recyclerView.getWidth();
                this.mHeight = recyclerView.getHeight();
            }
            this.mWidthMode = 0x40000000;
            this.mHeightMode = 0x40000000;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean shouldMeasureChild(View view, int n2, int n3, LayoutParams layoutParams) {
            if (view.isLayoutRequested()) return true;
            if (!this.mMeasurementCacheEnabled) return true;
            if (!LayoutManager.isMeasurementUpToDate(view.getWidth(), n2, layoutParams.width)) return true;
            if (LayoutManager.isMeasurementUpToDate(view.getHeight(), n3, layoutParams.height)) return false;
            return true;
        }

        boolean shouldMeasureTwice() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean shouldReMeasureChild(View view, int n2, int n3, LayoutParams layoutParams) {
            if (!this.mMeasurementCacheEnabled) return true;
            if (!LayoutManager.isMeasurementUpToDate(view.getMeasuredWidth(), n2, layoutParams.width)) return true;
            if (LayoutManager.isMeasurementUpToDate(view.getMeasuredHeight(), n3, layoutParams.height)) return false;
            return true;
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, State state, int n2) {
            Log.e((String)RecyclerView.TAG, (String)"You must override smoothScrollToPosition to support smooth scrolling");
        }

        public void startSmoothScroll(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller != null && smoothScroller != this.mSmoothScroller && this.mSmoothScroller.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        public void stopIgnoringView(View object) {
            object = RecyclerView.getChildViewHolderInt((View)object);
            ((ViewHolder)object).stopIgnoring();
            ((ViewHolder)object).resetInternal();
            ((ViewHolder)object).addFlags(4);
        }

        void stopSmoothScroller() {
            if (this.mSmoothScroller != null) {
                this.mSmoothScroller.stop();
            }
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        final Rect mDecorInsets = new Rect();
        boolean mInsetsDirty = true;
        boolean mPendingInvalidate = false;
        ViewHolder mViewHolder;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.LayoutParams)layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public int getViewAdapterPosition() {
            return this.mViewHolder.getAdapterPosition();
        }

        public int getViewLayoutPosition() {
            return this.mViewHolder.getLayoutPosition();
        }

        public int getViewPosition() {
            return this.mViewHolder.getPosition();
        }

        public boolean isItemChanged() {
            return this.mViewHolder.isUpdated();
        }

        public boolean isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        public boolean isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        public boolean viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }
    }

    public static interface OnChildAttachStateChangeListener {
        public void onChildViewAttachedToWindow(View var1);

        public void onChildViewDetachedFromWindow(View var1);
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(RecyclerView var1, MotionEvent var2);

        public void onRequestDisallowInterceptTouchEvent(boolean var1);

        public void onTouchEvent(RecyclerView var1, MotionEvent var2);
    }

    public static abstract class OnScrollListener {
        public void onScrollStateChanged(RecyclerView recyclerView, int n2) {
        }

        public void onScrolled(RecyclerView recyclerView, int n2, int n3) {
        }
    }

    public static class RecycledViewPool {
        private static final int DEFAULT_MAX_SCRAP = 5;
        private int mAttachCount = 0;
        private SparseIntArray mMaxScrap;
        private SparseArray<ArrayList<ViewHolder>> mScrap = new SparseArray();

        public RecycledViewPool() {
            this.mMaxScrap = new SparseIntArray();
        }

        private ArrayList<ViewHolder> getScrapHeapForType(int n2) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = (ArrayList)this.mScrap.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mScrap.put(n2, arrayList);
                arrayList2 = arrayList;
                if (this.mMaxScrap.indexOfKey(n2) < 0) {
                    this.mMaxScrap.put(n2, 5);
                    arrayList2 = arrayList;
                }
            }
            return arrayList2;
        }

        void attach(Adapter adapter) {
            ++this.mAttachCount;
        }

        public void clear() {
            this.mScrap.clear();
        }

        void detach() {
            --this.mAttachCount;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ViewHolder getRecycledView(int n2) {
            ArrayList arrayList = (ArrayList)this.mScrap.get(n2);
            if (arrayList == null) return null;
            if (arrayList.isEmpty()) return null;
            n2 = arrayList.size() - 1;
            ViewHolder viewHolder = (ViewHolder)arrayList.get(n2);
            arrayList.remove(n2);
            return viewHolder;
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl2) {
            if (adapter != null) {
                this.detach();
            }
            if (!bl2 && this.mAttachCount == 0) {
                this.clear();
            }
            if (adapter2 != null) {
                this.attach(adapter2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void putRecycledView(ViewHolder viewHolder) {
            int n2 = viewHolder.getItemViewType();
            ArrayList<ViewHolder> arrayList = this.getScrapHeapForType(n2);
            if (this.mMaxScrap.get(n2) <= arrayList.size()) {
                return;
            }
            viewHolder.resetInternal();
            arrayList.add(viewHolder);
        }

        public void setMaxRecycledViews(int n2, int n3) {
            this.mMaxScrap.put(n2, n3);
            ArrayList arrayList = (ArrayList)this.mScrap.get(n2);
            if (arrayList != null) {
                while (arrayList.size() > n3) {
                    arrayList.remove(arrayList.size() - 1);
                }
            }
        }

        int size() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.mScrap.size(); ++i2) {
                ArrayList arrayList = (ArrayList)this.mScrap.valueAt(i2);
                int n3 = n2;
                if (arrayList != null) {
                    n3 = n2 + arrayList.size();
                }
                n2 = n3;
            }
            return n2;
        }
    }

    public final class Recycler {
        private static final int DEFAULT_CACHE_SIZE = 2;
        final ArrayList<ViewHolder> mAttachedScrap = new ArrayList();
        final ArrayList<ViewHolder> mCachedViews = new ArrayList();
        private ArrayList<ViewHolder> mChangedScrap = null;
        private RecycledViewPool mRecyclerPool;
        private final List<ViewHolder> mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
        private ViewCacheExtension mViewCacheExtension;
        private int mViewCacheMax = 2;

        private void attachAccessibilityDelegate(View view) {
            if (RecyclerView.this.isAccessibilityEnabled()) {
                if (ViewCompat.getImportantForAccessibility(view) == 0) {
                    ViewCompat.setImportantForAccessibility(view, 1);
                }
                if (!ViewCompat.hasAccessibilityDelegate(view)) {
                    ViewCompat.setAccessibilityDelegate(view, RecyclerView.this.mAccessibilityDelegate.getItemDelegate());
                }
            }
        }

        private void invalidateDisplayListInt(ViewHolder viewHolder) {
            if (viewHolder.itemView instanceof ViewGroup) {
                this.invalidateDisplayListInt((ViewGroup)viewHolder.itemView, false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void invalidateDisplayListInt(ViewGroup viewGroup, boolean bl2) {
            int n2;
            for (n2 = viewGroup.getChildCount() - 1; n2 >= 0; --n2) {
                View view = viewGroup.getChildAt(n2);
                if (!(view instanceof ViewGroup)) continue;
                this.invalidateDisplayListInt((ViewGroup)view, true);
            }
            if (!bl2) {
                return;
            }
            if (viewGroup.getVisibility() == 4) {
                viewGroup.setVisibility(0);
                viewGroup.setVisibility(4);
                return;
            }
            n2 = viewGroup.getVisibility();
            viewGroup.setVisibility(4);
            viewGroup.setVisibility(n2);
        }

        void addViewHolderToRecycledViewPool(ViewHolder viewHolder) {
            ViewCompat.setAccessibilityDelegate(viewHolder.itemView, null);
            this.dispatchViewRecycled(viewHolder);
            viewHolder.mOwnerRecyclerView = null;
            this.getRecycledViewPool().putRecycledView(viewHolder);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public void bindViewToPosition(View object, int n2) {
            ViewGroup.LayoutParams layoutParams;
            void var2_7;
            boolean bl2 = true;
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(object);
            if (viewHolder == null) {
                throw new IllegalArgumentException("The view does not have a ViewHolder. You cannot pass arbitrary views to this method, they should be created by the Adapter");
            }
            int n3 = RecyclerView.this.mAdapterHelper.findPositionOffset((int)var2_7);
            if (n3 < 0 || n3 >= RecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + (int)var2_7 + "(offset:" + n3 + ")." + "state:" + RecyclerView.this.mState.getItemCount());
            }
            viewHolder.mOwnerRecyclerView = RecyclerView.this;
            RecyclerView.this.mAdapter.bindViewHolder(viewHolder, n3);
            this.attachAccessibilityDelegate((View)object);
            if (RecyclerView.this.mState.isPreLayout()) {
                viewHolder.mPreLayoutPosition = var2_7;
            }
            if ((layoutParams = viewHolder.itemView.getLayoutParams()) == null) {
                LayoutParams layoutParams2 = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                viewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            } else if (!RecyclerView.this.checkLayoutParams(layoutParams)) {
                LayoutParams layoutParams3 = (LayoutParams)RecyclerView.this.generateLayoutParams(layoutParams);
                viewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            } else {
                LayoutParams layoutParams4 = (LayoutParams)layoutParams;
            }
            var1_4.mInsetsDirty = true;
            var1_4.mViewHolder = viewHolder;
            if (viewHolder.itemView.getParent() != null) {
                bl2 = false;
            }
            var1_4.mPendingInvalidate = bl2;
        }

        public void clear() {
            this.mAttachedScrap.clear();
            this.recycleAndClearCachedViews();
        }

        void clearOldPositions() {
            int n2;
            int n3 = 0;
            int n4 = this.mCachedViews.size();
            for (n2 = 0; n2 < n4; ++n2) {
                this.mCachedViews.get(n2).clearOldPosition();
            }
            n4 = this.mAttachedScrap.size();
            for (n2 = 0; n2 < n4; ++n2) {
                this.mAttachedScrap.get(n2).clearOldPosition();
            }
            if (this.mChangedScrap != null) {
                n4 = this.mChangedScrap.size();
                for (n2 = n3; n2 < n4; ++n2) {
                    this.mChangedScrap.get(n2).clearOldPosition();
                }
            }
        }

        void clearScrap() {
            this.mAttachedScrap.clear();
            if (this.mChangedScrap != null) {
                this.mChangedScrap.clear();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int convertPreLayoutPositionToPostLayout(int n2) {
            if (n2 < 0) throw new IndexOutOfBoundsException("invalid position " + n2 + ". State " + "item count is " + RecyclerView.this.mState.getItemCount());
            if (n2 >= RecyclerView.this.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("invalid position " + n2 + ". State " + "item count is " + RecyclerView.this.mState.getItemCount());
            }
            if (RecyclerView.this.mState.isPreLayout()) return RecyclerView.this.mAdapterHelper.findPositionOffset(n2);
            return n2;
        }

        void dispatchViewRecycled(ViewHolder viewHolder) {
            if (RecyclerView.this.mRecyclerListener != null) {
                RecyclerView.this.mRecyclerListener.onViewRecycled(viewHolder);
            }
            if (RecyclerView.this.mAdapter != null) {
                RecyclerView.this.mAdapter.onViewRecycled(viewHolder);
            }
            if (RecyclerView.this.mState != null) {
                RecyclerView.this.mViewInfoStore.removeViewHolder(viewHolder);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ViewHolder getChangedScrapViewForPosition(int n2) {
            ViewHolder viewHolder;
            int n3 = 0;
            if (this.mChangedScrap == null) return null;
            int n4 = this.mChangedScrap.size();
            if (n4 == 0) {
                return null;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                viewHolder = this.mChangedScrap.get(i2);
                if (viewHolder.wasReturnedFromScrap() || viewHolder.getLayoutPosition() != n2) continue;
                viewHolder.addFlags(32);
                return viewHolder;
            }
            if (!RecyclerView.this.mAdapter.hasStableIds()) return null;
            if ((n2 = RecyclerView.this.mAdapterHelper.findPositionOffset(n2)) <= 0) return null;
            if (n2 >= RecyclerView.this.mAdapter.getItemCount()) return null;
            long l2 = RecyclerView.this.mAdapter.getItemId(n2);
            n2 = n3;
            while (n2 < n4) {
                viewHolder = this.mChangedScrap.get(n2);
                if (!viewHolder.wasReturnedFromScrap() && viewHolder.getItemId() == l2) {
                    viewHolder.addFlags(32);
                    return viewHolder;
                }
                ++n2;
            }
            return null;
        }

        RecycledViewPool getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
            }
            return this.mRecyclerPool;
        }

        int getScrapCount() {
            return this.mAttachedScrap.size();
        }

        public List<ViewHolder> getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        View getScrapViewAt(int n2) {
            return this.mAttachedScrap.get((int)n2).itemView;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ViewHolder getScrapViewForId(long l2, int n2, boolean bl2) {
            ViewHolder viewHolder;
            ViewHolder viewHolder2;
            int n3;
            for (n3 = this.mAttachedScrap.size() - 1; n3 >= 0; --n3) {
                viewHolder2 = this.mAttachedScrap.get(n3);
                if (viewHolder2.getItemId() != l2 || viewHolder2.wasReturnedFromScrap()) continue;
                if (n2 == viewHolder2.getItemViewType()) {
                    viewHolder2.addFlags(32);
                    viewHolder = viewHolder2;
                    if (!viewHolder2.isRemoved()) return viewHolder;
                    viewHolder = viewHolder2;
                    if (RecyclerView.this.mState.isPreLayout()) return viewHolder;
                    viewHolder2.setFlags(2, 14);
                    return viewHolder2;
                }
                if (bl2) continue;
                this.mAttachedScrap.remove(n3);
                RecyclerView.this.removeDetachedView(viewHolder2.itemView, false);
                this.quickRecycleScrapView(viewHolder2.itemView);
            }
            n3 = this.mCachedViews.size() - 1;
            while (n3 >= 0) {
                viewHolder2 = this.mCachedViews.get(n3);
                if (viewHolder2.getItemId() == l2) {
                    if (n2 == viewHolder2.getItemViewType()) {
                        viewHolder = viewHolder2;
                        if (bl2) return viewHolder;
                        this.mCachedViews.remove(n3);
                        return viewHolder2;
                    }
                    if (!bl2) {
                        this.recycleCachedViewAt(n3);
                    }
                }
                --n3;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ViewHolder getScrapViewForPosition(int n2, int n3, boolean bl2) {
            Object object;
            Object object2;
            int n4;
            int n5;
            block6: {
                n5 = 0;
                int n6 = this.mAttachedScrap.size();
                n4 = 0;
                while (true) {
                    block8: {
                        block9: {
                            block7: {
                                if (n4 >= n6) break block7;
                                object2 = this.mAttachedScrap.get(n4);
                                if (((ViewHolder)object2).wasReturnedFromScrap() || ((ViewHolder)object2).getLayoutPosition() != n2 || ((ViewHolder)object2).isInvalid() || !RecyclerView.this.mState.mInPreLayout && ((ViewHolder)object2).isRemoved()) break block8;
                                if (n3 == -1 || ((ViewHolder)object2).getItemViewType() == n3) break block9;
                                Log.e((String)RecyclerView.TAG, (String)("Scrap view for position " + n2 + " isn't dirty but has" + " wrong view type! (found " + ((ViewHolder)object2).getItemViewType() + " but expected " + n3 + ")"));
                            }
                            if (!bl2 && (object = RecyclerView.this.mChildHelper.findHiddenNonRemovedView(n2, n3)) != null) {
                                object2 = RecyclerView.getChildViewHolderInt((View)object);
                                RecyclerView.this.mChildHelper.unhide((View)object);
                                n2 = RecyclerView.this.mChildHelper.indexOfChild((View)object);
                                if (n2 != -1) break;
                                throw new IllegalStateException("layout index should not be -1 after unhiding a view:" + object2);
                            }
                            break block6;
                        }
                        ((ViewHolder)object2).addFlags(32);
                        return object2;
                    }
                    ++n4;
                }
                RecyclerView.this.mChildHelper.detachViewFromParent(n2);
                this.scrapView((View)object);
                ((ViewHolder)object2).addFlags(8224);
                return object2;
            }
            n4 = this.mCachedViews.size();
            n3 = n5;
            while (n3 < n4) {
                object = this.mCachedViews.get(n3);
                if (!((ViewHolder)object).isInvalid() && ((ViewHolder)object).getLayoutPosition() == n2) {
                    object2 = object;
                    if (bl2) return object2;
                    this.mCachedViews.remove(n3);
                    return object;
                }
                ++n3;
            }
            return null;
        }

        public View getViewForPosition(int n2) {
            return this.getViewForPosition(n2, false);
        }

        /*
         * Unable to fully structure code
         */
        View getViewForPosition(int var1_1, boolean var2_2) {
            block30: {
                block26: {
                    block27: {
                        block24: {
                            block25: {
                                block31: {
                                    var3_3 = true;
                                    if (var1_1 < 0 || var1_1 >= RecyclerView.this.mState.getItemCount()) {
                                        throw new IndexOutOfBoundsException("Invalid item position " + var1_1 + "(" + var1_1 + "). Item count:" + RecyclerView.this.mState.getItemCount());
                                    }
                                    if (!RecyclerView.this.mState.isPreLayout()) break block30;
                                    var4_4 = this.getChangedScrapViewForPosition(var1_1);
                                    if (var4_4 == null) break block31;
                                    var5_5 = 1;
lbl8:
                                    // 3 sources

                                    while (true) {
                                        var6_6 = var4_4;
                                        if (var4_4 != null) ** GOTO lbl22
                                        var6_6 = var4_4 = this.getScrapViewForPosition(var1_1, -1, var2_2);
                                        if (var4_4 == null) ** GOTO lbl22
                                        if (this.validateViewHolderForOffsetPosition((ViewHolder)var4_4)) break block24;
                                        if (var2_2) ** GOTO lbl21
                                        var4_4.addFlags(4);
                                        if (!var4_4.isScrap()) break block25;
                                        RecyclerView.this.removeDetachedView(var4_4.itemView, false);
                                        var4_4.unScrap();
lbl19:
                                        // 3 sources

                                        while (true) {
                                            this.recycleViewHolderInternal((ViewHolder)var4_4);
lbl21:
                                            // 2 sources

                                            var6_6 = null;
lbl22:
                                            // 4 sources

                                            while (true) {
                                                var7_7 = var6_6;
                                                var8_8 = var5_5;
                                                if (var6_6 != null) break block26;
                                                var8_8 = RecyclerView.this.mAdapterHelper.findPositionOffset(var1_1);
                                                if (var8_8 < 0 || var8_8 >= RecyclerView.access$3100(RecyclerView.this).getItemCount()) {
                                                    throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + var1_1 + "(offset:" + var8_8 + ")." + "state:" + RecyclerView.this.mState.getItemCount());
                                                }
                                                break block27;
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                }
                                var5_5 = 0;
                                ** GOTO lbl8
                            }
                            if (!var4_4.wasReturnedFromScrap()) ** GOTO lbl19
                            var4_4.clearReturnedFromScrapFlag();
                            ** while (true)
                        }
                        var5_5 = 1;
                        var6_6 = var4_4;
                        ** while (true)
                    }
                    var9_9 = RecyclerView.access$3100(RecyclerView.this).getItemViewType(var8_8);
                    var4_4 = var6_6;
                    var10_10 = var5_5;
                    if (RecyclerView.access$3100(RecyclerView.this).hasStableIds()) {
                        var4_4 = var6_6 = this.getScrapViewForId(RecyclerView.access$3100(RecyclerView.this).getItemId(var8_8), var9_9, var2_2);
                        var10_10 = var5_5;
                        if (var6_6 != null) {
                            var6_6.mPosition = var8_8;
                            var10_10 = 1;
                            var4_4 = var6_6;
                        }
                    }
                    var6_6 = var4_4;
                    if (var4_4 == null) {
                        var6_6 = var4_4;
                        if (this.mViewCacheExtension != null) {
                            var7_7 = this.mViewCacheExtension.getViewForPositionAndType(this, var1_1, var9_9);
                            var6_6 = var4_4;
                            if (var7_7 != null) {
                                var4_4 = RecyclerView.this.getChildViewHolder((View)var7_7);
                                if (var4_4 == null) {
                                    throw new IllegalArgumentException("getViewForPositionAndType returned a view which does not have a ViewHolder");
                                }
                                var6_6 = var4_4;
                                if (var4_4.shouldIgnore()) {
                                    throw new IllegalArgumentException("getViewForPositionAndType returned a view that is ignored. You must call stopIgnoring before returning this view.");
                                }
                            }
                        }
                    }
                    var4_4 = var6_6;
                    if (var6_6 == null) {
                        var4_4 = var6_6 = this.getRecycledViewPool().getRecycledView(var9_9);
                        if (var6_6 != null) {
                            var6_6.resetInternal();
                            var4_4 = var6_6;
                            if (RecyclerView.access$4600()) {
                                this.invalidateDisplayListInt((ViewHolder)var6_6);
                                var4_4 = var6_6;
                            }
                        }
                    }
                    var7_7 = var4_4;
                    var8_8 = var10_10;
                    if (var4_4 != null) break block26;
                    var4_4 = RecyclerView.access$3100(RecyclerView.this).createViewHolder(RecyclerView.this, var9_9);
                    var5_5 = var10_10;
lbl79:
                    // 2 sources

                    while (true) {
                        block32: {
                            block29: {
                                block33: {
                                    block28: {
                                        if (var5_5 != 0 && !RecyclerView.this.mState.isPreLayout() && var4_4.hasAnyOfTheFlags(8192)) {
                                            var4_4.setFlags(0, 8192);
                                            if (State.access$2500(RecyclerView.this.mState)) {
                                                var10_10 = ItemAnimator.buildAdapterChangeFlagsForAnimations((ViewHolder)var4_4);
                                                var6_6 = RecyclerView.this.mItemAnimator.recordPreLayoutInformation(RecyclerView.this.mState, (ViewHolder)var4_4, var10_10 | 4096, var4_4.getUnmodifiedPayloads());
                                                RecyclerView.access$4700(RecyclerView.this, (ViewHolder)var4_4, (ItemAnimator.ItemHolderInfo)var6_6);
                                            }
                                        }
                                        if (RecyclerView.this.mState.isPreLayout() && var4_4.isBound()) {
                                            var4_4.mPreLayoutPosition = var1_1;
                                            var1_1 = 0;
lbl89:
                                            // 3 sources

                                            while (true) {
                                                var6_6 = var4_4.itemView.getLayoutParams();
                                                if (var6_6 != null) break block28;
                                                var6_6 = (LayoutParams)RecyclerView.this.generateDefaultLayoutParams();
                                                var4_4.itemView.setLayoutParams((ViewGroup.LayoutParams)var6_6);
lbl94:
                                                // 3 sources

                                                while (true) {
                                                    var6_6.mViewHolder = var4_4;
                                                    if (var5_5 != 0 && var1_1 != 0) {
                                                        var2_2 = var3_3;
lbl98:
                                                        // 2 sources

                                                        while (true) {
                                                            var6_6.mPendingInvalidate = var2_2;
                                                            return var4_4.itemView;
                                                        }
                                                    }
                                                    break block29;
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        if (var4_4.isBound() && !var4_4.needsUpdate() && !var4_4.isInvalid()) break block32;
                                        var10_10 = RecyclerView.this.mAdapterHelper.findPositionOffset(var1_1);
                                        var4_4.mOwnerRecyclerView = RecyclerView.this;
                                        RecyclerView.access$3100(RecyclerView.this).bindViewHolder(var4_4, var10_10);
                                        this.attachAccessibilityDelegate(var4_4.itemView);
                                        if (RecyclerView.this.mState.isPreLayout()) {
                                            var4_4.mPreLayoutPosition = var1_1;
                                        }
                                        var1_1 = 1;
                                        ** GOTO lbl89
                                    }
                                    if (RecyclerView.this.checkLayoutParams((ViewGroup.LayoutParams)var6_6)) break block33;
                                    var6_6 = (LayoutParams)RecyclerView.this.generateLayoutParams((ViewGroup.LayoutParams)var6_6);
                                    var4_4.itemView.setLayoutParams((ViewGroup.LayoutParams)var6_6);
                                    ** GOTO lbl94
                                }
                                var6_6 = (LayoutParams)var6_6;
                                ** continue;
                            }
                            var2_2 = false;
                            ** continue;
                        }
                        var1_1 = 0;
                        ** continue;
                        break;
                    }
                }
                var4_4 = var7_7;
                var5_5 = var8_8;
                ** while (true)
            }
            var4_4 = null;
            var5_5 = 0;
            ** while (true)
        }

        void markItemDecorInsetsDirty() {
            int n2 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                LayoutParams layoutParams = (LayoutParams)this.mCachedViews.get((int)i2).itemView.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.mInsetsDirty = true;
            }
        }

        void markKnownViewsInvalid() {
            if (RecyclerView.this.mAdapter != null && RecyclerView.this.mAdapter.hasStableIds()) {
                int n2 = this.mCachedViews.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ViewHolder viewHolder = this.mCachedViews.get(i2);
                    if (viewHolder == null) continue;
                    viewHolder.addFlags(6);
                    viewHolder.addChangePayload(null);
                }
            } else {
                this.recycleAndClearCachedViews();
            }
        }

        void offsetPositionRecordsForInsert(int n2, int n3) {
            int n4 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null || viewHolder.mPosition < n2) continue;
                viewHolder.offsetPosition(n3, true);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void offsetPositionRecordsForMove(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (n2 < n3) {
                n6 = -1;
                n5 = n3;
                n4 = n2;
            } else {
                n6 = 1;
                n5 = n2;
                n4 = n3;
            }
            int n7 = this.mCachedViews.size();
            int n8 = 0;
            while (n8 < n7) {
                ViewHolder viewHolder = this.mCachedViews.get(n8);
                if (viewHolder != null && viewHolder.mPosition >= n4 && viewHolder.mPosition <= n5) {
                    if (viewHolder.mPosition == n2) {
                        viewHolder.offsetPosition(n3 - n2, false);
                    } else {
                        viewHolder.offsetPosition(n6, false);
                    }
                }
                ++n8;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        void offsetPositionRecordsForRemove(int n2, int n3, boolean bl2) {
            int n4 = this.mCachedViews.size() - 1;
            while (n4 >= 0) {
                ViewHolder viewHolder = this.mCachedViews.get(n4);
                if (viewHolder != null) {
                    if (viewHolder.mPosition >= n2 + n3) {
                        viewHolder.offsetPosition(-n3, bl2);
                    } else if (viewHolder.mPosition >= n2) {
                        viewHolder.addFlags(8);
                        this.recycleCachedViewAt(n4);
                    }
                }
                --n4;
            }
            return;
        }

        void onAdapterChanged(Adapter adapter, Adapter adapter2, boolean bl2) {
            this.clear();
            this.getRecycledViewPool().onAdapterChanged(adapter, adapter2, bl2);
        }

        void quickRecycleScrapView(View object) {
            object = RecyclerView.getChildViewHolderInt((View)object);
            ViewHolder.access$5002((ViewHolder)object, null);
            ViewHolder.access$5102((ViewHolder)object, false);
            ((ViewHolder)object).clearReturnedFromScrapFlag();
            this.recycleViewHolderInternal((ViewHolder)object);
        }

        void recycleAndClearCachedViews() {
            for (int i2 = this.mCachedViews.size() - 1; i2 >= 0; --i2) {
                this.recycleCachedViewAt(i2);
            }
            this.mCachedViews.clear();
        }

        void recycleCachedViewAt(int n2) {
            this.addViewHolderToRecycledViewPool(this.mCachedViews.get(n2));
            this.mCachedViews.remove(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void recycleView(View view) {
            ViewHolder viewHolder = RecyclerView.getChildViewHolderInt(view);
            if (viewHolder.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(view, false);
            }
            if (viewHolder.isScrap()) {
                viewHolder.unScrap();
            } else if (viewHolder.wasReturnedFromScrap()) {
                viewHolder.clearReturnedFromScrapFlag();
            }
            this.recycleViewHolderInternal(viewHolder);
        }

        /*
         * Unable to fully structure code
         */
        void recycleViewHolderInternal(ViewHolder var1_1) {
            block14: {
                block12: {
                    block13: {
                        var2_2 = true;
                        var3_3 = false;
                        if (var1_1.isScrap() || var1_1.itemView.getParent() != null) {
                            var4_4 = new StringBuilder().append("Scrapped or attached views may not be recycled. isScrap:").append(var1_1.isScrap()).append(" isAttached:");
                            if (var1_1.itemView.getParent() != null) lbl-1000:
                            // 2 sources

                            {
                                throw new IllegalArgumentException(var4_4.append(var2_2).toString());
                            }
                            var2_2 = false;
                            ** continue;
                        }
                        if (var1_1.isTmpDetached()) {
                            throw new IllegalArgumentException("Tmp detached view should be removed from RecyclerView before it can be recycled: " + var1_1);
                        }
                        if (var1_1.shouldIgnore()) {
                            throw new IllegalArgumentException("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle.");
                        }
                        var2_2 = ViewHolder.access$4900(var1_1);
                        if (RecyclerView.access$3100(RecyclerView.this) == null || !var2_2 || !RecyclerView.access$3100(RecyclerView.this).onFailedToRecycleView(var1_1)) break block13;
                        var5_5 = 1;
lbl17:
                        // 2 sources

                        while (var5_5 != 0 || var1_1.isRecyclable()) {
                            if (var1_1.hasAnyOfTheFlags(14)) break block12;
                            var5_5 = this.mCachedViews.size();
                            if (var5_5 == this.mViewCacheMax && var5_5 > 0) {
                                this.recycleCachedViewAt(0);
                            }
                            if (var5_5 < this.mViewCacheMax) {
                                this.mCachedViews.add(var1_1);
                                var5_5 = 1;
lbl26:
                                // 2 sources

                                while (true) {
                                    if (var5_5 == 0) {
                                        this.addViewHolderToRecycledViewPool(var1_1);
                                        var3_3 = true;
                                    }
lbl30:
                                    // 4 sources

                                    while (true) {
                                        RecyclerView.this.mViewInfoStore.removeViewHolder(var1_1);
                                        if (var5_5 == 0 && !var3_3 && var2_2) {
                                            var1_1.mOwnerRecyclerView = null;
                                        }
                                        return;
                                    }
                                    break;
                                }
                            }
                            break block12;
                        }
                        break block14;
                    }
                    var5_5 = 0;
                    ** GOTO lbl17
                }
                var5_5 = 0;
                ** while (true)
            }
            var5_5 = 0;
            ** while (true)
        }

        void recycleViewInternal(View view) {
            this.recycleViewHolderInternal(RecyclerView.getChildViewHolderInt(view));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void scrapView(View object) {
            if (((ViewHolder)(object = RecyclerView.getChildViewHolderInt((View)object))).hasAnyOfTheFlags(12) || !((ViewHolder)object).isUpdated() || RecyclerView.this.canReuseUpdatedViewHolder((ViewHolder)object)) {
                if (((ViewHolder)object).isInvalid() && !((ViewHolder)object).isRemoved() && !RecyclerView.this.mAdapter.hasStableIds()) {
                    throw new IllegalArgumentException("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool.");
                }
                ((ViewHolder)object).setScrapContainer(this, false);
                this.mAttachedScrap.add((ViewHolder)object);
                return;
            }
            if (this.mChangedScrap == null) {
                this.mChangedScrap = new ArrayList();
            }
            ((ViewHolder)object).setScrapContainer(this, true);
            this.mChangedScrap.add((ViewHolder)object);
        }

        void setAdapterPositionsAsUnknown() {
            int n2 = this.mCachedViews.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ViewHolder viewHolder = this.mCachedViews.get(i2);
                if (viewHolder == null) continue;
                viewHolder.addFlags(512);
            }
        }

        void setRecycledViewPool(RecycledViewPool recycledViewPool) {
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detach();
            }
            this.mRecyclerPool = recycledViewPool;
            if (recycledViewPool != null) {
                this.mRecyclerPool.attach(RecyclerView.this.getAdapter());
            }
        }

        void setViewCacheExtension(ViewCacheExtension viewCacheExtension) {
            this.mViewCacheExtension = viewCacheExtension;
        }

        public void setViewCacheSize(int n2) {
            this.mViewCacheMax = n2;
            for (int i2 = this.mCachedViews.size() - 1; i2 >= 0 && this.mCachedViews.size() > n2; --i2) {
                this.recycleCachedViewAt(i2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void unscrapView(ViewHolder viewHolder) {
            if (viewHolder.mInChangeScrap) {
                this.mChangedScrap.remove(viewHolder);
            } else {
                this.mAttachedScrap.remove(viewHolder);
            }
            ViewHolder.access$5002(viewHolder, null);
            ViewHolder.access$5102(viewHolder, false);
            viewHolder.clearReturnedFromScrapFlag();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean validateViewHolderForOffsetPosition(ViewHolder viewHolder) {
            boolean bl2 = true;
            if (viewHolder.isRemoved()) {
                return RecyclerView.this.mState.isPreLayout();
            }
            if (viewHolder.mPosition < 0) throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + viewHolder);
            if (viewHolder.mPosition >= RecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + viewHolder);
            }
            if (!RecyclerView.this.mState.isPreLayout() && RecyclerView.this.mAdapter.getItemViewType(viewHolder.mPosition) != viewHolder.getItemViewType()) {
                return false;
            }
            boolean bl3 = bl2;
            if (!RecyclerView.this.mAdapter.hasStableIds()) return bl3;
            bl3 = bl2;
            if (viewHolder.getItemId() == RecyclerView.this.mAdapter.getItemId(viewHolder.mPosition)) return bl3;
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        void viewRangeUpdate(int n2, int n3) {
            int n4 = this.mCachedViews.size() - 1;
            while (n4 >= 0) {
                int n5;
                ViewHolder viewHolder = this.mCachedViews.get(n4);
                if (viewHolder != null && (n5 = viewHolder.getLayoutPosition()) >= n2 && n5 < n2 + n3) {
                    viewHolder.addFlags(2);
                    this.recycleCachedViewAt(n4);
                }
                --n4;
            }
            return;
        }
    }

    public static interface RecyclerListener {
        public void onViewRecycled(ViewHolder var1);
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver {
        private RecyclerViewDataObserver() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onChanged() {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapter.hasStableIds()) {
                State.access$1802(RecyclerView.this.mState, true);
                RecyclerView.this.setDataSetChangedAfterLayout();
            } else {
                State.access$1802(RecyclerView.this.mState, true);
                RecyclerView.this.setDataSetChangedAfterLayout();
            }
            if (!RecyclerView.this.mAdapterHelper.hasPendingUpdates()) {
                RecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onItemRangeChanged(int n2, int n3, Object object) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeChanged(n2, n3, object)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeInserted(int n2, int n3) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeInserted(n2, n3)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeMoved(int n2, int n3, int n4) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeMoved(n2, n3, n4)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeRemoved(int n2, int n3) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.onItemRangeRemoved(n2, n3)) {
                this.triggerUpdateProcessor();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void triggerUpdateProcessor() {
            if (RecyclerView.this.mPostUpdatesOnAnimation && RecyclerView.this.mHasFixedSize && RecyclerView.this.mIsAttached) {
                ViewCompat.postOnAnimation((View)RecyclerView.this, RecyclerView.this.mUpdateChildViewsRunnable);
                return;
            }
            RecyclerView.access$4502(RecyclerView.this, true);
            RecyclerView.this.requestLayout();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new 1();
        Parcelable mLayoutState;

        SavedState(Parcel parcel) {
            super(parcel);
            this.mLayoutState = parcel.readParcelable(LayoutManager.class.getClassLoader());
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private void copyFrom(SavedState savedState) {
            this.mLayoutState = savedState.mLayoutState;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeParcelable(this.mLayoutState, 0);
        }
    }

    public static class SimpleOnItemTouchListener
    implements OnItemTouchListener {
        @Override
        public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
            return false;
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean bl2) {
        }

        @Override
        public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static abstract class SmoothScroller {
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private RecyclerView mRecyclerView;
        private final Action mRecyclingAction = new /* Unavailable Anonymous Inner Class!! */;
        private boolean mRunning;
        private int mTargetPosition = -1;
        private View mTargetView;

        static /* synthetic */ void access$3500(SmoothScroller smoothScroller, int n2, int n3) {
            smoothScroller.onAnimation(n2, n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onAnimation(int n2, int n3) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (!this.mRunning || this.mTargetPosition == -1 || recyclerView == null) {
                this.stop();
            }
            this.mPendingInitialRun = false;
            if (this.mTargetView != null) {
                if (this.getChildPosition(this.mTargetView) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, recyclerView.mState, this.mRecyclingAction);
                    Action.access$6100(this.mRecyclingAction, (RecyclerView)recyclerView);
                    this.stop();
                } else {
                    Log.e((String)"RecyclerView", (String)"Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (!this.mRunning) return;
            this.onSeekTargetStep(n2, n3, recyclerView.mState, this.mRecyclingAction);
            boolean bl2 = this.mRecyclingAction.hasJumpTarget();
            Action.access$6100(this.mRecyclingAction, (RecyclerView)recyclerView);
            if (!bl2) return;
            if (this.mRunning) {
                this.mPendingInitialRun = true;
                RecyclerView.access$5900(recyclerView).postOnAnimation();
                return;
            }
            this.stop();
        }

        public View findViewByPosition(int n2) {
            return this.mRecyclerView.mLayout.findViewByPosition(n2);
        }

        public int getChildCount() {
            return this.mRecyclerView.mLayout.getChildCount();
        }

        public int getChildPosition(View view) {
            return this.mRecyclerView.getChildLayoutPosition(view);
        }

        @Nullable
        public LayoutManager getLayoutManager() {
            return this.mLayoutManager;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        @Deprecated
        public void instantScrollToPosition(int n2) {
            this.mRecyclerView.scrollToPosition(n2);
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        protected void normalize(PointF pointF) {
            double d2 = Math.sqrt(pointF.x * pointF.x + pointF.y * pointF.y);
            pointF.x = (float)((double)pointF.x / d2);
            pointF.y = (float)((double)pointF.y / d2);
        }

        protected void onChildAttachedToWindow(View view) {
            if (this.getChildPosition(view) == this.getTargetPosition()) {
                this.mTargetView = view;
            }
        }

        protected abstract void onSeekTargetStep(int var1, int var2, State var3, Action var4);

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onTargetFound(View var1, State var2, Action var3);

        public void setTargetPosition(int n2) {
            this.mTargetPosition = n2;
        }

        void start(RecyclerView recyclerView, LayoutManager layoutManager) {
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            State.access$5802(this.mRecyclerView.mState, this.mTargetPosition);
            this.mRunning = true;
            this.mPendingInitialRun = true;
            this.mTargetView = this.findViewByPosition(this.getTargetPosition());
            this.onStart();
            RecyclerView.access$5900(this.mRecyclerView).postOnAnimation();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void stop() {
            if (!this.mRunning) {
                return;
            }
            this.onStop();
            State.access$5802(this.mRecyclerView.mState, -1);
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mRunning = false;
            LayoutManager.access$6000(this.mLayoutManager, this);
            this.mLayoutManager = null;
            this.mRecyclerView = null;
        }
    }

    public static class State {
        static final int STEP_ANIMATIONS = 4;
        static final int STEP_LAYOUT = 2;
        static final int STEP_START = 1;
        private SparseArray<Object> mData;
        private int mDeletedInvisibleItemCountSincePreviousLayout = 0;
        private boolean mInPreLayout = false;
        private boolean mIsMeasuring = false;
        int mItemCount = 0;
        private int mLayoutStep = 1;
        private int mPreviousLayoutItemCount = 0;
        private boolean mRunPredictiveAnimations = false;
        private boolean mRunSimpleAnimations = false;
        private boolean mStructureChanged = false;
        private int mTargetPosition = -1;
        private boolean mTrackOldChangeHolders = false;

        static /* synthetic */ int access$1702(State state, int n2) {
            state.mDeletedInvisibleItemCountSincePreviousLayout = n2;
            return n2;
        }

        static /* synthetic */ int access$1712(State state, int n2) {
            state.mDeletedInvisibleItemCountSincePreviousLayout = n2 = state.mDeletedInvisibleItemCountSincePreviousLayout + n2;
            return n2;
        }

        static /* synthetic */ boolean access$1802(State state, boolean bl2) {
            state.mStructureChanged = bl2;
            return bl2;
        }

        static /* synthetic */ int access$2102(State state, int n2) {
            state.mLayoutStep = n2;
            return n2;
        }

        static /* synthetic */ boolean access$2202(State state, boolean bl2) {
            state.mIsMeasuring = bl2;
            return bl2;
        }

        static /* synthetic */ boolean access$2302(State state, boolean bl2) {
            state.mRunPredictiveAnimations = bl2;
            return bl2;
        }

        static /* synthetic */ boolean access$2402(State state, boolean bl2) {
            state.mInPreLayout = bl2;
            return bl2;
        }

        static /* synthetic */ boolean access$2502(State state, boolean bl2) {
            state.mRunSimpleAnimations = bl2;
            return bl2;
        }

        static /* synthetic */ boolean access$2702(State state, boolean bl2) {
            state.mTrackOldChangeHolders = bl2;
            return bl2;
        }

        static /* synthetic */ int access$2802(State state, int n2) {
            state.mPreviousLayoutItemCount = n2;
            return n2;
        }

        static /* synthetic */ int access$5802(State state, int n2) {
            state.mTargetPosition = n2;
            return n2;
        }

        void assertLayoutStep(int n2) {
            if ((this.mLayoutStep & n2) == 0) {
                throw new IllegalStateException("Layout state should be one of " + Integer.toBinaryString(n2) + " but it is " + Integer.toBinaryString(this.mLayoutStep));
            }
        }

        public boolean didStructureChange() {
            return this.mStructureChanged;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public <T> T get(int n2) {
            Object object;
            if (this.mData == null) {
                object = null;
                return (T)object;
            }
            object = this.mData.get(n2);
            return (T)object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getItemCount() {
            if (!this.mInPreLayout) return this.mItemCount;
            return this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout;
        }

        public int getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasTargetScrollPosition() {
            if (this.mTargetPosition == -1) return false;
            return true;
        }

        public boolean isMeasuring() {
            return this.mIsMeasuring;
        }

        public boolean isPreLayout() {
            return this.mInPreLayout;
        }

        public void put(int n2, Object object) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(n2, object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove(int n2) {
            if (this.mData == null) {
                return;
            }
            this.mData.remove(n2);
        }

        State reset() {
            this.mTargetPosition = -1;
            if (this.mData != null) {
                this.mData.clear();
            }
            this.mItemCount = 0;
            this.mStructureChanged = false;
            this.mIsMeasuring = false;
            return this;
        }

        public String toString() {
            return "State{mTargetPosition=" + this.mTargetPosition + ", mData=" + this.mData + ", mItemCount=" + this.mItemCount + ", mPreviousLayoutItemCount=" + this.mPreviousLayoutItemCount + ", mDeletedInvisibleItemCountSincePreviousLayout=" + this.mDeletedInvisibleItemCountSincePreviousLayout + ", mStructureChanged=" + this.mStructureChanged + ", mInPreLayout=" + this.mInPreLayout + ", mRunSimpleAnimations=" + this.mRunSimpleAnimations + ", mRunPredictiveAnimations=" + this.mRunPredictiveAnimations + '}';
        }

        public boolean willRunPredictiveAnimations() {
            return this.mRunPredictiveAnimations;
        }

        public boolean willRunSimpleAnimations() {
            return this.mRunSimpleAnimations;
        }
    }

    public static abstract class ViewCacheExtension {
        public abstract View getViewForPositionAndType(Recycler var1, int var2, int var3);
    }

    private class ViewFlinger
    implements Runnable {
        private boolean mEatRunOnAnimationRequest = false;
        private Interpolator mInterpolator = RecyclerView.access$3000();
        private int mLastFlingX;
        private int mLastFlingY;
        private boolean mReSchedulePostAnimationCallback = false;
        private ScrollerCompat mScroller;

        public ViewFlinger() {
            this.mScroller = ScrollerCompat.create(RecyclerView.this.getContext(), sQuinticInterpolator);
        }

        /*
         * Enabled aggressive block sorting
         */
        private int computeScrollDuration(int n2, int n3, int n4, int n5) {
            int n6;
            int n7 = Math.abs(n2);
            boolean bl2 = n7 > (n6 = Math.abs(n3));
            n4 = (int)Math.sqrt(n4 * n4 + n5 * n5);
            n3 = (int)Math.sqrt(n2 * n2 + n3 * n3);
            n2 = bl2 ? RecyclerView.this.getWidth() : RecyclerView.this.getHeight();
            n5 = n2 / 2;
            float f2 = Math.min(1.0f, (float)n3 * 1.0f / (float)n2);
            float f3 = n5;
            float f4 = n5;
            f2 = this.distanceInfluenceForSnapDuration(f2);
            if (n4 > 0) {
                n2 = Math.round(1000.0f * Math.abs((f2 * f4 + f3) / (float)n4)) * 4;
                return Math.min(n2, 2000);
            }
            n3 = bl2 ? n7 : n6;
            n2 = (int)(((float)n3 / (float)n2 + 1.0f) * 300.0f);
            return Math.min(n2, 2000);
        }

        private void disableRunOnAnimationRequests() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
        }

        private float distanceInfluenceForSnapDuration(float f2) {
            return (float)Math.sin((float)((double)(f2 - 0.5f) * 0.4712389167638204));
        }

        private void enableRunOnAnimationRequests() {
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.postOnAnimation();
            }
        }

        public void fling(int n2, int n3) {
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.fling(0, 0, n2, n3, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
                return;
            }
            RecyclerView.this.removeCallbacks(this);
            ViewCompat.postOnAnimation((View)RecyclerView.this, this);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block21: {
                block23: {
                    block26: {
                        block27: {
                            block28: {
                                block25: {
                                    block24: {
                                        block32: {
                                            block22: {
                                                block29: {
                                                    block31: {
                                                        block30: {
                                                            if (RecyclerView.this.mLayout == null) {
                                                                this.stop();
lbl3:
                                                                // 2 sources

                                                                return;
                                                            }
                                                            this.disableRunOnAnimationRequests();
                                                            RecyclerView.access$400(RecyclerView.this);
                                                            var1_1 = this.mScroller;
                                                            var2_2 = RecyclerView.this.mLayout.mSmoothScroller;
                                                            if (!var1_1.computeScrollOffset()) ** GOTO lbl91
                                                            var3_3 = var1_1.getCurrX();
                                                            var4_4 = var1_1.getCurrY();
                                                            var5_5 = var3_3 - this.mLastFlingX;
                                                            var6_6 = var4_4 - this.mLastFlingY;
                                                            var7_7 = 0;
                                                            var8_8 = 0;
                                                            var9_9 = 0;
                                                            var10_10 = 0;
                                                            this.mLastFlingX = var3_3;
                                                            this.mLastFlingY = var4_4;
                                                            var11_11 = 0;
                                                            var12_12 = 0;
                                                            var13_13 = 0;
                                                            var14_14 = 0;
                                                            if (RecyclerView.access$3100(RecyclerView.this) == null) break block29;
                                                            RecyclerView.this.eatRequestLayout();
                                                            RecyclerView.access$3200(RecyclerView.this);
                                                            TraceCompat.beginSection("RV Scroll");
                                                            if (var5_5 != 0) {
                                                                var8_8 = RecyclerView.this.mLayout.scrollHorizontallyBy(var5_5, RecyclerView.this.mRecycler, RecyclerView.this.mState);
                                                                var12_12 = var5_5 - var8_8;
                                                            }
                                                            if (var6_6 != 0) {
                                                                var10_10 = RecyclerView.this.mLayout.scrollVerticallyBy(var6_6, RecyclerView.this.mRecycler, RecyclerView.this.mState);
                                                                var14_14 = var6_6 - var10_10;
                                                            }
                                                            TraceCompat.endSection();
                                                            RecyclerView.access$3300(RecyclerView.this);
                                                            RecyclerView.access$3400(RecyclerView.this);
                                                            RecyclerView.this.resumeRequestLayout(false);
                                                            var13_13 = var14_14;
                                                            var9_9 = var10_10;
                                                            var11_11 = var12_12;
                                                            var7_7 = var8_8;
                                                            if (var2_2 == null) break block29;
                                                            var13_13 = var14_14;
                                                            var9_9 = var10_10;
                                                            var11_11 = var12_12;
                                                            var7_7 = var8_8;
                                                            if (var2_2.isPendingInitialRun()) break block29;
                                                            var13_13 = var14_14;
                                                            var9_9 = var10_10;
                                                            var11_11 = var12_12;
                                                            var7_7 = var8_8;
                                                            if (!var2_2.isRunning()) break block29;
                                                            var13_13 = RecyclerView.this.mState.getItemCount();
                                                            if (var13_13 != 0) break block30;
                                                            var2_2.stop();
                                                            var13_13 = var10_10;
                                                            var10_10 = var12_12;
lbl58:
                                                            // 3 sources

                                                            while (true) {
                                                                if (!RecyclerView.access$3600(RecyclerView.this).isEmpty()) {
                                                                    RecyclerView.this.invalidate();
                                                                }
                                                                if (ViewCompat.getOverScrollMode((View)RecyclerView.this) != 2) {
                                                                    RecyclerView.access$3700(RecyclerView.this, var5_5, var6_6);
                                                                }
                                                                if (var10_10 == 0 && var14_14 == 0) ** GOTO lbl79
                                                                var7_7 = (int)var1_1.getCurrVelocity();
                                                                if (var10_10 == var3_3) break block21;
                                                                if (var10_10 >= 0) break block22;
                                                                var12_12 = -var7_7;
lbl68:
                                                                // 3 sources

                                                                while (true) {
                                                                    var9_9 = var12_12;
lbl70:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        if (var14_14 == var4_4) break block23;
                                                                        if (var14_14 >= 0) break block24;
                                                                        var12_12 = -var7_7;
lbl74:
                                                                        // 4 sources

                                                                        while (true) {
                                                                            if (ViewCompat.getOverScrollMode((View)RecyclerView.this) != 2) {
                                                                                RecyclerView.this.absorbGlows(var9_9, var12_12);
                                                                            }
                                                                            if (!(var9_9 == 0 && var10_10 != var3_3 && var1_1.getFinalX() != 0 || var12_12 == 0 && var14_14 != var4_4 && var1_1.getFinalY() != 0)) {
                                                                                var1_1.abortAnimation();
                                                                            }
lbl79:
                                                                            // 4 sources

                                                                            if (var8_8 != 0 || var13_13 != 0) {
                                                                                RecyclerView.this.dispatchOnScrolled(var8_8, var13_13);
                                                                            }
                                                                            if (!RecyclerView.access$3800(RecyclerView.this)) {
                                                                                RecyclerView.this.invalidate();
                                                                            }
                                                                            if (var6_6 == 0 || !RecyclerView.this.mLayout.canScrollVertically() || var13_13 != var6_6) break block25;
                                                                            var12_12 = 1;
lbl85:
                                                                            // 2 sources

                                                                            while (var5_5 != 0 && RecyclerView.this.mLayout.canScrollHorizontally() && var8_8 == var5_5) {
                                                                                var10_10 = 1;
lbl87:
                                                                                // 2 sources

                                                                                while (var5_5 == 0 && var6_6 == 0 || var10_10 != 0 || var12_12 != 0) {
                                                                                    var12_12 = 1;
lbl89:
                                                                                    // 2 sources

                                                                                    while (var1_1.isFinished() || var12_12 == 0) {
                                                                                        RecyclerView.access$3900(RecyclerView.this, 0);
lbl91:
                                                                                        // 3 sources

                                                                                        while (true) {
                                                                                            if (var2_2 != null) {
                                                                                                if (var2_2.isPendingInitialRun()) {
                                                                                                    SmoothScroller.access$3500(var2_2, 0, 0);
                                                                                                }
                                                                                                if (!this.mReSchedulePostAnimationCallback) {
                                                                                                    var2_2.stop();
                                                                                                }
                                                                                            }
                                                                                            this.enableRunOnAnimationRequests();
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
lbl99:
                                                                                        // 1 sources

                                                                                        ** GOTO lbl3
                                                                                    }
                                                                                    break block26;
                                                                                }
                                                                                break block27;
                                                                            }
                                                                            break block28;
                                                                            break;
                                                                        }
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        if (var2_2.getTargetPosition() < var13_13) break block31;
                                                        var2_2.setTargetPosition(var13_13 - 1);
                                                        SmoothScroller.access$3500(var2_2, var5_5 - var12_12, var6_6 - var14_14);
                                                        var13_13 = var10_10;
                                                        var10_10 = var12_12;
                                                        ** GOTO lbl58
                                                    }
                                                    SmoothScroller.access$3500(var2_2, var5_5 - var12_12, var6_6 - var14_14);
                                                    var7_7 = var8_8;
                                                    var11_11 = var12_12;
                                                    var9_9 = var10_10;
                                                    var13_13 = var14_14;
                                                }
                                                var10_10 = var11_11;
                                                var14_14 = var13_13;
                                                var13_13 = var9_9;
                                                var8_8 = var7_7;
                                                ** while (true)
                                            }
                                            if (var10_10 <= 0) break block32;
                                            var12_12 = var7_7;
                                            ** GOTO lbl68
                                        }
                                        var12_12 = 0;
                                        ** while (true)
                                    }
                                    var12_12 = var7_7;
                                    if (var14_14 > 0) ** GOTO lbl74
                                    var12_12 = 0;
                                    ** GOTO lbl74
                                }
                                var12_12 = 0;
                                ** GOTO lbl85
                            }
                            var10_10 = 0;
                            ** GOTO lbl87
                        }
                        var12_12 = 0;
                        ** GOTO lbl89
                    }
                    this.postOnAnimation();
                    ** while (true)
                }
                var12_12 = 0;
                ** while (true)
            }
            var9_9 = 0;
            ** while (true)
        }

        public void smoothScrollBy(int n2, int n3) {
            this.smoothScrollBy(n2, n3, 0, 0);
        }

        public void smoothScrollBy(int n2, int n3, int n4) {
            this.smoothScrollBy(n2, n3, n4, sQuinticInterpolator);
        }

        public void smoothScrollBy(int n2, int n3, int n4, int n5) {
            this.smoothScrollBy(n2, n3, this.computeScrollDuration(n2, n3, n4, n5));
        }

        public void smoothScrollBy(int n2, int n3, int n4, Interpolator interpolator) {
            if (this.mInterpolator != interpolator) {
                this.mInterpolator = interpolator;
                this.mScroller = ScrollerCompat.create(RecyclerView.this.getContext(), interpolator);
            }
            RecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, n2, n3, n4);
            this.postOnAnimation();
        }

        public void stop() {
            RecyclerView.this.removeCallbacks(this);
            this.mScroller.abortAnimation();
        }
    }

    public static abstract class ViewHolder {
        static final int FLAG_ADAPTER_FULLUPDATE = 1024;
        static final int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        static final int FLAG_BOUNCED_FROM_HIDDEN_LIST = 8192;
        static final int FLAG_BOUND = 1;
        static final int FLAG_IGNORE = 128;
        static final int FLAG_INVALID = 4;
        static final int FLAG_MOVED = 2048;
        static final int FLAG_NOT_RECYCLABLE = 16;
        static final int FLAG_REMOVED = 8;
        static final int FLAG_RETURNED_FROM_SCRAP = 32;
        static final int FLAG_TMP_DETACHED = 256;
        static final int FLAG_UPDATE = 2;
        private static final List<Object> FULLUPDATE_PAYLOADS = Collections.EMPTY_LIST;
        public final View itemView;
        private int mFlags;
        private boolean mInChangeScrap = false;
        private int mIsRecyclableCount = 0;
        long mItemId = -1L;
        int mItemViewType = -1;
        int mOldPosition = -1;
        RecyclerView mOwnerRecyclerView;
        List<Object> mPayloads = null;
        int mPosition = -1;
        int mPreLayoutPosition = -1;
        private Recycler mScrapContainer = null;
        ViewHolder mShadowedHolder = null;
        ViewHolder mShadowingHolder = null;
        List<Object> mUnmodifiedPayloads = null;
        private int mWasImportantForAccessibilityBeforeHidden = 0;

        public ViewHolder(View view) {
            if (view == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = view;
        }

        static /* synthetic */ boolean access$4900(ViewHolder viewHolder) {
            return viewHolder.doesTransientStatePreventRecycling();
        }

        static /* synthetic */ Recycler access$5002(ViewHolder viewHolder, Recycler recycler) {
            viewHolder.mScrapContainer = recycler;
            return recycler;
        }

        static /* synthetic */ boolean access$5102(ViewHolder viewHolder, boolean bl2) {
            viewHolder.mInChangeScrap = bl2;
            return bl2;
        }

        private void createPayloadsIfNeeded() {
            if (this.mPayloads == null) {
                this.mPayloads = new ArrayList<Object>();
                this.mUnmodifiedPayloads = Collections.unmodifiableList(this.mPayloads);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean doesTransientStatePreventRecycling() {
            if ((this.mFlags & 0x10) != 0) return false;
            if (!ViewCompat.hasTransientState(this.itemView)) return false;
            return true;
        }

        private void onEnteredHiddenState() {
            this.mWasImportantForAccessibilityBeforeHidden = ViewCompat.getImportantForAccessibility(this.itemView);
            ViewCompat.setImportantForAccessibility(this.itemView, 4);
        }

        private void onLeftHiddenState() {
            ViewCompat.setImportantForAccessibility(this.itemView, this.mWasImportantForAccessibilityBeforeHidden);
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldBeKeptAsChild() {
            if ((this.mFlags & 0x10) == 0) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void addChangePayload(Object object) {
            if (object == null) {
                this.addFlags(1024);
                return;
            }
            if ((this.mFlags & 0x400) != 0) return;
            this.createPayloadsIfNeeded();
            this.mPayloads.add(object);
        }

        void addFlags(int n2) {
            this.mFlags |= n2;
        }

        void clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        void clearPayload() {
            if (this.mPayloads != null) {
                this.mPayloads.clear();
            }
            this.mFlags &= 0xFFFFFBFF;
        }

        void clearReturnedFromScrapFlag() {
            this.mFlags &= 0xFFFFFFDF;
        }

        void clearTmpDetachFlag() {
            this.mFlags &= 0xFFFFFEFF;
        }

        void flagRemovedAndOffsetPosition(int n2, int n3, boolean bl2) {
            this.addFlags(8);
            this.offsetPosition(n3, bl2);
            this.mPosition = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int getAdapterPosition() {
            if (this.mOwnerRecyclerView != null) return this.mOwnerRecyclerView.getAdapterPositionFor(this);
            return -1;
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int getLayoutPosition() {
            if (this.mPreLayoutPosition != -1) return this.mPreLayoutPosition;
            return this.mPosition;
        }

        public final int getOldPosition() {
            return this.mOldPosition;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final int getPosition() {
            if (this.mPreLayoutPosition != -1) return this.mPreLayoutPosition;
            return this.mPosition;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        List<Object> getUnmodifiedPayloads() {
            if ((this.mFlags & 0x400) != 0) return FULLUPDATE_PAYLOADS;
            if (this.mPayloads == null) return FULLUPDATE_PAYLOADS;
            if (this.mPayloads.size() != 0) return this.mUnmodifiedPayloads;
            return FULLUPDATE_PAYLOADS;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean hasAnyOfTheFlags(int n2) {
            if ((this.mFlags & n2) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isAdapterPositionUnknown() {
            if ((this.mFlags & 0x200) != 0) return true;
            if (!this.isInvalid()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isBound() {
            if ((this.mFlags & 1) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isInvalid() {
            if ((this.mFlags & 4) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isRecyclable() {
            if ((this.mFlags & 0x10) != 0) return false;
            if (ViewCompat.hasTransientState(this.itemView)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isRemoved() {
            if ((this.mFlags & 8) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isScrap() {
            if (this.mScrapContainer == null) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isTmpDetached() {
            if ((this.mFlags & 0x100) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isUpdated() {
            if ((this.mFlags & 2) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean needsUpdate() {
            if ((this.mFlags & 2) == 0) return false;
            return true;
        }

        void offsetPosition(int n2, boolean bl2) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (bl2) {
                this.mPreLayoutPosition += n2;
            }
            this.mPosition += n2;
            if (this.itemView.getLayoutParams() != null) {
                ((LayoutParams)this.itemView.getLayoutParams()).mInsetsDirty = true;
            }
        }

        void resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            this.clearPayload();
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        void saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        void setFlags(int n2, int n3) {
            this.mFlags = this.mFlags & ~n3 | n2 & n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void setIsRecyclable(boolean bl2) {
            int n2 = bl2 ? this.mIsRecyclableCount - 1 : this.mIsRecyclableCount + 1;
            this.mIsRecyclableCount = n2;
            if (this.mIsRecyclableCount < 0) {
                this.mIsRecyclableCount = 0;
                Log.e((String)"View", (String)("isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this));
                return;
            }
            if (!bl2 && this.mIsRecyclableCount == 1) {
                this.mFlags |= 0x10;
                return;
            }
            if (!bl2) return;
            if (this.mIsRecyclableCount != 0) return;
            this.mFlags &= 0xFFFFFFEF;
        }

        void setScrapContainer(Recycler recycler, boolean bl2) {
            this.mScrapContainer = recycler;
            this.mInChangeScrap = bl2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean shouldIgnore() {
            if ((this.mFlags & 0x80) == 0) return false;
            return true;
        }

        void stopIgnoring() {
            this.mFlags &= 0xFFFFFF7F;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ViewHolder{" + Integer.toHexString(this.hashCode()) + " position=" + this.mPosition + " id=" + this.mItemId + ", oldPos=" + this.mOldPosition + ", pLpos:" + this.mPreLayoutPosition);
            if (this.isScrap()) {
                StringBuilder stringBuilder2 = stringBuilder.append(" scrap ");
                String string2 = this.mInChangeScrap ? "[changeScrap]" : "[attachedScrap]";
                stringBuilder2.append(string2);
            }
            if (this.isInvalid()) {
                stringBuilder.append(" invalid");
            }
            if (!this.isBound()) {
                stringBuilder.append(" unbound");
            }
            if (this.needsUpdate()) {
                stringBuilder.append(" update");
            }
            if (this.isRemoved()) {
                stringBuilder.append(" removed");
            }
            if (this.shouldIgnore()) {
                stringBuilder.append(" ignored");
            }
            if (this.isTmpDetached()) {
                stringBuilder.append(" tmpDetached");
            }
            if (!this.isRecyclable()) {
                stringBuilder.append(" not recyclable(" + this.mIsRecyclableCount + ")");
            }
            if (this.isAdapterPositionUnknown()) {
                stringBuilder.append(" undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                stringBuilder.append(" no parent");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        void unScrap() {
            this.mScrapContainer.unscrapView(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean wasReturnedFromScrap() {
            if ((this.mFlags & 0x20) == 0) return false;
            return true;
        }
    }
}

