/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.MenuRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.MenuItemCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.appcompat.R;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.widget.ActionMenuPresenter;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DecorToolbar;
import android.support.v7.widget.RtlSpacingHelper;
import android.support.v7.widget.TintTypedArray;
import android.support.v7.widget.Toolbar;
import android.support.v7.widget.ToolbarWidgetWrapper;
import android.support.v7.widget.ViewUtils;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class Toolbar
extends ViewGroup {
    private static final String TAG = "Toolbar";
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private int mButtonGravity;
    private ImageButton mCollapseButtonView;
    private CharSequence mCollapseDescription;
    private Drawable mCollapseIcon;
    private boolean mCollapsible;
    private final RtlSpacingHelper mContentInsets = new RtlSpacingHelper();
    private final AppCompatDrawableManager mDrawableManager;
    private boolean mEatingHover;
    private boolean mEatingTouch;
    View mExpandedActionView;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private int mGravity = 8388627;
    private final ArrayList<View> mHiddenViews;
    private ImageView mLogoView;
    private int mMaxButtonHeight;
    private MenuBuilder.Callback mMenuBuilderCallback;
    private ActionMenuView mMenuView;
    private final ActionMenuView.OnMenuItemClickListener mMenuViewItemClickListener;
    private ImageButton mNavButtonView;
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private ActionMenuPresenter mOuterActionMenuPresenter;
    private Context mPopupContext;
    private int mPopupTheme;
    private final Runnable mShowOverflowMenuRunnable;
    private CharSequence mSubtitleText;
    private int mSubtitleTextAppearance;
    private int mSubtitleTextColor;
    private TextView mSubtitleTextView;
    private final int[] mTempMargins;
    private final ArrayList<View> mTempViews = new ArrayList();
    private int mTitleMarginBottom;
    private int mTitleMarginEnd;
    private int mTitleMarginStart;
    private int mTitleMarginTop;
    private CharSequence mTitleText;
    private int mTitleTextAppearance;
    private int mTitleTextColor;
    private TextView mTitleTextView;
    private ToolbarWidgetWrapper mWrapper;

    public Toolbar(Context context) {
        this(context, null);
    }

    public Toolbar(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.toolbarStyle);
    }

    public Toolbar(Context object, @Nullable AttributeSet object2, int n2) {
        super((Context)object, object2, n2);
        this.mHiddenViews = new ArrayList();
        this.mTempMargins = new int[2];
        this.mMenuViewItemClickListener = new 1(this);
        this.mShowOverflowMenuRunnable = new 2(this);
        object = TintTypedArray.obtainStyledAttributes(this.getContext(), object2, R.styleable.Toolbar, n2, 0);
        this.mTitleTextAppearance = ((TintTypedArray)object).getResourceId(R.styleable.Toolbar_titleTextAppearance, 0);
        this.mSubtitleTextAppearance = ((TintTypedArray)object).getResourceId(R.styleable.Toolbar_subtitleTextAppearance, 0);
        this.mGravity = ((TintTypedArray)object).getInteger(R.styleable.Toolbar_android_gravity, this.mGravity);
        this.mButtonGravity = 48;
        this.mTitleMarginBottom = n2 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_titleMargins, 0);
        this.mTitleMarginTop = n2;
        this.mTitleMarginEnd = n2;
        this.mTitleMarginStart = n2;
        n2 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_titleMarginStart, -1);
        if (n2 >= 0) {
            this.mTitleMarginStart = n2;
        }
        if ((n2 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_titleMarginEnd, -1)) >= 0) {
            this.mTitleMarginEnd = n2;
        }
        if ((n2 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_titleMarginTop, -1)) >= 0) {
            this.mTitleMarginTop = n2;
        }
        if ((n2 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_titleMarginBottom, -1)) >= 0) {
            this.mTitleMarginBottom = n2;
        }
        this.mMaxButtonHeight = ((TintTypedArray)object).getDimensionPixelSize(R.styleable.Toolbar_maxButtonHeight, -1);
        int n3 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_contentInsetStart, Integer.MIN_VALUE);
        int n4 = ((TintTypedArray)object).getDimensionPixelOffset(R.styleable.Toolbar_contentInsetEnd, Integer.MIN_VALUE);
        n2 = ((TintTypedArray)object).getDimensionPixelSize(R.styleable.Toolbar_contentInsetLeft, 0);
        int n5 = ((TintTypedArray)object).getDimensionPixelSize(R.styleable.Toolbar_contentInsetRight, 0);
        this.mContentInsets.setAbsolute(n2, n5);
        if (n3 != Integer.MIN_VALUE || n4 != Integer.MIN_VALUE) {
            this.mContentInsets.setRelative(n3, n4);
        }
        this.mCollapseIcon = ((TintTypedArray)object).getDrawable(R.styleable.Toolbar_collapseIcon);
        this.mCollapseDescription = ((TintTypedArray)object).getText(R.styleable.Toolbar_collapseContentDescription);
        object2 = ((TintTypedArray)object).getText(R.styleable.Toolbar_title);
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            this.setTitle((CharSequence)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = ((TintTypedArray)object).getText(R.styleable.Toolbar_subtitle)))) {
            this.setSubtitle((CharSequence)object2);
        }
        this.mPopupContext = this.getContext();
        this.setPopupTheme(((TintTypedArray)object).getResourceId(R.styleable.Toolbar_popupTheme, 0));
        object2 = ((TintTypedArray)object).getDrawable(R.styleable.Toolbar_navigationIcon);
        if (object2 != null) {
            this.setNavigationIcon((Drawable)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = ((TintTypedArray)object).getText(R.styleable.Toolbar_navigationContentDescription)))) {
            this.setNavigationContentDescription((CharSequence)object2);
        }
        if ((object2 = ((TintTypedArray)object).getDrawable(R.styleable.Toolbar_logo)) != null) {
            this.setLogo((Drawable)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = ((TintTypedArray)object).getText(R.styleable.Toolbar_logoDescription)))) {
            this.setLogoDescription((CharSequence)object2);
        }
        if (((TintTypedArray)object).hasValue(R.styleable.Toolbar_titleTextColor)) {
            this.setTitleTextColor(((TintTypedArray)object).getColor(R.styleable.Toolbar_titleTextColor, -1));
        }
        if (((TintTypedArray)object).hasValue(R.styleable.Toolbar_subtitleTextColor)) {
            this.setSubtitleTextColor(((TintTypedArray)object).getColor(R.styleable.Toolbar_subtitleTextColor, -1));
        }
        ((TintTypedArray)object).recycle();
        this.mDrawableManager = AppCompatDrawableManager.get();
    }

    static /* synthetic */ OnMenuItemClickListener access$000(Toolbar toolbar) {
        return toolbar.mOnMenuItemClickListener;
    }

    static /* synthetic */ void access$200(Toolbar toolbar) {
        toolbar.ensureCollapseButtonView();
    }

    static /* synthetic */ ImageButton access$300(Toolbar toolbar) {
        return toolbar.mCollapseButtonView;
    }

    static /* synthetic */ int access$400(Toolbar toolbar) {
        return toolbar.mButtonGravity;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addCustomViewsWithGravity(List<View> list, int n2) {
        boolean bl2 = true;
        int n3 = 0;
        if (ViewCompat.getLayoutDirection((View)this) != 1) {
            bl2 = false;
        }
        int n4 = this.getChildCount();
        int n5 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        list.clear();
        if (bl2) {
            for (n2 = n4 - 1; n2 >= 0; --n2) {
                View view = this.getChildAt(n2);
                LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams.mViewType != 0 || !this.shouldLayout(view) || this.getChildHorizontalGravity(layoutParams.gravity) != n5) continue;
                list.add(view);
            }
            return;
        } else {
            for (n2 = n3; n2 < n4; ++n2) {
                View view = this.getChildAt(n2);
                LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams.mViewType != 0 || !this.shouldLayout(view) || this.getChildHorizontalGravity(layoutParams.gravity) != n5) continue;
                list.add(view);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addSystemView(View view, boolean bl2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams = layoutParams == null ? this.generateDefaultLayoutParams() : (!this.checkLayoutParams(layoutParams) ? this.generateLayoutParams(layoutParams) : layoutParams);
        layoutParams.mViewType = 1;
        if (bl2 && this.mExpandedActionView != null) {
            view.setLayoutParams(layoutParams);
            this.mHiddenViews.add(view);
            return;
        }
        this.addView(view, layoutParams);
    }

    private void ensureCollapseButtonView() {
        if (this.mCollapseButtonView == null) {
            this.mCollapseButtonView = new ImageButton(this.getContext(), null, R.attr.toolbarNavigationButtonStyle);
            this.mCollapseButtonView.setImageDrawable(this.mCollapseIcon);
            this.mCollapseButtonView.setContentDescription(this.mCollapseDescription);
            LayoutParams layoutParams = this.generateDefaultLayoutParams();
            layoutParams.gravity = 0x800003 | this.mButtonGravity & 0x70;
            layoutParams.mViewType = 2;
            this.mCollapseButtonView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mCollapseButtonView.setOnClickListener((View.OnClickListener)new 3(this));
        }
    }

    private void ensureLogoView() {
        if (this.mLogoView == null) {
            this.mLogoView = new ImageView(this.getContext());
        }
    }

    private void ensureMenu() {
        this.ensureMenuView();
        if (this.mMenuView.peekMenu() == null) {
            MenuBuilder menuBuilder = (MenuBuilder)this.mMenuView.getMenu();
            if (this.mExpandedMenuPresenter == null) {
                this.mExpandedMenuPresenter = new /* Unavailable Anonymous Inner Class!! */;
            }
            this.mMenuView.setExpandedActionViewsExclusive(true);
            menuBuilder.addMenuPresenter((MenuPresenter)this.mExpandedMenuPresenter, this.mPopupContext);
        }
    }

    private void ensureMenuView() {
        if (this.mMenuView == null) {
            this.mMenuView = new ActionMenuView(this.getContext());
            this.mMenuView.setPopupTheme(this.mPopupTheme);
            this.mMenuView.setOnMenuItemClickListener(this.mMenuViewItemClickListener);
            this.mMenuView.setMenuCallbacks(this.mActionMenuPresenterCallback, this.mMenuBuilderCallback);
            LayoutParams layoutParams = this.generateDefaultLayoutParams();
            layoutParams.gravity = 0x800005 | this.mButtonGravity & 0x70;
            this.mMenuView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addSystemView((View)this.mMenuView, false);
        }
    }

    private void ensureNavButtonView() {
        if (this.mNavButtonView == null) {
            this.mNavButtonView = new ImageButton(this.getContext(), null, R.attr.toolbarNavigationButtonStyle);
            LayoutParams layoutParams = this.generateDefaultLayoutParams();
            layoutParams.gravity = 0x800003 | this.mButtonGravity & 0x70;
            this.mNavButtonView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getChildHorizontalGravity(int n2) {
        int n3;
        int n4 = ViewCompat.getLayoutDirection((View)this);
        n2 = n3 = GravityCompat.getAbsoluteGravity(n2, n4) & 7;
        switch (n3) {
            default: {
                if (n4 != 1) return 3;
                n2 = 5;
            }
            case 1: 
            case 3: 
            case 5: {
                return n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getChildTop(View view, int n2) {
        int n3;
        block5: {
            int n4;
            int n5;
            LayoutParams layoutParams = view.getLayoutParams();
            int n6 = view.getMeasuredHeight();
            n2 = n2 > 0 ? (n6 - n2) / 2 : 0;
            switch (this.getChildVerticalGravity(layoutParams.gravity)) {
                default: {
                    n3 = this.getPaddingTop();
                    n5 = this.getPaddingBottom();
                    n4 = this.getHeight();
                    n2 = (n4 - n3 - n5 - n6) / 2;
                    if (n2 >= layoutParams.topMargin) break;
                    n2 = layoutParams.topMargin;
                    break block5;
                }
                case 48: {
                    return this.getPaddingTop() - n2;
                }
                case 80: {
                    return this.getHeight() - this.getPaddingBottom() - n6 - layoutParams.bottomMargin - n2;
                }
            }
            if ((n6 = n4 - n5 - n6 - n2 - n3) < layoutParams.bottomMargin) {
                n2 = Math.max(0, n2 - (layoutParams.bottomMargin - n6));
            }
        }
        n2 += n3;
        return n2;
    }

    private int getChildVerticalGravity(int n2) {
        int n3;
        n2 = n3 = n2 & 0x70;
        switch (n3) {
            default: {
                n2 = this.mGravity & 0x70;
            }
            case 16: 
            case 48: 
            case 80: 
        }
        return n2;
    }

    private int getHorizontalMargins(View view) {
        view = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n2 = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)view);
        return MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)view) + n2;
    }

    private MenuInflater getMenuInflater() {
        return new SupportMenuInflater(this.getContext());
    }

    private int getVerticalMargins(View view) {
        view = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n2 = view.topMargin;
        return view.bottomMargin + n2;
    }

    private int getViewListMeasuredWidth(List<View> list, int[] object) {
        int n2 = object[0];
        int n3 = object[1];
        int n4 = list.size();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            object = list.get(n5);
            LayoutParams layoutParams = object.getLayoutParams();
            n2 = layoutParams.leftMargin - n2;
            n3 = layoutParams.rightMargin - n3;
            int n7 = Math.max(0, n2);
            int n8 = Math.max(0, n3);
            n2 = Math.max(0, -n2);
            n3 = Math.max(0, -n3);
            int n9 = object.getMeasuredWidth();
            ++n5;
            n6 += n9 + n7 + n8;
        }
        return n6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChildOrHidden(View view) {
        if (view.getParent() == this) return true;
        if (!this.mHiddenViews.contains(view)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCustomView(View view) {
        if ((view.getLayoutParams()).mViewType != 0) return false;
        return true;
    }

    private int layoutChildLeft(View view, int n2, int[] nArray, int n3) {
        LayoutParams layoutParams = view.getLayoutParams();
        int n4 = layoutParams.leftMargin - nArray[0];
        n2 = Math.max(0, n4) + n2;
        nArray[0] = Math.max(0, -n4);
        n3 = this.getChildTop(view, n3);
        n4 = view.getMeasuredWidth();
        view.layout(n2, n3, n2 + n4, view.getMeasuredHeight() + n3);
        return layoutParams.rightMargin + n4 + n2;
    }

    private int layoutChildRight(View view, int n2, int[] nArray, int n3) {
        LayoutParams layoutParams = view.getLayoutParams();
        int n4 = layoutParams.rightMargin - nArray[1];
        n2 -= Math.max(0, n4);
        nArray[1] = Math.max(0, -n4);
        n3 = this.getChildTop(view, n3);
        n4 = view.getMeasuredWidth();
        view.layout(n2 - n4, n3, n2, view.getMeasuredHeight() + n3);
        return n2 - (layoutParams.leftMargin + n4);
    }

    private int measureChildCollapseMargins(View view, int n2, int n3, int n4, int n5, int[] nArray) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n6 = marginLayoutParams.leftMargin - nArray[0];
        int n7 = marginLayoutParams.rightMargin - nArray[1];
        int n8 = Math.max(0, n6) + Math.max(0, n7);
        nArray[0] = Math.max(0, -n6);
        nArray[1] = Math.max(0, -n7);
        view.measure(Toolbar.getChildMeasureSpec((int)n2, (int)(this.getPaddingLeft() + this.getPaddingRight() + n8 + n3), (int)marginLayoutParams.width), Toolbar.getChildMeasureSpec((int)n4, (int)(this.getPaddingTop() + this.getPaddingBottom() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + n5), (int)marginLayoutParams.height));
        return view.getMeasuredWidth() + n8;
    }

    private void measureChildConstrained(View view, int n2, int n3, int n4, int n5, int n6) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n7 = Toolbar.getChildMeasureSpec((int)n2, (int)(this.getPaddingLeft() + this.getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + n3), (int)marginLayoutParams.width);
        n3 = Toolbar.getChildMeasureSpec((int)n4, (int)(this.getPaddingTop() + this.getPaddingBottom() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + n5), (int)marginLayoutParams.height);
        n4 = View.MeasureSpec.getMode((int)n3);
        n2 = n3;
        if (n4 != 0x40000000) {
            n2 = n3;
            if (n6 >= 0) {
                n2 = n6;
                if (n4 != 0) {
                    n2 = Math.min(View.MeasureSpec.getSize((int)n3), n6);
                }
                n2 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            }
        }
        view.measure(n7, n2);
    }

    private void postShowOverflowMenu() {
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
        this.post(this.mShowOverflowMenuRunnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldCollapse() {
        boolean bl2 = false;
        if (!this.mCollapsible) {
            return bl2;
        }
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if (this.shouldLayout(view) && view.getMeasuredWidth() > 0) {
                boolean bl3 = bl2;
                if (view.getMeasuredHeight() > 0) return bl3;
            }
            ++n3;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldLayout(View view) {
        if (view == null) return false;
        if (view.getParent() != this) return false;
        if (view.getVisibility() == 8) return false;
        return true;
    }

    void addChildrenForExpandedActionView() {
        for (int i2 = this.mHiddenViews.size() - 1; i2 >= 0; --i2) {
            this.addView(this.mHiddenViews.get(i2));
        }
        this.mHiddenViews.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canShowOverflowMenu() {
        if (this.getVisibility() != 0) return false;
        if (this.mMenuView == null) return false;
        if (!this.mMenuView.isOverflowReserved()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!super.checkLayoutParams(layoutParams)) return false;
        if (!(layoutParams instanceof LayoutParams)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collapseActionView() {
        if (this.mExpandedMenuPresenter == null) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (menuItemImpl == null) return;
        menuItemImpl.collapseActionView();
    }

    public void dismissPopupMenus() {
        if (this.mMenuView != null) {
            this.mMenuView.dismissPopupMenus();
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (layoutParams instanceof ActionBar.LayoutParams) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) return new /* Unavailable Anonymous Inner Class!! */;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int getContentInsetEnd() {
        return this.mContentInsets.getEnd();
    }

    public int getContentInsetLeft() {
        return this.mContentInsets.getLeft();
    }

    public int getContentInsetRight() {
        return this.mContentInsets.getRight();
    }

    public int getContentInsetStart() {
        return this.mContentInsets.getStart();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getLogo() {
        if (this.mLogoView == null) return null;
        return this.mLogoView.getDrawable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getLogoDescription() {
        if (this.mLogoView == null) return null;
        return this.mLogoView.getContentDescription();
    }

    public Menu getMenu() {
        this.ensureMenu();
        return this.mMenuView.getMenu();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public CharSequence getNavigationContentDescription() {
        if (this.mNavButtonView == null) return null;
        return this.mNavButtonView.getContentDescription();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Drawable getNavigationIcon() {
        if (this.mNavButtonView == null) return null;
        return this.mNavButtonView.getDrawable();
    }

    @Nullable
    public Drawable getOverflowIcon() {
        this.ensureMenu();
        return this.mMenuView.getOverflowIcon();
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitleText;
    }

    public CharSequence getTitle() {
        return this.mTitleText;
    }

    public DecorToolbar getWrapper() {
        if (this.mWrapper == null) {
            this.mWrapper = new ToolbarWidgetWrapper(this, true);
        }
        return this.mWrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasExpandedActionView() {
        if (this.mExpandedMenuPresenter == null) return false;
        if (this.mExpandedMenuPresenter.mCurrentExpandedItem == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideOverflowMenu() {
        if (this.mMenuView == null) return false;
        if (!this.mMenuView.hideOverflowMenu()) return false;
        return true;
    }

    public void inflateMenu(@MenuRes int n2) {
        this.getMenuInflater().inflate(n2, this.getMenu());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowPending() {
        if (this.mMenuView == null) return false;
        if (!this.mMenuView.isOverflowMenuShowPending()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowing() {
        if (this.mMenuView == null) return false;
        if (!this.mMenuView.isOverflowMenuShowing()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTitleTruncated() {
        boolean bl2 = false;
        if (this.mTitleTextView == null) {
            return bl2;
        }
        Layout layout2 = this.mTitleTextView.getLayout();
        boolean bl3 = bl2;
        if (layout2 == null) return bl3;
        int n2 = layout2.getLineCount();
        int n3 = 0;
        while (true) {
            bl3 = bl2;
            if (n3 >= n2) return bl3;
            if (layout2.getEllipsisCount(n3) > 0) {
                return true;
            }
            ++n3;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionMasked(motionEvent);
        if (n2 == 9) {
            this.mEatingHover = false;
        }
        if (!this.mEatingHover) {
            boolean bl2 = super.onHoverEvent(motionEvent);
            if (n2 == 9 && !bl2) {
                this.mEatingHover = true;
            }
        }
        if (n2 == 10 || n2 == 3) {
            this.mEatingHover = false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block41: {
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block40: {
                                var6_6 = ViewCompat.getLayoutDirection((View)this) == 1 ? 1 : 0;
                                var7_7 = this.getWidth();
                                var8_8 = this.getHeight();
                                var9_9 = this.getPaddingLeft();
                                var10_10 = this.getPaddingRight();
                                var11_11 = this.getPaddingTop();
                                var12_12 = this.getPaddingBottom();
                                var5_5 = var7_7 - var10_10;
                                var13_13 = this.mTempMargins;
                                var13_13[1] = 0;
                                var13_13[0] = 0;
                                var14_14 = ViewCompat.getMinimumHeight((View)this);
                                if (this.shouldLayout((View)this.mNavButtonView)) {
                                    if (var6_6 != 0) {
                                        var5_5 = this.layoutChildRight((View)this.mNavButtonView, var5_5, var13_13, var14_14);
                                        var2_2 = var9_9;
                                    } else {
                                        var2_2 = this.layoutChildLeft((View)this.mNavButtonView, var9_9, var13_13, var14_14);
                                    }
                                } else {
                                    var2_2 = var9_9;
                                }
                                var4_4 = var5_5;
                                var3_3 = var2_2;
                                if (this.shouldLayout((View)this.mCollapseButtonView)) {
                                    if (var6_6 != 0) {
                                        var4_4 = this.layoutChildRight((View)this.mCollapseButtonView, var5_5, var13_13, var14_14);
                                        var3_3 = var2_2;
                                    } else {
                                        var3_3 = this.layoutChildLeft((View)this.mCollapseButtonView, var2_2, var13_13, var14_14);
                                        var4_4 = var5_5;
                                    }
                                }
                                var2_2 = var4_4;
                                var5_5 = var3_3;
                                if (this.shouldLayout((View)this.mMenuView)) {
                                    if (var6_6 != 0) {
                                        var5_5 = this.layoutChildLeft((View)this.mMenuView, var3_3, var13_13, var14_14);
                                        var2_2 = var4_4;
                                    } else {
                                        var2_2 = this.layoutChildRight((View)this.mMenuView, var4_4, var13_13, var14_14);
                                        var5_5 = var3_3;
                                    }
                                }
                                var13_13[0] = Math.max(0, this.getContentInsetLeft() - var5_5);
                                var13_13[1] = Math.max(0, this.getContentInsetRight() - (var7_7 - var10_10 - var2_2));
                                var4_4 = Math.max(var5_5, this.getContentInsetLeft());
                                var3_3 = var5_5 = Math.min(var2_2, var7_7 - var10_10 - this.getContentInsetRight());
                                var2_2 = var4_4;
                                if (this.shouldLayout(this.mExpandedActionView)) {
                                    if (var6_6 != 0) {
                                        var3_3 = this.layoutChildRight(this.mExpandedActionView, var5_5, var13_13, var14_14);
                                        var2_2 = var4_4;
                                    } else {
                                        var2_2 = this.layoutChildLeft(this.mExpandedActionView, var4_4, var13_13, var14_14);
                                        var3_3 = var5_5;
                                    }
                                }
                                if (this.shouldLayout((View)this.mLogoView)) {
                                    if (var6_6 != 0) {
                                        var3_3 = this.layoutChildRight((View)this.mLogoView, var3_3, var13_13, var14_14);
                                        var4_4 = var2_2;
                                    } else {
                                        var4_4 = this.layoutChildLeft((View)this.mLogoView, var2_2, var13_13, var14_14);
                                    }
                                } else {
                                    var4_4 = var2_2;
                                }
                                var15_15 = this.shouldLayout((View)this.mTitleTextView);
                                var1_1 = this.shouldLayout((View)this.mSubtitleTextView);
                                var2_2 = 0;
                                if (var15_15) {
                                    var16_16 = this.mTitleTextView.getLayoutParams();
                                    var2_2 = var16_16.topMargin;
                                    var5_5 = this.mTitleTextView.getMeasuredHeight();
                                    var2_2 = 0 + (var16_16.bottomMargin + (var2_2 + var5_5));
                                }
                                if (var1_1) {
                                    var16_16 = this.mSubtitleTextView.getLayoutParams();
                                    var5_5 = var16_16.topMargin;
                                    var17_17 = this.mSubtitleTextView.getMeasuredHeight();
                                    var18_18 = var16_16.bottomMargin + (var5_5 + var17_17) + var2_2;
                                } else {
                                    var18_18 = var2_2;
                                }
                                if (var15_15) break block40;
                                var5_5 = var3_3;
                                var2_2 = var4_4;
                                if (!var1_1) break block41;
                            }
                            var16_16 = var15_15 != false ? this.mTitleTextView : this.mSubtitleTextView;
                            var19_19 = var1_1 != false ? this.mSubtitleTextView : this.mTitleTextView;
                            var16_16 = var16_16.getLayoutParams();
                            var19_19 = var19_19.getLayoutParams();
                            var17_17 = var15_15 != false && this.mTitleTextView.getMeasuredWidth() > 0 || var1_1 != false && this.mSubtitleTextView.getMeasuredWidth() > 0 ? 1 : 0;
                            switch (this.mGravity & 112) {
                                default: {
                                    var2_2 = (var8_8 - var11_11 - var12_12 - var18_18) / 2;
                                    if (var2_2 >= var16_16.topMargin + this.mTitleMarginTop) ** GOTO lbl96
                                    var2_2 = var16_16.topMargin + this.mTitleMarginTop;
                                    ** GOTO lbl99
                                }
                                case 48: {
                                    var2_2 = this.getPaddingTop();
                                    var2_2 = var16_16.topMargin + var2_2 + this.mTitleMarginTop;
                                    break block42;
                                }
lbl96:
                                // 1 sources

                                var5_5 = var8_8 - var12_12 - var18_18 - var2_2 - var11_11;
                                if (var5_5 < var16_16.bottomMargin + this.mTitleMarginBottom) {
                                    var2_2 = Math.max(0, var2_2 - (var19_19.bottomMargin + this.mTitleMarginBottom - var5_5));
                                }
lbl99:
                                // 4 sources

                                var2_2 = var11_11 + var2_2;
                                break block42;
                                case 80: 
                            }
                            var2_2 = var8_8 - var12_12 - var19_19.bottomMargin - this.mTitleMarginBottom - var18_18;
                        }
                        if (var6_6 == 0) break block43;
                        var5_5 = var17_17 != 0 ? this.mTitleMarginStart : 0;
                        var3_3 -= Math.max(0, var5_5 -= var13_13[1]);
                        var13_13[1] = Math.max(0, -var5_5);
                        if (!var15_15) break block44;
                        var16_16 = this.mTitleTextView.getLayoutParams();
                        var5_5 = var3_3 - this.mTitleTextView.getMeasuredWidth();
                        var6_6 = this.mTitleTextView.getMeasuredHeight() + var2_2;
                        this.mTitleTextView.layout(var5_5, var2_2, var3_3, var6_6);
                        var18_18 = this.mTitleMarginEnd;
                        var2_2 = var6_6 + var16_16.bottomMargin;
                        var5_5 -= var18_18;
                        break block45;
                    }
                    var5_5 = var17_17 != 0 ? this.mTitleMarginStart : 0;
                    var4_4 += Math.max(0, var5_5 -= var13_13[0]);
                    var13_13[0] = Math.max(0, -var5_5);
                    if (var15_15) {
                        var16_16 = this.mTitleTextView.getLayoutParams();
                        var6_6 = this.mTitleTextView.getMeasuredWidth() + var4_4;
                        var5_5 = this.mTitleTextView.getMeasuredHeight() + var2_2;
                        this.mTitleTextView.layout(var4_4, var2_2, var6_6, var5_5);
                        var18_18 = this.mTitleMarginEnd;
                        var2_2 = var16_16.bottomMargin;
                        var6_6 += var18_18;
                        var2_2 += var5_5;
                    } else {
                        var6_6 = var4_4;
                    }
                    if (var1_1) {
                        var16_16 = this.mSubtitleTextView.getLayoutParams();
                        var18_18 = var2_2 + var16_16.topMargin;
                        var2_2 = this.mSubtitleTextView.getMeasuredWidth() + var4_4;
                        var5_5 = this.mSubtitleTextView.getMeasuredHeight() + var18_18;
                        this.mSubtitleTextView.layout(var4_4, var18_18, var2_2, var5_5);
                        var18_18 = this.mTitleMarginEnd;
                        var5_5 = var16_16.bottomMargin;
                        var18_18 += var2_2;
                    } else {
                        var18_18 = var4_4;
                    }
                    var5_5 = var3_3;
                    var2_2 = var4_4;
                    if (var17_17 != 0) {
                        var2_2 = Math.max(var6_6, var18_18);
                        var5_5 = var3_3;
                    }
                    break block41;
                }
                var5_5 = var3_3;
            }
            if (var1_1) {
                var16_16 = this.mSubtitleTextView.getLayoutParams();
                var6_6 = var16_16.topMargin + var2_2;
                var18_18 = this.mSubtitleTextView.getMeasuredWidth();
                var2_2 = this.mSubtitleTextView.getMeasuredHeight() + var6_6;
                this.mSubtitleTextView.layout(var3_3 - var18_18, var6_6, var3_3, var2_2);
                var6_6 = this.mTitleMarginEnd;
                var2_2 = var16_16.bottomMargin;
                var2_2 = var3_3 - var6_6;
            } else {
                var2_2 = var3_3;
            }
            var2_2 = var17_17 != 0 ? Math.min(var5_5, var2_2) : var3_3;
            var5_5 = var2_2;
            var2_2 = var4_4;
        }
        this.addCustomViewsWithGravity(this.mTempViews, 3);
        var4_4 = this.mTempViews.size();
        for (var3_3 = 0; var3_3 < var4_4; ++var3_3) {
            var2_2 = this.layoutChildLeft(this.mTempViews.get(var3_3), var2_2, var13_13, var14_14);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 5);
        var4_4 = this.mTempViews.size();
        for (var3_3 = 0; var3_3 < var4_4; ++var3_3) {
            var5_5 = this.layoutChildRight(this.mTempViews.get(var3_3), var5_5, var13_13, var14_14);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 1);
        var4_4 = this.getViewListMeasuredWidth(this.mTempViews, var13_13);
        var3_3 = (var7_7 - var9_9 - var10_10) / 2 + var9_9 - var4_4 / 2;
        var4_4 += var3_3;
        if (var3_3 >= var2_2) {
            var2_2 = var3_3;
            if (var4_4 > var5_5) {
                var2_2 = var3_3 - (var4_4 - var5_5);
            }
        }
        var4_4 = this.mTempViews.size();
        var3_3 = 0;
        while (true) {
            if (var3_3 >= var4_4) {
                this.mTempViews.clear();
                return;
            }
            var2_2 = this.layoutChildLeft(this.mTempViews.get(var3_3), var2_2, var13_13, var14_14);
            ++var3_3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int[] nArray = this.mTempMargins;
        if (ViewUtils.isLayoutRtl((View)this)) {
            n5 = 0;
            n4 = 1;
        } else {
            n5 = 1;
            n4 = 0;
        }
        int n8 = 0;
        if (this.shouldLayout((View)this.mNavButtonView)) {
            this.measureChildConstrained((View)this.mNavButtonView, n2, 0, n3, 0, this.mMaxButtonHeight);
            n8 = this.mNavButtonView.getMeasuredWidth() + this.getHorizontalMargins((View)this.mNavButtonView);
            n6 = Math.max(0, this.mNavButtonView.getMeasuredHeight() + this.getVerticalMargins((View)this.mNavButtonView));
            n7 = ViewUtils.combineMeasuredStates(0, ViewCompat.getMeasuredState((View)this.mNavButtonView));
        }
        int n9 = n8;
        int n10 = n7;
        n8 = n6;
        if (this.shouldLayout((View)this.mCollapseButtonView)) {
            this.measureChildConstrained((View)this.mCollapseButtonView, n2, 0, n3, 0, this.mMaxButtonHeight);
            n9 = this.mCollapseButtonView.getMeasuredWidth() + this.getHorizontalMargins((View)this.mCollapseButtonView);
            n8 = Math.max(n6, this.mCollapseButtonView.getMeasuredHeight() + this.getVerticalMargins((View)this.mCollapseButtonView));
            n10 = ViewUtils.combineMeasuredStates(n7, ViewCompat.getMeasuredState((View)this.mCollapseButtonView));
        }
        n7 = this.getContentInsetStart();
        int n11 = 0 + Math.max(n7, n9);
        nArray[n4] = Math.max(0, n7 - n9);
        n4 = 0;
        n6 = n10;
        n7 = n8;
        if (this.shouldLayout((View)this.mMenuView)) {
            this.measureChildConstrained((View)this.mMenuView, n2, n11, n3, 0, this.mMaxButtonHeight);
            n4 = this.mMenuView.getMeasuredWidth() + this.getHorizontalMargins((View)this.mMenuView);
            n7 = Math.max(n8, this.mMenuView.getMeasuredHeight() + this.getVerticalMargins((View)this.mMenuView));
            n6 = ViewUtils.combineMeasuredStates(n10, ViewCompat.getMeasuredState((View)this.mMenuView));
        }
        n8 = this.getContentInsetEnd();
        n9 = n11 + Math.max(n8, n4);
        nArray[n5] = Math.max(0, n8 - n4);
        n4 = n9;
        n10 = n6;
        n8 = n7;
        if (this.shouldLayout(this.mExpandedActionView)) {
            n4 = n9 + this.measureChildCollapseMargins(this.mExpandedActionView, n2, n9, n3, 0, nArray);
            n8 = Math.max(n7, this.mExpandedActionView.getMeasuredHeight() + this.getVerticalMargins(this.mExpandedActionView));
            n10 = ViewUtils.combineMeasuredStates(n6, ViewCompat.getMeasuredState(this.mExpandedActionView));
        }
        n7 = n4;
        n5 = n10;
        n6 = n8;
        if (this.shouldLayout((View)this.mLogoView)) {
            n7 = n4 + this.measureChildCollapseMargins((View)this.mLogoView, n2, n4, n3, 0, nArray);
            n6 = Math.max(n8, this.mLogoView.getMeasuredHeight() + this.getVerticalMargins((View)this.mLogoView));
            n5 = ViewUtils.combineMeasuredStates(n10, ViewCompat.getMeasuredState((View)this.mLogoView));
        }
        n9 = this.getChildCount();
        n4 = 0;
        n10 = n6;
        n8 = n5;
        n6 = n4;
        n4 = n7;
        while (true) {
            block13: {
                block15: {
                    block14: {
                        if (n6 >= n9) break block14;
                        View view = this.getChildAt(n6);
                        if ((view.getLayoutParams()).mViewType != 0) break block15;
                        if (!this.shouldLayout(view)) {
                            n7 = n8;
                            n8 = n10;
                            n10 = n7;
                            break block13;
                        } else {
                            n4 += this.measureChildCollapseMargins(view, n2, n4, n3, 0, nArray);
                            n7 = Math.max(n10, view.getMeasuredHeight() + this.getVerticalMargins(view));
                            n10 = ViewUtils.combineMeasuredStates(n8, ViewCompat.getMeasuredState(view));
                            n8 = n7;
                        }
                        break block13;
                    }
                    n5 = 0;
                    n6 = 0;
                    int n12 = this.mTitleMarginTop + this.mTitleMarginBottom;
                    int n13 = this.mTitleMarginStart + this.mTitleMarginEnd;
                    n7 = n8;
                    if (this.shouldLayout((View)this.mTitleTextView)) {
                        this.measureChildCollapseMargins((View)this.mTitleTextView, n2, n4 + n13, n3, n12, nArray);
                        n7 = this.mTitleTextView.getMeasuredWidth();
                        n5 = this.getHorizontalMargins((View)this.mTitleTextView) + n7;
                        n6 = this.mTitleTextView.getMeasuredHeight() + this.getVerticalMargins((View)this.mTitleTextView);
                        n7 = ViewUtils.combineMeasuredStates(n8, ViewCompat.getMeasuredState((View)this.mTitleTextView));
                    }
                    n11 = n6;
                    n9 = n5;
                    n8 = n7;
                    if (this.shouldLayout((View)this.mSubtitleTextView)) {
                        n9 = Math.max(n5, this.measureChildCollapseMargins((View)this.mSubtitleTextView, n2, n4 + n13, n3, n12 + n6, nArray));
                        n11 = n6 + (this.mSubtitleTextView.getMeasuredHeight() + this.getVerticalMargins((View)this.mSubtitleTextView));
                        n8 = ViewUtils.combineMeasuredStates(n7, ViewCompat.getMeasuredState((View)this.mSubtitleTextView));
                    }
                    n7 = Math.max(n10, n11);
                    n11 = this.getPaddingLeft();
                    n5 = this.getPaddingRight();
                    n10 = this.getPaddingTop();
                    n6 = this.getPaddingBottom();
                    n5 = ViewCompat.resolveSizeAndState(Math.max(n9 + n4 + (n11 + n5), this.getSuggestedMinimumWidth()), n2, 0xFF000000 & n8);
                    n2 = ViewCompat.resolveSizeAndState(Math.max(n7 + (n10 + n6), this.getSuggestedMinimumHeight()), n3, n8 << 16);
                    if (this.shouldCollapse()) {
                        n2 = 0;
                    }
                    this.setMeasuredDimension(n5, n2);
                    return;
                }
                n7 = n8;
                n8 = n10;
                n10 = n7;
            }
            ++n6;
            n7 = n8;
            n8 = n10;
            n10 = n7;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        SavedState savedState = object;
        super.onRestoreInstanceState(savedState.getSuperState());
        object = this.mMenuView != null ? this.mMenuView.peekMenu() : null;
        if (savedState.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && object != null && (object = object.findItem(savedState.expandedMenuItemId)) != null) {
            MenuItemCompat.expandActionView((MenuItem)object);
        }
        if (!savedState.isOverflowOpen) return;
        this.postShowOverflowMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onRtlPropertiesChanged(int n2) {
        boolean bl2 = true;
        if (Build.VERSION.SDK_INT >= 17) {
            super.onRtlPropertiesChanged(n2);
        }
        RtlSpacingHelper rtlSpacingHelper = this.mContentInsets;
        if (n2 != 1) {
            bl2 = false;
        }
        rtlSpacingHelper.setDirection(bl2);
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new /* Unavailable Anonymous Inner Class!! */;
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            savedState.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        savedState.isOverflowOpen = this.isOverflowMenuShowing();
        return savedState;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = MotionEventCompat.getActionMasked(motionEvent);
        if (n2 == 0) {
            this.mEatingTouch = false;
        }
        if (!this.mEatingTouch) {
            boolean bl2 = super.onTouchEvent(motionEvent);
            if (n2 == 0 && !bl2) {
                this.mEatingTouch = true;
            }
        }
        if (n2 == 1 || n2 == 3) {
            this.mEatingTouch = false;
        }
        return true;
    }

    void removeChildrenForExpandedActionView() {
        for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
            View view = this.getChildAt(i2);
            if ((view.getLayoutParams()).mViewType == 2 || view == this.mMenuView) continue;
            this.removeViewAt(i2);
            this.mHiddenViews.add(view);
        }
    }

    public void setCollapsible(boolean bl2) {
        this.mCollapsible = bl2;
        this.requestLayout();
    }

    public void setContentInsetsAbsolute(int n2, int n3) {
        this.mContentInsets.setAbsolute(n2, n3);
    }

    public void setContentInsetsRelative(int n2, int n3) {
        this.mContentInsets.setRelative(n2, n3);
    }

    public void setLogo(@DrawableRes int n2) {
        this.setLogo(this.mDrawableManager.getDrawable(this.getContext(), n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLogo(Drawable drawable2) {
        if (drawable2 != null) {
            this.ensureLogoView();
            if (!this.isChildOrHidden((View)this.mLogoView)) {
                this.addSystemView((View)this.mLogoView, true);
            }
        } else if (this.mLogoView != null && this.isChildOrHidden((View)this.mLogoView)) {
            this.removeView((View)this.mLogoView);
            this.mHiddenViews.remove(this.mLogoView);
        }
        if (this.mLogoView != null) {
            this.mLogoView.setImageDrawable(drawable2);
        }
    }

    public void setLogoDescription(@StringRes int n2) {
        this.setLogoDescription(this.getContext().getText(n2));
    }

    public void setLogoDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            this.ensureLogoView();
        }
        if (this.mLogoView != null) {
            this.mLogoView.setContentDescription(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMenu(MenuBuilder menuBuilder, ActionMenuPresenter actionMenuPresenter) {
        if (menuBuilder == null && this.mMenuView == null) {
            return;
        }
        this.ensureMenuView();
        MenuBuilder menuBuilder2 = this.mMenuView.peekMenu();
        if (menuBuilder2 == menuBuilder) return;
        if (menuBuilder2 != null) {
            menuBuilder2.removeMenuPresenter((MenuPresenter)this.mOuterActionMenuPresenter);
            menuBuilder2.removeMenuPresenter((MenuPresenter)this.mExpandedMenuPresenter);
        }
        if (this.mExpandedMenuPresenter == null) {
            this.mExpandedMenuPresenter = new /* Unavailable Anonymous Inner Class!! */;
        }
        actionMenuPresenter.setExpandedActionViewsExclusive(true);
        if (menuBuilder != null) {
            menuBuilder.addMenuPresenter((MenuPresenter)actionMenuPresenter, this.mPopupContext);
            menuBuilder.addMenuPresenter((MenuPresenter)this.mExpandedMenuPresenter, this.mPopupContext);
        } else {
            actionMenuPresenter.initForMenu(this.mPopupContext, null);
            this.mExpandedMenuPresenter.initForMenu(this.mPopupContext, null);
            actionMenuPresenter.updateMenuView(true);
            this.mExpandedMenuPresenter.updateMenuView(true);
        }
        this.mMenuView.setPopupTheme(this.mPopupTheme);
        this.mMenuView.setPresenter(actionMenuPresenter);
        this.mOuterActionMenuPresenter = actionMenuPresenter;
    }

    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        this.mActionMenuPresenterCallback = callback;
        this.mMenuBuilderCallback = callback2;
        if (this.mMenuView != null) {
            this.mMenuView.setMenuCallbacks(callback, callback2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationContentDescription(@StringRes int n2) {
        CharSequence charSequence = n2 != 0 ? this.getContext().getText(n2) : null;
        this.setNavigationContentDescription(charSequence);
    }

    public void setNavigationContentDescription(@Nullable CharSequence charSequence) {
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            this.ensureNavButtonView();
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setContentDescription(charSequence);
        }
    }

    public void setNavigationIcon(@DrawableRes int n2) {
        this.setNavigationIcon(this.mDrawableManager.getDrawable(this.getContext(), n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationIcon(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            this.ensureNavButtonView();
            if (!this.isChildOrHidden((View)this.mNavButtonView)) {
                this.addSystemView((View)this.mNavButtonView, true);
            }
        } else if (this.mNavButtonView != null && this.isChildOrHidden((View)this.mNavButtonView)) {
            this.removeView((View)this.mNavButtonView);
            this.mHiddenViews.remove(this.mNavButtonView);
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setImageDrawable(drawable2);
        }
    }

    public void setNavigationOnClickListener(View.OnClickListener onClickListener) {
        this.ensureNavButtonView();
        this.mNavButtonView.setOnClickListener(onClickListener);
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setOverflowIcon(@Nullable Drawable drawable2) {
        this.ensureMenu();
        this.mMenuView.setOverflowIcon(drawable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPopupTheme(@StyleRes int n2) {
        block4: {
            block3: {
                if (this.mPopupTheme == n2) break block3;
                this.mPopupTheme = n2;
                if (n2 != 0) break block4;
                this.mPopupContext = this.getContext();
            }
            return;
        }
        this.mPopupContext = new ContextThemeWrapper(this.getContext(), n2);
    }

    public void setSubtitle(@StringRes int n2) {
        this.setSubtitle(this.getContext().getText(n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSubtitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            if (this.mSubtitleTextView == null) {
                Context context = this.getContext();
                this.mSubtitleTextView = new TextView(context);
                this.mSubtitleTextView.setSingleLine();
                this.mSubtitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mSubtitleTextAppearance != 0) {
                    this.mSubtitleTextView.setTextAppearance(context, this.mSubtitleTextAppearance);
                }
                if (this.mSubtitleTextColor != 0) {
                    this.mSubtitleTextView.setTextColor(this.mSubtitleTextColor);
                }
            }
            if (!this.isChildOrHidden((View)this.mSubtitleTextView)) {
                this.addSystemView((View)this.mSubtitleTextView, true);
            }
        } else if (this.mSubtitleTextView != null && this.isChildOrHidden((View)this.mSubtitleTextView)) {
            this.removeView((View)this.mSubtitleTextView);
            this.mHiddenViews.remove(this.mSubtitleTextView);
        }
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setText(charSequence);
        }
        this.mSubtitleText = charSequence;
    }

    public void setSubtitleTextAppearance(Context context, @StyleRes int n2) {
        this.mSubtitleTextAppearance = n2;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextAppearance(context, n2);
        }
    }

    public void setSubtitleTextColor(@ColorInt int n2) {
        this.mSubtitleTextColor = n2;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextColor(n2);
        }
    }

    public void setTitle(@StringRes int n2) {
        this.setTitle(this.getContext().getText(n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            if (this.mTitleTextView == null) {
                Context context = this.getContext();
                this.mTitleTextView = new TextView(context);
                this.mTitleTextView.setSingleLine();
                this.mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mTitleTextAppearance != 0) {
                    this.mTitleTextView.setTextAppearance(context, this.mTitleTextAppearance);
                }
                if (this.mTitleTextColor != 0) {
                    this.mTitleTextView.setTextColor(this.mTitleTextColor);
                }
            }
            if (!this.isChildOrHidden((View)this.mTitleTextView)) {
                this.addSystemView((View)this.mTitleTextView, true);
            }
        } else if (this.mTitleTextView != null && this.isChildOrHidden((View)this.mTitleTextView)) {
            this.removeView((View)this.mTitleTextView);
            this.mHiddenViews.remove(this.mTitleTextView);
        }
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setText(charSequence);
        }
        this.mTitleText = charSequence;
    }

    public void setTitleTextAppearance(Context context, @StyleRes int n2) {
        this.mTitleTextAppearance = n2;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextAppearance(context, n2);
        }
    }

    public void setTitleTextColor(@ColorInt int n2) {
        this.mTitleTextColor = n2;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextColor(n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showOverflowMenu() {
        if (this.mMenuView == null) return false;
        if (!this.mMenuView.showOverflowMenu()) return false;
        return true;
    }
}

