/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.dragback;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import com.android.gmacs.dragback.ParallaxBackLayout;
import java.util.Stack;

public class ParallaxBackActivityHelper {
    private static final Stack<ParallaxBackActivityHelper> sActivities = new Stack();
    private Activity mActivity;
    private ParallaxBackLayout mParallaxBackLayout;

    public ParallaxBackActivityHelper(Activity activity) {
        this.mActivity = activity;
        this.mParallaxBackLayout = new ParallaxBackLayout((Context)this.mActivity);
        sActivities.push(this);
    }

    public static void finishAllExceptPeek() {
        for (int i2 = 0; i2 < sActivities.size() - 1; ++i2) {
            ((ParallaxBackActivityHelper)sActivities.get(i2)).getActivity().finish();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Activity getPeakActivity() {
        if (sActivities.isEmpty()) return null;
        return sActivities.peek().getActivity();
    }

    public void drawThumb(Canvas canvas) {
        this.getBackLayout().getContentView().draw(canvas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View findViewById(int n2) {
        if (this.mParallaxBackLayout == null) return null;
        return this.mParallaxBackLayout.findViewById(n2);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public ParallaxBackLayout getBackLayout() {
        return this.mParallaxBackLayout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParallaxBackActivityHelper getSecondActivity() {
        if (sActivities.size() < 2) return null;
        return (ParallaxBackActivityHelper)sActivities.elementAt(sActivities.size() - 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSecondActivity() {
        if (sActivities.size() < 2) return false;
        return true;
    }

    public void onActivityDestroy() {
        sActivities.remove(this);
    }

    public void onPostCreate() {
        this.mParallaxBackLayout.attachToActivity(this);
    }

    public void scrollToFinishActivity() {
        this.getBackLayout().scrollToFinishActivity();
    }

    public void setBackEnable(boolean bl2) {
        this.getBackLayout().setEnableGesture(bl2);
    }
}

