/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.adapter.ConversationListAdapter;
import com.android.gmacs.event.RecentTalksEvent;
import com.android.gmacs.fragment.BaseFragment;
import com.android.gmacs.fragment.ConversationListFragment;
import com.android.gmacs.view.GmacsDialog;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.parse.talk.Talk;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsUiUtil;
import com.common.gmacs.utils.NetworkUtil;
import com.ganji.android.comp.a.a;
import com.ganji.android.comp.utils.o;
import java.util.ArrayList;
import java.util.Collection;
import org.greenrobot.eventbus.ThreadMode;
import org.greenrobot.eventbus.j;

public class ConversationListFragment
extends BaseFragment
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
ClientManager.ConnectListener {
    private boolean isBackground;
    protected LinearLayout mConnectionStatusHeaderView;
    private LinearLayout mConnectionStatusHeaderViewContainer;
    protected ImageView mConnectionStatusImageView;
    protected TextView mConnectionStatusTextView;
    private LinearLayout mHeaderView;
    private LinearLayout mHiddenView;
    protected ListView mListView;
    private ConversationListAdapter mTalkAdapter;
    protected LinearLayout mTalkListEmptyPromptView;
    protected ArrayList<Talk> mTalks = new ArrayList();

    @NonNull
    private GmacsUserInfo createGmacsUserInfo(Talk talk) {
        GmacsUserInfo gmacsUserInfo = new GmacsUserInfo();
        gmacsUserInfo.userId = talk.mTalkOtherUserId;
        gmacsUserInfo.userName = talk.mTalkOtherUserName;
        gmacsUserInfo.nickName = talk.mTalkOtherUserName;
        gmacsUserInfo.avatar = talk.mTalkOtherUserAvatar;
        gmacsUserInfo.userSource = talk.mTalkOtherUserSource;
        return gmacsUserInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void specialTalksPreparedWrapper(boolean bl2) {
        this.mListView.getLayoutParams().height = bl2 ? -2 : -1;
        this.mListView.requestLayout();
    }

    @Override
    public void connectStatusChanged(int n2) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread((Runnable)new 2(this, n2));
        }
    }

    @Override
    public void connectionTokenInvalid(String string2) {
    }

    protected LinearLayout getHeaderView() {
        return this.mHeaderView;
    }

    protected LinearLayout getHiddenView() {
        return this.mHiddenView;
    }

    @Override
    protected void initData() {
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
    }

    @Override
    protected void initView() {
        this.mListView = (ListView)this.getView().findViewById(R.id.lv_conversation_list);
        this.mTalkListEmptyPromptView = (LinearLayout)this.getView().findViewById(R.id.ll_conversation_list_empty_prompt);
        this.mHiddenView = (LinearLayout)this.getView().findViewById(R.id.ll_conversation_hiddenview);
        this.mHeaderView = new LinearLayout((Context)this.getActivity());
        this.mHeaderView.setOrientation(1);
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
        ClientManager.getInstance().regConnectListener(this);
        if (this.showDisconnectedHeader()) {
            this.mConnectionStatusHeaderViewContainer = new LinearLayout((Context)this.getActivity());
            this.mConnectionStatusHeaderViewContainer.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
            this.mConnectionStatusHeaderView = (LinearLayout)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.gmacs_conversation_connection_status_header, (ViewGroup)this.mConnectionStatusHeaderViewContainer, false);
            this.mConnectionStatusTextView = (TextView)this.mConnectionStatusHeaderView.findViewById(R.id.gmacs_connection_status_text);
            this.mConnectionStatusImageView = (ImageView)this.mConnectionStatusHeaderView.findViewById(R.id.gmacs_connection_status_img);
            this.mConnectionStatusHeaderViewContainer.addView((View)this.mConnectionStatusHeaderView);
            this.showOrHideDisconnectHeader(ClientManager.getInstance().getConnectionStatus());
        }
        if (this.mConnectionStatusHeaderViewContainer != null) {
            this.mListView.addHeaderView((View)this.mConnectionStatusHeaderViewContainer);
        }
        this.mListView.addHeaderView((View)this.mHeaderView);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.setContentView(R.layout.gmacs_conversation_list);
        return super.onCreateView(layoutInflater, viewGroup, bundle);
    }

    @Override
    public void onDestroy() {
        ClientManager.getInstance().unRegConnectListener(this);
        super.onDestroy();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void onItemClick(AdapterView<?> object, View object2, int n2, long l2) {
        void var3_4;
        if ((var3_4 -= this.mListView.getHeaderViewsCount()) < 0) return;
        if (var3_4 >= this.mTalks.size()) {
            return;
        }
        Talk talk = this.mTalks.get((int)var3_4);
        if (this.onItemClickDelegate(talk)) return;
        Message.MessageUserInfo messageUserInfo = talk.getmLastMessage().getTalkOtherUserInfo();
        if (messageUserInfo == null) return;
        if (messageUserInfo.gmacsUserInfo == null) {
            messageUserInfo.gmacsUserInfo = this.createGmacsUserInfo(talk);
        } else {
            GmacsUserInfo gmacsUserInfo = messageUserInfo.gmacsUserInfo;
            if (o.i(gmacsUserInfo.userName)) {
                gmacsUserInfo.userName = talk.mTalkOtherUserName;
            }
            if (o.i(gmacsUserInfo.nickName)) {
                gmacsUserInfo.userName = talk.mTalkOtherUserName;
            }
        }
        this.startActivity(new Intent(GmacsUiUtil.createToChatActivity((Context)this.getActivity(), "", messageUserInfo)));
        if ("100".equals(talk.mTalkOtherUserId)) {
            a.a("100000002671000500000001", "gc", "/im/-/-/-/1012");
            return;
        }
        a.a("100000002671000700000001", "gc", "/im/-/-/-/1011");
    }

    protected boolean onItemClickDelegate(Talk talk) {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean onItemLongClick(AdapterView<?> object, View object2, int n2, long l2) {
        void var3_4;
        GmacsDialog.Builder builder = new GmacsDialog.Builder((Context)this.getActivity(), 1);
        if ((var3_4 -= this.mListView.getHeaderViewsCount()) < 0) return false;
        if (var3_4 >= this.mTalks.size()) {
            return false;
        }
        Talk talk = this.mTalks.get((int)var3_4);
        if (talk.mNoReadMsgCount > 0) {
            builder.setListTexts(new String[]{this.getString(R.string.mark_as_read), this.getString(R.string.delete_talk)});
        } else {
            builder.setListTexts(new String[]{this.getString(R.string.delete_talk)});
        }
        builder.initDialog((AdapterView.OnItemClickListener)new 1(this, talk, builder)).create().show();
        return true;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.isBackground = false;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.isBackground = true;
    }

    @j(a=ThreadMode.MAIN)
    public void onTalkListChanged(RecentTalksEvent object) {
        boolean bl2 = false;
        object = object.getTalks();
        this.mTalks.clear();
        if (object != null) {
            this.mTalks.addAll((Collection<Talk>)object);
        }
        if (this.mTalkAdapter != null) {
            if (this.isBackground) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.mListView.getChildCount() && this.mListView.getChildAt(n2).getTag() == null; ++n2) {
                    ++n3;
                }
                int n4 = this.mListView.getLastVisiblePosition();
                int n5 = this.mListView.getHeaderViewsCount();
                int n6 = this.mListView.getFooterViewsCount();
                for (n2 = this.mListView.getFirstVisiblePosition() - this.mListView.getHeaderViewsCount() + n3; n2 <= n4 - n5 - n6 && n2 <= this.mTalks.size() - 1 && n3 < this.mListView.getChildCount(); ++n2, ++n3) {
                    this.mTalkAdapter.getView(n2, this.mListView.getChildAt(n3), null);
                }
            } else {
                this.mTalkAdapter.notifyDataSetChanged();
            }
        }
        GLog.d(this.TAG, "talks.size=" + this.mTalks.size());
        if (this.mTalks.size() == 0) {
            bl2 = true;
        }
        this.specialTalksPreparedWrapper(bl2);
    }

    protected void setAdapter(ConversationListAdapter conversationListAdapter) {
        this.mTalkAdapter = conversationListAdapter;
        this.mListView.setAdapter((ListAdapter)this.mTalkAdapter);
    }

    protected boolean showDisconnectedHeader() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void showOrHideDisconnectHeader(int n2) {
        if (this.mConnectionStatusHeaderViewContainer == null) {
            return;
        }
        switch (n2) {
            default: {
                this.mConnectionStatusHeaderView.setVisibility(0);
                if (NetworkUtil.isNetworkAvailable()) {
                    this.mConnectionStatusTextView.setText(R.string.connection_status_disconnected);
                    return;
                }
                this.mConnectionStatusTextView.setText(R.string.network_unavailable);
                return;
            }
            case 1: {
                this.mConnectionStatusHeaderView.setVisibility(0);
                this.mConnectionStatusTextView.setText(R.string.connection_status_connecting);
                return;
            }
            case 2: {
                this.mConnectionStatusHeaderView.setVisibility(0);
                this.mConnectionStatusTextView.setText(R.string.connection_status_connecting);
                return;
            }
            case 3: {
                this.mConnectionStatusHeaderView.setVisibility(8);
                return;
            }
            case 4: 
        }
        this.mConnectionStatusHeaderView.setVisibility(0);
        this.mConnectionStatusTextView.setText(R.string.connection_status_kickedoff);
    }
}

