/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.msg.view;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.gmacs.activity.GmacsChatActivity;
import com.android.gmacs.adapter.GmacsChatAdapter;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.utils.GLog;

public abstract class IMMessageView
implements View.OnClickListener {
    protected String TAG = this.getClass().getSimpleName();
    protected GmacsChatAdapter mAdapter;
    protected GmacsChatActivity mChatActivity;
    protected View mContentView;
    private IMMessage mIMMsg;
    IMMsgClickListener mMsgClickListener;
    protected int mPosition;

    public View createIMView(IMMessage iMMessage, ViewGroup viewGroup, LayoutInflater layoutInflater, int n2, GmacsChatAdapter gmacsChatAdapter, GmacsChatActivity gmacsChatActivity) {
        this.init(n2, gmacsChatAdapter, gmacsChatActivity, iMMessage);
        viewGroup.addView(this.initView(layoutInflater));
        this.mContentView.setTag((Object)this);
        return this.mContentView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteIMMessageView() {
        if (this.mIMMsg == null) {
            return;
        }
        GLog.d("mIMMsg----", this.mIMMsg + "");
        this.mAdapter.deleteMsg(this.mPosition);
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void init(int n2, GmacsChatAdapter gmacsChatAdapter, GmacsChatActivity gmacsChatActivity, IMMessage iMMessage) {
        this.mAdapter = gmacsChatAdapter;
        this.mChatActivity = gmacsChatActivity;
        this.mPosition = n2;
        this.mIMMsg = iMMessage;
        this.setIMMessage(iMMessage);
    }

    protected View initView(LayoutInflater layoutInflater) {
        return this.mContentView;
    }

    public void onClick(View view) {
        if (this.mMsgClickListener != null) {
            this.mMsgClickListener.onIMMsgClick(view, this.mIMMsg);
        }
    }

    public void setDataForView() {
    }

    protected abstract void setIMMessage(IMMessage var1);

    public void setMsgClickListener(IMMsgClickListener iMMsgClickListener) {
        this.mMsgClickListener = iMMsgClickListener;
    }

    public static interface IMMsgClickListener {
        public void onIMMsgClick(View var1, IMMessage var2);
    }
}

