/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.sound;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.AnimationDrawable;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.sound.SoundRecord;
import com.common.gmacs.utils.FileUtil;
import com.common.gmacs.utils.ToastUtil;
import java.io.File;

public class SoundRecord {
    private static final int MIN_RECORD_DURATION = 1;
    private final int ONE_MINUTE;
    private RecordListener currentListener;
    private int duration;
    private boolean isRecordTimeOut;
    private boolean isRecording;
    private boolean isSuccessRecord;
    boolean isTryCancelRecord;
    private RecordSoundAnimation recordSoundDialog;
    private int recordTime = 60;
    private MediaRecorder recorder;
    private String resultFilePath;
    private String soundFilePath = FileUtil.getCacheDir("record").getAbsolutePath();
    private long startTime;
    private UpdateTime update;

    public SoundRecord() {
        this.ONE_MINUTE = 60;
    }

    static /* synthetic */ boolean access$602(SoundRecord soundRecord, boolean bl2) {
        soundRecord.isRecordTimeOut = bl2;
        return bl2;
    }

    static /* synthetic */ int access$710(SoundRecord soundRecord) {
        int n2 = soundRecord.recordTime;
        soundRecord.recordTime = n2 - 1;
        return n2;
    }

    private void endTime() {
        if (this.update != null) {
            UpdateTime.access$302(this.update, true);
            this.update = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void release() {
        if (this.recorder == null) return;
        try {
            this.recorder.stop();
            this.recorder.release();
            this.recorder = null;
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void startUpTime() {
        this.startTime = System.currentTimeMillis();
        this.update = new UpdateTime();
        this.recordTime = 60;
        this.update.start();
    }

    public int getDuration() {
        return this.duration;
    }

    public String getSoundFilePath() {
        return this.resultFilePath;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public boolean isUserCancelRecord() {
        return this.isTryCancelRecord;
    }

    void showRecordingView() {
        if (this.recordSoundDialog != null && this.recordSoundDialog.recordingView.getVisibility() == 8) {
            this.recordSoundDialog.cancelRecordView.setVisibility(8);
            this.recordSoundDialog.recordingView.setVisibility(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startRecord(Context context, boolean bl2, RecordListener object) {
        boolean bl3 = false;
        if (!FileUtil.sdcardAvailable()) {
            ToastUtil.showToast(context.getResources().getString(R.string.sdcard_not_exist));
            return bl3;
        }
        File file = new File(this.soundFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.currentListener = object;
        this.isRecording = true;
        this.isTryCancelRecord = false;
        this.resultFilePath = file.getAbsolutePath() + "/" + System.currentTimeMillis() + ".amr";
        this.recorder = new MediaRecorder();
        this.recorder.setAudioSource(1);
        this.recorder.setOutputFormat(3);
        this.recorder.setAudioEncoder(1);
        this.recorder.setOutputFile(this.resultFilePath);
        try {
            this.recorder.prepare();
            this.recorder.start();
            if (bl2) {
                RecordSoundAnimation recordSoundAnimation;
                this.recordSoundDialog = recordSoundAnimation = new RecordSoundAnimation(context, R.style.publish_btn_dialog);
                this.recordSoundDialog.show();
            }
            this.startUpTime();
            this.isSuccessRecord = true;
            return true;
        }
        catch (Throwable throwable) {
            this.isSuccessRecord = false;
            this.isRecording = false;
            ToastUtil.showToast(context.getText(R.string.record_failed));
            return bl3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopRecord() {
        this.isRecording = false;
        if (this.recorder == null) {
            return;
        }
        if (!this.isSuccessRecord) {
            this.release();
            return;
        }
        try {
            this.endTime();
            if (!this.isRecordTimeOut) {
                this.duration = (int)(System.currentTimeMillis() - this.startTime) / 1000;
            } else {
                this.duration = 60;
                if (this.recordSoundDialog != null) {
                    this.recordSoundDialog.showFailedRecordHint(R.string.record_time_too_longer);
                }
            }
            this.release();
            if (this.isTryCancelRecord) {
                if (this.recordSoundDialog == null) return;
                this.recordSoundDialog.dismiss();
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.recordSoundDialog == null) return;
            this.recordSoundDialog.handler.post(new Runnable(){

                @Override
                public void run() {
                    ToastUtil.showToast(String.format(SoundRecord.this.recordSoundDialog.getContext().getString(R.string.record_failed_err_msg), throwable.getMessage()));
                }
            });
            return;
        }
        if (this.duration < 1) {
            File file;
            if (this.recordSoundDialog != null) {
                this.recordSoundDialog.showFailedRecordHint(R.string.record_time_too_shorter);
            }
            if (this.currentListener != null) {
                this.currentListener.onFailedRecord();
            }
            if ((file = new File(this.resultFilePath)).exists()) {
                file.delete();
            }
            this.resultFilePath = null;
            return;
        }
        File file = new File(this.resultFilePath);
        if (file.length() <= 94L) {
            if (this.recordSoundDialog != null) {
                this.recordSoundDialog.showFailedRecordHint(R.string.record_error_permission_denied);
            }
            if (this.currentListener != null) {
                this.currentListener.onFailedRecord();
            }
            this.resultFilePath = null;
            return;
        }
        if (this.duration != 60) {
            this.duration = 60 - this.recordTime;
        }
        if (this.recordSoundDialog != null && !this.isRecordTimeOut) {
            this.recordSoundDialog.dismiss();
        }
        this.currentListener.onSuccessRecord(this.resultFilePath, this.duration);
    }

    void tellUserHowCancelRecord() {
        if (this.recordSoundDialog != null && this.recordSoundDialog.cancelRecordView.getVisibility() == 8) {
            this.recordSoundDialog.cancelRecordView.setVisibility(0);
            this.recordSoundDialog.recordingView.setVisibility(8);
        }
    }

    public static interface RecordListener {
        public void onFailedRecord();

        public void onSuccessRecord(String var1, int var2);
    }

    private class RecordSoundAnimation
    extends AlertDialog
    implements DialogInterface.OnShowListener {
        private AnimationDrawable anim;
        private View cancelRecordView;
        private Runnable dissDialog;
        private View failedRecordView;
        private Handler handler;
        private TextView recordCountdownView;
        private TextView recordHint;
        private ImageView recording;
        private View recordingView;

        protected RecordSoundAnimation(Context context) {
            super(context);
            this.handler = new 1(this);
            this.dissDialog = new 2(this);
            this.setCanceledOnTouchOutside(false);
            this.setCancelable(false);
        }

        RecordSoundAnimation(Context context, int n2) {
            super(context, n2);
            this.handler = new 1(this);
            this.dissDialog = new 2(this);
            this.setCanceledOnTouchOutside(false);
            this.setCancelable(false);
        }

        static /* synthetic */ View access$1000(RecordSoundAnimation recordSoundAnimation) {
            return recordSoundAnimation.failedRecordView;
        }

        static /* synthetic */ AnimationDrawable access$1100(RecordSoundAnimation recordSoundAnimation) {
            return recordSoundAnimation.anim;
        }

        static /* synthetic */ TextView access$1200(RecordSoundAnimation recordSoundAnimation) {
            return recordSoundAnimation.recordHint;
        }

        static /* synthetic */ TextView access$800(RecordSoundAnimation recordSoundAnimation) {
            return recordSoundAnimation.recordCountdownView;
        }

        static /* synthetic */ ImageView access$900(RecordSoundAnimation recordSoundAnimation) {
            return recordSoundAnimation.recording;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void dismiss() {
            try {
                if (this.isShowing()) {
                    super.dismiss();
                }
                this.handler.removeCallbacks(this.dissDialog);
                if (this.isShowing() && this.anim != null) {
                    this.anim.stop();
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        public void hide() {
            super.hide();
        }

        protected void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.setContentView(R.layout.gmacs_layout_record_sound);
            this.setOnShowListener(this);
            this.recordHint = (TextView)this.findViewById(R.id.record_time);
            this.recording = (ImageView)this.findViewById(R.id.recordImg);
            this.recordingView = this.findViewById(R.id.recording);
            this.cancelRecordView = this.findViewById(R.id.cancel_record);
            this.failedRecordView = this.findViewById(R.id.failed_record_hint);
            this.recordCountdownView = (TextView)this.findViewById(R.id.record_countdown);
        }

        public void onShow(DialogInterface dialogInterface) {
            this.anim = (AnimationDrawable)this.recording.getBackground();
            this.anim.stop();
            this.anim.start();
        }

        public void show() {
            super.show();
            this.recordHint.setVisibility(0);
            this.recordingView.setVisibility(0);
            this.cancelRecordView.setVisibility(8);
            this.recordCountdownView.setVisibility(8);
            this.failedRecordView.setVisibility(8);
            this.recording.setVisibility(0);
            this.recordHint.setText(R.string.record_slide_up_to_cancel);
        }

        void showFailedRecordHint(int n2) {
            this.handler.post((Runnable)new 3(this, n2));
            this.handler.postDelayed(this.dissDialog, 1500L);
        }
    }

    private class UpdateTime
    extends Thread {
        private volatile boolean isStop = false;

        private UpdateTime() {
        }

        static /* synthetic */ boolean access$302(UpdateTime updateTime, boolean bl2) {
            updateTime.isStop = bl2;
            return bl2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SoundRecord.access$602(SoundRecord.this, false);
            while (!this.isStop) {
                if (SoundRecord.this.recordSoundDialog != null) {
                    SoundRecord.this.recordSoundDialog.handler.obtainMessage().sendToTarget();
                }
                if (SoundRecord.this.recordTime == 0) {
                    SoundRecord.access$602(SoundRecord.this, true);
                    this.isStop = true;
                    SoundRecord.this.stopRecord();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                SoundRecord.access$710(SoundRecord.this);
            }
            return;
        }
    }
}

