/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.view.FastScrollView;
import com.android.gmacs.view.GmacsDialog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;

public class GmacsDialog
extends Dialog {
    private GmacsDialog(Context context) {
        super(context);
    }

    private GmacsDialog(Context context, int n2) {
        super(context, n2);
    }

    private GmacsDialog(Context context, boolean bl2, DialogInterface.OnCancelListener onCancelListener) {
        super(context, bl2, onCancelListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void post(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        if (this.getWindow() == null) return;
        View view = this.getWindow().getDecorView();
        if (view == null) return;
        view.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    public static class Builder {
        public static final int DIALOG_TYPE_CUSTOM_CONTENT_VIEW = 5;
        public static final int DIALOG_TYPE_LIST_NO_BUTTON = 1;
        public static final int DIALOG_TYPE_TEXT_NEG_POS_BUTTON = 3;
        public static final int DIALOG_TYPE_TEXT_NEU_BUTTON = 2;
        public static final int DIALOG_TYPE_TEXT_PROGRESSBAR_NO_BUTTON = 4;
        private boolean cancelable = true;
        private LinearLayout mBtnLayout;
        private View mContentView;
        private Context mContext;
        private GmacsDialog mDialog;
        private int mDialogStyle;
        private int mDialogType;
        private LinearLayout mLayout;
        private CharSequence[] mListTexts;
        private ListView mListView;
        private LinearLayout mMessageLayout;
        private TextView mMsg;
        private FastScrollView mMsgScrollView;
        private View.OnClickListener mNegBtnListener;
        private View.OnClickListener mNeuBtnListener;
        private DialogInterface.OnCancelListener mOnCancelListener;
        private AdapterView.OnItemClickListener mOnItemClickListener;
        private View.OnClickListener mPosBtnListener;
        private TextView mTitle;
        private CharSequence msgText;
        private Button negBtn;
        private CharSequence negBtnText;
        private Button neuBtn;
        private CharSequence neuBtnText;
        private Button posBtn;
        private CharSequence posBtnText;
        private Resources resources;
        private CharSequence titleText;
        private int windowFlags;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder(Context context, int n2) {
            this.mContext = context;
            this.mDialogType = n2;
            this.mDialogStyle = n2 != 4 ? R.style.dialog : R.style.publish_btn_dialog;
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    this.windowFlags = ((Activity)context).getWindow().getDecorView().getSystemUiVisibility();
                }
                catch (ClassCastException classCastException) {}
            }
            this.resources = context.getResources();
        }

        static /* synthetic */ void access$100(Builder builder) {
            builder.resetPreviousWindowFlags();
        }

        static /* synthetic */ DialogInterface.OnCancelListener access$200(Builder builder) {
            return builder.mOnCancelListener;
        }

        static /* synthetic */ AdapterView.OnItemClickListener access$300(Builder builder) {
            return builder.mOnItemClickListener;
        }

        static /* synthetic */ FastScrollView access$400(Builder builder) {
            return builder.mMsgScrollView;
        }

        static /* synthetic */ View.OnClickListener access$500(Builder builder) {
            return builder.mNeuBtnListener;
        }

        static /* synthetic */ View.OnClickListener access$600(Builder builder) {
            return builder.mNegBtnListener;
        }

        static /* synthetic */ View.OnClickListener access$700(Builder builder) {
            return builder.mPosBtnListener;
        }

        static /* synthetic */ CharSequence[] access$800(Builder builder) {
            return builder.mListTexts;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CharSequence checkNull(CharSequence charSequence) {
            if (charSequence == null) return "";
            return charSequence;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void resetPreviousWindowFlags() {
            if (Build.VERSION.SDK_INT < 21) return;
            try {
                ((Activity)this.mContext).getWindow().getDecorView().setSystemUiVisibility(this.windowFlags);
                return;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }

        public void cancel() {
            if (this.mDialog.isShowing()) {
                this.mDialog.cancel();
                this.mDialog.setOnCancelListener(null);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public GmacsDialog create() {
            GmacsDialog gmacsDialog;
            this.mDialog = gmacsDialog = new GmacsDialog(this.mContext, this.mDialogStyle);
            this.mLayout = (LinearLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.gmacs_dialog_layout, null);
            if (this.mDialogType != 5) {
                gmacsDialog.setContentView((View)this.mLayout, new ViewGroup.LayoutParams(GmacsEnvi.screenWidth * 3 / 4, -2));
            } else {
                gmacsDialog.setContentView((View)this.mLayout, new ViewGroup.LayoutParams(-2, -2));
            }
            gmacsDialog.setCancelable(this.cancelable);
            gmacsDialog.setOnCancelListener((DialogInterface.OnCancelListener)new 1(this));
            this.mMsgScrollView = (FastScrollView)this.mLayout.findViewById(R.id.dialog_scrollview);
            this.mListView = (ListView)this.mLayout.findViewById(R.id.dialog_list);
            this.mTitle = (TextView)this.mLayout.findViewById(R.id.dialog_title);
            this.mMessageLayout = (LinearLayout)this.mLayout.findViewById(R.id.dialog_message_layout);
            this.mMsg = (TextView)this.mLayout.findViewById(R.id.dialog_text);
            this.mBtnLayout = (LinearLayout)this.mLayout.findViewById(R.id.dialog_btns_layout);
            this.neuBtn = (Button)this.mLayout.findViewById(R.id.dialog_neu_btn);
            if (this.titleText != null) {
                this.mTitle.setText(this.titleText);
            } else {
                this.mTitle.setVisibility(8);
            }
            switch (this.mDialogType) {
                case 1: {
                    this.mMessageLayout.setVisibility(8);
                    this.mMsg.setVisibility(8);
                    this.neuBtn.setVisibility(8);
                    this.mBtnLayout.setVisibility(8);
                    this.mListView.setAdapter((ListAdapter)new /* Unavailable Anonymous Inner Class!! */);
                    this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)new 2(this, gmacsDialog));
                    return gmacsDialog;
                }
                case 2: {
                    ViewGroup.LayoutParams layoutParams;
                    if (this.mMsg.getPaint().measureText(this.msgText.toString()) / (float)(GmacsEnvi.screenWidth * 3 / 4) > (float)GmacsEnvi.screenHeight * 0.6f / (float)this.mMsg.getLineHeight()) {
                        layoutParams = this.mMsgScrollView.getLayoutParams();
                        layoutParams.height = (int)((float)GmacsEnvi.screenHeight * 0.6f);
                        this.mMsgScrollView.setLayoutParams(layoutParams);
                    }
                    this.mListView.setVisibility(8);
                    this.mBtnLayout.setVisibility(8);
                    layoutParams = (LinearLayout.LayoutParams)this.mMessageLayout.getLayoutParams();
                    int n2 = GmacsUtils.dipToPixel(18.0f);
                    layoutParams.setMargins(n2, n2, n2, GmacsUtils.dipToPixel(50.0f));
                    this.mMsg.setText(this.msgText);
                    this.mMsg.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new 3(this));
                    this.neuBtn.setText(this.neuBtnText);
                    this.neuBtn.setOnClickListener((View.OnClickListener)new 4(this, gmacsDialog));
                    return gmacsDialog;
                }
                case 3: {
                    ViewGroup.LayoutParams layoutParams;
                    if (this.mMsg.getPaint().measureText(this.msgText.toString()) / (float)(GmacsEnvi.screenWidth * 3 / 4) > (float)GmacsEnvi.screenHeight * 0.6f / (float)this.mMsg.getLineHeight()) {
                        layoutParams = this.mMsgScrollView.getLayoutParams();
                        layoutParams.height = (int)((float)GmacsEnvi.screenHeight * 0.6f);
                        this.mMsgScrollView.setLayoutParams(layoutParams);
                    }
                    this.mListView.setVisibility(8);
                    this.neuBtn.setVisibility(8);
                    this.negBtn = (Button)this.mLayout.findViewById(R.id.dialog_neg_btn);
                    this.posBtn = (Button)this.mLayout.findViewById(R.id.dialog_pos_btn);
                    layoutParams = (LinearLayout.LayoutParams)this.mMessageLayout.getLayoutParams();
                    int n3 = GmacsUtils.dipToPixel(18.0f);
                    layoutParams.setMargins(n3, n3, n3, GmacsUtils.dipToPixel(50.0f));
                    this.mMsg.setText(this.msgText);
                    this.mMsg.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new 5(this));
                    this.negBtn.setText(this.negBtnText);
                    this.posBtn.setText(this.posBtnText);
                    this.negBtn.setOnClickListener((View.OnClickListener)new 6(this, gmacsDialog));
                    this.posBtn.setOnClickListener((View.OnClickListener)new 7(this, gmacsDialog));
                    return gmacsDialog;
                }
                case 4: {
                    ProgressBar progressBar = (ProgressBar)this.mLayout.findViewById(R.id.dialog_progressbar);
                    ((LinearLayout.LayoutParams)this.mMessageLayout.getLayoutParams()).leftMargin = 0;
                    this.mMessageLayout.setGravity(1);
                    progressBar.setVisibility(0);
                    gmacsDialog.setContentView((View)this.mLayout, new ViewGroup.LayoutParams(GmacsEnvi.screenWidth / 2, -2));
                    this.mLayout.setBackgroundColor(this.resources.getColor(R.color.dark_grey));
                    this.mTitle.setTextColor(this.resources.getColor(R.color.white));
                    this.mMsg.setText(this.msgText);
                    this.mMsg.setTextColor(this.resources.getColor(R.color.white));
                    this.mMsg.getLayoutParams().width = -2;
                    this.mBtnLayout.setVisibility(8);
                    this.neuBtn.setVisibility(8);
                    return gmacsDialog;
                }
                case 5: {
                    this.mListView.setVisibility(8);
                    this.neuBtn.setVisibility(8);
                    this.mBtnLayout.setVisibility(8);
                    this.mMessageLayout.removeAllViews();
                    this.mMessageLayout.addView(this.mContentView);
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mMessageLayout.getLayoutParams();
                    layoutParams.topMargin = 0;
                    layoutParams.bottomMargin = 0;
                    return gmacsDialog;
                }
            }
            return gmacsDialog;
        }

        public void dismiss() {
            if (this.mDialog.isShowing()) {
                this.mDialog.dismiss();
                this.mDialog.setOnCancelListener(null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getContentView() {
            if (this.mDialogType != 5) return null;
            return this.mContentView;
        }

        public Builder initDialog(@StringRes int n2) {
            if (this.mDialogType == 4) {
                this.msgText = this.resources.getText(n2);
            }
            return this;
        }

        public Builder initDialog(@StringRes int n2, @StringRes int n3, @StringRes int n4, @NonNull View.OnClickListener onClickListener, @NonNull View.OnClickListener onClickListener2) {
            if (this.mDialogType == 3) {
                this.msgText = this.resources.getText(n2);
                this.negBtnText = this.resources.getText(n3);
                this.posBtnText = this.resources.getText(n4);
                this.mNegBtnListener = onClickListener;
                this.mPosBtnListener = onClickListener2;
            }
            return this;
        }

        public Builder initDialog(@StringRes int n2, @StringRes int n3, @NonNull View.OnClickListener onClickListener) {
            if (this.mDialogType == 2) {
                this.msgText = this.resources.getText(n2);
                this.neuBtnText = this.resources.getText(n3);
                this.mNeuBtnListener = onClickListener;
            }
            return this;
        }

        public Builder initDialog(View view) {
            if (this.mDialogType == 5) {
                this.mContentView = view;
            }
            return this;
        }

        public Builder initDialog(@NonNull AdapterView.OnItemClickListener onItemClickListener) {
            if (this.mDialogType == 1) {
                this.mOnItemClickListener = onItemClickListener;
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder initDialog(CharSequence charSequence) {
            if (this.mDialogType == 4) {
                if (this.checkNull(charSequence).length() == 0) {
                    charSequence = this.mContext.getText(R.string.wait);
                }
                this.msgText = charSequence;
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder initDialog(CharSequence charSequence, CharSequence charSequence2, @NonNull View.OnClickListener onClickListener) {
            if (this.mDialogType == 2) {
                this.msgText = this.checkNull(charSequence);
                if (this.checkNull(charSequence2).length() == 0) {
                    charSequence2 = this.mContext.getText(R.string.ok);
                }
                this.neuBtnText = charSequence2;
                this.mNeuBtnListener = onClickListener;
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder initDialog(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, @NonNull View.OnClickListener onClickListener, @NonNull View.OnClickListener onClickListener2) {
            if (this.mDialogType == 3) {
                this.msgText = this.checkNull(charSequence);
                if (this.checkNull(charSequence2).length() == 0) {
                    charSequence2 = this.mContext.getText(R.string.cancel);
                }
                this.negBtnText = charSequence2;
                if (this.checkNull(charSequence3).length() == 0) {
                    charSequence3 = this.mContext.getText(R.string.ok);
                }
                this.posBtnText = charSequence3;
                this.mNegBtnListener = onClickListener;
                this.mPosBtnListener = onClickListener2;
            }
            return this;
        }

        public Builder setCancelable(boolean bl2) {
            this.cancelable = bl2;
            return this;
        }

        public Builder setListTexts(@ArrayRes int n2) {
            if (this.mDialogType == 1) {
                this.mListTexts = this.resources.getTextArray(n2);
            }
            return this;
        }

        public Builder setListTexts(CharSequence[] charSequenceArray) {
            block4: {
                block3: {
                    if (this.mDialogType != 1) break block3;
                    if (charSequenceArray == null) break block4;
                    int n2 = charSequenceArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        charSequenceArray[i2] = this.checkNull(charSequenceArray[i2]);
                    }
                    this.mListTexts = charSequenceArray;
                }
                return this;
            }
            throw new NullPointerException("GmacsDialog -> Adapter text array null");
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setTitle(@StringRes int n2) {
            this.titleText = this.resources.getText(n2);
            return this;
        }

        public Builder setTitle(CharSequence charSequence) {
            this.titleText = this.checkNull(charSequence);
            return this;
        }
    }
}

