/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.gmacs.R;
import com.android.gmacs.view.NetworkImageView;
import com.common.gmacs.downloader.RequestManager;
import com.common.gmacs.downloader.image.ImageLoader;
import com.common.gmacs.utils.GmacsEnvi;

public class NetworkImageView
extends ImageView {
    public static final int IMG_RESIZE = GmacsEnvi.appContext.getResources().getDimensionPixelOffset(R.dimen.avatar_conversation_list);
    private int mDecorate;
    private int mDefaultImageId;
    private int mDrawShape = 0;
    private int mErrorImageId;
    private int mHeight;
    private ImageLoader.ImageContainer mImageContainer;
    private Drawable mSideLine;
    private String mUrl;
    private int mWidth;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public NetworkImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.NetworkImageView);
        String string2 = attributeSet.getString(R.styleable.NetworkImageView_drawShape);
        if (string2 != null) {
            if (string2.equals(context.getString(R.string.drawShape_RoundRect))) {
                this.mDrawShape = 2;
            } else if (string2.equals(context.getString(R.string.drawShape_Circle))) {
                this.mDrawShape = 1;
            }
        }
        this.mDecorate = attributeSet.getResourceId(R.styleable.NetworkImageView_drawDecorate, 0);
        this.mSideLine = attributeSet.getDrawable(R.styleable.NetworkImageView_drawSideLine);
        attributeSet.recycle();
    }

    public NetworkImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    static /* synthetic */ int access$000(NetworkImageView networkImageView) {
        return networkImageView.mErrorImageId;
    }

    static /* synthetic */ int access$100(NetworkImageView networkImageView) {
        return networkImageView.mDecorate;
    }

    static /* synthetic */ int access$200(NetworkImageView networkImageView) {
        return networkImageView.mDefaultImageId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            if (this.mDecorate != 0) {
                this.setImageBitmap(null);
                this.setBackgroundResource(this.mDefaultImageId);
                return;
            }
            this.setImageResource(this.mDefaultImageId);
            return;
        }
        this.setImageBitmap(null);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    void loadImageIfNecessary(boolean bl2) {
        boolean bl3;
        boolean bl4;
        int n2;
        int n3;
        boolean bl5 = true;
        int n4 = 0;
        if (this.mHeight == 0 || this.mWidth == 0) {
            n3 = this.getWidth();
            n2 = this.getHeight();
        } else {
            n3 = this.mWidth;
            n2 = this.mHeight;
        }
        ImageView.ScaleType scaleType = this.getScaleType();
        if (this.getLayoutParams() != null) {
            bl4 = this.getLayoutParams().width == -2;
            bl3 = this.getLayoutParams().height == -2;
        } else {
            bl3 = false;
            bl4 = false;
        }
        if (!bl4 || !bl3) {
            bl5 = false;
        }
        if (n3 == 0 && n2 == 0 && !bl5) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) return;
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        if (bl4) {
            n3 = 0;
        }
        if (bl3) {
            n2 = n4;
        }
        this.mImageContainer = RequestManager.getInstance().getImageLoader().get(this.mUrl, (ImageLoader.ImageListener)new 1(this), n3, n2, scaleType, this.mDrawShape, this.mDecorate);
    }

    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSideLine != null) {
            this.mSideLine.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mSideLine.draw(canvas);
        }
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        super.onLayout(bl2, n2, n3, n4, n5);
        if (this.mHeight == 0 || this.mWidth == 0) {
            this.loadImageIfNecessary(true);
        }
    }

    public NetworkImageView setDefaultImageResId(int n2) {
        this.mDefaultImageId = n2;
        return this;
    }

    public NetworkImageView setErrorImageResId(int n2) {
        this.mErrorImageId = n2;
        return this;
    }

    public void setImageUrl(String string2) {
        this.mUrl = string2;
        this.loadImageIfNecessary(false);
    }

    public NetworkImageView setViewHeight(int n2) {
        this.mHeight = n2;
        return this;
    }

    public NetworkImageView setViewWidth(int n2) {
        this.mWidth = n2;
        return this;
    }
}

