/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.content.Context;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GenericLoaderFactory {
    private static final ModelLoader NULL_MODEL_LOADER = new 1();
    private final Map<Class, Map<Class, ModelLoader>> cachedModelLoaders;
    private final Context context;
    private final Map<Class, Map<Class, ModelLoaderFactory>> modelClassToResourceFactories = new HashMap<Class, Map<Class, ModelLoaderFactory>>();

    public GenericLoaderFactory(Context context) {
        this.cachedModelLoaders = new HashMap<Class, Map<Class, ModelLoader>>();
        this.context = context.getApplicationContext();
    }

    private <T, Y> void cacheModelLoader(Class<T> clazz, Class<Y> clazz2, ModelLoader<T, Y> modelLoader) {
        Map<Class, ModelLoader> map;
        Map<Class, ModelLoader> map2 = map = this.cachedModelLoaders.get(clazz);
        if (map == null) {
            map2 = new HashMap<Class, ModelLoader>();
            this.cachedModelLoaders.put(clazz, map2);
        }
        map2.put(clazz2, modelLoader);
    }

    private <T, Y> void cacheNullLoader(Class<T> clazz, Class<Y> clazz2) {
        this.cacheModelLoader(clazz, clazz2, NULL_MODEL_LOADER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, Y> ModelLoader<T, Y> getCachedLoader(Class<T> object, Class<Y> clazz) {
        if ((object = this.cachedModelLoaders.get(object)) == null) return null;
        return (ModelLoader)object.get(clazz);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private <T, Y> ModelLoaderFactory<T, Y> getFactory(Class<T> clazz, Class<Y> clazz2) {
        void var4_14;
        void var3_5;
        Map<Class, ModelLoaderFactory> map = this.modelClassToResourceFactories.get(clazz);
        if (map != null) {
            ModelLoaderFactory modelLoaderFactory = map.get(clazz2);
        } else {
            Object var3_8 = null;
        }
        void var4_9 = var3_5;
        if (var3_5 != null) return var4_14;
        Iterator<Class> iterator = this.modelClassToResourceFactories.keySet().iterator();
        while (true) {
            ModelLoaderFactory modelLoaderFactory;
            Map<Class, ModelLoaderFactory> map2;
            if (!iterator.hasNext()) {
                void var3_6;
                void var4_16 = var3_6;
                return var4_14;
            }
            Class clazz3 = iterator.next();
            if (!clazz3.isAssignableFrom(clazz) || (map2 = this.modelClassToResourceFactories.get(clazz3)) == null) continue;
            ModelLoaderFactory modelLoaderFactory2 = modelLoaderFactory = map2.get(clazz2);
            if (modelLoaderFactory != null) break;
        }
        return var4_14;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> modelLoader, Class<Y> clazz) {
        synchronized (this) {
            ModelLoader modelLoader2 = this.getCachedLoader((Class<T>)modelLoader, clazz);
            if (modelLoader2 != null) {
                boolean bl2 = NULL_MODEL_LOADER.equals(modelLoader2);
                modelLoader = modelLoader2;
                if (!bl2) return modelLoader;
                return null;
            }
            ModelLoaderFactory<T, Y> modelLoaderFactory = this.getFactory((Class<T>)modelLoader, clazz);
            if (modelLoaderFactory != null) {
                modelLoader2 = modelLoaderFactory.build(this.context, this);
                this.cacheModelLoader((Class<T>)modelLoader, clazz, (ModelLoader<T, Y>)modelLoader2);
                return modelLoader2;
            }
            this.cacheNullLoader((Class<T>)modelLoader, clazz);
            return modelLoader2;
        }
    }

    @Deprecated
    public <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> clazz, Class<Y> clazz2, Context context) {
        synchronized (this) {
            clazz = this.buildModelLoader(clazz, clazz2);
            return clazz;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, Y> ModelLoaderFactory<T, Y> register(Class<T> modelLoaderFactory, Class<Y> modelLoaderFactory2, ModelLoaderFactory<T, Y> object) {
        synchronized (this) {
            boolean bl2;
            Iterator<Map<Class, ModelLoaderFactory>> iterator;
            ModelLoaderFactory modelLoaderFactory3;
            HashMap<void, void> hashMap;
            this.cachedModelLoaders.clear();
            HashMap<void, void> hashMap2 = hashMap = this.modelClassToResourceFactories.get(modelLoaderFactory);
            if (hashMap == null) {
                hashMap2 = new HashMap<void, void>();
                this.modelClassToResourceFactories.put((Class)modelLoaderFactory, hashMap2);
            }
            modelLoaderFactory = modelLoaderFactory3 = (ModelLoaderFactory)hashMap2.put((void)modelLoaderFactory3, (void)iterator);
            if (modelLoaderFactory3 == null) return modelLoaderFactory;
            iterator = this.modelClassToResourceFactories.values().iterator();
            do {
                modelLoaderFactory = modelLoaderFactory3;
                if (!iterator.hasNext()) return modelLoaderFactory;
            } while (!(bl2 = iterator.next().containsValue(modelLoaderFactory3)));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, Y> ModelLoaderFactory<T, Y> unregister(Class<T> object, Class<Y> clazz) {
        synchronized (this) {
            this.cachedModelLoaders.clear();
            object = this.modelClassToResourceFactories.get(object);
            if (object == null) return null;
            return (ModelLoaderFactory)object.remove(clazz);
        }
    }
}

