/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.core;

import android.content.ContentValues;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.common.gmacs.R;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.core.ImageToolManager;
import com.common.gmacs.core.MediaToolManager;
import com.common.gmacs.core.MessageManager;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.msg.data.IMAudioMsg;
import com.common.gmacs.msg.data.IMImageMsg;
import com.common.gmacs.msg.data.IMLocationMsg;
import com.common.gmacs.msg.data.IMTextMsg;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.parse.message.MessageDetail;
import com.common.gmacs.parse.talk.Talk;
import com.common.gmacs.utils.BitmapUtil;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.ToastUtil;
import com.wuba.wchat.api.Define;
import com.wuba.wchat.api.a;
import com.wuba.wchat.api.e;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MessageManager {
    private static final long SEND_MESSAGE_RETRY_TIME = 10000L;
    private static final long TOTAL_RETRY_TIME = 300000L;
    private static volatile MessageManager instance;
    private final String TAG = MessageManager.class.getSimpleName();
    private Handler handler;
    private ArrayList<RecvMsgListener> listenerArray = new ArrayList();
    private final Pattern logPattern = Pattern.compile("\\*#58#:(view|upload)log(:(\\d+):(\\d+))?");
    private Map<String, SendingMsgsOfTalk> mAllSendImgMsgs;
    private Set<SendIMMsgListener> mListenerList = new HashSet<SendIMMsgListener>(2);
    private long mTotalRetryTime = 300000L;

    private MessageManager() {
        this.mAllSendImgMsgs = new HashMap<String, SendingMsgsOfTalk>();
        this.regRecvMsgListener();
        HandlerThread handlerThread = new HandlerThread("SendMessageRetryThread", 10);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
    }

    static /* synthetic */ String access$000(MessageManager messageManager) {
        return messageManager.TAG;
    }

    static /* synthetic */ void access$100(MessageManager messageManager, Define.Msg msg, Define.SendStatus sendStatus) {
        messageManager.updateSendStatus(msg, sendStatus);
    }

    static /* synthetic */ ArrayList access$1000(MessageManager messageManager) {
        return messageManager.listenerArray;
    }

    static /* synthetic */ void access$200(MessageManager messageManager, Message message, SendIMMsgListener sendIMMsgListener) {
        messageManager.startSendMessage(message, sendIMMsgListener);
    }

    static /* synthetic */ void access$300(MessageManager messageManager, Message message, Define.SendStatus sendStatus) {
        messageManager.updateSendStatus(message, sendStatus);
    }

    static /* synthetic */ void access$400(MessageManager messageManager, Message message, SendIMMsgListener sendIMMsgListener) {
        messageManager.updateLocalUrl2Remote(message, sendIMMsgListener);
    }

    static /* synthetic */ Pattern access$500(MessageManager messageManager) {
        return messageManager.logPattern;
    }

    static /* synthetic */ long access$600(MessageManager messageManager) {
        return messageManager.mTotalRetryTime;
    }

    static /* synthetic */ void access$700(MessageManager messageManager, Message message, SendIMMsgListener sendIMMsgListener) {
        messageManager.sendMessageRetry(message, sendIMMsgListener);
    }

    static /* synthetic */ Handler access$800(MessageManager messageManager) {
        return messageManager.handler;
    }

    static /* synthetic */ void access$900(MessageManager messageManager, Message message, SendIMMsgListener sendIMMsgListener, int n2, String string2) {
        messageManager.notifySendFinish(message, sendIMMsgListener, n2, string2);
    }

    private Message createMessage(int n2, IMMessage iMMessage, Message.MessageUserInfo messageUserInfo, SendIMMsgListener sendIMMsgListener) {
        Message message = new Message();
        message.mReceiverInfo = messageUserInfo;
        message.mMsgDetail = new MessageDetail(message);
        message.mMsgDetail.mIsSelfSendMsg = true;
        message.mMsgDetail.setMsgContent(iMMessage);
        message.mSenderInfo = Message.MessageUserInfo.createLoginUserInfo();
        message.mSenderInfo.mTalkType = message.mTalkType = n2;
        if (sendIMMsgListener != null) {
            sendIMMsgListener.onPreSaveMessage(message);
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessageManager getInstance() {
        if (instance == null) {
            synchronized (MessageManager.class) {
                if (instance == null) {
                    MessageManager messageManager;
                    instance = messageManager = new MessageManager();
                }
            }
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifySendFinish(Message message, SendIMMsgListener sendIMMsgListener2, int n2, String string2) {
        if (sendIMMsgListener2 != null) {
            sendIMMsgListener2.onSendMessageResult(message, n2, string2);
        }
        for (SendIMMsgListener sendIMMsgListener2 : this.mListenerList) {
            if (sendIMMsgListener2 == null) continue;
            sendIMMsgListener2.onSendMessageResult(message, n2, string2);
        }
        synchronized (this) {
            string2 = Talk.getTalkId(message);
            if (string2 != null && (sendIMMsgListener2 = this.mAllSendImgMsgs.get(string2)) != null) {
                sendIMMsgListener2.removeSendingMsg(message.mId);
                if (sendIMMsgListener2.mSendingMsgs.size() == 0) {
                    this.mAllSendImgMsgs.remove(string2);
                }
            }
            return;
        }
    }

    private ContentValues parseContentValuesFromSenderInfo(String string2, int n2, GmacsUserInfo gmacsUserInfo) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("user_id", string2);
        contentValues.put("user_source", Integer.valueOf(n2));
        if (!TextUtils.isEmpty((CharSequence)gmacsUserInfo.userName)) {
            contentValues.put("user_name", gmacsUserInfo.userName);
        }
        if (!TextUtils.isEmpty((CharSequence)gmacsUserInfo.avatar)) {
            contentValues.put("avatar", gmacsUserInfo.avatar);
        }
        contentValues.put("user_type", Integer.valueOf(gmacsUserInfo.userType));
        contentValues.put("gender", Integer.valueOf(gmacsUserInfo.gender));
        contentValues.put("nick_name", gmacsUserInfo.nickName);
        contentValues.put("level", Integer.valueOf(gmacsUserInfo.level));
        return contentValues;
    }

    private void regRecvMsgListener() {
        a.a((a.h)new 18(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveMessage(Message message, SendIMMsgListener sendIMMsgListener) {
        e e2 = a.b();
        if (e2 == null || this.shouldInterceptMessageSend()) {
            return;
        }
        message.mMsgDetail.setMsgSendStatus(0);
        message.mMsgDetail.setMsgReadStatus(1);
        GLog.d(this.TAG, "saveMessage");
        e2.saveAsync(Message.buildMsg(message), (Define.SaveMessgeCallback)new 1(this, message, sendIMMsgListener));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMessage(Message message, SendIMMsgListener sendIMMsgListener) {
        Define.Msg msg;
        e e2;
        block4: {
            block3: {
                e2 = a.b();
                if (e2 == null) break block3;
                GLog.d(this.TAG, "sendMessage");
                msg = Message.buildMsg(message);
                if (msg.getContent().length() <= 4000) break block4;
                message.mMsgDetail.setMsgSendStatus(2);
                this.updateSendStatus(msg, Define.SendStatus.MSG_SEND_FAILED);
                this.notifySendFinish(message, sendIMMsgListener, Gmacs.Error.ERROR_MESSAGE_CONTENT_OVERFLOW.getErrorCode(), Gmacs.Error.ERROR_MESSAGE_CONTENT_OVERFLOW.getErrorMessage());
            }
            return;
        }
        e2.sendAsync(msg, (Define.SendMessageCallback)new 4(this, System.currentTimeMillis(), message, sendIMMsgListener));
    }

    private void sendMessageRetry(Message message, SendIMMsgListener sendIMMsgListener) {
        e e2 = a.b();
        if (e2 != null) {
            GLog.d(this.TAG, "sendMessageRetry" + message);
            e2.sendAsync(Message.buildMsg(message), (Define.SendMessageCallback)new 5(this, message, System.currentTimeMillis(), sendIMMsgListener));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldInterceptMessageSend() {
        if (ClientManager.getInstance().getConnectionStatus() != 4) return false;
        ToastUtil.showToast(GmacsEnvi.appContext.getText(R.string.connection_status_kickedoff));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startSendMessage(Message message, SendIMMsgListener sendIMMsgListener) {
        IMMessage iMMessage = message.mMsgDetail.getmMsgContent();
        Object object = iMMessage.mType;
        int n2 = -1;
        switch (((String)object).hashCode()) {
            case 93166550: {
                if (((String)object).equals("audio")) {
                    n2 = 0;
                }
            }
            default: {
                break;
            }
            case 100313435: {
                if (!((String)object).equals("image")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            default: {
                this.sendMessage(message, sendIMMsgListener);
                return;
            }
            case 0: {
                object = (IMAudioMsg)iMMessage;
                if (TextUtils.isEmpty((CharSequence)((IMAudioMsg)object).mUrl)) {
                    message.mMsgDetail.setMsgSendStatus(2);
                    this.updateSendStatus(message, Define.SendStatus.MSG_SEND_FAILED);
                    if (sendIMMsgListener == null) return;
                    sendIMMsgListener.onSendMessageResult(message, Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorCode(), Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorMessage());
                    return;
                }
                if (((IMAudioMsg)object).mUrl.startsWith("/")) {
                    this.uploadAudioFile((IMAudioMsg)object, message, sendIMMsgListener);
                    return;
                }
                if (((IMAudioMsg)object).mUrl.regionMatches(true, 0, "http", 0, 4)) {
                    this.sendMessage(message, sendIMMsgListener);
                    return;
                }
                message.mMsgDetail.setMsgSendStatus(2);
                this.updateSendStatus(message, Define.SendStatus.MSG_SEND_FAILED);
                if (sendIMMsgListener == null) return;
                sendIMMsgListener.onSendMessageResult(message, Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorCode(), Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorMessage());
                return;
            }
            case 1: 
        }
        object = (IMImageMsg)iMMessage;
        if (TextUtils.isEmpty((CharSequence)((IMImageMsg)object).mUrl)) {
            message.mMsgDetail.setMsgSendStatus(2);
            this.updateSendStatus(message, Define.SendStatus.MSG_SEND_FAILED);
            if (sendIMMsgListener == null) return;
            sendIMMsgListener.onSendMessageResult(message, Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorCode(), Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorMessage());
            return;
        }
        if (((IMImageMsg)object).mUrl.startsWith("/")) {
            this.uploadImageFile((IMImageMsg)object, message, sendIMMsgListener);
            return;
        }
        if (((IMImageMsg)object).mUrl.regionMatches(true, 0, "http", 0, 4)) {
            this.sendMessage(message, sendIMMsgListener);
            return;
        }
        message.mMsgDetail.setMsgSendStatus(2);
        this.updateSendStatus(message, Define.SendStatus.MSG_SEND_FAILED);
        if (sendIMMsgListener == null) return;
        sendIMMsgListener.onSendMessageResult(message, Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorCode(), Gmacs.Error.ERROR_INVALID_LOCAL_PATH.getErrorMessage());
    }

    private void updateLocalUrl2Remote(Message message, SendIMMsgListener sendIMMsgListener) {
        Define.Msg msg = Message.buildMsg(message);
        e e2 = a.b();
        if (e2 != null) {
            e2.saveAsync(msg, (Define.SaveMessgeCallback)new 20(this, message, sendIMMsgListener));
        }
    }

    private void updateSendStatus(Message message, Define.SendStatus sendStatus) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updateSendStatusAsync(Message.buildMsg(message), sendStatus, (Define.UpdateSendStatusCallback)new 16(this));
        }
    }

    private void updateSendStatus(Define.Msg msg, Define.SendStatus sendStatus) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updateSendStatusAsync(msg, sendStatus, (Define.UpdateSendStatusCallback)new 17(this));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadAudioFile(IMAudioMsg iMAudioMsg, Message message, SendIMMsgListener sendIMMsgListener) {
        if (iMAudioMsg == null || message == null) {
            return;
        }
        MediaToolManager.getInstance().uploadAudioFile(iMAudioMsg.mUrl, (MediaToolManager.UploadAudioListener)new 3(this, iMAudioMsg, message, sendIMMsgListener));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadImageFile(IMImageMsg iMImageMsg, Message message, SendIMMsgListener sendIMMsgListener) {
        GLog.d(this.TAG, "uploadImageFile" + iMImageMsg + message);
        if (iMImageMsg == null || message == null) {
            return;
        }
        ImageToolManager.getInstance().uploadImageFile(iMImageMsg.mUrl, (ImageToolManager.UploadImageListener)new 2(this, iMImageMsg, sendIMMsgListener, message));
    }

    public void ackMsgShow(long l2) {
        e e2 = a.b();
        if (e2 != null) {
            e2.ackMsgShowAsync(l2);
        }
    }

    public void addSendIMMsgListener(SendIMMsgListener sendIMMsgListener) {
        this.mListenerList.add(sendIMMsgListener);
    }

    public void deleteMsgByLocalIdAsync(long[] lArray, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.deleteByMsgIdAsync(lArray, (Define.DeleteByMsgIdCallback)new 8(this, actionCb));
        }
    }

    public void getHistoryAsync(String string2, int n2, long l2, int n3, GetHistoryMsgCb getHistoryMsgCb) {
        e e2 = a.b();
        if (e2 != null) {
            GLog.i(this.TAG, "getHistoryAsync.beginMsgId:" + l2);
            e2.getHistoryAsync(string2, n2, l2, n3, (Define.GetHistoryCallback)new 7(this, getHistoryMsgCb));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message getSendingMsgForTalk(String object, long l2) {
        synchronized (this) {
            object = this.mAllSendImgMsgs.get(object);
            if (object == null) return null;
            return object.getSendingMsg(l2);
        }
    }

    public void getUnreadCountByMsgTypeAsync(List<Integer> list, GetUnreadMsgCb getUnreadMsgCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.a(list, (Define.GetUnreadCountByMsgTypeCallback)new 14(this, getUnreadMsgCb));
        }
    }

    public void getUnreadCountByTalkIdAsync(String string2, int n2, GetUnreadMsgCb getUnreadMsgCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.getUnreadCountByTalkIdAsync(string2, n2, (Define.GetUnreadCountByTalkIdCallback)new 13(this, getUnreadMsgCb));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertLocalMessage(int n2, Message.MessageUserInfo object, Message.MessageUserInfo messageUserInfo, String string2, IMMessage iMMessage, boolean bl2, boolean bl3, boolean bl4, InsertLocalMessageCb insertLocalMessageCb) {
        int n3 = 1;
        if (object == null || messageUserInfo == null) {
            GLog.d(this.TAG, "insertLocalMessage: sendInfo or receiverInfo is null.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((Message.MessageUserInfo)object).mUserId)) {
            GLog.d(this.TAG, "insertLocalMessage: sendInfo's userId is empty.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)messageUserInfo.mUserId)) {
            GLog.d(this.TAG, "insertLocalMessage: receiverInfo's userId is empty.");
            return;
        }
        Message message = new Message();
        message.mReceiverInfo = messageUserInfo;
        message.mSenderInfo = object;
        message.mMsgDetail = new MessageDetail(message);
        message.mMsgDetail.setMsgContent(iMMessage);
        message.mMsgDetail.setMsgSendStatus(4);
        object = message.mMsgDetail;
        int n4 = bl3 ? 1 : 0;
        ((MessageDetail)object).setMsgPlayStatus(n4);
        object = message.mMsgDetail;
        n4 = bl4 ? n3 : 0;
        ((MessageDetail)object).setMsgReadStatus(n4);
        message.mMsgDetail.setRefer(string2);
        message.mSenderInfo.mTalkType = message.mTalkType = n2;
        message.mReceiverInfo.mTalkType = message.mTalkType;
        message.shouldHideOnTalkList = bl2;
        message.shouldHideUnreadCount = false;
        message.checkIsSelfSendMessage();
        object = Message.buildMsg(message);
        messageUserInfo = a.b();
        if (messageUserInfo == null) return;
        messageUserInfo.saveFakeMsgAsync((Define.Msg)object, (Define.SaveFakeMsgCallback)new 19(this, message, insertLocalMessageCb));
    }

    public boolean isTalkHasSendingMsgs(String string2) {
        return this.mAllSendImgMsgs.containsKey(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keepSendingMessage(Message message) {
        String string2 = Talk.getTalkId(message);
        synchronized (this) {
            if (this.mAllSendImgMsgs.containsKey(string2)) {
                this.mAllSendImgMsgs.get(string2).addSendingMsg(message);
            } else {
                SendingMsgsOfTalk sendingMsgsOfTalk = new /* Unavailable Anonymous Inner Class!! */;
                sendingMsgsOfTalk.addSendingMsg(message);
                this.mAllSendImgMsgs.put(string2, sendingMsgsOfTalk);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void regRecvMsgListener(RecvMsgListener recvMsgListener) {
        synchronized (this) {
            if (!this.listenerArray.contains(recvMsgListener)) {
                this.listenerArray.add(recvMsgListener);
            }
            return;
        }
    }

    public void removeSendIMMsgListener(SendIMMsgListener sendIMMsgListener) {
        this.mListenerList.remove(sendIMMsgListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendIMAudioMsg(int n2, String string2, IMAudioMsg iMAudioMsg, String string3, int n3, String string4, SendIMMsgListener sendIMMsgListener) {
        if (iMAudioMsg == null || TextUtils.isEmpty((CharSequence)iMAudioMsg.mUrl) || iMAudioMsg.mDuration <= 0L) {
            return;
        }
        iMAudioMsg.mLocalUrl = iMAudioMsg.mUrl;
        this.sendIMMsg(n2, iMAudioMsg, string2, string3, n3, string4, sendIMMsgListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendIMImageMsg(int n2, String string2, IMImageMsg iMImageMsg, String string3, int n3, String string4, boolean bl2, SendIMMsgListener sendIMMsgListener) {
        if (iMImageMsg == null || TextUtils.isEmpty((CharSequence)iMImageMsg.mUrl)) {
            return;
        }
        if (!bl2) {
            iMImageMsg.mUrl = BitmapUtil.compressImage(iMImageMsg.mUrl);
        }
        int[] nArray = BitmapUtil.imageSize(iMImageMsg.mUrl);
        iMImageMsg.mWidth = String.valueOf(nArray[0]);
        iMImageMsg.mHeight = String.valueOf(nArray[1]);
        this.sendIMMsg(n2, iMImageMsg, string2, string3, n3, string4, sendIMMsgListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendIMLocationMsg(int n2, IMLocationMsg iMLocationMsg, String string2, String string3, int n3, String string4, SendIMMsgListener sendIMMsgListener) {
        if (iMLocationMsg == null || TextUtils.isEmpty((CharSequence)iMLocationMsg.mAddress)) {
            return;
        }
        this.sendIMMsg(n2, iMLocationMsg, string2, string3, n3, string4, sendIMMsgListener);
    }

    public void sendIMMsg(int n2, IMMessage object, String string2, String string3, int n3, String string4, SendIMMsgListener sendIMMsgListener) {
        Message.MessageUserInfo messageUserInfo = new Message.MessageUserInfo();
        messageUserInfo.mUserId = string3;
        messageUserInfo.mUserSource = n3;
        messageUserInfo.mTalkType = n2;
        messageUserInfo.mDeviceId = string4;
        object = this.createMessage(n2, (IMMessage)object, messageUserInfo, sendIMMsgListener);
        ((Message)object).mMsgDetail.setRefer(string2);
        this.sendIMMsg((Message)object, sendIMMsgListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendIMMsg(Message message, SendIMMsgListener sendIMMsgListener) {
        if (message.mReceiverInfo == null || message.mMsgDetail == null) {
            return;
        }
        if (message.mSenderInfo == null) {
            message.mSenderInfo = Message.MessageUserInfo.createLoginUserInfo();
            message.mSenderInfo.mTalkType = message.mTalkType;
        }
        if (message.mId > 0L) {
            message.mMsgDetail.setMsgSendStatus(1);
            this.updateSendStatus(message, Define.SendStatus.MSG_SENDING);
            this.keepSendingMessage(message);
            this.startSendMessage(message, sendIMMsgListener);
            return;
        }
        this.saveMessage(message, sendIMMsgListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendIMTextMsg(int n2, IMTextMsg iMTextMsg, String string2, String string3, int n3, String string4, SendIMMsgListener sendIMMsgListener) {
        if (iMTextMsg == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)iMTextMsg.mMsg)) return;
        this.sendIMMsg(n2, iMTextMsg, string2, string3, n3, string4, sendIMMsgListener);
    }

    public void setTotalRetryTime(long l2) {
        this.mTotalRetryTime = l2;
    }

    public void showLog() {
        Message message = new Message();
        message.mReceiverInfo = Message.MessageUserInfo.createLoginUserInfo();
        message.mMsgDetail = new MessageDetail(message);
        message.mMsgDetail.mIsSelfSendMsg = true;
        IMTextMsg iMTextMsg = new IMTextMsg();
        iMTextMsg.mMsg = "*#58#:viewlog:1:1000";
        message.mMsgDetail.setMsgContent(iMTextMsg);
        message.mSenderInfo = message.mReceiverInfo;
        message.mSenderInfo.mTalkType = message.mTalkType = Gmacs.TalkType.TALKETYPE_NORMAL.getValue();
        message.mMsgDetail.setMsgSendStatus(3);
        message.mMsgDetail.setMsgReadStatus(1);
        message.mId = 1000L;
        message.mMsgDetail.mMsgUpdateTime = System.currentTimeMillis();
        message = Message.buildMsg(message);
        iMTextMsg = a.b();
        if (iMTextMsg != null) {
            iMTextMsg.sendAsync((Define.Msg)message, (Define.SendMessageCallback)new 21(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unRegRecvMsgListener(RecvMsgListener recvMsgListener) {
        synchronized (this) {
            if (this.listenerArray.contains(recvMsgListener)) {
                this.listenerArray.remove(recvMsgListener);
            }
            return;
        }
    }

    public void updateMessage(Message message) {
        e e2 = a.b();
        if (e2 != null) {
            e2.saveAsync(Message.buildMsg(message), (Define.SaveMessgeCallback)new 6(this));
        }
    }

    public void updatePlayStatusBatchByLocalIdAsync(List<Long> list, int n2, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.a(list, Define.PlayStatus.valueOf((int)n2), (Define.UpdatePlayStatusBatchByMsgIdCallback)new 15(this, actionCb));
        }
    }

    public void updatePlayStatusByMsgIdAsync(long l2, int n2, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updatePlayStatusByMsgIdAsync(l2, Define.PlayStatus.valueOf((int)n2), (Define.UpdatePlayStatusByMsgIdCallback)new 11(this, actionCb));
        }
    }

    public void updatePlayStatusByTalkIdAsync(String string2, int n2, int n3, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updatePlayStatusByTalkIdAsync(string2, n2, Define.PlayStatus.valueOf((int)n3), (Define.UpdatePlayStatusByTalkIdCallback)new 12(this, actionCb));
        }
    }

    public void updateReadStatusByMsgIdAsync(long l2, int n2, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updateReadStatusByMsgIdAsync(l2, Define.ReadStatus.valueOf((int)n2), (Define.UpdateReadStatusByMsgIdCallback)new 9(this, actionCb));
        }
    }

    public void updateReadStatusByTalkIdAsync(String string2, int n2, int n3, ActionCb actionCb) {
        e e2 = a.b();
        if (e2 != null) {
            e2.updateReadStatusByTalkIdAsync(string2, n2, Define.ReadStatus.valueOf((int)n3), (Define.UpdateReadStatusByTalkIdCallback)new 10(this, actionCb));
        }
    }

    public static interface ActionCb {
        public void done(int var1, String var2);
    }

    public static interface InsertLocalMessageCb {
        public void onInsertLocalMessage(int var1, String var2, Message var3);
    }

    public static interface RecvMsgListener {
        public void msgRecved(Message var1);
    }

    public static interface SendIMMsgListener {
        public void onAfterSaveMessage(Message var1, int var2, String var3);

        public void onPreSaveMessage(Message var1);

        public void onSendMessageResult(Message var1, int var2, String var3);
    }
}

