/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.DefaultRetryPolicy;
import com.common.gmacs.downloader.NetworkResponse;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.RequestQueue;
import com.common.gmacs.downloader.Response;
import com.common.gmacs.downloader.RetryPolicy;
import com.common.gmacs.downloader.VolleyError;
import com.common.gmacs.downloader.VolleyLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private Cache.Entry mCacheEntry;
    private boolean mCanceled;
    private final int mDefaultTrafficStatsTag;
    private final Response.ErrorListener mErrorListener;
    private final VolleyLog.MarkerLog mEventLog;
    private final int mMethod;
    private RequestQueue mRequestQueue;
    private boolean mResponseDelivered;
    private RetryPolicy mRetryPolicy;
    private Integer mSequence;
    private boolean mShouldCache;
    private Object mTag;
    private final String mUrl;

    /*
     * Enabled aggressive block sorting
     */
    public Request(int n2, String string2, Response.ErrorListener errorListener) {
        VolleyLog.MarkerLog markerLog = VolleyLog.MarkerLog.ENABLED ? new VolleyLog.MarkerLog() : null;
        this.mEventLog = markerLog;
        this.mShouldCache = true;
        this.mCanceled = false;
        this.mResponseDelivered = false;
        this.mCacheEntry = null;
        this.mMethod = n2;
        this.mUrl = string2;
        this.mErrorListener = errorListener;
        this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy());
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(string2);
    }

    @Deprecated
    public Request(String string2, Response.ErrorListener errorListener) {
        this(-1, string2, errorListener);
    }

    static /* synthetic */ VolleyLog.MarkerLog access$000(Request request) {
        return request.mEventLog;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] encodeParameters(Map<String, String> object, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                stringBuilder.append(URLEncoder.encode((String)entry.getKey(), string2));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode((String)entry.getValue(), string2));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Encoding not supported: " + string2, unsupportedEncodingException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findDefaultTrafficStatsTag(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) return 0;
        if ((string2 = Uri.parse((String)string2)) == null) return 0;
        if ((string2 = string2.getHost()) == null) return 0;
        return string2.hashCode();
    }

    public void addMarker(String string2) {
        if (VolleyLog.MarkerLog.ENABLED) {
            this.mEventLog.add(string2, Thread.currentThread().getId());
        }
    }

    public void cancel() {
        this.mCanceled = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Request<T> request) {
        Priority priority;
        Priority priority2 = this.getPriority();
        if (priority2 != (priority = request.getPriority())) return priority.ordinal() - priority2.ordinal();
        return this.mSequence - request.mSequence;
    }

    public void deliverError(VolleyError volleyError) {
        if (this.mErrorListener != null) {
            this.mErrorListener.onErrorResponse(volleyError);
        }
    }

    protected abstract void deliverResponse(T var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void finish(String string2) {
        long l2;
        block6: {
            block5: {
                if (this.mRequestQueue != null) {
                    this.mRequestQueue.finish(this);
                }
                if (!VolleyLog.MarkerLog.ENABLED) break block5;
                l2 = Thread.currentThread().getId();
                if (Looper.myLooper() == Looper.getMainLooper()) break block6;
                new Handler(Looper.getMainLooper()).post((Runnable)new 1(this, string2, l2));
            }
            return;
        }
        this.mEventLog.add(string2, l2);
        this.mEventLog.finish(this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBody() {
        Map<String, String> map = this.getParams();
        if (map == null) return null;
        if (map.size() <= 0) return null;
        return (Map<String, String>)this.encodeParameters(map, this.getParamsEncoding());
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    public String getCacheKey() {
        return this.getUrl();
    }

    public Response.ErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    public int getMethod() {
        return this.mMethod;
    }

    protected Map<String, String> getParams() {
        return null;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public byte[] getPostBody() {
        Map<String, String> map = this.getPostParams();
        if (map == null) return null;
        if (map.size() <= 0) return null;
        return (Map<String, String>)this.encodeParameters(map, this.getPostParamsEncoding());
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    protected Map<String, String> getPostParams() {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    public final int getSequence() {
        if (this.mSequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.mSequence;
    }

    public Object getTag() {
        return this.mTag;
    }

    public final int getTimeoutMs() {
        return this.mRetryPolicy.getCurrentTimeout();
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    protected abstract Response<T> parseLocalResponse(String var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
        return this;
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public final Request<?> setSequence(int n2) {
        this.mSequence = n2;
        return this;
    }

    public final Request<?> setShouldCache(boolean bl2) {
        this.mShouldCache = bl2;
        return this;
    }

    public Request<?> setTag(Object object) {
        this.mTag = object;
        return this;
    }

    public final boolean shouldCache() {
        return this.mShouldCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        String string3 = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mCanceled) {
            string2 = "[X] ";
            return stringBuilder.append(string2).append(this.getUrl()).append(" ").append(string3).append(" ").append(this.getPriority()).append(" ").append(this.mSequence).toString();
        }
        string2 = "[ ] ";
        return stringBuilder.append(string2).append(this.getUrl()).append(" ").append(string3).append(" ").append(this.getPriority()).append(" ").append(this.mSequence).toString();
    }
}

