/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.widget.ImageView;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.DefaultRetryPolicy;
import com.common.gmacs.downloader.HttpHeaderParser;
import com.common.gmacs.downloader.NetworkResponse;
import com.common.gmacs.downloader.ParseError;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.Response;
import com.common.gmacs.downloader.RetryPolicy;
import com.common.gmacs.downloader.VolleyError;
import com.common.gmacs.downloader.VolleyLog;

public class ImageRequest
extends Request<Bitmap> {
    public static final int DRAW_SHAPE_CIRCLE = 1;
    public static final int DRAW_SHAPE_RECT = 0;
    public static final int DRAW_SHAPE_ROUND_RECT = 2;
    private static final float IMAGE_BACKOFF_MULT = 2.0f;
    private static final int IMAGE_MAX_RETRIES = 2;
    private static final int IMAGE_TIMEOUT_MS = 1000;
    private static final Object sDecodeLock = new Object();
    private final Bitmap.Config mDecodeConfig;
    private final int mDecorate;
    private final int mDrawShape;
    private final Response.Listener<Bitmap> mListener;
    private final int mMaxHeight;
    private final int mMaxWidth;
    private ImageView.ScaleType mScaleType;

    @Deprecated
    public ImageRequest(String string2, Response.Listener<Bitmap> listener, int n2, int n3, Bitmap.Config config, Response.ErrorListener errorListener) {
        this(string2, listener, n2, n3, ImageView.ScaleType.CENTER_INSIDE, config, 0, 0, errorListener);
    }

    public ImageRequest(String string2, Response.Listener<Bitmap> listener, int n2, int n3, ImageView.ScaleType scaleType, Bitmap.Config config, int n4, int n5, Response.ErrorListener errorListener) {
        super(0, string2, errorListener);
        this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(1000, 2, 2.0f));
        this.mListener = listener;
        this.mDecodeConfig = config;
        this.mMaxWidth = n2;
        this.mMaxHeight = n3;
        this.mScaleType = scaleType;
        this.mDrawShape = n4;
        this.mDecorate = n5;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Response<Bitmap> doParse(NetworkResponse networkResponse) {
        void var2_4;
        byte[] byArray = networkResponse.data;
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            options.inPreferredConfig = this.mDecodeConfig;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        } else {
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            int n2 = options.outWidth;
            int n3 = options.outHeight;
            int n4 = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, n2, n3, this.mScaleType);
            int n5 = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, n3, n2, this.mScaleType);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageRequest.findBestSampleSize(n2, n3, n4, n5);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            if (bitmap != null && (bitmap.getWidth() > n4 || bitmap.getHeight() > n5)) {
                options = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n4, (int)n5, (boolean)true);
                bitmap.recycle();
                BitmapFactory.Options options2 = options;
            }
        }
        if (var2_4 != null) return Response.success((Object)var2_4, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
        return Response.error((VolleyError)new ParseError(networkResponse));
    }

    public static int findBestSampleSize(int n2, int n3, int n4, int n5) {
        double d2 = Math.min((double)n2 / (double)n4, (double)n3 / (double)n5);
        float f2 = 1.0f;
        while ((double)(f2 * 2.0f) <= d2) {
            f2 *= 2.0f;
        }
        return (int)f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getResizedDimension(int n2, int n3, int n4, int n5, ImageView.ScaleType scaleType) {
        int n6;
        if (n2 == 0 && n3 == 0) {
            return n4;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            n6 = n2;
            if (n2 != 0) return n6;
            return n4;
        }
        if (n2 == 0) {
            return (int)((double)n3 / (double)n5 * (double)n4);
        }
        n6 = n2;
        if (n3 == 0) return n6;
        double d2 = (double)n5 / (double)n4;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            n6 = n2;
            if (!((double)n2 * d2 < (double)n3)) return n6;
            return (int)((double)n3 / d2);
        }
        n6 = n2;
        if (!((double)n2 * d2 > (double)n3)) return n6;
        return (int)((double)n3 / d2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void deliverResponse(Bitmap bitmap) {
        float f2 = 0.0f;
        Bitmap bitmap2 = bitmap;
        if (bitmap != null) {
            bitmap2 = bitmap;
            switch (this.mDrawShape) {
                default: {
                    bitmap2 = bitmap;
                }
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    float f3;
                    float f4;
                    bitmap2 = Bitmap.createBitmap((int)this.mMaxWidth, (int)this.mMaxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    RectF rectF = new RectF(0.0f, 0.0f, (float)this.mMaxWidth, (float)this.mMaxHeight);
                    Canvas canvas = new Canvas(bitmap2);
                    BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    if (bitmap.getWidth() * this.mMaxHeight > this.mMaxWidth * bitmap.getHeight()) {
                        f4 = (float)this.mMaxHeight / (float)bitmap.getHeight();
                        f3 = ((float)this.mMaxWidth - (float)bitmap.getWidth() * f4) * 0.5f;
                    } else {
                        f4 = (float)this.mMaxWidth / (float)bitmap.getWidth();
                        f2 = this.mMaxHeight;
                        float f5 = bitmap.getHeight();
                        f3 = 0.0f;
                        f2 = (f2 - f5 * f4) * 0.5f;
                    }
                    Matrix matrix = new Matrix();
                    matrix.setScale(f4, f4);
                    matrix.postTranslate(f3, f2);
                    bitmapShader.setLocalMatrix(matrix);
                    matrix = new Paint();
                    matrix.setAntiAlias(true);
                    matrix.setShader((Shader)bitmapShader);
                    if (this.mDrawShape == 1) {
                        canvas.drawRoundRect(rectF, (float)(this.mMaxWidth / 2), (float)(this.mMaxHeight / 2), (Paint)matrix);
                    } else {
                        canvas.drawRoundRect(rectF, (float)(this.mMaxWidth / 8), (float)(this.mMaxHeight / 8), (Paint)matrix);
                    }
                    bitmap.recycle();
                }
            }
        }
        this.mListener.onResponse((Object)bitmap2);
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Response<Bitmap> parseLocalResponse(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            options.inPreferredConfig = this.mDecodeConfig;
            string2 = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        } else {
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
            int n2 = options.outWidth;
            int n3 = options.outHeight;
            int n4 = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, n2, n3, this.mScaleType);
            int n5 = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, n3, n2, this.mScaleType);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageRequest.findBestSampleSize(n2, n3, n4, n5) * 2;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            if ((string2 = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options)) != null && (string2.getWidth() > n4 || string2.getHeight() > n5)) {
                options = Bitmap.createScaledBitmap((Bitmap)string2, (int)n4, (int)n5, (boolean)true);
                string2.recycle();
                string2 = options;
            }
        }
        if (string2 != null) return Response.success((Object)string2);
        return Response.error((VolleyError)new VolleyError());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Response<Bitmap> parseNetworkResponse(NetworkResponse parseError) {
        Object object = sDecodeLock;
        synchronized (object) {
            try {
                ParseError parseError2 = this.doParse((NetworkResponse)parseError);
                return parseError2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                VolleyLog.e((String)"Caught OOM for %d byte image, url=%s", (Object[])new Object[]{parseError.data.length, this.getUrl()});
                parseError = new ParseError((Throwable)outOfMemoryError);
                return Response.error((VolleyError)parseError);
            }
        }
    }
}

