/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.reflect;

import com.google.gson.internal.;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeToken<T> {
    final int hashCode;
    final Class<? super T> rawType;
    final Type type;

    protected TypeToken() {
        this.type = TypeToken.getSuperclassTypeParameter(this.getClass());
        this.rawType = .Gson.Types.getRawType((Type)this.type);
        this.hashCode = this.type.hashCode();
    }

    TypeToken(Type type) {
        this.type = .Gson.Types.canonicalize((Type)((Type).Gson.Preconditions.checkNotNull((Object)type)));
        this.rawType = .Gson.Types.getRawType((Type)this.type);
        this.hashCode = this.type.hashCode();
    }

    private static AssertionError buildUnexpectedTypeError(Type type, Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("Unexpected type. Expected one of: ");
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(classArray[i2].getName()).append(", ");
        }
        stringBuilder.append("but got: ").append(type.getClass().getName()).append(", for type token: ").append(type.toString()).append('.');
        return new AssertionError((Object)stringBuilder.toString());
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(clazz);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    static Type getSuperclassTypeParameter(Class<?> type) {
        if ((type = type.getGenericSuperclass()) instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return .Gson.Types.canonicalize((Type)((ParameterizedType)type).getActualTypeArguments()[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAssignableFrom(Type clazz, GenericArrayType type) {
        void var1_3;
        Type type2 = type.getGenericComponentType();
        if (!(type2 instanceof ParameterizedType)) return true;
        if (clazz instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)((Object)clazz)).getGenericComponentType();
            return TypeToken.isAssignableFrom((Type)var1_3, (ParameterizedType)type2, new HashMap<String, Type>());
        }
        Class<?> clazz2 = clazz;
        if (!(clazz instanceof Class)) return TypeToken.isAssignableFrom((Type)var1_3, (ParameterizedType)type2, new HashMap<String, Type>());
        while (true) {
            Class<?> clazz3 = clazz;
            if (!clazz.isArray()) return TypeToken.isAssignableFrom((Type)var1_3, (ParameterizedType)type2, new HashMap<String, Type>());
            clazz = clazz.getComponentType();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isAssignableFrom(Type object, ParameterizedType parameterizedType, Map<String, Type> map) {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        if (object == null) {
            return bl2;
        }
        if (parameterizedType.equals(object)) {
            return true;
        }
        Class clazz = .Gson.Types.getRawType((Type)object);
        if ((object = object instanceof ParameterizedType ? (ParameterizedType)object : null) != null) {
            Type[] typeArray = object.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                Type type = typeArray[n2];
                TypeVariable typeVariable = typeVariableArray[n2];
                while (type instanceof TypeVariable) {
                    type = map.get(((TypeVariable)type).getName());
                }
                map.put(typeVariable.getName(), type);
            }
            if (TypeToken.typeEquals((ParameterizedType)object, parameterizedType, map)) {
                return true;
            }
        }
        object = clazz.getGenericInterfaces();
        int n4 = ((Object)object).length;
        n2 = n3;
        while (n2 < n4) {
            if (TypeToken.isAssignableFrom((Type)object[n2], parameterizedType, new HashMap<String, Type>(map))) {
                return true;
            }
            ++n2;
        }
        return TypeToken.isAssignableFrom(clazz.getGenericSuperclass(), parameterizedType, new HashMap<String, Type>(map));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matches(Type type, Type type2, Map<String, Type> map) {
        if (type2.equals(type)) return true;
        if (!(type instanceof TypeVariable)) return false;
        if (!type2.equals(map.get(((TypeVariable)type).getName()))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean typeEquals(ParameterizedType typeArray, ParameterizedType typeArray2, Map<String, Type> map) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (!typeArray.getRawType().equals(typeArray2.getRawType())) return bl3;
        typeArray = typeArray.getActualTypeArguments();
        typeArray2 = typeArray2.getActualTypeArguments();
        int n2 = 0;
        while (n2 < typeArray.length) {
            if (!TypeToken.matches(typeArray[n2], typeArray2[n2], map)) {
                return bl2;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (!(object instanceof TypeToken)) return false;
        if (!.Gson.Types.equals((Type)this.type, (Type)((TypeToken)object).type)) return false;
        return true;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> typeToken) {
        return this.isAssignableFrom(typeToken.getType());
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom((Type)clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean isAssignableFrom(Type type) {
        boolean bl2 = false;
        if (type == null) {
            return bl2;
        }
        if (this.type.equals(type)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom(.Gson.Types.getRawType((Type)type));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(type, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (!(this.type instanceof GenericArrayType)) throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
        if (!this.rawType.isAssignableFrom(.Gson.Types.getRawType((Type)type))) return false;
        if (!TypeToken.isAssignableFrom(type, (GenericArrayType)this.type)) return false;
        return true;
    }

    public final String toString() {
        return .Gson.Types.typeToString((Type)this.type);
    }
}

