/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ProfileLevelIndicationDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

@Descriptor(tags={4})
public class DecoderConfigDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(DecoderConfigDescriptor.class.getName());
    AudioSpecificConfig audioSpecificInfo;
    long avgBitRate;
    int bufferSizeDB;
    byte[] configDescriptorDeadBytes;
    DecoderSpecificInfo decoderSpecificInfo;
    long maxBitRate;
    int objectTypeIndication;
    List<ProfileLevelIndicationDescriptor> profileLevelIndicationDescriptors = new ArrayList<ProfileLevelIndicationDescriptor>();
    int streamType;
    int upStream;

    public AudioSpecificConfig getAudioSpecificInfo() {
        return this.audioSpecificInfo;
    }

    public long getAvgBitRate() {
        return this.avgBitRate;
    }

    public int getBufferSizeDB() {
        return this.bufferSizeDB;
    }

    public DecoderSpecificInfo getDecoderSpecificInfo() {
        return this.decoderSpecificInfo;
    }

    public long getMaxBitRate() {
        return this.maxBitRate;
    }

    public int getObjectTypeIndication() {
        return this.objectTypeIndication;
    }

    public List<ProfileLevelIndicationDescriptor> getProfileLevelIndicationDescriptors() {
        return this.profileLevelIndicationDescriptors;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public int getUpStream() {
        return this.upStream;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        Integer n2;
        Object object;
        Object object2;
        Object object3;
        this.objectTypeIndication = IsoTypeReader.readUInt8((ByteBuffer)byteBuffer);
        int n3 = IsoTypeReader.readUInt8((ByteBuffer)byteBuffer);
        this.streamType = n3 >>> 2;
        this.upStream = n3 >> 1 & 1;
        this.bufferSizeDB = IsoTypeReader.readUInt24((ByteBuffer)byteBuffer);
        this.maxBitRate = IsoTypeReader.readUInt32((ByteBuffer)byteBuffer);
        this.avgBitRate = IsoTypeReader.readUInt32((ByteBuffer)byteBuffer);
        if (byteBuffer.remaining() > 2) {
            n3 = byteBuffer.position();
            object3 = ObjectDescriptorFactory.createFrom((int)this.objectTypeIndication, (ByteBuffer)byteBuffer);
            int n4 = byteBuffer.position() - n3;
            object2 = log;
            object = new StringBuilder().append(object3).append(" - DecoderConfigDescr1 read: ").append(n4).append(", size: ");
            n2 = object3 != null ? Integer.valueOf(((BaseDescriptor)object3).getSize()) : null;
            ((Logger)object2).finer(((StringBuilder)object).append(n2).toString());
            if (object3 != null && n4 < (n3 = ((BaseDescriptor)object3).getSize())) {
                this.configDescriptorDeadBytes = new byte[n3 - n4];
                byteBuffer.get(this.configDescriptorDeadBytes);
            }
            if (object3 instanceof DecoderSpecificInfo) {
                this.decoderSpecificInfo = (DecoderSpecificInfo)object3;
            }
            if (object3 instanceof AudioSpecificConfig) {
                this.audioSpecificInfo = (AudioSpecificConfig)object3;
            }
        }
        while (byteBuffer.remaining() > 2) {
            long l2 = byteBuffer.position();
            object = ObjectDescriptorFactory.createFrom((int)this.objectTypeIndication, (ByteBuffer)byteBuffer);
            long l3 = byteBuffer.position();
            object3 = log;
            object2 = new StringBuilder().append(object).append(" - DecoderConfigDescr2 read: ").append(l3 - l2).append(", size: ");
            n2 = object != null ? Integer.valueOf(((BaseDescriptor)object).getSize()) : null;
            ((Logger)object3).finer(((StringBuilder)object2).append(n2).toString());
            if (!(object instanceof ProfileLevelIndicationDescriptor)) continue;
            this.profileLevelIndicationDescriptors.add((ProfileLevelIndicationDescriptor)object);
        }
        return;
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)4);
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)(this.serializedSize() - 2));
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)this.objectTypeIndication);
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)(this.streamType << 2 | this.upStream << 1 | 1));
        IsoTypeWriter.writeUInt24((ByteBuffer)byteBuffer, (int)this.bufferSizeDB);
        IsoTypeWriter.writeUInt32((ByteBuffer)byteBuffer, (long)this.maxBitRate);
        IsoTypeWriter.writeUInt32((ByteBuffer)byteBuffer, (long)this.avgBitRate);
        byteBuffer.put(this.audioSpecificInfo.serialize().array());
        return byteBuffer;
    }

    public int serializedSize() {
        return this.audioSpecificInfo.serializedSize() + 15;
    }

    public void setAudioSpecificInfo(AudioSpecificConfig audioSpecificConfig) {
        this.audioSpecificInfo = audioSpecificConfig;
    }

    public void setAvgBitRate(long l2) {
        this.avgBitRate = l2;
    }

    public void setBufferSizeDB(int n2) {
        this.bufferSizeDB = n2;
    }

    public void setMaxBitRate(long l2) {
        this.maxBitRate = l2;
    }

    public void setObjectTypeIndication(int n2) {
        this.objectTypeIndication = n2;
    }

    public void setStreamType(int n2) {
        this.streamType = n2;
    }

    public void setUpStream(int n2) {
        this.upStream = n2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public String toString() {
        void var3_6;
        void var3_4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DecoderConfigDescriptor");
        stringBuilder.append("{objectTypeIndication=").append(this.objectTypeIndication);
        stringBuilder.append(", streamType=").append(this.streamType);
        stringBuilder.append(", upStream=").append(this.upStream);
        stringBuilder.append(", bufferSizeDB=").append(this.bufferSizeDB);
        stringBuilder.append(", maxBitRate=").append(this.maxBitRate);
        stringBuilder.append(", avgBitRate=").append(this.avgBitRate);
        stringBuilder.append(", decoderSpecificInfo=").append(this.decoderSpecificInfo);
        stringBuilder.append(", audioSpecificInfo=").append(this.audioSpecificInfo);
        StringBuilder stringBuilder2 = stringBuilder.append(", configDescriptorDeadBytes=");
        if (this.configDescriptorDeadBytes != null) {
            byte[] byArray = this.configDescriptorDeadBytes;
        } else {
            byte[] byArray = new byte[]{};
        }
        stringBuilder2.append(Hex.encodeHex((byte[])var3_4));
        stringBuilder2 = stringBuilder.append(", profileLevelIndicationDescriptors=");
        if (this.profileLevelIndicationDescriptors == null) {
            String string2 = "null";
        } else {
            String string3 = Arrays.asList(this.profileLevelIndicationDescriptors).toString();
        }
        stringBuilder2.append((String)var3_6);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

