/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenessdetection;

import org.json.JSONException;
import org.json.JSONObject;

public final class DetectionConfig {
    public final float eyeOpenThreshold;
    public final float gaussianBlur;
    public final float integrity;
    public final int maxBrightness;
    public final int minBrightness;
    public final float minFaceSize;
    public final float motionBlur;
    public final float mouthOpenThreshold;
    public final float pitchAngle;
    public final long timeout;
    public final float yawAngle;

    private DetectionConfig(Builder builder) {
        this.gaussianBlur = builder.f;
        this.motionBlur = builder.e;
        this.pitchAngle = builder.b;
        this.yawAngle = builder.a;
        this.minBrightness = builder.c;
        this.maxBrightness = builder.d;
        this.minFaceSize = builder.g;
        this.timeout = builder.h;
        this.eyeOpenThreshold = builder.i;
        this.mouthOpenThreshold = builder.j;
        this.integrity = builder.k;
    }

    /* synthetic */ DetectionConfig(Builder builder, byte by) {
        this(builder);
    }

    @Deprecated
    public final float getEyeOpenThreshold() {
        return this.eyeOpenThreshold;
    }

    @Deprecated
    public final float getGaussianBlur() {
        return this.gaussianBlur;
    }

    @Deprecated
    public final int getMaxBrightness() {
        return this.maxBrightness;
    }

    @Deprecated
    public final int getMinBrightness() {
        return this.minBrightness;
    }

    @Deprecated
    public final float getMinFaceSize() {
        return this.minFaceSize;
    }

    @Deprecated
    public final float getMotionBlur() {
        return this.motionBlur;
    }

    @Deprecated
    public final float getMouthOpenThreshold() {
        return this.mouthOpenThreshold;
    }

    @Deprecated
    public final float getPitchAngle() {
        return this.pitchAngle;
    }

    @Deprecated
    public final long getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public final float getYawAngle() {
        return this.yawAngle;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String toJsonString() {
        void var1_3;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("gaussianBlur", (double)this.gaussianBlur);
            jSONObject.put("motionBlur", (double)this.motionBlur);
            jSONObject.put("pitchAngle", (double)this.pitchAngle);
            jSONObject.put("yawAngle", (double)this.yawAngle);
            jSONObject.put("minBrightness", this.minBrightness);
            jSONObject.put("maxBrightness", this.maxBrightness);
            jSONObject.put("minFaceSize", (double)this.minFaceSize);
            jSONObject.put("timeout", this.timeout);
            jSONObject.put("eyeOpenThreshold", (double)this.eyeOpenThreshold);
            jSONObject.put("mouthOpenThreshold", (double)this.mouthOpenThreshold);
            jSONObject.put("integrity", (double)this.integrity);
            String string2 = jSONObject.toString();
            return var1_3;
        }
        catch (JSONException jSONException) {
            return var1_3;
        }
    }

    public static final class Builder {
        private float a = 0.17f;
        private float b = 0.17f;
        private int c = 80;
        private int d = 170;
        private float e = 0.1f;
        private float f = 0.08f;
        private float g = 150.0f;
        private int h = 10000;
        private float i = 0.3f;
        private float j = 0.4f;
        private float k = 0.9f;

        public final DetectionConfig build() {
            return new DetectionConfig(this, 0);
        }

        public final Builder setBlur(float f2, float f3) {
            this.f = f2;
            this.e = f3;
            return this;
        }

        public final Builder setBrightness(int n2, int n3) {
            this.c = n2;
            this.d = n3;
            return this;
        }

        public final Builder setDetectionTimeout(int n2) {
            this.h = n2;
            return this;
        }

        public final Builder setEyeHwratio(float f2) {
            this.i = f2;
            return this;
        }

        public final Builder setIntegrity(float f2) {
            this.k = f2;
            return this;
        }

        public final Builder setMaxAngle(float f2, float f3, float f4) {
            this.b = f2;
            this.a = f3;
            return this;
        }

        public final Builder setMinFaceSize(int n2) {
            this.g = n2;
            return this;
        }

        public final Builder setMouthHwratio(float f2) {
            this.j = f2;
            return this;
        }
    }
}

