/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.RouteDatabase;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.StreamAllocation;
import com.squareup.okhttp.internal.io.RealConnection;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final long DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final ConnectionPool systemDefault;
    private Runnable cleanupRunnable;
    private final Deque<RealConnection> connections;
    private final Executor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory((String)"OkHttp ConnectionPool", (boolean)true));
    private final long keepAliveDurationNs;
    private final int maxIdleConnections;
    final RouteDatabase routeDatabase;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !ConnectionPool.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
        String string2 = System.getProperty("http.keepAlive");
        String string3 = System.getProperty("http.keepAliveDuration");
        String string4 = System.getProperty("http.maxConnections");
        long l2 = string3 != null ? Long.parseLong(string3) : 300000L;
        if (string2 != null && !Boolean.parseBoolean(string2)) {
            systemDefault = new ConnectionPool(0, l2);
            return;
        }
        if (string4 != null) {
            systemDefault = new ConnectionPool(Integer.parseInt(string4), l2);
            return;
        }
        systemDefault = new ConnectionPool(5, l2);
    }

    public ConnectionPool(int n2, long l2) {
        this(n2, l2, TimeUnit.MILLISECONDS);
    }

    public ConnectionPool(int n2, long l2, TimeUnit timeUnit) {
        this.cleanupRunnable = new 1(this);
        this.connections = new ArrayDeque<RealConnection>();
        this.routeDatabase = new RouteDatabase();
        this.maxIdleConnections = n2;
        this.keepAliveDurationNs = timeUnit.toNanos(l2);
        if (l2 <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration <= 0: " + l2);
        }
    }

    public static ConnectionPool getDefault() {
        return systemDefault;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pruneAndGetAllocationCount(RealConnection realConnection, long l2) {
        int n2;
        block3: {
            n2 = 0;
            List list = realConnection.allocations;
            int n3 = 0;
            while (n3 < list.size()) {
                if (((Reference)list.get(n3)).get() != null) {
                    ++n3;
                    continue;
                }
                Internal.logger.warning("A connection to " + realConnection.getRoute().getAddress().url() + " was leaked. Did you forget to close a response body?");
                list.remove(n3);
                realConnection.noNewStreams = true;
                if (!list.isEmpty()) {
                    continue;
                }
                break block3;
            }
            return list.size();
        }
        realConnection.idleAtNanos = l2 - this.keepAliveDurationNs;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long cleanup(long l2) {
        RealConnection realConnection = null;
        long l3 = Long.MIN_VALUE;
        synchronized (this) {
            Iterator<RealConnection> iterator = this.connections.iterator();
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                RealConnection realConnection2 = iterator.next();
                if (this.pruneAndGetAllocationCount(realConnection2, l2) > 0) {
                    ++n3;
                    continue;
                }
                long l4 = l2 - realConnection2.idleAtNanos;
                if (l4 > l3) {
                    realConnection = realConnection2;
                    l3 = l4;
                }
                ++n2;
            }
            if (l3 >= this.keepAliveDurationNs || n2 > this.maxIdleConnections) {
                this.connections.remove(realConnection);
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl21 : MonitorExitStatement: MONITOREXIT : this
                Util.closeQuietly((Socket)realConnection.getSocket());
                return 0L;
            }
            if (n2 > 0) {
                return this.keepAliveDurationNs - l3;
            }
            if (n3 <= 0) return -1L;
            return this.keepAliveDurationNs;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean connectionBecameIdle(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (realConnection.noNewStreams || this.maxIdleConnections == 0) {
            this.connections.remove(realConnection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evictAll() {
        Object object = new ArrayList();
        synchronized (this) {
            Iterator<RealConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                RealConnection realConnection = iterator.next();
                if (!realConnection.allocations.isEmpty()) continue;
                realConnection.noNewStreams = true;
                object.add(realConnection);
                iterator.remove();
            }
        }
        object = object.iterator();
        while (object.hasNext()) {
            Util.closeQuietly((Socket)((RealConnection)object.next()).getSocket());
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RealConnection get(Address address, StreamAllocation streamAllocation) {
        RealConnection realConnection;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Iterator<RealConnection> iterator = this.connections.iterator();
        do {
            if (!iterator.hasNext()) return null;
            realConnection = iterator.next();
        } while (realConnection.allocations.size() >= realConnection.allocationLimit() || !address.equals(realConnection.getRoute().address) || realConnection.noNewStreams);
        streamAllocation.acquire(realConnection);
        return realConnection;
    }

    public int getConnectionCount() {
        synchronized (this) {
            int n2 = this.connections.size();
            return n2;
        }
    }

    public int getHttpConnectionCount() {
        synchronized (this) {
            int n2 = this.connections.size();
            int n3 = this.getMultiplexedConnectionCount();
            return n2 - n3;
        }
    }

    public int getIdleConnectionCount() {
        synchronized (this) {
            int n2 = 0;
            Iterator<RealConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = iterator.next().allocations.isEmpty();
                if (!bl2) continue;
                ++n2;
            }
            return n2;
        }
    }

    public int getMultiplexedConnectionCount() {
        synchronized (this) {
            int n2 = 0;
            Iterator<RealConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = iterator.next().isMultiplexed();
                if (!bl2) continue;
                ++n2;
            }
            return n2;
        }
    }

    @Deprecated
    public int getSpdyConnectionCount() {
        synchronized (this) {
            int n2 = this.getMultiplexedConnectionCount();
            return n2;
        }
    }

    void put(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.connections.isEmpty()) {
            this.executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    void setCleanupRunnableForTest(Runnable runnable) {
        this.cleanupRunnable = runnable;
    }
}

