/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.Log;
import com.wuba.recorder.util.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class WBCommonUtils {
    private static final String DEBUG_TAG = "GalleryDebug";
    private static final long INITIALCRC = -1L;
    private static final boolean IS_DEBUG_BUILD;
    private static final String MASK_STRING = "********************************";
    private static final long POLY64REV = -7661587058870466123L;
    private static final String TAG = "WBCommonUtils";
    public static long mConfigFileTime;
    public static Context mContext;
    public static String mCurStoragePath;
    private static long[] sCrcTable;

    /*
     * Enabled aggressive block sorting
     */
    static {
        sCrcTable = new long[256];
        boolean bl2 = Build.TYPE.equals("eng") || Build.TYPE.equals("userdebug");
        IS_DEBUG_BUILD = bl2;
        int n2 = 0;
        while (true) {
            if (n2 >= 256) {
                mCurStoragePath = null;
                mConfigFileTime = 0L;
                return;
            }
            long l2 = n2;
            for (int i2 = 0; i2 < 8; ++i2) {
                long l3 = ((int)l2 & 1) != 0 ? -7661587058870466123L : 0L;
                l2 = l3 ^ l2 >> 1;
            }
            WBCommonUtils.sCrcTable[n2] = l2;
            ++n2;
        }
    }

    public static void assertTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError();
        }
    }

    public static int ceilLog2(float f2) {
        int n2 = 0;
        while (n2 < 31 && !((float)(1 << n2) >= f2)) {
            ++n2;
        }
        return n2;
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float clamp(float f2, float f3, float f4) {
        if (f2 > f4) {
            return f4;
        }
        if (!(f2 < f3)) return f2;
        return f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int clamp(int n2, int n3, int n4) {
        if (n2 > n4) {
            return n4;
        }
        if (n2 >= n3) return n2;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long clamp(long l2, long l3, long l4) {
        if (l2 > l4) {
            return l4;
        }
        if (l2 >= l3) return l2;
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeSilently(Cursor cursor) {
        if (cursor == null) return;
        try {
            cursor.close();
            return;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"fail to close", (Throwable)throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeSilently(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) return;
        try {
            parcelFileDescriptor.close();
            return;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"fail to close", (Throwable)throwable);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"close fail", (Throwable)throwable);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compare(long l2, long l3) {
        if (l2 < l3) {
            return -1;
        }
        if (l2 != l3) return 1;
        return 0;
    }

    public static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, n2));
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long crc64Long(String string2) {
        if (string2 == null) return 0L;
        if (string2.length() != 0) return WBCommonUtils.crc64Long(WBCommonUtils.getBytes(string2));
        return 0L;
    }

    public static final long crc64Long(byte[] byArray) {
        long l2 = -1L;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 >> 8 ^ sCrcTable[((int)l2 ^ byArray[i2]) & 0xFF];
        }
        return l2;
    }

    public static void debug(String string2, Object ... objectArray) {
        LogUtils.v((String)DEBUG_TAG, (String)String.format(string2, objectArray));
    }

    public static String ensureNotNull(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Object object, Object object2) {
        if (object == object2) return true;
        if (object == null) {
            return false;
        }
        if (!object.equals(object2)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escapeXml(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string2.length();
        while (n2 < n3) {
            char c2 = string2.charAt(n2);
            switch (c2) {
                default: {
                    stringBuilder.append(c2);
                    break;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&#039;");
                    break;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fail(String string2, Object ... objectArray) {
        if (objectArray.length == 0) {
            throw new AssertionError((Object)string2);
        }
        string2 = String.format(string2, objectArray);
        throw new AssertionError((Object)string2);
    }

    public static int floorLog2(float f2) {
        int n2 = 0;
        while (n2 < 31 && !((float)(1 << n2) > f2)) {
            ++n2;
        }
        return n2 - 1;
    }

    public static byte[] getBytes(String object) {
        byte[] byArray = new byte[((String)object).length() * 2];
        object = ((String)object).toCharArray();
        int n2 = ((Object)object).length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            int n4 = n3 + 1;
            byArray[n3] = (byte)(object2 & 0xFF);
            n3 = n4 + 1;
            byArray[n4] = (byte)(object2 >> 8);
        }
        return byArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getConfigStorageDir() {
        SharedPreferences sharedPreferences;
        String string2;
        ArrayList<String> arrayList;
        if (Build.VERSION.SDK_INT < 12) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        try {
            arrayList = WBCommonUtils.getStoragePath(mContext);
            int n2 = Build.VERSION.SDK_INT;
            string2 = mContext;
            n2 = n2 > 8 ? 4 : 0;
            sharedPreferences = string2.getSharedPreferences("storage_config", n2);
            if ((string2 = sharedPreferences.getString("storagePath", "")).length() == 0) {
                if (arrayList == null) return Environment.getExternalStorageDirectory().getAbsolutePath();
                if (arrayList.size() <= 0) return Environment.getExternalStorageDirectory().getAbsolutePath();
                return arrayList.get(0);
            }
            if (arrayList != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    String string3 = arrayList.get(n2);
                    if (string3 == null || !string3.equalsIgnoreCase(string2)) continue;
                    return string2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        {
            string2 = sharedPreferences.edit();
            string2.clear();
            string2.commit();
            if (arrayList == null) return Environment.getExternalStorageDirectory().getAbsolutePath();
            if (arrayList.size() <= 0) return Environment.getExternalStorageDirectory().getAbsolutePath();
            return arrayList.get(0);
        }
    }

    public static String getCurrentStorageDir() {
        if (mCurStoragePath == null) {
            mCurStoragePath = WBCommonUtils.getConfigStorageDir();
        }
        return mCurStoragePath;
    }

    public static File getExternalCacheDir(Context object) {
        File file = object.getExternalCacheDir();
        object = file;
        if (file == null) {
            file = new File(WBCommonUtils.getCurrentStorageDir() + "/android/data/com.wuba.camera/cache");
            object = file;
            if (!file.exists()) {
                file.mkdirs();
                object = file;
            }
        }
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<String> getStoragePath(Context object) {
        Method method;
        Object object2;
        StorageManager storageManager;
        Object object3;
        block23: {
            object3 = null;
            storageManager = (StorageManager)object.getSystemService("storage");
            if (Build.VERSION.SDK_INT < 12) {
                object2 = new ArrayList<String>();
                ((ArrayList)object2).add(Environment.getExternalStorageDirectory().getAbsolutePath());
                return object2;
            }
            object = StorageManager.class.getDeclaredMethod("getVolumeList", null);
            method = StorageManager.class.getDeclaredMethod("getVolumeState", String.class);
            ((Method)object).setAccessible(true);
            method.setAccessible(true);
            break block23;
            catch (SecurityException securityException) {
                block25: {
                    method = null;
                    object = null;
                    break block25;
                    catch (NoSuchMethodException noSuchMethodException) {
                        block24: {
                            method = null;
                            object = null;
                            break block24;
                            catch (NoSuchMethodException noSuchMethodException2) {
                                method = null;
                                break block24;
                            }
                            catch (NoSuchMethodException noSuchMethodException3) {}
                        }
                        ((Throwable)object2).printStackTrace();
                    }
                    catch (SecurityException securityException2) {
                        method = null;
                        break block25;
                    }
                    catch (SecurityException securityException3) {}
                }
                ((Throwable)object2).printStackTrace();
            }
        }
        object2 = object3;
        if (method == null) return object2;
        if (object == null) {
            return object3;
        }
        try {
            object = (Object[])((Method)object).invoke((Object)storageManager, (Object[])null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            object = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            object = null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            object = null;
        }
        if (object == null) {
            LogUtils.e((String)TAG, (String)"storage == null");
            return object3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        object3 = null;
        int n2 = 0;
        object2 = null;
        while (true) {
            Object object4;
            block26: {
                if (n2 >= ((Object)object).length) {
                    return arrayList;
                }
                try {
                    object4 = object[n2].getClass().getDeclaredMethod("getPath", null);
                    ((Method)object4).setAccessible(true);
                    object4 = (String)((Method)object4).invoke(object[n2], (Object[])null);
                }
                catch (Exception exception) {}
                try {
                    object3 = object2 = (String)method.invoke((Object)storageManager, object4);
                    object2 = object4;
                    break block26;
                }
                catch (Exception exception) {
                    object2 = object4;
                }
                {
                    LogUtils.e((String)TAG, (String)"Failed to get inner sdcard");
                }
            }
            if (object2 != null && object3 != null && ((String)object3).equals("mounted") && ((File)(object4 = new File((String)object2))).exists()) {
                arrayList.add(((File)object4).getAbsolutePath());
            }
            ++n2;
        }
    }

    public static String getUserAgent(Context context) {
        try {
            context = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("getPackageInfo failed");
        }
        return String.format("%s/%s; %s/%s/%s/%s; %s/%s/%s", context.packageName, context.versionName, Build.BRAND, Build.DEVICE, Build.MODEL, Build.ID, Build.VERSION.SDK_INT, Build.VERSION.RELEASE, Build.VERSION.INCREMENTAL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean handleInterrruptedException(Throwable throwable) {
        if (!(throwable instanceof InterruptedIOException)) {
            if (!(throwable instanceof InterruptedException)) return false;
        }
        Thread.currentThread().interrupt();
        return true;
    }

    public static float interpolateAngle(float f2, float f3, float f4) {
        float f5;
        f3 = f5 = f3 - f2;
        if (f5 < 0.0f) {
            f3 = f5 + 360.0f;
        }
        f5 = f3;
        if (f3 > 180.0f) {
            f5 = f3 - 360.0f;
        }
        f2 = f3 = f5 * f4 + f2;
        if (f3 < 0.0f) {
            f2 = f3 + 360.0f;
        }
        return f2;
    }

    public static float interpolateScale(float f2, float f3, float f4) {
        return (f3 - f2) * f4 + f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isConfigChanged() {
        boolean bl2 = false;
        int n2 = Build.VERSION.SDK_INT;
        Object object = mContext;
        n2 = n2 > 8 ? 4 : 0;
        object = object.getSharedPreferences("storage_config", n2).getString("storagePath", "");
        if (mCurStoragePath == null && ((String)object).length() == 0) {
            return bl2;
        }
        if (mCurStoragePath == null) return true;
        if (((String)object).equalsIgnoreCase(mCurStoragePath)) return bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMediaType(String string2) {
        if (string2.endsWith(".jpg")) return true;
        if (string2.endsWith(".jpeg")) return true;
        if (string2.endsWith(".gif")) return true;
        if (string2.endsWith(".png")) return true;
        if (string2.endsWith(".bmp")) return true;
        if (string2.endsWith(".wbmp")) return true;
        if (string2.endsWith(".webp")) return true;
        if (string2.endsWith(".mp4")) return true;
        if (string2.endsWith(".3gp")) return true;
        if (string2.endsWith(".m4v")) return true;
        if (string2.endsWith(".rm")) return true;
        if (string2.endsWith(".mpg")) return true;
        if (string2.endsWith(".wmv")) return true;
        if (string2.endsWith(".rmvb")) return true;
        if (string2.endsWith(".webm")) return true;
        if (!string2.endsWith(".avi")) return false;
        return true;
    }

    public static boolean isNullOrEmpty(String string2) {
        return TextUtils.isEmpty((CharSequence)string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOpaque(int n2) {
        if (n2 >>> 24 != 255) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isStorageExists(String string2) {
        boolean bl2 = false;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            File file = new File(stringBuilder.append(string2).append("/.tmp.dat").toString());
            if (file.exists()) return true;
            boolean bl3 = file.createNewFile();
            if (!bl3) return bl2;
            return true;
        }
        catch (Exception exception) {
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String maskDebugInfo(Object object) {
        if (object == null) {
            return null;
        }
        object = object.toString();
        int n2 = Math.min(((String)object).length(), MASK_STRING.length());
        if (IS_DEBUG_BUILD) return object;
        return MASK_STRING.substring(0, n2);
    }

    public static int nextPowerOf2(int n2) {
        if (n2 <= 0 || n2 > 0x40000000) {
            throw new IllegalArgumentException("n is invalid: " + n2);
        }
        --n2;
        n2 |= n2 >> 16;
        n2 |= n2 >> 8;
        n2 |= n2 >> 4;
        n2 |= n2 >> 2;
        return (n2 | n2 >> 1) + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float parseFloatSafely(String string2, float f2) {
        if (string2 == null) {
            return f2;
        }
        try {
            float f3 = Float.parseFloat(string2);
            return f3;
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseIntSafely(String string2, int n2) {
        if (string2 == null) {
            return n2;
        }
        try {
            int n3 = Integer.parseInt(string2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static int prevPowerOf2(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        return Integer.highestOneBit(n2);
    }

    public static void swap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void waitWithoutInterrupt(Object object) {
        try {
            object.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            LogUtils.w((String)TAG, (String)("unexpected interrupt: " + object));
            return;
        }
    }
}

