/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.network;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Process;
import android.text.TextUtils;
import com.xiaomi.channel.commonutils.network.d;
import com.xiaomi.network.Fallback;
import com.xiaomi.network.Fallbacks;
import com.xiaomi.network.HostFilter;
import com.xiaomi.network.a;
import com.xiaomi.network.b;
import com.xiaomi.network.c;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HostManager {
    private static HostManagerFactory factory;
    protected static boolean hostLoaded;
    protected static Map<String, ArrayList<String>> mReservedHosts;
    private static String sAppName;
    private static String sAppVersion;
    private static HostManager sInstance;
    private final long MAX_REQUEST_FAILURE_CNT;
    private String currentISP = "isp_prov_city_country_ip";
    private long lastRemoteRequestTimestamp = 0L;
    protected Map<String, Fallbacks> mHostsMapping = new HashMap<String, Fallbacks>();
    private long remoteRequestFailureCount = 0L;
    protected Context sAppContext;
    private HostFilter sHostFilter;
    protected HttpGet sHttpGetter;
    private String sUserId = "0";

    static {
        mReservedHosts = new HashMap<String, ArrayList<String>>();
        hostLoaded = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected HostManager(Context context, HostFilter hostFilter, HttpGet httpGet, String string2, String string3, String string4) {
        this.MAX_REQUEST_FAILURE_CNT = 15L;
        this.sAppContext = context.getApplicationContext();
        if (this.sAppContext == null) {
            this.sAppContext = context;
        }
        this.sHttpGetter = httpGet;
        this.sHostFilter = hostFilter == null ? new a(this) : hostFilter;
        this.sUserId = string2;
        if (string3 == null) {
            string3 = context.getPackageName();
        }
        sAppName = string3;
        if (string4 == null) {
            string4 = this.getVersionName();
        }
        sAppVersion = string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addReservedHost(String string2, String string3) {
        ArrayList<String> arrayList = mReservedHosts.get(string2);
        Map<String, ArrayList<String>> map = mReservedHosts;
        synchronized (map) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add(string3);
                mReservedHosts.put(string2, arrayList);
            } else if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HostManager getInstance() {
        synchronized (HostManager.class) {
            if (sInstance != null) return sInstance;
            IllegalStateException illegalStateException = new IllegalStateException("the host manager is not initialized yet.");
            throw illegalStateException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getVersionName() {
        String string2 = this.sAppContext.getPackageManager().getPackageInfo(this.sAppContext.getPackageName(), 16384);
        if (string2 == null) return "0";
        try {
            return ((PackageInfo)string2).versionName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Context context, HostFilter hostFilter, HttpGet httpGet, String string2, String string3, String string4) {
        synchronized (HostManager.class) {
            block9: {
                block8: {
                    HostManager hostManager;
                    if (sInstance != null) break block8;
                    if (factory != null) break block9;
                    sInstance = hostManager = new HostManager(context, hostFilter, httpGet, string2, string3, string4);
                }
                return;
            }
            sInstance = factory.a(context, hostFilter, httpGet, string2);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> String join(Collection<T> object, String string2) {
        if (object == null) return "";
        if (object.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            stringBuilder.append(object.next());
            if (!object.hasNext()) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String join(String[] object, String string2) {
        void var0_2;
        if (object == null || ((String[])object).length == 0) {
            String string3 = "";
            return var0_2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object[0]);
        for (int i2 = 1; i2 < ((String[])object).length; ++i2) {
            void var1_4;
            stringBuilder.append((String)var1_4);
            stringBuilder.append(object[i2]);
        }
        String string4 = stringBuilder.toString();
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ArrayList<Fallback> requestRemoteFallbacks(ArrayList<String> arrayList) {
        int n2;
        Object object3;
        Object object2;
        block24: {
            this.purge();
            object2 = this.mHostsMapping;
            // MONITORENTER : object2
            this.checkHostMapping();
            for (Object object3 : this.mHostsMapping.keySet()) {
                if (arrayList.contains(object3)) continue;
                arrayList.add((String)object3);
            }
            // MONITOREXIT : object2
            object2 = mReservedHosts;
            // MONITORENTER : object2
            for (Object object4 : mReservedHosts.keySet()) {
                if (arrayList.contains(object4)) continue;
                arrayList.add((String)object4);
            }
            // MONITOREXIT : object2
            if (!arrayList.contains(this.getHost())) {
                arrayList.add(this.getHost());
            }
            object3 = new ArrayList<Fallback>(arrayList.size());
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ((ArrayList)object3).add(null);
            }
            try {
                Object object5;
                Object object4;
                object2 = d.f(this.sAppContext) ? "wifi" : "wap";
                object4 = this.getRemoteFallbackJSON(arrayList, (String)object2, this.sUserId);
                if (TextUtils.isEmpty((CharSequence)object4) || !"OK".equalsIgnoreCase((object5 = new JSONObject((String)object4)).getString("S"))) break block24;
                JSONObject jSONObject = object5.getJSONObject("R");
                String string2 = jSONObject.getString("province");
                String string3 = jSONObject.getString("city");
                String string4 = jSONObject.getString("isp");
                object5 = jSONObject.getString("ip");
                String string5 = jSONObject.getString("country");
                JSONObject jSONObject2 = jSONObject.getJSONObject((String)object2);
                object4 = object2;
                if (((String)object2).equals("wap")) {
                    object4 = this.getActiveNetworkLabel();
                }
                object2 = new StringBuilder();
                com.xiaomi.channel.commonutils.logger.b.a(((StringBuilder)object2).append("get bucket: ip = ").append((String)object5).append(" net = ").append(string4).append((String)object4).append(" hosts = ").append(jSONObject2.toString()).toString());
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    Object object6 = arrayList.get(n2);
                    object2 = jSONObject2.optJSONArray((String)object6);
                    if (object2 == null) {
                        object2 = new StringBuilder();
                        com.xiaomi.channel.commonutils.logger.b.a(((StringBuilder)object2).append("no bucket found for ").append((String)object6).toString());
                        continue;
                    }
                    object4 = new Fallback((String)object6);
                    for (int i2 = 0; i2 < object2.length(); ++i2) {
                        String string6 = object2.getString(i2);
                        if (TextUtils.isEmpty((CharSequence)string6)) continue;
                        object6 = new c(string6, object2.length() - i2);
                        ((Fallback)object4).a((c)object6);
                    }
                    ((ArrayList)object3).set(n2, (Fallback)object4);
                    ((Fallback)object4).g = string5;
                    ((Fallback)object4).c = string2;
                    ((Fallback)object4).e = string4;
                    ((Fallback)object4).f = object5;
                    ((Fallback)object4).d = string3;
                    if (jSONObject.has("stat-percent")) {
                        ((Fallback)object4).a(jSONObject.getDouble("stat-percent"));
                    }
                    if (jSONObject.has("stat-domain")) {
                        ((Fallback)object4).b(jSONObject.getString("stat-domain"));
                    }
                    if (jSONObject.has("ttl")) {
                        ((Fallback)object4).a((long)jSONObject.getInt("ttl") * 1000L);
                    }
                    this.setCurrentISP(((Fallback)object4).e());
                }
            }
            catch (Exception exception) {
                com.xiaomi.channel.commonutils.logger.b.a("failed to get bucket " + exception.getMessage());
            }
            {
                continue;
                break;
            }
        }
        n2 = 0;
        while (true) {
            if (n2 >= arrayList.size()) {
                this.persist();
                return object3;
            }
            object2 = (Fallback)((ArrayList)object3).get(n2);
            if (object2 != null) {
                this.updateFallbacks(arrayList.get(n2), (Fallback)object2);
            }
            ++n2;
        }
    }

    public static void setHostManagerFactory(HostManagerFactory hostManagerFactory) {
        synchronized (HostManager.class) {
            factory = hostManagerFactory;
            sInstance = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkHostMapping() {
        boolean bl2 = true;
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            if (hostLoaded) return bl2;
            hostLoaded = true;
            this.mHostsMapping.clear();
            try {
                String string2 = this.loadHosts();
                if (TextUtils.isEmpty((CharSequence)string2)) return false;
                this.fromJSON(string2);
                com.xiaomi.channel.commonutils.logger.b.a("loading the new hosts succeed");
                return bl2;
            }
            catch (Throwable throwable) {
                StringBuilder stringBuilder = new StringBuilder();
                com.xiaomi.channel.commonutils.logger.b.a(stringBuilder.append("load host exception ").append(throwable.getMessage()).toString());
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fromJSON(String object) {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
            JSONArray jSONArray = new JSONArray((String)object);
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                object = new Fallbacks();
                object = ((Fallbacks)object).fromJSON(jSONArray.getJSONObject(n2));
                this.mHostsMapping.put(((Fallbacks)object).getHost(), (Fallbacks)object);
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getActiveNetworkLabel() {
        if (this.sAppContext == null) {
            return "unknown";
        }
        try {
            CharSequence charSequence = (ConnectivityManager)this.sAppContext.getSystemService("connectivity");
            if (charSequence == null) {
                return "unknown";
            }
            Object object = charSequence.getActiveNetworkInfo();
            if (object == null) {
                return "unknown";
            }
            if (object.getType() != 1) {
                charSequence = new StringBuilder();
                return ((StringBuilder)charSequence).append(object.getTypeName()).append("-").append(object.getSubtypeName()).toString();
            }
            charSequence = (WifiManager)this.sAppContext.getSystemService("wifi");
            if (charSequence == null) return "unknown";
            if (charSequence.getConnectionInfo() == null) return "unknown";
            object = new StringBuilder();
            return ((StringBuilder)object).append("WIFI-").append(charSequence.getConnectionInfo().getSSID()).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown";
    }

    public Fallback getFallbacksByHost(String string2) {
        return this.getFallbacksByHost(string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Fallback getFallbacksByHost(String string2, boolean bl2) {
        Fallback fallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("the host is empty");
        }
        if (!this.sHostFilter.a(string2)) {
            return null;
        }
        Fallback fallback2 = this.getLocalFallback(string2);
        if (fallback2 != null) {
            fallback = fallback2;
            if (fallback2.b()) return fallback;
        }
        if (!bl2) return new b(this, string2, fallback2);
        if (!d.d(this.sAppContext)) return new b(this, string2, fallback2);
        fallback = this.requestRemoteFallback(string2);
        if (fallback == null) return new b(this, string2, fallback2);
        return fallback;
    }

    public Fallback getFallbacksByURL(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("the url is empty");
        }
        return this.getFallbacksByHost(new URL(string2).getHost(), true);
    }

    protected String getHost() {
        return "resolver.gslb.mi-idc.com";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Fallback getLocalFallback(String object) {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.checkHostMapping();
            object = this.mHostsMapping.get(object);
        }
        if (object == null) return null;
        if ((object = ((Fallbacks)object).getFallback()) == null) return null;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getProcessName() {
        Object object = ((ActivityManager)this.sAppContext.getSystemService("activity")).getRunningAppProcesses();
        if (object == null) return "com.xiaomi";
        Iterator iterator = object.iterator();
        do {
            if (!iterator.hasNext()) return "com.xiaomi";
            object = (ActivityManager.RunningAppProcessInfo)iterator.next();
        } while (((ActivityManager.RunningAppProcessInfo)object).pid != Process.myPid());
        return ((ActivityManager.RunningAppProcessInfo)object).processName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getRemoteFallbackJSON(ArrayList<String> object, String object2, String iterator) {
        Object var4_5 = null;
        Object object3 = new ArrayList<ArrayList<String>>();
        ArrayList<com.xiaomi.channel.commonutils.network.a> arrayList = new ArrayList<com.xiaomi.channel.commonutils.network.a>();
        arrayList.add(new com.xiaomi.channel.commonutils.network.a("type", (String)object2));
        arrayList.add(new com.xiaomi.channel.commonutils.network.a("uuid", (String)((Object)iterator)));
        arrayList.add(new com.xiaomi.channel.commonutils.network.a("list", HostManager.join(object, ",")));
        object2 = this.getLocalFallback("resolver.gslb.mi-idc.com");
        object = String.format("http://%1$s/gslb/gslb/getbucket.asp?ver=3.0", "resolver.gslb.mi-idc.com");
        if (object2 == null) {
            ((ArrayList)object3).add(object);
            object = object3;
        } else {
            object = ((Fallback)object2).a((String)object);
        }
        iterator = ((ArrayList)object).iterator();
        object2 = null;
        while (true) {
            if (!iterator.hasNext()) {
                object = var4_5;
                if (object2 == null) return object;
                throw object2;
            }
            object = Uri.parse((String)iterator.next()).buildUpon();
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object3 = (com.xiaomi.channel.commonutils.network.c)object2.next();
                object.appendQueryParameter(object3.a(), object3.b());
            }
            try {
                if (this.sHttpGetter != null) return this.sHttpGetter.a(object.toString());
                object2 = this.sAppContext;
                object3 = new URL(object.toString());
                return d.a((Context)object2, (URL)object3);
            }
            catch (IOException iOException) {
                com.xiaomi.channel.commonutils.logger.b.a("network ioErr: " + iOException.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String loadHosts() {
        block9: {
            block10: {
                var1_1 = null;
                var2_2 = new File(this.sAppContext.getFilesDir(), this.getProcessName());
                if (!var2_2.isFile()) break block9;
                var5_11 = new FileInputStream((File)var2_2);
                var4_7 = new InputStreamReader((InputStream)var5_11);
                var3_3 = new BufferedReader((Reader)var4_7);
                var2_2 = var3_3;
                try {
                    var2_2 = var3_3;
                    var4_7 = new StringBuilder();
                    while (true) {
                        var2_2 = var3_3;
                        var5_11 = var3_3.readLine();
                        if (var5_11 == null) break;
                        var2_2 = var3_3;
                        var4_7.append((String)var5_11);
                    }
                    var2_2 = var3_3;
                }
                catch (Throwable var4_8) {}
                var2_2 = var4_7 = var4_7.toString();
                break block10;
                ** GOTO lbl-1000
                {
                    catch (Throwable var3_6) {}
                }
            }
            com.xiaomi.channel.commonutils.file.a.a(var3_3);
            return var2_2;
        }
        com.xiaomi.channel.commonutils.file.a.a(null);
        return var1_1;
        catch (Throwable var3_4) {
            var2_2 = null;
            com.xiaomi.channel.commonutils.file.a.a((Reader)var2_2);
            throw var3_5;
        }
        catch (Throwable var4_10) {
            var3_3 = null;
        }
lbl-1000:
        // 2 sources

        {
            var2_2 = var3_3;
            var2_2 = var3_3;
            var5_11 = new StringBuilder();
            var2_2 = var3_3;
            com.xiaomi.channel.commonutils.logger.b.a(var5_11.append("load host exception ").append(var4_9.getMessage()).toString());
            com.xiaomi.channel.commonutils.file.a.a(var3_3);
            return var1_1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void persist() {
        this.purge();
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            try {
                Object object = this.sAppContext.openFileOutput(this.getProcessName(), 0);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                object = this.toJSON().toString();
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    bufferedWriter.write((String)object);
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void purge() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            Object object = this.mHostsMapping.values().iterator();
            while (object.hasNext()) {
                object.next().purge(false);
            }
            boolean bl2 = false;
            while (!bl2) {
                Iterator<String> iterator = this.mHostsMapping.keySet().iterator();
                do {
                    if (!iterator.hasNext()) return;
                } while (!this.mHostsMapping.get(object = iterator.next()).getFallbacks().isEmpty());
                this.mHostsMapping.remove(object);
                bl2 = false;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshFallbacks() {
        int n2;
        ArrayList<String> arrayList;
        Object object = this.mHostsMapping;
        synchronized (object) {
            this.checkHostMapping();
            arrayList = new ArrayList<String>(this.mHostsMapping.keySet());
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                Fallbacks fallbacks = this.mHostsMapping.get(arrayList.get(n2));
                if (fallbacks == null || fallbacks.getFallback() == null) continue;
                arrayList.remove(n2);
            }
        }
        object = this.requestRemoteFallbacks(arrayList);
        n2 = 0;
        while (n2 < arrayList.size()) {
            if (((ArrayList)object).get(n2) != null) {
                this.updateFallbacks(arrayList.get(n2), (Fallback)((ArrayList)object).get(n2));
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Fallback requestRemoteFallback(String object) {
        if (System.currentTimeMillis() - this.lastRemoteRequestTimestamp <= this.remoteRequestFailureCount * 60L * 1000L) return null;
        this.lastRemoteRequestTimestamp = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        object = this.requestRemoteFallbacks(arrayList).get(0);
        if (object != null) {
            this.remoteRequestFailureCount = 0L;
            return object;
        }
        if (this.remoteRequestFailureCount >= 15L) return null;
        ++this.remoteRequestFailureCount;
        return null;
    }

    public void setCurrentISP(String string2) {
        this.currentISP = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONArray toJSON() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            JSONArray jSONArray = new JSONArray();
            Iterator<Fallbacks> iterator = this.mHostsMapping.values().iterator();
            while (iterator.hasNext()) {
                jSONArray.put((Object)iterator.next().toJSON());
            }
            return jSONArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFallbacks(String string2, Fallback fallback) {
        if (TextUtils.isEmpty((CharSequence)string2) || fallback == null) {
            throw new IllegalArgumentException("the argument is invalid " + string2 + ", " + fallback);
        }
        if (this.sHostFilter.a(string2)) {
            Map<String, Fallbacks> map = this.mHostsMapping;
            synchronized (map) {
                this.checkHostMapping();
                if (this.mHostsMapping.containsKey(string2)) {
                    this.mHostsMapping.get(string2).addFallback(fallback);
                } else {
                    Fallbacks fallbacks = new Fallbacks(string2);
                    fallbacks.addFallback(fallback);
                    this.mHostsMapping.put(string2, fallbacks);
                }
            }
        }
    }

    public static interface HostManagerFactory {
        public HostManager a(Context var1, HostFilter var2, HttpGet var3, String var4);
    }

    public static interface HttpGet {
        public String a(String var1);
    }
}

