/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;
import me.henrytao.smoothappbarlayout.base.OnOffsetChangedListener;
import me.henrytao.smoothappbarlayout.base.ScrollTargetCallback;
import me.henrytao.smoothappbarlayout.base.Utils;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class SmoothAppBarLayout
extends AppBarLayout {
    private static final String ARG_CURRENT_OFFSET = "ARG_CURRENT_OFFSET";
    private static final String ARG_SUPER = "ARG_SUPER";
    public static boolean DEBUG = false;
    protected boolean mHaveChildWithInterpolator;
    protected final List<WeakReference<AppBarLayout.OnOffsetChangedListener>> mOffsetChangedListeners = new ArrayList<WeakReference<AppBarLayout.OnOffsetChangedListener>>();
    private int mRestoreCurrentOffset;
    private ScrollTargetCallback mScrollTargetCallback;
    private OnOffsetChangedListener mSyncOffsetListener;
    private int mViewPagerId;
    private ViewPager vViewPager;

    public SmoothAppBarLayout(Context context) {
        super(context);
        this.init(null);
    }

    public SmoothAppBarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(null);
    }

    static /* synthetic */ ScrollTargetCallback access$000(SmoothAppBarLayout smoothAppBarLayout) {
        return smoothAppBarLayout.mScrollTargetCallback;
    }

    static /* synthetic */ ViewPager access$100(SmoothAppBarLayout smoothAppBarLayout) {
        return smoothAppBarLayout.vViewPager;
    }

    static /* synthetic */ void access$300(SmoothAppBarLayout smoothAppBarLayout, OnOffsetChangedListener onOffsetChangedListener) {
        smoothAppBarLayout.setSyncOffsetListener(onOffsetChangedListener);
    }

    private void init(AttributeSet attributeSet) {
        attributeSet = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.SmoothAppBarLayout, 0, 0);
        try {
            this.mViewPagerId = attributeSet.getResourceId(R.styleable.SmoothAppBarLayout_sabl_view_pager_id, 0);
            return;
        }
        finally {
            attributeSet.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initViews() {
        if (this.mViewPagerId > 0) {
            this.vViewPager = (ViewPager)this.getRootView().findViewById(this.mViewPagerId);
            return;
        }
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof ViewPager) {
                this.vViewPager = (ViewPager)view;
                return;
            }
            ++n3;
        }
    }

    private void setSyncOffsetListener(OnOffsetChangedListener onOffsetChangedListener) {
        this.mSyncOffsetListener = onOffsetChangedListener;
        this.syncOffset(this.mRestoreCurrentOffset, true);
    }

    private void syncOffset(int n2, boolean bl2) {
        this.mRestoreCurrentOffset = n2;
        if (this.mSyncOffsetListener != null) {
            this.mSyncOffsetListener.onOffsetChanged(this, n2, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener onOffsetChangedListener) {
        super.addOnOffsetChangedListener(onOffsetChangedListener);
        int n2 = this.mOffsetChangedListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            WeakReference<AppBarLayout.OnOffsetChangedListener> weakReference = this.mOffsetChangedListeners.get(i2);
            if (weakReference == null || weakReference.get() != onOffsetChangedListener) continue;
            return;
        }
        this.mOffsetChangedListeners.add(new WeakReference<AppBarLayout.OnOffsetChangedListener>(onOffsetChangedListener));
    }

    public int getCurrentOffset() {
        return -Utils.parseInt((Object)this.getTag(R.id.tag_current_offset));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initViews();
    }

    @Override
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        super.onLayout(bl2, n2, n3, n4, n5);
        n3 = this.getChildCount();
        n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= n3) break block3;
                    if (((AppBarLayout.LayoutParams)this.getChildAt(n2).getLayoutParams()).getScrollInterpolator() == null) break block4;
                    this.mHaveChildWithInterpolator = true;
                }
                return;
            }
            ++n2;
        }
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        parcelable = (Bundle)parcelable;
        this.mRestoreCurrentOffset = parcelable.getInt(ARG_CURRENT_OFFSET);
        super.onRestoreInstanceState(parcelable.getParcelable(ARG_SUPER));
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_CURRENT_OFFSET, this.getCurrentOffset());
        bundle.putParcelable(ARG_SUPER, super.onSaveInstanceState());
        return bundle;
    }

    @Override
    public void removeOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener onOffsetChangedListener) {
        super.removeOnOffsetChangedListener(onOffsetChangedListener);
        Iterator<WeakReference<AppBarLayout.OnOffsetChangedListener>> iterator = this.mOffsetChangedListeners.iterator();
        while (iterator.hasNext()) {
            AppBarLayout.OnOffsetChangedListener onOffsetChangedListener2 = (AppBarLayout.OnOffsetChangedListener)iterator.next().get();
            if (onOffsetChangedListener2 != onOffsetChangedListener && onOffsetChangedListener2 != null) continue;
            iterator.remove();
        }
        return;
    }

    public void setScrollTargetCallback(ScrollTargetCallback scrollTargetCallback) {
        this.mScrollTargetCallback = scrollTargetCallback;
    }

    public void syncOffset(int n2) {
        this.syncOffset(n2, false);
    }
}

