/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.graphics.Point;
import android.opengl.Matrix;
import org.wrtc.RendererCommon;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    private static void adjustOrigin(float[] fArray) {
        fArray[12] = fArray[12] - (fArray[0] + fArray[4]) * 0.5f;
        fArray[13] = fArray[13] - (fArray[1] + fArray[5]) * 0.5f;
        fArray[12] = fArray[12] + 0.5f;
        fArray[13] = fArray[13] + 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        switch (1.$SwitchMap$org$wrtc$RendererCommon$ScalingType[scalingType.ordinal()]) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 0.0f;
            }
            case 3: 
        }
        return BALANCED_VISIBLE_FRACTION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Point getDisplaySize(float f2, float f3, int n2, int n3) {
        if (f2 == 0.0f) return new Point(n2, n3);
        if (f3 != 0.0f) return new Point(Math.min(n2, Math.round((float)n3 / f2 * f3)), Math.min(n3, Math.round((float)n2 / f2 / f3)));
        return new Point(n2, n3);
    }

    public static Point getDisplaySize(ScalingType scalingType, float f2, int n2, int n3) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f2, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] getLayoutMatrix(boolean bl2, float f2, float f3) {
        if (f3 > f2) {
            f3 = f2 / f3;
            f2 = 1.0f;
        } else {
            f2 = f3 / f2;
            f3 = 1.0f;
        }
        float f4 = f2;
        if (bl2) {
            f4 = f2 * -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f4, (float)f3, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static final float[] horizontalFlipMatrix() {
        return new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] multiplyMatrices(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[16];
        Matrix.multiplyMM((float[])fArray3, (int)0, (float[])fArray, (int)0, (float[])fArray2, (int)0);
        return fArray3;
    }

    public static float[] rotateTextureMatrix(float[] fArray, float f2) {
        float[] fArray2 = new float[16];
        Matrix.setRotateM((float[])fArray2, (int)0, (float)f2, (float)0.0f, (float)0.0f, (float)1.0f);
        RendererCommon.adjustOrigin(fArray2);
        return RendererCommon.multiplyMatrices(fArray, fArray2);
    }

    public static final float[] verticalFlipMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }
}

