/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.wrtc.EglBase;
import org.wrtc.EglRenderer;
import org.wrtc.GlRectDrawer;
import org.wrtc.Logging;
import org.wrtc.RendererCommon;
import org.wrtc.SurfaceViewRenderer;
import org.wrtc.ThreadUtils;
import org.wrtc.VideoRenderer;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoRenderer.Callbacks {
    private static final String TAG = "SurfaceViewRenderer";
    private final EglRenderer eglRenderer;
    private int frameRotation;
    private boolean isFirstFrameRendered;
    private final Object layoutLock;
    private RendererCommon.RendererEvents rendererEvents;
    private final String resourceName;
    private int rotatedFrameHeight;
    private int rotatedFrameWidth;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new /* Unavailable Anonymous Inner Class!! */;

    public SurfaceViewRenderer(Context context) {
        super(context);
        this.layoutLock = new Object();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.layoutLock = new Object();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResourceName() {
        try {
            CharSequence charSequence = new StringBuilder();
            return ((StringBuilder)charSequence).append(this.getResources().getResourceEntryName(this.getId())).append(": ").toString();
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void logD(String string2) {
        Logging.d((String)TAG, (String)(this.resourceName + string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(VideoRenderer.I420Frame i420Frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != i420Frame.rotatedWidth() || this.rotatedFrameHeight != i420Frame.rotatedHeight() || this.frameRotation != i420Frame.rotationDegree) {
                StringBuilder stringBuilder = new StringBuilder();
                this.logD(stringBuilder.append("Reporting frame resolution changed to ").append(i420Frame.width).append("x").append(i420Frame.height).append(" with rotation ").append(i420Frame.rotationDegree).toString());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
                }
                this.rotatedFrameWidth = i420Frame.rotatedWidth();
                this.rotatedFrameHeight = i420Frame.rotatedHeight();
                this.frameRotation = i420Frame.rotationDegree;
                i420Frame = new 1(this);
                this.post((Runnable)i420Frame);
            }
            return;
        }
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(EglBase.Context context, RendererCommon.RendererEvents object, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = object;
        object = this.layoutLock;
        synchronized (object) {
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        this.eglRenderer.init(context, nArray, glDrawer);
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(n4 - n2) / (float)(n5 - n3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int n2, int n3) {
        Point point;
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            point = this.videoLayoutMeasure.measure(n2, n3, this.rotatedFrameWidth, this.rotatedFrameHeight);
        }
        this.setMeasuredDimension(point.x, point.y);
        this.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    public void release() {
        this.eglRenderer.release();
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        this.updateFrameDimensionsAndReportEvents(i420Frame);
        this.eglRenderer.renderFrame(i420Frame);
    }

    public void setMirror(boolean bl2) {
        this.eglRenderer.setMirror(bl2);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.surfaceSizeChanged(n3, n4);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surfaceHolder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.releaseEglSurface();
    }
}

