/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.view.WindowManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wrtc.Camera1Enumerator;
import org.wrtc.CameraEnumerationAndroid;
import org.wrtc.CameraVideoCapturer;
import org.wrtc.Logging;
import org.wrtc.Metrics;
import org.wrtc.RendererCommon;
import org.wrtc.Size;
import org.wrtc.SurfaceTextureHelper;
import org.wrtc.VideoCapturer;
import org.wrtc.VideoCapturerAndroid;

@Deprecated
public class VideoCapturerAndroid
implements Camera.PreviewCallback,
CameraVideoCapturer,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final int CAMERA_STOP_TIMEOUT_MS = 7000;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final String TAG = "VideoCapturerAndroid";
    private static final Metrics.Histogram videoCapturerAndroidStartTimeMsHistogram = Metrics.Histogram.createCounts((String)"WebRTC.Android.VideoCapturerAndroid.StartTimeMs", (int)1, (int)10000, (int)50);
    private static final Metrics.Histogram videoCapturerAndroidStopTimeMsHistogram = Metrics.Histogram.createCounts((String)"WebRTC.Android.VideoCapturerAndroid.StopTimeMs", (int)1, (int)10000, (int)50);
    private Context applicationContext;
    private Camera camera;
    private final Camera.ErrorCallback cameraErrorCallback;
    private final Object cameraIdLock;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private volatile Handler cameraThreadHandler;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private int id;
    private Camera.CameraInfo info;
    private final AtomicBoolean isCameraRunning = new AtomicBoolean();
    private final boolean isCapturingToTexture;
    private int openCameraAttempts;
    private volatile boolean pendingCameraSwitch;
    private final Object pendingCameraSwitchLock;
    private final Set<byte[]> queuedBuffers;
    private int requestedFramerate;
    private int requestedHeight;
    private int requestedWidth;
    private long startStartTimeNs;
    private SurfaceTextureHelper surfaceHelper;

    /*
     * Enabled aggressive block sorting
     */
    public VideoCapturerAndroid(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean bl2) {
        this.cameraIdLock = new Object();
        this.pendingCameraSwitchLock = new Object();
        this.queuedBuffers = new HashSet<byte[]>();
        this.cameraErrorCallback = new 1(this);
        if (Camera.getNumberOfCameras() == 0) {
            throw new RuntimeException("No cameras available");
        }
        this.id = string2 == null || string2.equals("") ? 0 : Camera1Enumerator.getCameraIndex((String)string2);
        this.eventsHandler = cameraEventsHandler;
        this.isCapturingToTexture = bl2;
        Logging.d((String)TAG, (String)("VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture));
    }

    static /* synthetic */ CameraVideoCapturer.CameraEventsHandler access$000(VideoCapturerAndroid videoCapturerAndroid) {
        return videoCapturerAndroid.eventsHandler;
    }

    static /* synthetic */ void access$100(VideoCapturerAndroid videoCapturerAndroid) {
        videoCapturerAndroid.switchCameraOnCameraThread();
    }

    static /* synthetic */ Object access$200(VideoCapturerAndroid videoCapturerAndroid) {
        return videoCapturerAndroid.pendingCameraSwitchLock;
    }

    static /* synthetic */ boolean access$302(VideoCapturerAndroid videoCapturerAndroid, boolean bl2) {
        videoCapturerAndroid.pendingCameraSwitch = bl2;
        return bl2;
    }

    static /* synthetic */ Camera.CameraInfo access$400(VideoCapturerAndroid videoCapturerAndroid) {
        return videoCapturerAndroid.info;
    }

    static /* synthetic */ void access$500(VideoCapturerAndroid videoCapturerAndroid, int n2, int n3, int n4) {
        videoCapturerAndroid.startPreviewOnCameraThread(n2, n3, n4);
    }

    static /* synthetic */ int access$602(VideoCapturerAndroid videoCapturerAndroid, int n2) {
        videoCapturerAndroid.openCameraAttempts = n2;
        return n2;
    }

    static /* synthetic */ void access$700(VideoCapturerAndroid videoCapturerAndroid, int n2, int n3, int n4) {
        videoCapturerAndroid.startCaptureOnCameraThread(n2, n3, n4);
    }

    static /* synthetic */ void access$800(VideoCapturerAndroid videoCapturerAndroid, boolean bl2) {
        videoCapturerAndroid.stopCaptureOnCameraThread(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkIsOnCameraThread() {
        if (this.cameraThreadHandler == null) {
            Logging.e((String)TAG, (String)"Camera is not initialized - can't check thread.");
            return;
        } else {
            if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) return;
            throw new IllegalStateException("Wrong thread");
        }
    }

    public static VideoCapturerAndroid create(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return VideoCapturerAndroid.create(string2, cameraEventsHandler, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static VideoCapturerAndroid create(String object, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean bl2) {
        try {
            VideoCapturerAndroid videoCapturerAndroid = new VideoCapturerAndroid((String)object, cameraEventsHandler, bl2);
            return videoCapturerAndroid;
        }
        catch (RuntimeException runtimeException) {
            Logging.e((String)TAG, (String)"Couldn't create camera.", (Throwable)runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDeviceOrientation() {
        switch (((WindowManager)this.applicationContext.getSystemService("window")).getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: 
        }
        return 270;
    }

    private int getFrameOrientation() {
        int n2;
        int n3 = n2 = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            n3 = 360 - n2;
        }
        return (n3 + this.info.orientation) % 360;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInitialized() {
        if (this.applicationContext == null) return false;
        if (this.frameObserver == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean maybePostDelayedOnCameraThread(int n2, Runnable runnable) {
        if (this.cameraThreadHandler == null) return false;
        if (!this.isCameraRunning.get()) return false;
        if (!this.cameraThreadHandler.postAtTime(runnable, (Object)this, SystemClock.uptimeMillis() + (long)n2)) return false;
        return true;
    }

    private boolean maybePostOnCameraThread(Runnable runnable) {
        return this.maybePostDelayedOnCameraThread(0, runnable);
    }

    private void onFirstFrameAvailable() {
        if (this.eventsHandler != null) {
            this.eventsHandler.onFirstFrameAvailable();
        }
        int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startStartTimeNs);
        videoCapturerAndroidStartTimeMsHistogram.addSample(n2);
        this.firstFrameReported = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startCaptureOnCameraThread(int var1_1, int var2_2, int var3_3) {
        this.checkIsOnCameraThread();
        this.startStartTimeNs = System.nanoTime();
        if (!this.isCameraRunning.get()) {
            Logging.e((String)"VideoCapturerAndroid", (String)"startCaptureOnCameraThread: Camera is stopped");
            return;
        }
        if (this.camera != null) {
            Logging.e((String)"VideoCapturerAndroid", (String)"startCaptureOnCameraThread: Camera has already been started.");
            return;
        }
        this.firstFrameReported = false;
        try {
            var4_4 = this.cameraIdLock;
            synchronized (var4_4) {
            }
        }
        catch (IOException var4_5) lbl-1000:
        // 2 sources

        {
            while (true) {
                Logging.e((String)"VideoCapturerAndroid", (String)"startCapture failed", (Throwable)var4_6);
                this.stopCaptureOnCameraThread(true);
                this.frameObserver.onCapturerStarted(false);
                if (this.eventsHandler == null) return;
                this.eventsHandler.onCameraError("Camera can not be started.");
                return;
            }
        }
        {
            var5_10 = new StringBuilder();
            Logging.d((String)"VideoCapturerAndroid", (String)var5_10.append("Opening camera ").append(this.id).toString());
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraOpening(Camera1Enumerator.getDeviceName((int)this.id));
            }
            this.camera = Camera.open((int)this.id);
            var5_10 = new Camera.CameraInfo();
            this.info = var5_10;
            Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
        }
        this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
        var4_4 = new StringBuilder();
        Logging.d((String)"VideoCapturerAndroid", (String)var4_4.append("Camera orientation: ").append(this.info.orientation).append(" .Device orientation: ").append(this.getDeviceOrientation()).toString());
        this.camera.setErrorCallback(this.cameraErrorCallback);
        this.startPreviewOnCameraThread(var1_1, var2_2, var3_3);
        this.frameObserver.onCapturerStarted(true);
        if (this.isCapturingToTexture) {
            this.surfaceHelper.startListening((SurfaceTextureHelper.OnTextureFrameAvailableListener)this);
        }
        var4_4 = new CameraVideoCapturer.CameraStatistics(this.surfaceHelper, this.eventsHandler);
        this.cameraStatistics = var4_4;
        return;
        {
            catch (RuntimeException var4_9) {
                ** continue;
            }
        }
        catch (RuntimeException var4_7) {
            ++this.openCameraAttempts;
            if (this.openCameraAttempts >= 3) throw var4_7;
            Logging.e((String)"VideoCapturerAndroid", (String)"Camera.open failed, retrying", (Throwable)var4_7);
            var4_8 = new 5(this, var1_1, var2_2, var3_3);
            this.maybePostDelayedOnCameraThread(500, (Runnable)var4_8);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startPreviewOnCameraThread(int n2, int n3, int n4) {
        int n5 = 0;
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get() || this.camera == null) {
            Logging.e((String)TAG, (String)"startPreviewOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d((String)TAG, (String)("startPreviewOnCameraThread requested: " + n2 + "x" + n3 + "@" + n4));
        this.requestedWidth = n2;
        this.requestedHeight = n3;
        this.requestedFramerate = n4;
        Object object = this.camera.getParameters();
        List list = Camera1Enumerator.convertFramerates((List)object.getSupportedPreviewFpsRange());
        Logging.d((String)TAG, (String)("Available fps ranges: " + list));
        CameraEnumerationAndroid.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list, n4);
        List list2 = Camera1Enumerator.convertSizes((List)object.getSupportedPreviewSizes());
        list = CameraEnumerationAndroid.getClosestSupportedSize(list2, n2, n3);
        Logging.d((String)TAG, (String)("Available preview sizes: " + list2));
        if ((framerateRange = new /* Unavailable Anonymous Inner Class!! */).equals((Object)this.captureFormat)) return;
        Logging.d((String)TAG, (String)("isVideoStabilizationSupported: " + object.isVideoStabilizationSupported()));
        if (object.isVideoStabilizationSupported()) {
            object.setVideoStabilization(true);
        }
        if (framerateRange.framerate.max > 0) {
            object.setPreviewFpsRange(framerateRange.framerate.min, framerateRange.framerate.max);
        }
        object.setPreviewSize(((Size)list).width, ((Size)list).height);
        if (!this.isCapturingToTexture) {
            framerateRange.getClass();
            object.setPreviewFormat(17);
        }
        list = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes((List)object.getSupportedPictureSizes()), n2, n3);
        object.setPictureSize(((Size)list).width, ((Size)list).height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        if (object.getSupportedFocusModes().contains("continuous-video")) {
            Logging.d((String)TAG, (String)"Enable continuous auto focus mode.");
            object.setFocusMode("continuous-video");
        }
        Logging.d((String)TAG, (String)("Start capturing: " + framerateRange));
        this.captureFormat = framerateRange;
        this.camera.setParameters((Camera.Parameters)object);
        this.camera.setDisplayOrientation(0);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            n3 = framerateRange.frameSize();
            for (n2 = n5; n2 < 3; ++n2) {
                object = ByteBuffer.allocateDirect(n3);
                this.queuedBuffers.add(((ByteBuffer)object).array());
                this.camera.addCallbackBuffer(((ByteBuffer)object).array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    private void stopCaptureOnCameraThread(boolean bl2) {
        this.checkIsOnCameraThread();
        Logging.d((String)TAG, (String)"stopCaptureOnCameraThread");
        long l2 = System.nanoTime();
        if (this.surfaceHelper != null) {
            this.surfaceHelper.stopListening();
        }
        if (bl2) {
            this.isCameraRunning.set(false);
            this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
        }
        if (this.cameraStatistics != null) {
            this.cameraStatistics.release();
            this.cameraStatistics = null;
        }
        Logging.d((String)TAG, (String)"Stop preview.");
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Logging.d((String)TAG, (String)"Release camera.");
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
        int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
        videoCapturerAndroidStopTimeMsHistogram.addSample(n2);
        Logging.d((String)TAG, (String)"stopCaptureOnCameraThread done");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e((String)TAG, (String)"switchCameraOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d((String)TAG, (String)"switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread(false);
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate);
        Logging.d((String)TAG, (String)"switchCameraOnCameraThread done");
    }

    public void changeCaptureFormat(int n2, int n3, int n4) {
        this.maybePostOnCameraThread((Runnable)new 3(this, n2, n3, n4));
    }

    public void dispose() {
        Logging.d((String)TAG, (String)"dispose");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initialize(SurfaceTextureHelper object, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        Logging.d((String)TAG, (String)"initialize");
        if (context == null) {
            throw new IllegalArgumentException("applicationContext not set.");
        }
        if (capturerObserver == null) {
            throw new IllegalArgumentException("frameObserver not set.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
        this.applicationContext = context;
        this.frameObserver = capturerObserver;
        this.surfaceHelper = object;
        object = object == null ? null : object.getHandler();
        this.cameraThreadHandler = object;
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    public boolean isScreencast() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e((String)TAG, (String)"onPreviewFrame: Camera is stopped");
            return;
        }
        if (!this.queuedBuffers.contains(byArray)) return;
        if (this.camera != camera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (!this.firstFrameReported) {
            this.onFirstFrameAvailable();
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onByteBufferFrameCaptured(byArray, this.captureFormat.width, this.captureFormat.height, this.getFrameOrientation(), l2);
        this.camera.addCallbackBuffer(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e((String)TAG, (String)"onTextureFrameAvailable: Camera is stopped");
            this.surfaceHelper.returnTextureFrame();
            return;
        }
        int n3 = this.getFrameOrientation();
        if (this.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if (!this.firstFrameReported) {
            this.onFirstFrameAvailable();
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, n2, fArray, n3, l2);
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray = null;
        if (this.cameraThreadHandler != null) {
            stackTraceElementArray = this.cameraThreadHandler.getLooper().getThread();
        }
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d((String)TAG, (String)"VideoCapturerAndroid stacks trace:");
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d((String)TAG, (String)stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startCapture(int n2, int n3, int n4) {
        Logging.d((String)TAG, (String)("startCapture requested: " + n2 + "x" + n3 + "@" + n4));
        if (!this.isInitialized()) {
            throw new IllegalStateException("startCapture called in uninitialized state");
        }
        if (this.surfaceHelper == null) {
            this.frameObserver.onCapturerStarted(false);
            if (this.eventsHandler == null) return;
            this.eventsHandler.onCameraError("No SurfaceTexture created.");
            return;
        }
        if (this.isCameraRunning.getAndSet(true)) {
            Logging.e((String)TAG, (String)"Camera has already been started.");
            return;
        }
        if (this.maybePostOnCameraThread((Runnable)new 4(this, n2, n3, n4))) return;
        this.frameObserver.onCapturerStarted(false);
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraError("Could not post task to camera thread.");
        }
        this.isCameraRunning.set(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopCapture() throws InterruptedException {
        Logging.d((String)TAG, (String)"stopCapture");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        if (!this.maybePostOnCameraThread((Runnable)new 6(this, countDownLatch))) {
            Logging.e((String)TAG, (String)"Calling stopCapture() for already stopped camera.");
            return;
        }
        if (!countDownLatch.await(7000L, TimeUnit.MILLISECONDS)) {
            Logging.e((String)TAG, (String)"Camera stop timeout");
            this.printStackTrace();
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera stop timeout");
            }
        }
        this.frameObserver.onCapturerStopped();
        Logging.d((String)TAG, (String)"stopCapture done");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void switchCamera(CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        if (Camera.getNumberOfCameras() < 2) {
            if (cameraSwitchHandler == null) return;
            cameraSwitchHandler.onCameraSwitchError("No camera to switch to.");
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Logging.w((String)TAG, (String)"Ignoring camera switch request.");
                if (cameraSwitchHandler == null) return;
                cameraSwitchHandler.onCameraSwitchError("Pending camera switch already in progress.");
                return;
            }
            this.pendingCameraSwitch = true;
        }
        if (this.maybePostOnCameraThread((Runnable)new 2(this, cameraSwitchHandler))) return;
        if (cameraSwitchHandler == null) return;
        cameraSwitchHandler.onCameraSwitchError("Camera is stopped.");
    }
}

