/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.support.annotation.StyleRes;
import android.support.v7.appcompat.R;
import android.view.LayoutInflater;

public class ContextThemeWrapper
extends ContextWrapper {
    private LayoutInflater mInflater;
    private Resources.Theme mTheme;
    private int mThemeResource;

    public ContextThemeWrapper(Context context, @StyleRes int n2) {
        super(context);
        this.mThemeResource = n2;
    }

    public ContextThemeWrapper(Context context, Resources.Theme theme) {
        super(context);
        this.mTheme = theme;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeTheme() {
        boolean bl = this.mTheme == null;
        if (bl) {
            this.mTheme = this.getResources().newTheme();
            Resources.Theme theme = this.getBaseContext().getTheme();
            if (theme != null) {
                this.mTheme.setTo(theme);
            }
        }
        this.onApplyThemeResource(this.mTheme, this.mThemeResource, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSystemService(String object) {
        if (!"layout_inflater".equals(object)) return this.getBaseContext().getSystemService((String)object);
        if (this.mInflater != null) return this.mInflater;
        this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
        return this.mInflater;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resources.Theme getTheme() {
        if (this.mTheme != null) {
            return this.mTheme;
        }
        if (this.mThemeResource == 0) {
            this.mThemeResource = R.style.Theme_AppCompat_Light;
        }
        this.initializeTheme();
        return this.mTheme;
    }

    public int getThemeResId() {
        return this.mThemeResource;
    }

    protected void onApplyThemeResource(Resources.Theme theme, int n2, boolean bl) {
        theme.applyStyle(n2, true);
    }

    public void setTheme(int n2) {
        if (this.mThemeResource != n2) {
            this.mThemeResource = n2;
            this.initializeTheme();
        }
    }
}

