/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view.menu;

import android.content.DialogInterface;
import android.os.IBinder;
import android.support.v7.app.AlertDialog;
import android.support.v7.appcompat.R;
import android.support.v7.view.menu.ListMenuPresenter;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

class MenuDialogHelper
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
DialogInterface.OnKeyListener,
MenuPresenter.Callback {
    private AlertDialog mDialog;
    private MenuBuilder mMenu;
    ListMenuPresenter mPresenter;
    private MenuPresenter.Callback mPresenterCallback;

    public MenuDialogHelper(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    public void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public void onClick(DialogInterface dialogInterface, int n2) {
        this.mMenu.performItemAction((MenuItem)((MenuItemImpl)this.mPresenter.getAdapter().getItem(n2)), 0);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        if (bl || menuBuilder == this.mMenu) {
            this.dismiss();
        }
        if (this.mPresenterCallback != null) {
            this.mPresenterCallback.onCloseMenu(menuBuilder, bl);
        }
    }

    public void onDismiss(DialogInterface dialogInterface) {
        this.mPresenter.onCloseMenu(this.mMenu, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKey(DialogInterface dialogInterface, int n2, KeyEvent keyEvent) {
        boolean bl = true;
        if (n2 != 82) {
            if (n2 != 4) return this.mMenu.performShortcut(n2, keyEvent, 0);
        }
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            dialogInterface = this.mDialog.getWindow();
            if (dialogInterface == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
            if ((dialogInterface = dialogInterface.getDecorView()) == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
            if ((dialogInterface = dialogInterface.getKeyDispatcherState()) == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
            dialogInterface.startTracking(keyEvent, (Object)this);
            return bl;
        }
        if (keyEvent.getAction() != 1) return this.mMenu.performShortcut(n2, keyEvent, 0);
        if (keyEvent.isCanceled()) return this.mMenu.performShortcut(n2, keyEvent, 0);
        Window window = this.mDialog.getWindow();
        if (window == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
        if ((window = window.getDecorView()) == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
        if ((window = window.getKeyDispatcherState()) == null) return this.mMenu.performShortcut(n2, keyEvent, 0);
        if (!window.isTracking(keyEvent)) return this.mMenu.performShortcut(n2, keyEvent, 0);
        this.mMenu.close(true);
        dialogInterface.dismiss();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
        if (this.mPresenterCallback == null) return false;
        return this.mPresenterCallback.onOpenSubMenu(menuBuilder);
    }

    public void setPresenterCallback(MenuPresenter.Callback callback) {
        this.mPresenterCallback = callback;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show(IBinder iBinder) {
        MenuBuilder menuBuilder = this.mMenu;
        AlertDialog.Builder builder = new AlertDialog.Builder(menuBuilder.getContext());
        this.mPresenter = new ListMenuPresenter(builder.getContext(), R.layout.abc_list_menu_item_layout);
        this.mPresenter.setCallback(this);
        this.mMenu.addMenuPresenter(this.mPresenter);
        builder.setAdapter(this.mPresenter.getAdapter(), (DialogInterface.OnClickListener)this);
        View view = menuBuilder.getHeaderView();
        if (view != null) {
            builder.setCustomTitle(view);
        } else {
            builder.setIcon(menuBuilder.getHeaderIcon()).setTitle(menuBuilder.getHeaderTitle());
        }
        builder.setOnKeyListener((DialogInterface.OnKeyListener)this);
        this.mDialog = builder.create();
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        menuBuilder = this.mDialog.getWindow().getAttributes();
        ((WindowManager.LayoutParams)menuBuilder).type = 1003;
        if (iBinder != null) {
            ((WindowManager.LayoutParams)menuBuilder).token = iBinder;
        }
        ((WindowManager.LayoutParams)menuBuilder).flags |= 0x20000;
        this.mDialog.show();
    }
}

