/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.AppCompatTextHelper;
import android.support.v7.widget.TintContextWrapper;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.CheckedTextView;
import android.widget.TextView;

public class AppCompatCheckedTextView
extends CheckedTextView {
    private static final int[] TINT_ATTRS = new int[]{0x1010108};
    private AppCompatDrawableManager mDrawableManager;
    private AppCompatTextHelper mTextHelper = AppCompatTextHelper.create((TextView)this);

    public AppCompatCheckedTextView(Context context) {
        this(context, null);
    }

    public AppCompatCheckedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843720);
    }

    public AppCompatCheckedTextView(Context context, AttributeSet attributeSet, int n2) {
        super(TintContextWrapper.wrap(context), attributeSet, n2);
        this.mTextHelper.loadFromAttributes(attributeSet, n2);
        this.mTextHelper.applyCompoundDrawablesTints();
        this.mDrawableManager = AppCompatDrawableManager.get();
        context = TintTypedArray.obtainStyledAttributes((Context)this.getContext(), (AttributeSet)attributeSet, (int[])TINT_ATTRS, (int)n2, (int)0);
        this.setCheckMarkDrawable(context.getDrawable(0));
        context.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mTextHelper != null) {
            this.mTextHelper.applyCompoundDrawablesTints();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCheckMarkDrawable(@DrawableRes int n2) {
        if (this.mDrawableManager != null) {
            this.setCheckMarkDrawable(this.mDrawableManager.getDrawable(this.getContext(), n2));
            return;
        }
        super.setCheckMarkDrawable(n2);
    }

    public void setTextAppearance(Context context, int n2) {
        super.setTextAppearance(context, n2);
        if (this.mTextHelper != null) {
            this.mTextHelper.onSetTextAppearance(context, n2);
        }
    }
}

