/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.appcompat.R;
import android.support.v7.text.AllCapsTransformationMethod;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.AppCompatTextHelperV17;
import android.support.v7.widget.TintInfo;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.widget.TextView;

class AppCompatTextHelper {
    private static final int[] TEXT_APPEARANCE_ATTRS;
    private static final int[] VIEW_ATTRS;
    private TintInfo mDrawableBottomTint;
    private TintInfo mDrawableLeftTint;
    private TintInfo mDrawableRightTint;
    private TintInfo mDrawableTopTint;
    final TextView mView;

    static {
        VIEW_ATTRS = new int[]{16842804, 16843119, 16843117, 0x1010170, 16843118};
        TEXT_APPEARANCE_ATTRS = new int[]{R.attr.textAllCaps};
    }

    AppCompatTextHelper(TextView textView) {
        this.mView = textView;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AppCompatTextHelper create(TextView object) {
        void var0_2;
        if (Build.VERSION.SDK_INT >= 17) {
            AppCompatTextHelperV17 appCompatTextHelperV17 = new AppCompatTextHelperV17((TextView)object);
            return var0_2;
        }
        AppCompatTextHelper appCompatTextHelper = new AppCompatTextHelper((TextView)object);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static TintInfo createTintInfo(Context object, AppCompatDrawableManager appCompatDrawableManager, int n2) {
        void var0_2;
        void var2_5;
        ColorStateList colorStateList;
        if ((colorStateList = colorStateList.getTintList((Context)object, (int)var2_5)) == null) return var0_2;
        TintInfo tintInfo = new TintInfo();
        tintInfo.mHasTintList = true;
        tintInfo.mTintList = colorStateList;
        return var0_2;
    }

    final void applyCompoundDrawableTint(Drawable drawable2, TintInfo tintInfo) {
        if (drawable2 != null && tintInfo != null) {
            AppCompatDrawableManager.tintDrawable(drawable2, tintInfo, this.mView.getDrawableState());
        }
    }

    void applyCompoundDrawablesTints() {
        if (this.mDrawableLeftTint != null || this.mDrawableTopTint != null || this.mDrawableRightTint != null || this.mDrawableBottomTint != null) {
            Drawable[] drawableArray = this.mView.getCompoundDrawables();
            this.applyCompoundDrawableTint(drawableArray[0], this.mDrawableLeftTint);
            this.applyCompoundDrawableTint(drawableArray[1], this.mDrawableTopTint);
            this.applyCompoundDrawableTint(drawableArray[2], this.mDrawableRightTint);
            this.applyCompoundDrawableTint(drawableArray[3], this.mDrawableBottomTint);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void loadFromAttributes(AttributeSet attributeSet, int n2) {
        int n3 = 1;
        Context context = this.mView.getContext();
        AppCompatDrawableManager appCompatDrawableManager = AppCompatDrawableManager.get();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, VIEW_ATTRS, n2, 0);
        int n4 = typedArray.getResourceId(0, -1);
        if (typedArray.hasValue(1)) {
            this.mDrawableLeftTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, typedArray.getResourceId(1, 0));
        }
        if (typedArray.hasValue(2)) {
            this.mDrawableTopTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, typedArray.getResourceId(2, 0));
        }
        if (typedArray.hasValue(3)) {
            this.mDrawableRightTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, typedArray.getResourceId(3, 0));
        }
        if (typedArray.hasValue(4)) {
            this.mDrawableBottomTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, typedArray.getResourceId(4, 0));
        }
        typedArray.recycle();
        if (!(this.mView.getTransformationMethod() instanceof PasswordTransformationMethod)) {
            boolean bl;
            if (n4 != -1) {
                typedArray = context.obtainStyledAttributes(n4, R.styleable.TextAppearance);
                if (typedArray.hasValue(R.styleable.TextAppearance_textAllCaps)) {
                    bl = typedArray.getBoolean(R.styleable.TextAppearance_textAllCaps, false);
                    n4 = 1;
                } else {
                    n4 = 0;
                    bl = false;
                }
                typedArray.recycle();
            } else {
                n4 = 0;
                bl = false;
            }
            if ((attributeSet = context.obtainStyledAttributes(attributeSet, TEXT_APPEARANCE_ATTRS, n2, 0)).hasValue(0)) {
                bl = attributeSet.getBoolean(0, false);
                n4 = n3;
            }
            attributeSet.recycle();
            if (n4 != 0) {
                this.setAllCaps(bl);
            }
        }
    }

    void onSetTextAppearance(Context context, int n2) {
        if ((context = context.obtainStyledAttributes(n2, TEXT_APPEARANCE_ATTRS)).hasValue(0)) {
            this.setAllCaps(context.getBoolean(0, false));
        }
        context.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    void setAllCaps(boolean bl) {
        TextView textView = this.mView;
        AllCapsTransformationMethod allCapsTransformationMethod = bl ? new AllCapsTransformationMethod(this.mView.getContext()) : null;
        textView.setTransformationMethod(allCapsTransformationMethod);
    }
}

