/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class ButtonBarLayout
extends LinearLayout {
    private boolean mAllowStacking;
    private int mLastWidthSize = -1;

    public ButtonBarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.ButtonBarLayout);
        this.mAllowStacking = context.getBoolean(R.styleable.ButtonBarLayout_allowStacking, false);
        context.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStacked() {
        boolean bl = true;
        if (this.getOrientation() != 1) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setStacked(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.setOrientation(n2);
        n2 = bl ? 5 : 80;
        this.setGravity(n2);
        View view = this.findViewById(R.id.spacer);
        if (view != null) {
            n2 = bl ? 8 : 4;
            view.setVisibility(n2);
        }
        n2 = this.getChildCount() - 2;
        while (n2 >= 0) {
            this.bringChildToFront(this.getChildAt(n2));
            --n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = View.MeasureSpec.getSize((int)n2);
        if (this.mAllowStacking) {
            if (n7 > this.mLastWidthSize && this.isStacked()) {
                this.setStacked(false);
            }
            this.mLastWidthSize = n7;
        }
        if (!this.isStacked() && View.MeasureSpec.getMode((int)n2) == 0x40000000) {
            n5 = View.MeasureSpec.makeMeasureSpec((int)n7, (int)Integer.MIN_VALUE);
            n4 = 1;
        } else {
            n5 = n2;
            n4 = 0;
        }
        super.onMeasure(n5, n3);
        int n8 = n4;
        if (this.mAllowStacking) {
            n8 = n4;
            if (!this.isStacked()) {
                if (Build.VERSION.SDK_INT >= 11) {
                    n5 = n6;
                    if ((ViewCompat.getMeasuredWidthAndState((View)this) & 0xFF000000) == 0x1000000) {
                        n5 = 1;
                    }
                } else {
                    int n9 = this.getChildCount();
                    n8 = 0;
                    for (n5 = 0; n5 < n9; n8 += this.getChildAt(n5).getMeasuredWidth(), ++n5) {
                    }
                    n5 = n6;
                    if (this.getPaddingLeft() + n8 + this.getPaddingRight() > n7) {
                        n5 = 1;
                    }
                }
                n8 = n4;
                if (n5 != 0) {
                    this.setStacked(true);
                    n8 = 1;
                }
            }
        }
        if (n8 != 0) {
            super.onMeasure(n2, n3);
        }
    }

    public void setAllowStacking(boolean bl) {
        if (this.mAllowStacking != bl) {
            this.mAllowStacking = bl;
            if (!this.mAllowStacking && this.getOrientation() == 1) {
                this.setStacked(false);
            }
            this.requestLayout();
        }
    }
}

