/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.graphics.drawable.DrawableWrapper;
import android.support.v7.widget.ThemeUtils;

public class DrawableUtils {
    public static final Rect INSETS_NONE = new Rect();
    private static final String TAG = "DrawableUtils";
    private static final String VECTOR_DRAWABLE_CLAZZ_NAME = "android.graphics.drawable.VectorDrawable";
    private static Class<?> sInsetsClazz;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        if (Build.VERSION.SDK_INT < 18) return;
        try {
            sInsetsClazz = Class.forName("android.graphics.Insets");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    private DrawableUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canSafelyMutateDrawable(@NonNull Drawable drawableArray) {
        boolean bl;
        boolean bl2 = true;
        if (drawableArray instanceof LayerDrawable) {
            if (Build.VERSION.SDK_INT < 16) return false;
            return true;
        }
        if (drawableArray instanceof InsetDrawable) {
            bl = bl2;
            if (Build.VERSION.SDK_INT >= 14) return bl;
            return false;
        }
        if (drawableArray instanceof StateListDrawable) {
            bl = bl2;
            if (Build.VERSION.SDK_INT >= 8) return bl;
            return false;
        }
        if (drawableArray instanceof GradientDrawable) {
            bl = bl2;
            if (Build.VERSION.SDK_INT >= 14) return bl;
            return false;
        }
        if (drawableArray instanceof DrawableContainer) {
            drawableArray = drawableArray.getConstantState();
            bl = bl2;
            if (!(drawableArray instanceof DrawableContainer.DrawableContainerState)) return bl;
            drawableArray = ((DrawableContainer.DrawableContainerState)drawableArray).getChildren();
            int n2 = drawableArray.length;
            int n3 = 0;
            while (true) {
                bl = bl2;
                if (n3 >= n2) return bl;
                if (!DrawableUtils.canSafelyMutateDrawable(drawableArray[n3])) {
                    return false;
                }
                ++n3;
            }
        }
        if (drawableArray instanceof android.support.v4.graphics.drawable.DrawableWrapper) {
            return DrawableUtils.canSafelyMutateDrawable(((android.support.v4.graphics.drawable.DrawableWrapper)drawableArray).getWrappedDrawable());
        }
        if (drawableArray instanceof DrawableWrapper) {
            return DrawableUtils.canSafelyMutateDrawable(((DrawableWrapper)drawableArray).getWrappedDrawable());
        }
        bl = bl2;
        if (!(drawableArray instanceof ScaleDrawable)) return bl;
        return DrawableUtils.canSafelyMutateDrawable(((ScaleDrawable)drawableArray).getDrawable());
    }

    static void fixDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT == 21 && VECTOR_DRAWABLE_CLAZZ_NAME.equals(drawable2.getClass().getName())) {
            DrawableUtils.fixVectorDrawableTinting(drawable2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void fixVectorDrawableTinting(Drawable drawable2) {
        int[] nArray = drawable2.getState();
        if (nArray == null || nArray.length == 0) {
            drawable2.setState(ThemeUtils.CHECKED_STATE_SET);
        } else {
            drawable2.setState(ThemeUtils.EMPTY_STATE_SET);
        }
        drawable2.setState(nArray);
    }

    /*
     * Exception decompiling
     */
    public static Rect getOpticalBounds(Drawable var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [9 : 257->293)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    static PorterDuff.Mode parseTintMode(int n2, PorterDuff.Mode mode) {
        PorterDuff.Mode mode2 = mode;
        int n3 = 0;
        block9: do {
            switch (n3 == 0 ? n2 : n3) {
                default: {
                    mode2 = mode;
                    n3 = 4;
                    continue block9;
                }
                case 3: {
                    mode2 = PorterDuff.Mode.SRC_OVER;
                    n3 = 4;
                    continue block9;
                }
                case 5: {
                    mode2 = PorterDuff.Mode.SRC_IN;
                    n3 = 4;
                    continue block9;
                }
                case 9: {
                    mode2 = PorterDuff.Mode.SRC_ATOP;
                    n3 = 4;
                    continue block9;
                }
                case 14: {
                    mode2 = PorterDuff.Mode.MULTIPLY;
                    n3 = 4;
                    continue block9;
                }
                case 15: {
                    mode2 = PorterDuff.Mode.SCREEN;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return mode2;
                }
                case 16: 
            }
            break;
        } while (true);
        mode2 = mode;
        if (Build.VERSION.SDK_INT < 11) return mode2;
        return PorterDuff.Mode.valueOf((String)"ADD");
    }
}

