/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.ResourceCursorAdapter;
import android.support.v7.appcompat.R;
import android.support.v7.widget.SearchView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter
implements View.OnClickListener {
    private static final boolean DBG = false;
    static final int INVALID_INDEX = -1;
    private static final String LOG_TAG = "SuggestionsAdapter";
    private static final int QUERY_LIMIT = 50;
    static final int REFINE_ALL = 2;
    static final int REFINE_BY_ENTRY = 1;
    static final int REFINE_NONE = 0;
    private boolean mClosed = false;
    private final int mCommitIconResId;
    private int mFlagsCol = -1;
    private int mIconName1Col = -1;
    private int mIconName2Col = -1;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private final Context mProviderContext;
    private int mQueryRefinement = 1;
    private final SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    private final SearchView mSearchView;
    private final SearchableInfo mSearchable;
    private int mText1Col = -1;
    private int mText2Col = -1;
    private int mText2UrlCol = -1;
    private ColorStateList mUrlColor;

    public SuggestionsAdapter(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, searchView.getSuggestionRowLayout(), null, true);
        this.mSearchView = searchView;
        this.mSearchable = searchableInfo;
        this.mCommitIconResId = searchView.getSuggestionCommitIconResId();
        this.mProviderContext = context;
        this.mOutsideDrawablesCache = weakHashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable checkIconCache(String string2) {
        if ((string2 = this.mOutsideDrawablesCache.get(string2)) != null) return string2.newDrawable();
        return null;
    }

    private CharSequence formatUrl(CharSequence charSequence) {
        TypedValue typedValue;
        if (this.mUrlColor == null) {
            typedValue = new TypedValue();
            this.mContext.getTheme().resolveAttribute(R.attr.textColorSearchUrl, typedValue, true);
            this.mUrlColor = this.mContext.getResources().getColorStateList(typedValue.resourceId);
        }
        typedValue = new SpannableString(charSequence);
        typedValue.setSpan((Object)new TextAppearanceSpan(null, 0, 0, this.mUrlColor, null), 0, charSequence.length(), 33);
        return typedValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getActivityIcon(ComponentName componentName) {
        ActivityInfo activityInfo;
        Object var2_3 = null;
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)LOG_TAG, (String)nameNotFoundException.toString());
            return var2_3;
        }
        int n2 = activityInfo.getIconResource();
        if (n2 == 0) {
            return var2_3;
        }
        if ((packageManager = packageManager.getDrawable(componentName.getPackageName(), n2, activityInfo.applicationInfo)) != null) return packageManager;
        Log.w((String)LOG_TAG, (String)("Invalid icon resource " + n2 + " for " + componentName.flattenToShortString()));
        return var2_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getActivityIconWithCache(ComponentName object) {
        Object var2_2 = null;
        String string2 = object.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(string2)) {
            object = this.mOutsideDrawablesCache.get(string2);
            if (object != null) return object.newDrawable(this.mProviderContext.getResources());
            return null;
        }
        Drawable drawable2 = this.getActivityIcon((ComponentName)object);
        object = drawable2 == null ? var2_2 : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(string2, (Drawable.ConstantState)object);
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String string2) {
        return SuggestionsAdapter.getStringOrNull(cursor, cursor.getColumnIndex(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDefaultIcon1(Cursor cursor) {
        cursor = this.getActivityIconWithCache(this.mSearchable.getSearchActivity());
        if (cursor == null) return this.mContext.getPackageManager().getDefaultActivityIcon();
        return cursor;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getDrawable(Uri uri) {
        Object object;
        block13: {
            try {
                boolean bl = "android.resource".equals(uri.getScheme());
                if (bl) {
                    try {
                        Drawable drawable2 = this.getDrawableFromResourceUri(uri);
                        return drawable2;
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(stringBuilder.append("Resource does not exist: ").append(uri).toString());
                        throw fileNotFoundException;
                    }
                }
                object = this.mProviderContext.getContentResolver().openInputStream(uri);
                if (object != null) break block13;
                object = new StringBuilder();
                FileNotFoundException fileNotFoundException = new FileNotFoundException(((StringBuilder)object).append("Failed to open ").append(uri).toString());
                throw fileNotFoundException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w((String)LOG_TAG, (String)("Icon not found: " + uri + ", " + fileNotFoundException.getMessage()));
                return null;
            }
        }
        Drawable drawable3 = Drawable.createFromStream((InputStream)object, null);
        {
            catch (Throwable throwable) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Log.e((String)LOG_TAG, (String)stringBuilder.append("Error closing icon stream for ").append(uri).toString(), (Throwable)iOException);
                    throw throwable;
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)object).close();
            return drawable3;
        }
        catch (IOException iOException) {
            object = new StringBuilder();
            Log.e((String)LOG_TAG, (String)((StringBuilder)object).append("Error closing icon stream for ").append(uri).toString(), (Throwable)iOException);
            return drawable3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDrawableFromResourceValue(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) return null;
        if ("0".equals(string2)) {
            return null;
        }
        int n2 = Integer.parseInt(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = stringBuilder.append("android.resource://").append(this.mProviderContext.getPackageName()).append("/").append(n2).toString();
        Drawable drawable2 = this.checkIconCache(string3);
        stringBuilder = drawable2;
        if (drawable2 != null) return stringBuilder;
        try {
            stringBuilder = ContextCompat.getDrawable((Context)this.mProviderContext, (int)n2);
            this.storeInIconCache(string3, (Drawable)stringBuilder);
            return stringBuilder;
        }
        catch (NumberFormatException numberFormatException) {
            drawable2 = this.checkIconCache(string2);
            stringBuilder = drawable2;
            if (drawable2 != null) return stringBuilder;
            stringBuilder = this.getDrawable(Uri.parse((String)string2));
            this.storeInIconCache(string2, (Drawable)stringBuilder);
            return stringBuilder;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.w((String)LOG_TAG, (String)("Icon resource not found: " + string2));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon1(Cursor cursor) {
        Drawable drawable2;
        if (this.mIconName1Col == -1) {
            return null;
        }
        Drawable drawable3 = drawable2 = this.getDrawableFromResourceValue(cursor.getString(this.mIconName1Col));
        if (drawable2 != null) return drawable3;
        return this.getDefaultIcon1(cursor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col != -1) return this.getDrawableFromResourceValue(cursor.getString(this.mIconName2Col));
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getStringOrNull(Cursor object, int n2) {
        void var0_2;
        void var1_6;
        Object var2_7 = null;
        if (var1_6 == -1) {
            Object var0_1 = var2_7;
            return var0_2;
        }
        try {
            String string2 = object.getString((int)var1_6);
            return var0_2;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"unexpected error retrieving valid column from cursor, did the remote process die?", (Throwable)exception);
            Object var0_5 = var2_7;
            return var0_2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setViewDrawable(ImageView imageView, Drawable drawable2, int n2) {
        imageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            imageView.setVisibility(n2);
            return;
        }
        imageView.setVisibility(0);
        drawable2.setVisible(false, false);
        drawable2.setVisible(true, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setViewText(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            textView.setVisibility(8);
            return;
        }
        textView.setVisibility(0);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        if (drawable2 != null) {
            this.mOutsideDrawablesCache.put(string2, drawable2.getConstantState());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSpinnerState(Cursor cursor) {
        if (cursor == null) return;
        cursor = cursor.getExtras();
        if (cursor == null) return;
        if (!cursor.getBoolean("in_progress")) return;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void bindView(View object, Context object2, Cursor cursor) {
        void var3_10;
        ChildViewCache childViewCache = (ChildViewCache)object.getTag();
        int n2 = this.mFlagsCol != -1 ? var3_10.getInt(this.mFlagsCol) : 0;
        if (childViewCache.mText1 != null) {
            String string2 = SuggestionsAdapter.getStringOrNull((Cursor)var3_10, this.mText1Col);
            this.setViewText(childViewCache.mText1, string2);
        }
        if (childViewCache.mText2 != null) {
            void var1_6;
            String string3 = SuggestionsAdapter.getStringOrNull((Cursor)var3_10, this.mText2UrlCol);
            if (string3 != null) {
                CharSequence charSequence = this.formatUrl(string3);
            } else {
                String string4 = SuggestionsAdapter.getStringOrNull((Cursor)var3_10, this.mText2Col);
            }
            if (TextUtils.isEmpty((CharSequence)var1_6)) {
                if (childViewCache.mText1 != null) {
                    childViewCache.mText1.setSingleLine(false);
                    childViewCache.mText1.setMaxLines(2);
                }
            } else if (childViewCache.mText1 != null) {
                childViewCache.mText1.setSingleLine(true);
                childViewCache.mText1.setMaxLines(1);
            }
            this.setViewText(childViewCache.mText2, (CharSequence)var1_6);
        }
        if (childViewCache.mIcon1 != null) {
            this.setViewDrawable(childViewCache.mIcon1, this.getIcon1((Cursor)var3_10), 4);
        }
        if (childViewCache.mIcon2 != null) {
            this.setViewDrawable(childViewCache.mIcon2, this.getIcon2((Cursor)var3_10), 8);
        }
        if (this.mQueryRefinement == 2 || this.mQueryRefinement == 1 && (n2 & 1) != 0) {
            childViewCache.mIconRefine.setVisibility(0);
            childViewCache.mIconRefine.setTag((Object)childViewCache.mText1.getText());
            childViewCache.mIconRefine.setOnClickListener((View.OnClickListener)this);
            return;
        }
        childViewCache.mIconRefine.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeCursor(Cursor cursor) {
        if (this.mClosed) {
            Log.w((String)LOG_TAG, (String)"Tried to change cursor after adapter was closed.");
            if (cursor == null) return;
            cursor.close();
            return;
        }
        try {
            super.changeCursor(cursor);
            if (cursor == null) return;
            this.mText1Col = cursor.getColumnIndex("suggest_text_1");
            this.mText2Col = cursor.getColumnIndex("suggest_text_2");
            this.mText2UrlCol = cursor.getColumnIndex("suggest_text_2_url");
            this.mIconName1Col = cursor.getColumnIndex("suggest_icon_1");
            this.mIconName2Col = cursor.getColumnIndex("suggest_icon_2");
            this.mFlagsCol = cursor.getColumnIndex("suggest_flags");
            return;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"error changing cursor and caching columns", (Throwable)exception);
            return;
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CharSequence convertToString(Cursor object) {
        String string2 = null;
        if (object == null) {
            return string2;
        }
        String string3 = SuggestionsAdapter.getColumnString(object, "suggest_intent_query");
        if (string3 != null) {
            return string3;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (string3 = SuggestionsAdapter.getColumnString(object, "suggest_intent_data")) != null) {
            return string3;
        }
        string3 = string2;
        if (!this.mSearchable.shouldRewriteQueryFromText()) return string3;
        String string4 = SuggestionsAdapter.getColumnString(object, "suggest_text_1");
        string3 = string2;
        if (string4 == null) return string3;
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Drawable getDrawableFromResourceUri(Uri uri) throws FileNotFoundException {
        Resources resources;
        String string2 = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            resources = this.mContext.getPackageManager().getResourcesForApplication(string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List list = uri.getPathSegments();
        if (list == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int n2 = list.size();
        if (n2 == 1) {
            try {
                n2 = Integer.parseInt((String)list.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else {
            if (n2 != 2) {
                throw new FileNotFoundException("More than two path segments: " + uri);
            }
            n2 = resources.getIdentifier((String)list.get(1), (String)list.get(0), string2);
        }
        if (n2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        return resources.getDrawable(n2);
    }

    public int getQueryRefinement() {
        return this.mQueryRefinement;
    }

    /*
     * Enabled aggressive block sorting
     */
    Cursor getSearchManagerSuggestions(SearchableInfo stringArray, String string2, int n2) {
        Uri.Builder builder = null;
        if (stringArray == null) {
            return builder;
        }
        String string3 = stringArray.getSuggestAuthority();
        if (string3 == null) return builder;
        builder = new Uri.Builder().scheme("content").authority(string3).query("").fragment("");
        string3 = stringArray.getSuggestPath();
        if (string3 != null) {
            builder.appendEncodedPath(string3);
        }
        builder.appendPath("search_suggest_query");
        string3 = stringArray.getSuggestSelection();
        if (string3 != null) {
            stringArray = new String[]{string2};
        } else {
            builder.appendPath(string2);
            stringArray = null;
        }
        if (n2 > 0) {
            builder.appendQueryParameter("limit", String.valueOf(n2));
        }
        string2 = builder.build();
        return this.mContext.getContentResolver().query((Uri)string2, null, string3, stringArray, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View getView(int n2, View view, ViewGroup viewGroup) {
        try {
            return super.getView(n2, view, viewGroup);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOG_TAG, (String)"Search suggestions cursor threw exception.", (Throwable)runtimeException);
            view = this.newView(this.mContext, this.mCursor, viewGroup);
            if (view == null) return view;
            ((ChildViewCache)view.getTag()).mText1.setText((CharSequence)runtimeException.toString());
            return view;
        }
    }

    public boolean hasStableIds() {
        return false;
    }

    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        context = super.newView(context, cursor, viewGroup);
        context.setTag((Object)new ChildViewCache((View)context));
        ((ImageView)context.findViewById(R.id.edit_query)).setImageResource(this.mCommitIconResId);
        return context;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.updateSpinnerState(this.getCursor());
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.updateSpinnerState(this.getCursor());
    }

    public void onClick(View object) {
        if ((object = object.getTag()) instanceof CharSequence) {
            this.mSearchView.onQueryRefine((CharSequence)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        charSequence = charSequence == null ? "" : charSequence.toString();
        if (this.mSearchView.getVisibility() != 0) return null;
        if (this.mSearchView.getWindowVisibility() != 0) {
            return null;
        }
        try {
            charSequence = this.getSearchManagerSuggestions(this.mSearchable, (String)charSequence, 50);
            if (charSequence == null) return null;
            charSequence.getCount();
            return charSequence;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOG_TAG, (String)"Search suggestions query threw an exception.", (Throwable)runtimeException);
        }
        return null;
    }

    public void setQueryRefinement(int n2) {
        this.mQueryRefinement = n2;
    }

    private static final class ChildViewCache {
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final ImageView mIconRefine;
        public final TextView mText1;
        public final TextView mText2;

        public ChildViewCache(View view) {
            this.mText1 = (TextView)view.findViewById(16908308);
            this.mText2 = (TextView)view.findViewById(16908309);
            this.mIcon1 = (ImageView)view.findViewById(16908295);
            this.mIcon2 = (ImageView)view.findViewById(16908296);
            this.mIconRefine = (ImageView)view.findViewById(R.id.edit_query);
        }
    }
}

