/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.android.app.encrypt;

public final class Base64 {
    private static final int BASELENGTH = 128;
    private static final int EIGHTBIT = 8;
    private static final int FOURBYTE = 4;
    private static final int LOOKUPLENGTH = 64;
    private static final char PAD = '=';
    private static final int SIGN = -128;
    private static final int SIXTEENBIT = 16;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    static {
        int n2;
        int n3 = 0;
        base64Alphabet = new byte[128];
        lookUpBase64Alphabet = new char[64];
        for (n2 = 0; n2 < 128; ++n2) {
            Base64.base64Alphabet[n2] = (byte)-1;
        }
        for (n2 = 90; n2 >= 65; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
        }
        for (n2 = 122; n2 >= 97; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 57; n2 >= 48; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
        }
        Base64.base64Alphabet[43] = (byte)62;
        Base64.base64Alphabet[47] = (byte)63;
        for (n2 = 0; n2 <= 25; ++n2) {
            Base64.lookUpBase64Alphabet[n2] = (char)(n2 + 65);
        }
        int n4 = 26;
        n2 = 0;
        while (n4 <= 51) {
            Base64.lookUpBase64Alphabet[n4] = (char)(n2 + 97);
            ++n4;
            ++n2;
        }
        n4 = 52;
        n2 = n3;
        while (n4 <= 61) {
            Base64.lookUpBase64Alphabet[n4] = (char)(n2 + 48);
            ++n4;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = (char)43;
        Base64.lookUpBase64Alphabet[63] = (char)47;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decode(String object) {
        int n2;
        char c2;
        char c3;
        int n3;
        int n4;
        Object var1_1 = null;
        if (object == null) {
            return var1_1;
        }
        char[] cArray = ((String)object).toCharArray();
        int n5 = Base64.removeWhiteSpace(cArray);
        object = var1_1;
        if (n5 % 4 != 0) return object;
        int n6 = n5 / 4;
        if (n6 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n6 * 3];
        int n7 = 0;
        n5 = 0;
        for (n4 = 0; n4 < n6 - 1; ++n4) {
            n3 = n7 + 1;
            char c4 = cArray[n7];
            object = var1_1;
            if (!Base64.isData(c4)) return object;
            n7 = n3 + 1;
            c3 = cArray[n3];
            object = var1_1;
            if (!Base64.isData(c3)) return object;
            n3 = n7 + 1;
            char c5 = cArray[n7];
            object = var1_1;
            if (!Base64.isData(c5)) return object;
            n7 = n3 + 1;
            c2 = cArray[n3];
            object = var1_1;
            if (!Base64.isData(c2)) return object;
            int n8 = base64Alphabet[c4];
            byte by = base64Alphabet[c3];
            n3 = base64Alphabet[c5];
            n2 = base64Alphabet[c2];
            int n9 = n5 + 1;
            byArray[n5] = (byte)(n8 << 2 | by >> 4);
            n8 = n9 + 1;
            byArray[n9] = (byte)((by & 0xF) << 4 | n3 >> 2 & 0xF);
            n5 = n8 + 1;
            byArray[n8] = (byte)(n3 << 6 | n2);
        }
        n6 = n7 + 1;
        c3 = cArray[n7];
        object = var1_1;
        if (!Base64.isData(c3)) return object;
        n3 = n6 + 1;
        c2 = cArray[n6];
        object = var1_1;
        if (!Base64.isData(c2)) return object;
        n6 = base64Alphabet[c3];
        n7 = base64Alphabet[c2];
        n2 = n3 + 1;
        c2 = cArray[n3];
        c3 = cArray[n2];
        if (!Base64.isData(c2) || !Base64.isData(c3)) {
            if (Base64.isPad(c2) && Base64.isPad(c3)) {
                object = var1_1;
                if ((n7 & 0xF) != 0) return object;
                object = new byte[n4 * 3 + 1];
                System.arraycopy(byArray, 0, object, 0, n4 * 3);
                object[n5] = (byte)(n6 << 2 | n7 >> 4);
                return object;
            }
            object = var1_1;
            if (Base64.isPad(c2)) return object;
            object = var1_1;
            if (!Base64.isPad(c3)) return object;
            n3 = base64Alphabet[c2];
            object = var1_1;
            if ((n3 & 3) != 0) return object;
            object = new byte[n4 * 3 + 2];
            System.arraycopy(byArray, 0, object, 0, n4 * 3);
            object[n5] = (byte)(n6 << 2 | n7 >> 4);
            object[n5 + 1] = (byte)((n7 & 0xF) << 4 | n3 >> 2 & 0xF);
            return object;
        }
        n4 = base64Alphabet[c2];
        n2 = base64Alphabet[c3];
        n3 = n5 + 1;
        byArray[n5] = (byte)(n6 << 2 | n7 >> 4);
        n5 = n3 + 1;
        byArray[n3] = (byte)((n7 & 0xF) << 4 | n4 >> 2 & 0xF);
        byArray[n5] = (byte)(n4 << 6 | n2);
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String encode(byte[] object) {
        byte by;
        int n2;
        int n3;
        void var0_2;
        int n4 = 0;
        if (object == null) {
            return var0_2;
        }
        int n5 = ((byte[])object).length * 8;
        if (n5 == 0) {
            return var0_2;
        }
        int n6 = n5 % 24;
        int n7 = n5 / 24;
        n5 = n6 != 0 ? n7 + 1 : n7;
        char[] cArray = new char[n5 * 4];
        n5 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = n4 + 1;
            n4 = object[n4];
            int n8 = n2 + 1;
            n2 = object[n2];
            byte by2 = object[n8];
            byte by3 = (byte)(n2 & 0xF);
            byte by4 = (byte)(n4 & 3);
            n4 = (n4 & 0xFFFFFF80) == 0 ? (int)((byte)(n4 >> 2)) : (int)((byte)(n4 >> 2 ^ 0xC0));
            n2 = (n2 & 0xFFFFFF80) == 0 ? (int)((byte)(n2 >> 4)) : (int)((byte)(n2 >> 4 ^ 0xF0));
            by = (by2 & 0xFFFFFF80) == 0 ? (byte)(by2 >> 6) : (byte)(by2 >> 6 ^ 0xFC);
            int n9 = n5 + 1;
            cArray[n5] = lookUpBase64Alphabet[n4];
            n5 = n9 + 1;
            cArray[n9] = lookUpBase64Alphabet[n2 | by4 << 4];
            n4 = n5 + 1;
            cArray[n5] = lookUpBase64Alphabet[by | by3 << 2];
            cArray[n4] = lookUpBase64Alphabet[by2 & 0x3F];
            n5 = n4 + 1;
            n4 = n8 + 1;
        }
        if (n6 == 8) {
            n3 = object[n4];
            n4 = (byte)(n3 & 3);
            n3 = (n3 & 0xFFFFFF80) == 0 ? (int)((byte)(n3 >> 2)) : (int)((byte)(n3 >> 2 ^ 0xC0));
            n2 = n5 + 1;
            cArray[n5] = lookUpBase64Alphabet[n3];
            n5 = n2 + 1;
            cArray[n2] = lookUpBase64Alphabet[n4 << 4];
            n3 = n5 + 1;
            cArray[n5] = (char)61;
            cArray[n3] = (char)61;
        } else if (n6 == 16) {
            n3 = object[n4];
            n4 = object[n4 + 1];
            n2 = (byte)(n4 & 0xF);
            by = (byte)(n3 & 3);
            n3 = (n3 & 0xFFFFFF80) == 0 ? (int)((byte)(n3 >> 2)) : (int)((byte)(n3 >> 2 ^ 0xC0));
            n4 = (n4 & 0xFFFFFF80) == 0 ? (int)((byte)(n4 >> 4)) : (int)((byte)(n4 >> 4 ^ 0xF0));
            n7 = n5 + 1;
            cArray[n5] = lookUpBase64Alphabet[n3];
            n5 = n7 + 1;
            cArray[n7] = lookUpBase64Alphabet[n4 | by << 4];
            n3 = n5 + 1;
            cArray[n5] = lookUpBase64Alphabet[n2 << 2];
            cArray[n3] = (char)61;
        }
        String string2 = new String(cArray);
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isData(char c2) {
        if (c2 >= '\u0080') return false;
        if (base64Alphabet[c2] == -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPad(char c2) {
        if (c2 != '=') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWhiteSpace(char c2) {
        if (c2 == ' ') return true;
        if (c2 == '\r') return true;
        if (c2 == '\n') return true;
        if (c2 != '\t') return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int removeWhiteSpace(char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        if (cArray != null) {
            int n4 = cArray.length;
            int n5 = 0;
            while (true) {
                n3 = n2;
                if (n5 >= n4) break;
                if (!Base64.isWhiteSpace(cArray[n5])) {
                    n3 = n2 + 1;
                    cArray[n2] = cArray[n5];
                    n2 = n3;
                }
                ++n5;
            }
        }
        return n3;
    }
}

