/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.msg.view;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsChatActivity;
import com.android.gmacs.adapter.GmacsChatAdapter;
import com.android.gmacs.logic.MessageLogic;
import com.android.gmacs.msg.view.IMMessageView;
import com.android.gmacs.view.GmacsDialog;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.msg.data.IMCallMsg;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.utils.TimeUtil;

public class IMCallMsgView
extends IMMessageView {
    private IMCallMsg imCallMsg;
    private TextView mCallContent;
    private ImageView mCallPic;
    private ImageView mNoRead;
    private Message.MessageUserInfo receiverInfo;
    private Message.MessageUserInfo senderInfo;

    public void init(int n2, GmacsChatAdapter gmacsChatAdapter, GmacsChatActivity gmacsChatActivity, IMMessage iMMessage) {
        super.init(n2, gmacsChatAdapter, gmacsChatActivity, iMMessage);
        gmacsChatAdapter = gmacsChatAdapter.getItem(n2);
        this.receiverInfo = gmacsChatAdapter.mReceiverInfo;
        this.senderInfo = gmacsChatAdapter.mSenderInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected View initView(LayoutInflater layoutInflater) {
        if (this.imCallMsg.parentMsg.mIsSelfSendMsg) {
            this.mContentView = layoutInflater.inflate(R.layout.gmacs_adapter_talk_item_right_call, null);
        } else {
            this.mContentView = layoutInflater.inflate(R.layout.gmacs_adapter_talk_item_left_call, null);
            this.mNoRead = (ImageView)this.mContentView.findViewById(R.id.call_no_read);
        }
        this.mCallContent = (TextView)this.mContentView.findViewById(R.id.tv_msg_call);
        this.mCallPic = (ImageView)this.mContentView.findViewById(R.id.iv_call);
        RelativeLayout relativeLayout = (RelativeLayout)this.mContentView.findViewById(R.id.rl_talk_item_call);
        relativeLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (IMCallMsgView.this.mMsgClickListener != null) {
                    IMCallMsgView.this.mMsgClickListener.onIMMsgClick(view, (IMMessage)IMCallMsgView.this.imCallMsg);
                }
                if (!((IMCallMsgView)IMCallMsgView.this).imCallMsg.parentMsg.mIsSelfSendMsg && ((IMCallMsgView)IMCallMsgView.this).imCallMsg.parentMsg.getMsgPlayStatus() == 0) {
                    ((IMCallMsgView)IMCallMsgView.this).imCallMsg.parentMsg.setMsgPlayStatus(1);
                    ((IMCallMsgView)IMCallMsgView.this).imCallMsg.style = null;
                    IMCallMsgView.this.mNoRead.setVisibility(8);
                    MessageLogic.getInstance().updatePlayStatusByLocalId(((IMCallMsgView)IMCallMsgView.this).imCallMsg.parentMsg.mMessage.mId, 1);
                }
            }
        });
        relativeLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                view = new GmacsDialog.Builder(IMCallMsgView.this.getContentView().getContext(), 1);
                view.initDialog(new AdapterView.OnItemClickListener((GmacsDialog.Builder)view){
                    final /* synthetic */ GmacsDialog.Builder val$dialog;
                    {
                        this.val$dialog = builder;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                        switch (n2) {
                            default: {
                                break;
                            }
                            case 0: {
                                IMCallMsgView.this.deleteIMMessageView();
                                this.val$dialog.dismiss();
                            }
                        }
                        this.val$dialog.dismiss();
                    }
                }).setListTexts((CharSequence[])new String[]{IMCallMsgView.this.mChatActivity.getString(R.string.delete_message)}).create().show();
                return true;
            }
        });
        super.initView(layoutInflater);
        return this.mContentView;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataForView() {
        super.setDataForView();
        if (this.imCallMsg.callType == 0) {
            if (this.imCallMsg.parentMsg.mIsSelfSendMsg) {
                this.mCallPic.setImageResource(R.drawable.gmacs_talk_item_right_audio_call);
            } else {
                this.mCallPic.setImageResource(R.drawable.gmacs_talk_item_left_audio_call);
            }
        } else if (this.imCallMsg.callType == 1) {
            this.mCallPic.setImageResource(R.drawable.gmacs_talk_item_video_call);
        }
        if (this.imCallMsg.parentMsg.mIsSelfSendMsg) {
            switch (this.imCallMsg.finalState) {
                case 0: {
                    this.mCallContent.setText(R.string.finalState_self_cancel);
                    return;
                }
                case 3: {
                    this.mCallContent.setText((CharSequence)this.mCallContent.getContext().getString(R.string.finalState_self_chat_time, new Object[]{TimeUtil.secondsToChatTime((int)this.imCallMsg.durationInSeconds)}));
                    return;
                }
                case 1: {
                    this.mCallContent.setText(R.string.finalState_other_refuse);
                    return;
                }
                case 2: {
                    this.mCallContent.setText(R.string.finalState_other_no_answer);
                    return;
                }
                case 4: {
                    this.mCallContent.setText(R.string.finalState_other_busy);
                    return;
                }
                case 5: {
                    this.mCallContent.setText(R.string.finalState_other_fail);
                    return;
                }
            }
            return;
        }
        this.mNoRead.setVisibility(8);
        switch (this.imCallMsg.finalState) {
            default: {
                return;
            }
            case 0: {
                if (this.imCallMsg.parentMsg.getMsgPlayStatus() == 0) {
                    this.mNoRead.setVisibility(0);
                } else {
                    this.mNoRead.setVisibility(8);
                }
                this.mCallContent.setText(R.string.finalState_other_cancel);
                return;
            }
            case 3: {
                this.mCallContent.setText((CharSequence)this.mCallContent.getContext().getString(R.string.finalState_self_chat_time, new Object[]{TimeUtil.secondsToChatTime((int)this.imCallMsg.durationInSeconds)}));
                return;
            }
            case 1: 
        }
        this.mCallContent.setText(R.string.finalState_self_refuse);
    }

    protected void setIMMessage(IMMessage iMMessage) {
        if (iMMessage instanceof IMCallMsg) {
            this.imCallMsg = (IMCallMsg)iMMessage;
        }
    }
}

