/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.android.gmacs.R;
import java.util.ArrayList;
import java.util.List;

public class TagFlowLayout
extends ViewGroup {
    public static final String GRAVITY_CENTER = "center";
    public static final String GRAVITY_LEFT = "left";
    public static final String GRAVITY_RIGHT = "right";
    private int itemSpace;
    private int lineSpace;
    protected List<List<View>> mAllViews = new ArrayList<List<View>>();
    private String mGravity;
    protected List<Integer> mLineHeightList = new ArrayList<Integer>();
    private int maxLineCount;

    public TagFlowLayout(Context context) {
        this(context, null);
    }

    public TagFlowLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TagFlowLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.TagFlowLayout);
        this.mGravity = context.getString(R.styleable.TagFlowLayout_gmacs_gravity);
        if (this.mGravity == null) {
            this.mGravity = GRAVITY_LEFT;
        }
        this.maxLineCount = context.getInteger(R.styleable.TagFlowLayout_gmacs_maxLineCount, Integer.MAX_VALUE);
        this.lineSpace = context.getDimensionPixelOffset(R.styleable.TagFlowLayout_gmacs_lineSpace, 0);
        this.itemSpace = context.getDimensionPixelOffset(R.styleable.TagFlowLayout_gmacs_itemSpace, 0);
        context.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getStartLeft(List<View> list) {
        int n2 = this.getPaddingLeft();
        int n3 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            View view = list.get(i2);
            if (view.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            n3 += view.getMeasuredWidth() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + this.itemSpace;
        }
        n3 = this.getPaddingLeft() + this.getPaddingRight() - this.itemSpace + n3;
        if (this.mGravity.equals(GRAVITY_CENTER)) {
            if (this.getMeasuredWidth() <= n3) return n2;
            return (this.getMeasuredWidth() - n3) / 2 + n2;
        }
        if (!this.mGravity.equals(GRAVITY_RIGHT)) return n2;
        if (this.getMeasuredWidth() <= n3) return n2;
        return this.getMeasuredWidth() - n3 + n2;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    public int getItemSpace() {
        return this.itemSpace;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public int getMaxLineCount() {
        return this.maxLineCount;
    }

    public String getmGravity() {
        return this.mGravity;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        View view;
        this.mAllViews.clear();
        this.mLineHeightList.clear();
        int n8 = this.getWidth();
        n3 = 0;
        n2 = 0;
        ArrayList<View> arrayList = new ArrayList();
        int n9 = this.getChildCount();
        for (n4 = 0; n4 < n9; ++n4) {
            void var10_10;
            view = this.getChildAt(n4);
            if (view.getVisibility() == 8) {
                ArrayList arrayList2 = arrayList;
            } else {
                void var10_14;
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                int n10 = view.getMeasuredWidth();
                n7 = view.getMeasuredHeight();
                ArrayList arrayList3 = arrayList;
                n5 = n2;
                n6 = n3;
                if (n10 + n3 + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin > n8 - this.getPaddingLeft() - this.getPaddingRight()) {
                    this.mLineHeightList.add(n2);
                    this.mAllViews.add(arrayList);
                    n6 = 0;
                    n2 = marginLayoutParams.topMargin;
                    n5 = marginLayoutParams.bottomMargin + (n2 + n7);
                    ArrayList arrayList4 = new ArrayList();
                }
                n3 = n6 + (n10 + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + this.itemSpace);
                n2 = marginLayoutParams.topMargin;
                n2 = Math.max(n5, marginLayoutParams.bottomMargin + (n2 + n7));
                var10_14.add(view);
            }
            arrayList = var10_10;
        }
        this.mLineHeightList.add(n2);
        this.mAllViews.add(arrayList);
        this.getPaddingLeft();
        n3 = this.getPaddingTop();
        n6 = this.mAllViews.size();
        n4 = 0;
        while (n4 < n6) {
            arrayList = this.mAllViews.get(n4);
            n8 = this.mLineHeightList.get(n4);
            n2 = this.getStartLeft(arrayList);
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                view = (View)arrayList.get(n5);
                if (view.getVisibility() == 8) continue;
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                n7 = marginLayoutParams.leftMargin + n2;
                n9 = marginLayoutParams.topMargin + n3;
                view.layout(n7, n9, view.getMeasuredWidth() + n7, view.getMeasuredHeight() + n9);
                n9 = marginLayoutParams.leftMargin;
                n2 += view.getMeasuredWidth() + n9 + marginLayoutParams.rightMargin + this.itemSpace;
            }
            n2 = this.lineSpace;
            ++n4;
            n3 += n2 + n8;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getSize((int)n2);
        int n5 = View.MeasureSpec.getMode((int)n2);
        int n6 = View.MeasureSpec.getSize((int)n3);
        int n7 = View.MeasureSpec.getMode((int)n3);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = this.getChildCount();
        int n13 = 1;
        int n14 = 0;
        while (true) {
            block9: {
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                block12: {
                    block10: {
                        block11: {
                            block7: {
                                View view;
                                block8: {
                                    n19 = n9;
                                    n18 = n8;
                                    if (n14 >= n12) break block7;
                                    view = this.getChildAt(n14);
                                    if (view.getVisibility() != 8) break block8;
                                    if (n14 == n12 - 1) {
                                        n8 = Math.max(n10, n8);
                                        n9 += n11;
                                    }
                                    break block9;
                                }
                                this.measureChild(view, n2, n3);
                                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                                n17 = view.getMeasuredWidth() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin;
                                n19 = view.getMeasuredHeight() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
                                if (n10 + n17 <= n4 - this.getPaddingLeft() - this.getPaddingRight()) break block10;
                                n18 = n13 + 1;
                                n8 = Math.max(n8, n10 - this.itemSpace);
                                n16 = n9 + (this.lineSpace + n11);
                                if (n18 <= this.maxLineCount) break block11;
                                n19 = n16 - this.lineSpace;
                                n18 = n8;
                            }
                            n2 = n5 == 0x40000000 ? n4 : this.getPaddingLeft() + n18 + this.getPaddingRight();
                            n3 = n7 == 0x40000000 ? n6 : this.getPaddingTop() + n19 + this.getPaddingBottom();
                            this.setMeasuredDimension(n2, n3);
                            return;
                        }
                        n15 = n8;
                        break block12;
                    }
                    n18 = this.itemSpace;
                    n19 = Math.max(n11, n19);
                    n17 = n10 + (n18 + n17);
                    n18 = n13;
                    n16 = n9;
                    n15 = n8;
                }
                n13 = n18;
                n11 = n19;
                n10 = n17;
                n9 = n16;
                n8 = n15;
                if (n14 == n12 - 1) {
                    n8 = Math.max(n17, n15);
                    n9 = n16 + n19;
                    n13 = n18;
                    n11 = n19;
                    n10 = n17;
                }
            }
            ++n14;
        }
    }

    public void setItemSpace(int n2) {
        this.itemSpace = n2;
        this.requestLayout();
    }

    public void setLineSpace(int n2) {
        this.lineSpace = n2;
        this.requestLayout();
    }

    public void setMaxLineCount(int n2) {
        this.maxLineCount = n2;
        this.requestLayout();
    }

    public void setmGravity(String string2) {
        this.mGravity = string2;
        this.requestLayout();
    }
}

