/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.emoji;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import com.android.gmacs.R;
import com.android.gmacs.view.emoji.ChatEmoji;
import com.common.gmacs.parse.emoji.IEmojiParser;
import com.common.gmacs.utils.GmacsEnvi;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FaceConversionUtil
implements IEmojiParser {
    static List<List<ChatEmoji>> emojiLists;
    private static LinkedHashMap<String, Integer> emojiMap;
    private static List<ChatEmoji> emojis;
    private static FaceConversionUtil mFaceConversionUtil;

    static {
        int n2;
        emojiMap = new LinkedHashMap();
        emojis = new ArrayList<ChatEmoji>();
        emojiLists = new ArrayList<List<ChatEmoji>>();
        emojiMap.put("[\u5fae\u7b11]", R.drawable.smiley_001);
        emojiMap.put("[\u6487\u5634]", R.drawable.smiley_016);
        emojiMap.put("[\u8272]", R.drawable.smiley_011);
        emojiMap.put("[\u53d1\u5446]", R.drawable.smiley_036);
        emojiMap.put("[\u5f97\u610f]", R.drawable.smiley_037);
        emojiMap.put("[\u6d41\u6cea]", R.drawable.smiley_006);
        emojiMap.put("[\u5bb3\u7f9e]", R.drawable.smiley_029);
        emojiMap.put("[\u95ed\u5634]", R.drawable.smiley_030);
        emojiMap.put("[\u7761\u89c9]", R.drawable.smiley_022);
        emojiMap.put("[\u5927\u54ed]", R.drawable.smiley_003);
        emojiMap.put("[\u5c34\u5c2c]", R.drawable.smiley_032);
        emojiMap.put("[\u53d1\u6012]", R.drawable.smiley_004);
        emojiMap.put("[\u8c03\u76ae]", R.drawable.smiley_026);
        emojiMap.put("[\u5472\u7259]", R.drawable.smiley_008);
        emojiMap.put("[\u60ca\u8bb6]", R.drawable.smiley_069);
        emojiMap.put("[\u96be\u8fc7]", R.drawable.smiley_045);
        emojiMap.put("[\u9177]", R.drawable.smiley_040);
        emojiMap.put("[\u51b7\u6c57]", R.drawable.smiley_077);
        emojiMap.put("[\u6293\u72c2]", R.drawable.smiley_014);
        emojiMap.put("[\u5410]", R.drawable.smiley_028);
        emojiMap.put("[\u5077\u7b11]", R.drawable.smiley_002);
        emojiMap.put("[\u6109\u5feb]", R.drawable.smiley_053);
        emojiMap.put("[\u767d\u773c]", R.drawable.smiley_038);
        emojiMap.put("[\u50b2\u6162]", R.drawable.smiley_010);
        emojiMap.put("[\u9965\u997f]", R.drawable.smiley_079);
        emojiMap.put("[\u56f0]", R.drawable.smiley_023);
        emojiMap.put("[\u60ca\u6050]", R.drawable.smiley_020);
        emojiMap.put("[\u64e6\u6c57]", R.drawable.smiley_080);
        emojiMap.put("[\u61a8\u7b11]", R.drawable.smiley_005);
        emojiMap.put("[\u60a0\u95f2]", R.drawable.smiley_081);
        emojiMap.put("[\u594b\u6597]", R.drawable.smiley_046);
        emojiMap.put("[\u5492\u9a82]", R.drawable.smiley_042);
        emojiMap.put("[\u7591\u95ee]", R.drawable.smiley_025);
        emojiMap.put("[\u5618]", R.drawable.smiley_035);
        emojiMap.put("[\u6655]", R.drawable.smiley_009);
        emojiMap.put("[\u75af\u4e86]", R.drawable.smiley_082);
        emojiMap.put("[\u8870]", R.drawable.smiley_024);
        emojiMap.put("[\u9ab7\u9ac5]", R.drawable.smiley_083);
        emojiMap.put("[\u6572\u6253]", R.drawable.smiley_027);
        emojiMap.put("[\u518d\u89c1]", R.drawable.smiley_078);
        emojiMap.put("[\u6d41\u6c57]", R.drawable.smiley_007);
        emojiMap.put("[\u62a0\u9f3b]", R.drawable.smiley_015);
        emojiMap.put("[\u9f13\u638c]", R.drawable.smiley_017);
        emojiMap.put("[\u7cd7\u5927\u4e86]", R.drawable.smiley_039);
        emojiMap.put("[\u574f\u7b11]", R.drawable.smiley_018);
        emojiMap.put("[\u5de6\u54fc\u54fc]", R.drawable.smiley_034);
        emojiMap.put("[\u53f3\u54fc\u54fc]", R.drawable.smiley_033);
        emojiMap.put("[\u54c8\u6b20]", R.drawable.smiley_041);
        emojiMap.put("[\u9119\u89c6]", R.drawable.smiley_019);
        emojiMap.put("[\u59d4\u5c48]", R.drawable.smiley_021);
        emojiMap.put("[\u5feb\u54ed\u4e86]", R.drawable.smiley_012);
        emojiMap.put("[\u9634\u9669]", R.drawable.smiley_031);
        emojiMap.put("[\u4eb2\u4eb2]", R.drawable.smiley_013);
        emojiMap.put("[\u60ca\u5413]", R.drawable.smiley_044);
        emojiMap.put("[\u53ef\u601c]", R.drawable.smiley_043);
        emojiMap.put("[\u83dc\u5200]", R.drawable.smiley_084);
        emojiMap.put("[\u897f\u74dc]", R.drawable.smiley_074);
        emojiMap.put("[\u5564\u9152]", R.drawable.smiley_075);
        emojiMap.put("[\u7bee\u7403]", R.drawable.smiley_070);
        emojiMap.put("[\u4e52\u4e53]", R.drawable.smiley_072);
        emojiMap.put("[\u5496\u5561]", R.drawable.smiley_049);
        emojiMap.put("[\u7c73\u996d]", R.drawable.smiley_073);
        emojiMap.put("[\u732a\u5934]", R.drawable.smiley_047);
        emojiMap.put("[\u73ab\u7470]", R.drawable.smiley_051);
        emojiMap.put("[\u51cb\u8c22]", R.drawable.smiley_052);
        emojiMap.put("[\u793a\u7231]", R.drawable.smiley_056);
        emojiMap.put("[\u7231\u5fc3]", R.drawable.smiley_054);
        emojiMap.put("[\u5fc3\u788e]", R.drawable.smiley_055);
        emojiMap.put("[\u86cb\u7cd5]", R.drawable.smiley_059);
        emojiMap.put("[\u95ea\u7535]", R.drawable.smiley_060);
        emojiMap.put("[\u70b8\u5f39]", R.drawable.smiley_048);
        emojiMap.put("[\u5200]", R.drawable.smiley_068);
        emojiMap.put("[\u8db3\u7403]", R.drawable.smiley_071);
        emojiMap.put("[\u74e2\u866b]", R.drawable.smiley_085);
        emojiMap.put("[\u4fbf\u4fbf]", R.drawable.smiley_076);
        emojiMap.put("[\u6708\u4eae]", R.drawable.smiley_058);
        emojiMap.put("[\u592a\u9633]", R.drawable.smiley_057);
        emojiMap.put("[\u793c\u54c1]", R.drawable.smiley_050);
        emojiMap.put("[\u62e5\u62b1]", R.drawable.smiley_086);
        emojiMap.put("[\u5f3a]", R.drawable.smiley_063);
        emojiMap.put("[\u5f31]", R.drawable.smiley_064);
        emojiMap.put("[\u63e1\u624b]", R.drawable.smiley_067);
        emojiMap.put("[\u80dc\u5229]", R.drawable.smiley_065);
        emojiMap.put("[\u62b1\u62f3]", R.drawable.smiley_066);
        emojiMap.put("[\u52fe\u5f15]", R.drawable.smiley_062);
        emojiMap.put("[\u62f3\u5934]", R.drawable.smiley_087);
        emojiMap.put("[\u5dee\u52b2]", R.drawable.smiley_088);
        emojiMap.put("[\u7231\u4f60]", R.drawable.smiley_089);
        emojiMap.put("[\u4e0d]", R.drawable.smiley_090);
        emojiMap.put("[OK]", R.drawable.smiley_061);
        for (Map.Entry<String, Integer> entry : emojiMap.entrySet()) {
            ChatEmoji chatEmoji = new ChatEmoji();
            chatEmoji.setId(entry.getValue());
            chatEmoji.setCharacter(entry.getKey());
            emojis.add(chatEmoji);
        }
        int n3 = n2 = emojis.size() / 31;
        if (emojis.size() % 31 != 0) {
            n3 = n2 + 1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            emojiLists.add(FaceConversionUtil.getData(n2));
        }
    }

    private FaceConversionUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SpannableString dealExpression(String string2, int n2) {
        int[] nArray;
        EmojiMatcher emojiMatcher = new EmojiMatcher(string2);
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        while ((nArray = emojiMatcher.find()) != null) {
            Object object = string2.substring(nArray[0], nArray[1] + 1);
            if ((object = emojiMap.get(object)) == null || (Integer)object == 0) continue;
            int n3 = (int)(GmacsEnvi.appContext.getResources().getDisplayMetrics().density * (float)n2 + 0.5f);
            try {
                object = GmacsEnvi.appContext.getResources().getDrawable(((Integer)object).intValue());
            }
            catch (Resources.NotFoundException notFoundException) {
                continue;
            }
            object.setBounds(0, 0, n3, n3);
            spannableString.setSpan((Object)new ImageSpan((Drawable)object), nArray[0], nArray[1] + 1, 33);
        }
        return spannableString;
    }

    private static List<ChatEmoji> getData(int n2) {
        int n3;
        int n4 = n2 * 31;
        n2 = n3 = n4 + 31;
        if (n3 > emojis.size()) {
            n2 = emojis.size();
        }
        ArrayList<ChatEmoji> arrayList = new ArrayList<ChatEmoji>();
        arrayList.addAll(emojis.subList(n4, n2));
        if (arrayList.size() < 31) {
            for (n2 = arrayList.size(); n2 < 31; ++n2) {
                arrayList.add(new ChatEmoji());
            }
        }
        if (arrayList.size() == 31) {
            ChatEmoji chatEmoji = new ChatEmoji();
            chatEmoji.setId(R.drawable.gmacs_btn_del_emoji);
            arrayList.add(chatEmoji);
        }
        return arrayList;
    }

    public static FaceConversionUtil getInstace() {
        if (mFaceConversionUtil == null) {
            mFaceConversionUtil = new FaceConversionUtil();
        }
        return mFaceConversionUtil;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SpannableString getExpressionString(String string2, int n2) {
        if (string2 != null) return this.dealExpression(string2, n2);
        return new SpannableString((CharSequence)"");
    }

    public void replaceAllEmojis(Context context, Spannable spannable) {
        int[] nArray;
        int n2;
        Object object = (ImageSpan[])spannable.getSpans(0, spannable.length(), ImageSpan.class);
        int n3 = ((ImageSpan[])object).length;
        for (n2 = 0; n2 < n3; ++n2) {
            spannable.removeSpan((Object)object[n2]);
        }
        String string2 = spannable.toString();
        object = new EmojiMatcher(string2);
        while ((nArray = ((EmojiMatcher)object).find()) != null) {
            Object object2 = string2.substring(nArray[0], nArray[1] + 1);
            if ((object2 = emojiMap.get(object2)) == null || (Integer)object2 == 0) continue;
            n2 = (int)(context.getResources().getDisplayMetrics().density * 24.0f + 0.5f);
            object2 = context.getResources().getDrawable(((Integer)object2).intValue());
            object2.setBounds(0, 0, n2, n2);
            spannable.setSpan((Object)new ImageSpan((Drawable)object2), nArray[0], nArray[1] + 1, 33);
        }
    }

    public class EmojiMatcher {
        int index = 0;
        int len;
        CharSequence str;

        public EmojiMatcher(CharSequence charSequence) {
            this.str = charSequence;
            this.len = charSequence.length();
        }

        /*
         * Enabled aggressive block sorting
         */
        public int[] find() {
            int n2 = -1;
            while (this.index < this.len) {
                int n3;
                char c2 = this.str.charAt(this.index);
                if (c2 == '[') {
                    n3 = this.index;
                } else {
                    n3 = n2;
                    if (c2 == ']') {
                        n3 = n2;
                        if (n2 != -1) {
                            return new int[]{n2, this.index};
                        }
                    }
                }
                ++this.index;
                n2 = n3;
            }
            return null;
        }
    }
}

