/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.photoview.gestures;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.android.gmacs.view.photoview.gestures.EclairGestureDetector;

@TargetApi(value=8)
public class FroyoGestureDetector
extends EclairGestureDetector {
    protected final ScaleGestureDetector mDetector;

    public FroyoGestureDetector(Context context) {
        super(context);
        this.mDetector = new ScaleGestureDetector(context, new ScaleGestureDetector.OnScaleGestureListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                float f2 = scaleGestureDetector.getScaleFactor();
                if (Float.isNaN(f2)) return false;
                if (Float.isInfinite(f2)) {
                    return false;
                }
                FroyoGestureDetector.this.mListener.onScale(f2, scaleGestureDetector.getFocusX(), scaleGestureDetector.getFocusY());
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            }
        });
    }

    @Override
    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mDetector.onTouchEvent(motionEvent);
        return super.onTouchEvent(motionEvent);
    }
}

