/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

public final class Address {
    public final String address;
    public final String city;
    public final String cityCode;
    public final String country;
    public final String countryCode;
    public final String district;
    public final String province;
    public final String street;
    public final String streetNumber;

    private Address(Builder builder) {
        this.country = builder.mCountry;
        this.countryCode = builder.mCountryCode;
        this.province = builder.mProvince;
        this.city = builder.mCity;
        this.cityCode = builder.mCityCode;
        this.district = builder.mDistrict;
        this.street = builder.mStreet;
        this.streetNumber = builder.mStreetNumber;
        this.address = builder.mAddress;
    }

    public static class Builder {
        private static final String BEI_JING = "\u5317\u4eac";
        private static final String CHONG_QIN = "\u91cd\u5e86";
        private static final String SHANG_HAI = "\u4e0a\u6d77";
        private static final String TIAN_JIN = "\u5929\u6d25";
        private String mAddress = null;
        private String mCity = null;
        private String mCityCode = null;
        private String mCountry = null;
        private String mCountryCode = null;
        private String mDistrict = null;
        private String mProvince = null;
        private String mStreet = null;
        private String mStreetNumber = null;

        public Address build() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.mCountry != null) {
                stringBuffer.append(this.mCountry);
            }
            if (this.mProvince != null) {
                stringBuffer.append(this.mProvince);
            }
            if (!(this.mProvince == null || this.mCity == null || this.mProvince.contains(BEI_JING) && this.mCity.contains(BEI_JING) || this.mProvince.contains(SHANG_HAI) && this.mCity.contains(SHANG_HAI) || this.mProvince.contains(TIAN_JIN) && this.mCity.contains(TIAN_JIN) || this.mProvince.contains(CHONG_QIN) && this.mCity.contains(CHONG_QIN))) {
                stringBuffer.append(this.mCity);
            }
            if (this.mDistrict != null) {
                stringBuffer.append(this.mDistrict);
            }
            if (this.mStreet != null) {
                stringBuffer.append(this.mStreet);
            }
            if (this.mStreetNumber != null) {
                stringBuffer.append(this.mStreetNumber);
            }
            if (stringBuffer.length() > 0) {
                this.mAddress = stringBuffer.toString();
            }
            return new Address(this);
        }

        public Builder city(String string2) {
            this.mCity = string2;
            return this;
        }

        public Builder cityCode(String string2) {
            this.mCityCode = string2;
            return this;
        }

        public Builder country(String string2) {
            this.mCountry = string2;
            return this;
        }

        public Builder countryCode(String string2) {
            this.mCountryCode = string2;
            return this;
        }

        public Builder district(String string2) {
            this.mDistrict = string2;
            return this;
        }

        public Builder province(String string2) {
            this.mProvince = string2;
            return this;
        }

        public Builder street(String string2) {
            this.mStreet = string2;
            return this;
        }

        public Builder streetNumber(String string2) {
            this.mStreetNumber = string2;
            return this;
        }
    }
}

