/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.disklrucache;

import com.bumptech.glide.disklrucache.StrictLineReader;
import com.bumptech.glide.disklrucache.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    private static final String READ = "READ";
    private static final String REMOVE = "REMOVE";
    static final String VERSION_1 = "1";
    private final int appVersion;
    private final Callable<Void> cleanupCallable;
    private final File directory;
    final ThreadPoolExecutor executorService;
    private final File journalFile;
    private final File journalFileBackup;
    private final File journalFileTmp;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private long maxSize;
    private long nextSequenceNumber = 0L;
    private int redundantOpCount;
    private long size = 0L;
    private final int valueCount;

    private DiskLruCache(File file, int n2, int n3, long l2) {
        this.executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.cleanupCallable = new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() throws Exception {
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (DiskLruCache.this.journalWriter == null) {
                        return null;
                    }
                    DiskLruCache.this.trimToSize();
                    if (!DiskLruCache.this.journalRebuildRequired()) return null;
                    DiskLruCache.this.rebuildJournal();
                    DiskLruCache.access$402(DiskLruCache.this, 0);
                    return null;
                }
            }
        };
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
    }

    static /* synthetic */ int access$402(DiskLruCache diskLruCache, int n2) {
        diskLruCache.redundantOpCount = n2;
        return n2;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEdit(Editor var1_1, boolean var2_2) throws IOException {
        var3_3 = 0;
        synchronized (this) {
            block19: {
                var4_4 = Editor.access$1400((Editor)var1_1);
                if (Entry.access$700((Entry)var4_4) != var1_1) {
                    var1_1 = new IllegalStateException();
                    throw var1_1;
                }
                var5_5 = var3_3;
                if (var2_2) {
                    var5_5 = var3_3;
                    if (!Entry.access$600((Entry)var4_4)) {
                        var6_6 = 0;
                        while (true) {
                            var5_5 = var3_3;
                            if (var6_6 >= this.valueCount) break block19;
                            if (!Editor.access$1500((Editor)var1_1)[var6_6]) {
                                var1_1.abort();
                                var4_4 = new StringBuilder();
                                var1_1 = new IllegalStateException(var4_4.append("Newly created entry didn't create value for index ").append(var6_6).toString());
                                throw var1_1;
                            }
                            if (!var4_4.getDirtyFile(var6_6).exists()) {
                                var1_1.abort();
                                break;
                            }
                            ++var6_6;
                        }
lbl25:
                        // 3 sources

                        return;
                    }
                }
            }
            while (var5_5 < this.valueCount) {
                var7_7 = var4_4.getDirtyFile(var5_5);
                if (var2_2) {
                    if (var7_7.exists()) {
                        var1_1 = var4_4.getCleanFile(var5_5);
                        var7_7.renameTo((File)var1_1);
                        var8_8 = Entry.access$1000((Entry)var4_4)[var5_5];
                        Entry.access$1000((Entry)var4_4)[var5_5] = var10_9 = var1_1.length();
                        this.size = this.size - var8_8 + var10_9;
                    }
                } else {
                    DiskLruCache.deleteIfExists(var7_7);
                }
                ++var5_5;
            }
            ++this.redundantOpCount;
            Entry.access$702((Entry)var4_4, null);
            if (Entry.access$600((Entry)var4_4) | var2_2) {
                Entry.access$602((Entry)var4_4, true);
                this.journalWriter.append("CLEAN");
                this.journalWriter.append(' ');
                this.journalWriter.append(Entry.access$1100((Entry)var4_4));
                this.journalWriter.append(var4_4.getLengths());
                this.journalWriter.append('\n');
                if (var2_2) {
                    var8_8 = this.nextSequenceNumber;
                    this.nextSequenceNumber = 1L + var8_8;
                    Entry.access$1202((Entry)var4_4, var8_8);
                }
            } else {
                this.lruEntries.remove(Entry.access$1100((Entry)var4_4));
                this.journalWriter.append("REMOVE");
                this.journalWriter.append(' ');
                this.journalWriter.append(Entry.access$1100((Entry)var4_4));
                this.journalWriter.append('\n');
            }
            this.journalWriter.flush();
            if (this.size <= this.maxSize && !this.journalRebuildRequired()) ** GOTO lbl25
            this.executorService.submit(this.cleanupCallable);
            ** continue;
        }
    }

    private static void deleteIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Editor edit(String object, long l2) throws IOException {
        synchronized (this) {
            Editor editor;
            this.checkNotClosed();
            Entry entry = this.lruEntries.get(object);
            if (l2 != -1L) {
                if (entry == null) return null;
                long l3 = entry.sequenceNumber;
                if (l3 != l2) {
                    return null;
                }
            }
            if (entry == null) {
                entry = new Entry((String)object);
                this.lruEntries.put((String)object, entry);
            } else {
                editor = entry.currentEditor;
                if (editor != null) {
                    return null;
                }
            }
            editor = new Editor(this, entry);
            Entry.access$702(entry, editor);
            this.journalWriter.append(DIRTY);
            this.journalWriter.append(' ');
            this.journalWriter.append((CharSequence)object);
            this.journalWriter.append('\n');
            this.journalWriter.flush();
            return editor;
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean journalRebuildRequired() {
        if (this.redundantOpCount < 2000) return false;
        if (this.redundantOpCount < this.lruEntries.size()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DiskLruCache open(File object, int n2, int n3, long l2) throws IOException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        Object object2 = new File((File)object, JOURNAL_FILE_BACKUP);
        if (((File)object2).exists()) {
            File file = new File((File)object, JOURNAL_FILE);
            if (file.exists()) {
                ((File)object2).delete();
            } else {
                DiskLruCache.renameTo((File)object2, file, false);
            }
        }
        object2 = new DiskLruCache((File)object, n2, n3, l2);
        if (((DiskLruCache)object2).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                return object2;
            }
            catch (IOException iOException) {
                System.out.println("DiskLruCache " + object + " is corrupt: " + iOException.getMessage() + ", removing");
                ((DiskLruCache)object2).delete();
            }
        }
        ((File)object).mkdirs();
        object = new DiskLruCache((File)object, n2, n3, l2);
        super.rebuildJournal();
        return object;
    }

    private void processJournal() throws IOException {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                }
                continue;
            }
            Entry.access$702(entry, null);
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n2));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n2));
            }
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readJournal() throws IOException {
        StrictLineReader strictLineReader;
        block9: {
            strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
            String string2 = strictLineReader.readLine();
            String string3 = strictLineReader.readLine();
            Object object = strictLineReader.readLine();
            String string4 = strictLineReader.readLine();
            String string5 = strictLineReader.readLine();
            if (!(MAGIC.equals(string2) && VERSION_1.equals(string3) && Integer.toString(this.appVersion).equals(object) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                StringBuilder stringBuilder = new StringBuilder();
                object = new IOException(stringBuilder.append("unexpected journal header: [").append(string2).append(", ").append(string3).append(", ").append(string4).append(", ").append(string5).append("]").toString());
                throw object;
            }
            break block9;
            finally {
                Util.closeQuietly(strictLineReader);
            }
        }
        int n2 = 0;
        while (true) {
            this.readJournalLine(strictLineReader.readLine());
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readJournalLine(String stringArray) throws IOException {
        Entry entry;
        String string2;
        int n2 = stringArray.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
        int n3 = n2 + 1;
        int n4 = stringArray.indexOf(32, n3);
        if (n4 == -1) {
            string2 = stringArray.substring(n3);
            if (n2 == REMOVE.length() && stringArray.startsWith(REMOVE)) {
                this.lruEntries.remove(string2);
                return;
            }
        } else {
            string2 = stringArray.substring(n3, n4);
        }
        Entry entry2 = entry = this.lruEntries.get(string2);
        if (entry == null) {
            entry2 = new Entry(string2);
            this.lruEntries.put(string2, entry2);
        }
        if (n4 != -1 && n2 == CLEAN.length() && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            Entry.access$602(entry2, true);
            Entry.access$702(entry2, null);
            entry2.setLengths(stringArray);
            return;
        }
        if (n4 == -1 && n2 == DIRTY.length() && stringArray.startsWith(DIRTY)) {
            Entry.access$702(entry2, new Editor(this, entry2));
            return;
        }
        if (n4 != -1 || n2 != READ.length() || !stringArray.startsWith(READ)) throw new IOException("unexpected journal line: " + (String)stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildJournal() throws IOException {
        synchronized (this) {
            if (this.journalWriter != null) {
                this.journalWriter.close();
            }
            Object object = new FileOutputStream(this.journalFileTmp);
            Object object22 = new OutputStreamWriter((OutputStream)object, Util.US_ASCII);
            Closeable closeable = new BufferedWriter((Writer)object22);
            try {
                closeable.write(MAGIC);
                closeable.write("\n");
                closeable.write(VERSION_1);
                closeable.write("\n");
                closeable.write(Integer.toString(this.appVersion));
                closeable.write("\n");
                closeable.write(Integer.toString(this.valueCount));
                closeable.write("\n");
                closeable.write("\n");
                for (Object object22 : this.lruEntries.values()) {
                    StringBuilder stringBuilder;
                    if (((Entry)object22).currentEditor != null) {
                        stringBuilder = new StringBuilder();
                        closeable.write(stringBuilder.append("DIRTY ").append(((Entry)object22).key).append('\n').toString());
                        continue;
                    }
                    stringBuilder = new StringBuilder();
                    closeable.write(stringBuilder.append("CLEAN ").append(((Entry)object22).key).append(((Entry)object22).getLengths()).append('\n').toString());
                }
            }
            finally {
                ((Writer)closeable).close();
            }
            if (this.journalFile.exists()) {
                DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
            }
            DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
            this.journalFileBackup.delete();
            closeable = new FileOutputStream(this.journalFile, true);
            object = new OutputStreamWriter((OutputStream)closeable, Util.US_ASCII);
            this.journalWriter = object22 = new BufferedWriter((Writer)object);
            return;
        }
    }

    private static void renameTo(File file, File file2, boolean bl) throws IOException {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            this.remove(this.lruEntries.entrySet().iterator().next().getKey());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        synchronized (this) {
            Object object = this.journalWriter;
            if (object != null) {
                object = new ArrayList(this.lruEntries.values());
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    Entry entry = (Entry)object.next();
                    if (entry.currentEditor == null) continue;
                    entry.currentEditor.abort();
                }
                this.trimToSize();
                this.journalWriter.close();
                this.journalWriter = null;
            }
            return;
        }
    }

    public void delete() throws IOException {
        this.close();
        Util.deleteContents(this.directory);
    }

    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    public void flush() throws IOException {
        synchronized (this) {
            this.checkNotClosed();
            this.trimToSize();
            this.journalWriter.flush();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value get(String string2) throws IOException {
        Value value = null;
        synchronized (this) {
            Entry entry;
            block10: {
                this.checkNotClosed();
                entry = this.lruEntries.get(string2);
                if (entry != null) break block10;
                return value;
            }
            Value value2 = value;
            if (!entry.readable) return value2;
            File[] fileArray = entry.cleanFiles;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                value2 = value;
                if (!fileArray[i2].exists()) return value2;
                continue;
            }
            try {
                ++this.redundantOpCount;
                this.journalWriter.append(READ);
                this.journalWriter.append(' ');
                this.journalWriter.append(string2);
                this.journalWriter.append('\n');
                if (this.journalRebuildRequired()) {
                    this.executorService.submit(this.cleanupCallable);
                }
                value2 = new Value(string2, entry.sequenceNumber, entry.cleanFiles, entry.lengths);
                return value2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getMaxSize() {
        synchronized (this) {
            long l2 = this.maxSize;
            return l2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        synchronized (this) {
            Writer writer = this.journalWriter;
            if (writer != null) return false;
            return true;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(String var1_1) throws IOException {
        var2_2 = 0;
        synchronized (this) {
            block6: {
                this.checkNotClosed();
                var3_3 = this.lruEntries.get(var1_1);
                if (var3_3 == null) return false;
                var4_4 = Entry.access$700((Entry)var3_3);
                if (var4_4 == null) ** GOTO lbl12
                return false;
lbl-1000:
                // 1 sources

                {
                    this.size -= Entry.access$1000((Entry)var3_3)[var2_2];
                    Entry.access$1000((Entry)var3_3)[var2_2] = 0L;
                    ++var2_2;
lbl12:
                    // 2 sources

                    if (var2_2 >= this.valueCount) break block6;
                    ** while (!(var4_4 = var3_3.getCleanFile((int)var2_2)).exists() || var4_4.delete())
                }
lbl14:
                // 1 sources

                var1_1 = new StringBuilder();
                var3_3 = new IOException(var1_1.append("failed to delete ").append(var4_4).toString());
                throw var3_3;
            }
            ++this.redundantOpCount;
            this.journalWriter.append("REMOVE");
            this.journalWriter.append(' ');
            this.journalWriter.append(var1_1);
            this.journalWriter.append('\n');
            this.lruEntries.remove(var1_1);
            if (this.journalRebuildRequired() == false) return true;
            this.executorService.submit(this.cleanupCallable);
            return true;
        }
    }

    public void setMaxSize(long l2) {
        synchronized (this) {
            this.maxSize = l2;
            this.executorService.submit(this.cleanupCallable);
            return;
        }
    }

    public long size() {
        synchronized (this) {
            long l2 = this.size;
            return l2;
        }
    }

    public static final class Editor {
        private boolean committed;
        private final Entry entry;
        final /* synthetic */ DiskLruCache this$0;
        private final boolean[] written;

        /*
         * Enabled aggressive block sorting
         */
        private Editor(DiskLruCache object, Entry entry) {
            this.this$0 = object;
            this.entry = entry;
            object = entry.readable ? null : (Object)new boolean[((DiskLruCache)object).valueCount];
            this.written = (boolean[])object;
        }

        static /* synthetic */ Entry access$1400(Editor editor) {
            return editor.entry;
        }

        static /* synthetic */ boolean[] access$1500(Editor editor) {
            return editor.written;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private InputStream newInputStream(int n2) throws IOException {
            Object object = null;
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    object = new IllegalStateException();
                    throw object;
                }
                if (!this.entry.readable) {
                    return object;
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.entry.getCleanFile(n2));
                    return fileInputStream;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return object;
                }
            }
        }

        public void abort() throws IOException {
            this.this$0.completeEdit(this, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abortUnlessCommitted() {
            if (this.committed) return;
            try {
                this.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        public void commit() throws IOException {
            this.this$0.completeEdit(this, true);
            this.committed = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public File getFile(int n2) throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                File file = this.entry.getDirtyFile(n2);
                if (!this.this$0.directory.exists()) {
                    this.this$0.directory.mkdirs();
                }
                return file;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getString(int n2) throws IOException {
            InputStream inputStream = this.newInputStream(n2);
            if (inputStream == null) return null;
            return DiskLruCache.inputStreamToString(inputStream);
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void set(int n2, String string2) throws IOException {
            OutputStreamWriter outputStreamWriter;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.getFile(n2));
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Util.UTF_8);
            }
            catch (Throwable throwable) {
                void var2_4;
                outputStreamWriter = null;
                Util.closeQuietly(outputStreamWriter);
                throw var2_4;
            }
            outputStreamWriter.write(string2);
            {
                catch (Throwable throwable) {}
            }
            Util.closeQuietly(outputStreamWriter);
        }
    }

    private final class Entry {
        File[] cleanFiles;
        private Editor currentEditor;
        File[] dirtyFiles;
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private long sequenceNumber;

        private Entry(String charSequence) {
            this.key = charSequence;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            charSequence = new StringBuilder((String)charSequence).append('.');
            int n2 = ((StringBuilder)charSequence).length();
            for (int i2 = 0; i2 < DiskLruCache.this.valueCount; ++i2) {
                ((StringBuilder)charSequence).append(i2);
                this.cleanFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(".tmp");
                this.dirtyFiles[i2] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n2);
            }
        }

        static /* synthetic */ long access$1202(Entry entry, long l2) {
            entry.sequenceNumber = l2;
            return l2;
        }

        static /* synthetic */ boolean access$602(Entry entry, boolean bl) {
            entry.readable = bl;
            return bl;
        }

        static /* synthetic */ Editor access$702(Entry entry, Editor editor) {
            entry.currentEditor = editor;
            return editor;
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        private void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n2 = 0;
            while (true) {
                try {
                    if (n2 >= stringArray.length) break;
                    this.lengths[n2] = Long.parseLong(stringArray[n2]);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.invalidLengths(stringArray);
                }
            }
        }

        public File getCleanFile(int n2) {
            return this.cleanFiles[n2];
        }

        public File getDirtyFile(int n2) {
            return this.dirtyFiles[n2];
        }

        public String getLengths() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l2 : this.lengths) {
                stringBuilder.append(' ').append(l2);
            }
            return stringBuilder.toString();
        }
    }

    public final class Value {
        private final File[] files;
        private final String key;
        private final long[] lengths;
        private final long sequenceNumber;

        private Value(String string2, long l2, File[] fileArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l2;
            this.files = fileArray;
            this.lengths = lArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public File getFile(int n2) {
            return this.files[n2];
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }

        public String getString(int n2) throws IOException {
            return DiskLruCache.inputStreamToString(new FileInputStream(this.files[n2]));
        }
    }
}

