/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.util.Log;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifHeaderParser {
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    static final int MIN_FRAME_DELAY = 3;
    public static final String TAG = "GifHeaderParser";
    private final byte[] block = new byte[256];
    private int blockSize = 0;
    private GifHeader header;
    private ByteBuffer rawData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean err() {
        if (this.header.status == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int read() {
        int n2 = 0;
        try {
            byte by = this.rawData.get();
            return by & 0xFF;
        }
        catch (Exception exception) {
            this.header.status = 1;
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readBitmap() {
        boolean bl = true;
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int n2 = this.read();
        boolean bl2 = (n2 & 0x80) != 0;
        int n3 = (int)Math.pow(2.0, (n2 & 7) + 1);
        Object object = this.header.currentFrame;
        if ((n2 & 0x40) == 0) {
            bl = false;
        }
        ((GifFrame)object).interlace = bl;
        this.header.currentFrame.lct = (int[])(bl2 ? this.readColorTable(n3) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        object = this.header;
        ++((GifHeader)object).frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readBlock() {
        int n2 = 0;
        int n3 = 0;
        this.blockSize = this.read();
        if (this.blockSize <= 0) return n2;
        int n5 = 0;
        while (true) {
            int n4 = n5;
            n2 = n3;
            try {
                if (n3 >= this.blockSize) return n2;
                n4 = n5;
                n4 = n5 = this.blockSize - n3;
                this.rawData.get(this.block, n3, n5);
                n3 += n5;
            }
            catch (Exception exception) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Error Reading Block n: " + n3 + " count: " + n4 + " blockSize: " + this.blockSize), (Throwable)exception);
                }
                this.header.status = 1;
                return n3;
            }
        }
    }

    private int[] readColorTable(int n2) {
        int[] nArray;
        int n3;
        int[] nArray2;
        int n4 = 0;
        byte[] byArray = new byte[n2 * 3];
        try {
            this.rawData.get(byArray);
            nArray2 = new int[256];
            n3 = 0;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            nArray = null;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Format Error Reading Color Table", (Throwable)bufferUnderflowException);
            }
            this.header.status = 1;
        }
        while (true) {
            nArray = nArray2;
            if (n4 < n2) {
                int n5 = n3 + 1;
                byte by = byArray[n3];
                int n6 = n5 + 1;
                n5 = byArray[n5];
                n3 = n6 + 1;
                nArray2[n4] = (by & 0xFF) << 16 | 0xFF000000 | (n5 & 0xFF) << 8 | byArray[n6] & 0xFF;
                ++n4;
                continue;
            }
            break;
        }
        return nArray;
    }

    private void readContents() {
        boolean bl = false;
        block11: while (!bl && !this.err()) {
            switch (this.read()) {
                default: {
                    this.header.status = 1;
                    continue block11;
                }
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    switch (this.read()) {
                        default: {
                            this.skip();
                            continue block11;
                        }
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            String string2 = "";
                            for (int i2 = 0; i2 < 11; ++i2) {
                                string2 = string2 + (char)this.block[i2];
                            }
                            if (string2.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: 
                    }
                    this.skip();
                    continue block11;
                }
                case 59: 
            }
            bl = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readGraphicControlExt() {
        int n2;
        boolean bl = true;
        this.read();
        int n3 = this.read();
        this.header.currentFrame.dispose = (n3 & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        GifFrame gifFrame = this.header.currentFrame;
        if ((n3 & 1) == 0) {
            bl = false;
        }
        gifFrame.transparency = bl;
        n3 = n2 = this.readShort();
        if (n2 < 3) {
            n3 = 10;
        }
        this.header.currentFrame.delay = n3 * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readHeader() {
        String string2 = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string2 = string2 + (char)this.read();
        }
        if (!string2.startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (!this.header.gctFlag) return;
        if (this.err()) return;
        this.header.gct = this.readColorTable(this.header.gctSize);
        this.header.bgColor = this.header.gct[this.header.bgIndex];
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int n2 = this.read();
        GifHeader gifHeader = this.header;
        boolean bl = (n2 & 0x80) != 0;
        gifHeader.gctFlag = bl;
        this.header.gctSize = 2 << (n2 & 7);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            byte by = this.block[1];
            byte by2 = this.block[2];
            this.header.loopCount = by & 0xFF | (by2 & 0xFF) << 8;
        } while (this.blockSize > 0 && !this.err());
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    private void skip() {
        int n2;
        do {
            n2 = this.read();
            this.rawData.position(this.rawData.position() + n2);
        } while (n2 > 0);
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (this.err()) return this.header;
        this.readContents();
        if (this.header.frameCount >= 0) return this.header;
        this.header.status = 1;
        return this.header;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GifHeaderParser setData(byte[] byArray) {
        this.reset();
        if (byArray != null) {
            this.rawData = ByteBuffer.wrap(byArray);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
            return this;
        }
        this.rawData = null;
        this.header.status = 2;
        return this;
    }
}

