/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifencoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.Log;
import com.bumptech.glide.gifencoder.LZWEncoder;
import com.bumptech.glide.gifencoder.NeuQuant;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AnimatedGifEncoder {
    private static final double MIN_TRANSPARENT_PERCENTAGE = 4.0;
    private static final String TAG = "AnimatedGifEncoder";
    private boolean closeStream = false;
    private int colorDepth;
    private byte[] colorTab;
    private int delay = 0;
    private int dispose = -1;
    private boolean firstFrame = true;
    private boolean hasTransparentPixels;
    private int height;
    private Bitmap image;
    private byte[] indexedPixels;
    private OutputStream out;
    private int palSize = 7;
    private byte[] pixels;
    private int repeat = -1;
    private int sample = 10;
    private boolean sizeSet = false;
    private boolean started = false;
    private int transIndex;
    private Integer transparent = null;
    private boolean[] usedEntry = new boolean[256];
    private int width;

    /*
     * Enabled aggressive block sorting
     */
    private void analyzePixels() {
        int n2;
        int n3 = this.pixels.length;
        int n4 = n3 / 3;
        this.indexedPixels = new byte[n4];
        NeuQuant neuQuant = new NeuQuant(this.pixels, n3, this.sample);
        this.colorTab = neuQuant.process();
        for (n3 = 0; n3 < this.colorTab.length; n3 += 3) {
            n2 = this.colorTab[n3];
            this.colorTab[n3] = this.colorTab[n3 + 2];
            this.colorTab[n3 + 2] = (byte)n2;
            this.usedEntry[n3 / 3] = false;
        }
        n2 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            byte[] byArray = this.pixels;
            int n5 = n2 + 1;
            int n6 = byArray[n2];
            byArray = this.pixels;
            int n7 = n5 + 1;
            n5 = byArray[n5];
            byArray = this.pixels;
            n2 = n7 + 1;
            n6 = neuQuant.map(n6 & 0xFF, n5 & 0xFF, byArray[n7] & 0xFF);
            this.usedEntry[n6] = true;
            this.indexedPixels[n3] = (byte)n6;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
            return;
        }
        if (!this.hasTransparentPixels) return;
        this.transIndex = this.findClosest(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int findClosest(int n2) {
        int n3 = 0;
        if (this.colorTab == null) {
            return -1;
        }
        int n4 = Color.red((int)n2);
        int n5 = Color.green((int)n2);
        int n6 = Color.blue((int)n2);
        int n7 = 0x1000000;
        int n8 = this.colorTab.length;
        n2 = 0;
        while (true) {
            int n9 = n2;
            if (n3 >= n8) return n9;
            byte[] byArray = this.colorTab;
            n9 = n3 + 1;
            n3 = n4 - (byArray[n3] & 0xFF);
            byArray = this.colorTab;
            int n10 = n9 + 1;
            n9 = n5 - (byArray[n9] & 0xFF);
            int n11 = n6 - (this.colorTab[n10] & 0xFF);
            n3 = n3 * n3 + n9 * n9 + n11 * n11;
            n9 = n10 / 3;
            if (this.usedEntry[n9] && n3 < n7) {
                n7 = n9;
                n2 = n3;
            } else {
                n3 = n2;
                n2 = n7;
                n7 = n3;
            }
            n9 = n7;
            n3 = n10 + 1;
            n7 = n2;
            n2 = n9;
        }
    }

    private void getImagePixels() {
        Object object;
        boolean bl = false;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        if (n2 != this.width || n3 != this.height) {
            object = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(object).drawBitmap(object, 0.0f, 0.0f, null);
            this.image = object;
        }
        object = new int[n2 * n3];
        this.image.getPixels((int[])object, 0, n2, 0, 0, n2, n3);
        this.pixels = new byte[((Bitmap)object).length * 3];
        this.hasTransparentPixels = false;
        int n4 = ((Bitmap)object).length;
        int n5 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            Bitmap bitmap = object[n2];
            int n6 = n5;
            if (bitmap == false) {
                n6 = n5 + 1;
            }
            byte[] byArray = this.pixels;
            n5 = n3 + 1;
            byArray[n3] = (byte)(bitmap & 0xFF);
            byArray = this.pixels;
            int n7 = n5 + 1;
            byArray[n5] = (byte)(bitmap >> 8 & 0xFF);
            byArray = this.pixels;
            n3 = n7 + 1;
            byArray[n7] = (byte)(bitmap >> 16 & 0xFF);
            n5 = n6;
        }
        double d2 = (double)(n5 * 100) / (double)((Bitmap)object).length;
        if (d2 > 4.0) {
            bl = true;
        }
        this.hasTransparentPixels = bl;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("got pixels for frame with " + d2 + "% transparent pixels"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeGraphicCtrlExt() throws IOException {
        int n2;
        int n3;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null && !this.hasTransparentPixels) {
            n3 = 0;
            n2 = 0;
        } else {
            n2 = 1;
            n3 = 2;
        }
        if (this.dispose >= 0) {
            n3 = this.dispose & 7;
        }
        this.out.write(n3 << 2 | 0 | 0 | n2);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
            return;
        }
        this.out.write(this.palSize | 0x80);
    }

    private void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(this.palSize | 0xF0);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    private void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n2 = this.colorTab.length;
        for (int i2 = 0; i2 < 768 - n2; ++i2) {
            this.out.write(0);
        }
    }

    private void writePixels() throws IOException {
        new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth).encode(this.out);
    }

    private void writeShort(int n2) throws IOException {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
    }

    private void writeString(String string2) throws IOException {
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            this.out.write((byte)string2.charAt(i2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFrame(Bitmap bitmap) {
        if (bitmap == null) return false;
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (!this.sizeSet) {
                this.setSize(bitmap.getWidth(), bitmap.getHeight());
            }
            this.image = bitmap;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finish() {
        boolean bl = false;
        if (!this.started) {
            return bl;
        }
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setDelay(int n2) {
        this.delay = Math.round((float)n2 / 10.0f);
    }

    public void setDispose(int n2) {
        if (n2 >= 0) {
            this.dispose = n2;
        }
    }

    public void setFrameRate(float f2) {
        if (f2 != 0.0f) {
            this.delay = Math.round(100.0f / f2);
        }
    }

    public void setQuality(int n2) {
        int n3 = n2;
        if (n2 < 1) {
            n3 = 1;
        }
        this.sample = n3;
    }

    public void setRepeat(int n2) {
        if (n2 >= 0) {
            this.repeat = n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSize(int n2, int n3) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n2;
        this.height = n3;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setTransparent(int n2) {
        this.transparent = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start(OutputStream outputStream) {
        boolean bl = false;
        if (outputStream == null) {
            return bl;
        }
        bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start(String string2) {
        boolean bl;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.out = bufferedOutputStream;
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return bl;
    }
}

