/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifencoder;

import java.io.IOException;
import java.io.OutputStream;

class LZWEncoder {
    static final int BITS = 12;
    private static final int EOF = -1;
    static final int HSIZE = 5003;
    int ClearCode;
    int EOFCode;
    int a_count;
    byte[] accum;
    boolean clear_flg = false;
    int[] codetab;
    private int curPixel;
    int cur_accum = 0;
    int cur_bits = 0;
    int free_ent = 0;
    int g_init_bits;
    int hsize = 5003;
    int[] htab = new int[5003];
    private int imgH;
    private int imgW;
    private int initCodeSize;
    int[] masks;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int n_bits;
    private byte[] pixAry;
    private int remaining;

    LZWEncoder(int n2, int n3, byte[] byArray, int n4) {
        this.codetab = new int[5003];
        this.masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        this.accum = new byte[256];
        this.imgW = n2;
        this.imgH = n3;
        this.pixAry = byArray;
        this.initCodeSize = Math.max(2, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte[] byArray = this.pixAry;
        int n2 = this.curPixel;
        this.curPixel = n2 + 1;
        return byArray[n2] & 0xFF;
    }

    final int MAXCODE(int n2) {
        return (1 << n2) - 1;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        byte[] byArray = this.accum;
        int n2 = this.a_count;
        this.a_count = n2 + 1;
        byArray[n2] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.htab[i2] = -1;
        }
    }

    void compress(int n2, OutputStream outputStream) throws IOException {
        int n3;
        int n4 = 0;
        this.g_init_bits = n2;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n2 - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        int n5 = this.nextPixel();
        for (n2 = this.hsize; n2 < 65536; n2 *= 2) {
            ++n4;
        }
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        n2 = n5;
        block1: while ((n3 = this.nextPixel()) != -1) {
            n5 = n3 << 8 - n4 ^ n2;
            int n7 = (n3 << this.maxbits) + n2;
            if (this.htab[n5] == n7) {
                n2 = this.codetab[n5];
                continue;
            }
            int n8 = n5;
            if (this.htab[n5] >= 0) {
                n8 = n6 - n5;
                int n9 = n5;
                if (n5 == 0) {
                    n8 = 1;
                    n9 = n5;
                }
                do {
                    n5 = n9 -= n8;
                    if (n9 < 0) {
                        n5 = n9 + n6;
                    }
                    if (this.htab[n5] == n7) {
                        n2 = this.codetab[n5];
                        continue block1;
                    }
                    n9 = n5;
                } while (this.htab[n5] >= 0);
                n8 = n5;
            }
            this.output(n2, outputStream);
            if (this.free_ent < this.maxmaxcode) {
                int[] nArray = this.codetab;
                n2 = this.free_ent;
                this.free_ent = n2 + 1;
                nArray[n8] = n2;
                this.htab[n8] = n7;
                n2 = n3;
                continue;
            }
            this.cl_block(outputStream);
            n2 = n3;
        }
        this.output(n2, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, outputStream);
        outputStream.write(0);
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void output(int n2, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n2 << this.cur_bits) : n2;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                int n3;
                this.n_bits = n3 = this.g_init_bits;
                this.maxcode = this.MAXCODE(n3);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n2 == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }
}

