/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.cache.DiskCache;
import java.io.File;
import java.io.IOException;

class CacheLoader {
    private static final String TAG = "CacheLoader";
    private final DiskCache diskCache;

    public CacheLoader(DiskCache diskCache) {
        this.diskCache = diskCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Z> Resource<Z> load(Key key, ResourceDecoder<File, Z> resource, int n2, int n3) {
        Resource resource2;
        block4: {
            resource2 = null;
            Resource resource3 = null;
            File file = this.diskCache.get(key);
            if (file == null) {
                return resource3;
            }
            try {
                resource = resource.decode(file, n2, n3);
            }
            catch (IOException iOException) {
                resource = resource2;
                if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                Log.d((String)TAG, (String)"Exception decoding image from cache", (Throwable)iOException);
                resource = resource2;
            }
        }
        resource2 = resource;
        if (resource != null) return resource2;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Failed to decode image from cache or not present in cache");
        }
        this.diskCache.delete(key);
        return resource;
    }
}

