/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DecodeJob;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.executor.Prioritized;
import com.bumptech.glide.request.ResourceCallback;

class EngineRunnable
implements Prioritized,
Runnable {
    private static final String TAG = "EngineRunnable";
    private final DecodeJob<?, ?, ?> decodeJob;
    private volatile boolean isCancelled;
    private final EngineRunnableManager manager;
    private final Priority priority;
    private Stage stage;

    public EngineRunnable(EngineRunnableManager engineRunnableManager, DecodeJob<?, ?, ?> decodeJob, Priority priority) {
        this.manager = engineRunnableManager;
        this.decodeJob = decodeJob;
        this.stage = Stage.CACHE;
        this.priority = priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource<?> decode() throws Exception {
        if (!this.isDecodingFromCache()) return this.decodeFromSource();
        return this.decodeFromCache();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource<?> decodeFromCache() throws Exception {
        Resource<?> resource;
        try {
            resource = this.decodeJob.decodeResultFromCache();
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Exception decoding result from cache: " + exception));
            }
            resource = null;
        }
        Resource<?> resource2 = resource;
        if (resource != null) return resource2;
        return this.decodeJob.decodeSourceFromCache();
    }

    private Resource<?> decodeFromSource() throws Exception {
        return this.decodeJob.decodeFromSource();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDecodingFromCache() {
        if (this.stage != Stage.CACHE) return false;
        return true;
    }

    private void onLoadComplete(Resource resource) {
        this.manager.onResourceReady(resource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onLoadFailed(Exception exception) {
        if (this.isDecodingFromCache()) {
            this.stage = Stage.SOURCE;
            this.manager.submitForSource(this);
            return;
        }
        this.manager.onException(exception);
    }

    public void cancel() {
        this.isCancelled = true;
        this.decodeJob.cancel();
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Resource<?> resource;
        Exception exception = null;
        if (this.isCancelled) {
            return;
        }
        try {
            Resource<?> resource2;
            resource = resource2 = this.decode();
        }
        catch (Exception exception2) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Exception decoding", (Throwable)exception2);
            }
            resource = null;
            exception = exception2;
        }
        if (this.isCancelled) {
            if (resource == null) return;
            resource.recycle();
            return;
        }
        if (resource == null) {
            this.onLoadFailed(exception);
            return;
        }
        this.onLoadComplete(resource);
    }

    static interface EngineRunnableManager
    extends ResourceCallback {
        public void submitForSource(EngineRunnable var1);
    }

    private static enum Stage {
        CACHE,
        SOURCE;

    }
}

