/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

@TargetApi(value=19)
public class SizeConfigStrategy
implements LruPoolStrategy {
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS;
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS;
    private final GroupedLinkedMap<Key, Bitmap> groupedMap;
    private final KeyPool keyPool = new KeyPool();
    private final Map<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes;

    static {
        ARGB_8888_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, null};
        RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
        ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
        ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    }

    public SizeConfigStrategy() {
        this.groupedMap = new GroupedLinkedMap();
        this.sortedSizes = new HashMap<Bitmap.Config, NavigableMap<Integer, Integer>>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decrementBitmapOfSize(Integer n2, Bitmap.Config object) {
        NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig((Bitmap.Config)object);
        if ((Integer)(object = (Integer)navigableMap.get(n2)) == 1) {
            navigableMap.remove(n2);
            return;
        }
        navigableMap.put(n2, (Integer)object - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Key findBestKey(Key key, int n2, Bitmap.Config config) {
        Bitmap.Config[] configArray = SizeConfigStrategy.getInConfigs(config);
        int n3 = configArray.length;
        int n4 = 0;
        while (true) {
            Key key2 = key;
            if (n4 >= n3) return key2;
            Bitmap.Config config2 = configArray[n4];
            Integer n5 = this.getSizesForConfig(config2).ceilingKey(n2);
            if (n5 != null && n5 <= n2 * 8) {
                if (n5 == n2) {
                    if (config2 == null) {
                        key2 = key;
                        if (config == null) return key2;
                    } else {
                        key2 = key;
                        if (config2.equals((Object)config)) return key2;
                    }
                }
                this.keyPool.offer(key);
                return this.keyPool.get(n5, config2);
            }
            ++n4;
        }
    }

    private static String getBitmapString(int n2, Bitmap.Config config) {
        return "[" + n2 + "](" + config + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap.Config[] getInConfigs(Bitmap.Config configArray) {
        switch (1.$SwitchMap$android$graphics$Bitmap$Config[configArray.ordinal()]) {
            default: {
                Bitmap.Config[] configArray2 = new Bitmap.Config[]{configArray};
                return configArray2;
            }
            case 1: {
                return ARGB_8888_IN_CONFIGS;
            }
            case 2: {
                return RGB_565_IN_CONFIGS;
            }
            case 3: {
                return ARGB_4444_IN_CONFIGS;
            }
            case 4: 
        }
        return ALPHA_8_IN_CONFIGS;
    }

    private NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        NavigableMap<Integer, Integer> navigableMap;
        NavigableMap<Integer, Integer> navigableMap2 = navigableMap = this.sortedSizes.get(config);
        if (navigableMap == null) {
            navigableMap2 = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(config, navigableMap2);
        }
        return navigableMap2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config object) {
        int n4 = Util.getBitmapByteSize((int)n2, (int)n3, (Bitmap.Config)object);
        Key key = this.findBestKey(this.keyPool.get(n4, (Bitmap.Config)object), n4, (Bitmap.Config)object);
        Bitmap bitmap = this.groupedMap.get(key);
        if (bitmap != null) {
            void var3_6;
            this.decrementBitmapOfSize(Util.getBitmapByteSize((Bitmap)bitmap), bitmap.getConfig());
            if (bitmap.getConfig() != null) {
                Bitmap.Config config = bitmap.getConfig();
            } else {
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
            }
            bitmap.reconfigure(n2, n3, (Bitmap.Config)var3_6);
        }
        return bitmap;
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize((Bitmap)bitmap);
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize((int)n2, (int)n3, (Bitmap.Config)config), config);
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize((Bitmap)bitmap), bitmap.getConfig());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void put(Bitmap object) {
        int n2 = Util.getBitmapByteSize((Bitmap)object);
        Key key = this.keyPool.get(n2, object.getConfig());
        this.groupedMap.put(key, (Bitmap)object);
        object = this.getSizesForConfig(object.getConfig());
        Integer n3 = (Integer)object.get(key.size);
        int n4 = key.size;
        n2 = n3 == null ? 1 : n3 + 1;
        object.put(n4, n2);
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize((Bitmap)bitmap), bitmap.getConfig());
        }
        return bitmap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("SizeConfigStrategy{groupedMap=").append(this.groupedMap).append(", sortedSizes=(");
        for (Map.Entry<Bitmap.Config, NavigableMap<Integer, Integer>> entry : this.sortedSizes.entrySet()) {
            stringBuilder.append(entry.getKey()).append('[').append(entry.getValue()).append("], ");
        }
        if (!this.sortedSizes.isEmpty()) {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        }
        return stringBuilder.append(")}").toString();
    }

    static final class Key
    implements Poolable {
        private Bitmap.Config config;
        private final KeyPool pool;
        private int size;

        public Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        Key(KeyPool keyPool, int n2, Bitmap.Config config) {
            this(keyPool);
            this.init(n2, config);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = false;
            if (!(object instanceof Key)) return bl2;
            object = (Key)object;
            bl2 = bl;
            if (this.size != ((Key)object).size) return bl2;
            if (this.config == null) {
                bl2 = bl;
                if (((Key)object).config != null) return bl2;
                return true;
            }
            bl2 = bl;
            if (!this.config.equals((Object)((Key)object).config)) return bl2;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            int n3 = this.size;
            if (this.config != null) {
                n2 = this.config.hashCode();
                return n2 + n3 * 31;
            }
            n2 = 0;
            return n2 + n3 * 31;
        }

        public void init(int n2, Bitmap.Config config) {
            this.size = n2;
            this.config = config;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeConfigStrategy.getBitmapString(this.size, this.config);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        public Key get(int n2, Bitmap.Config config) {
            Key key = (Key)this.get();
            key.init(n2, config);
            return key;
        }
    }
}

