/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.util.Log;
import com.bumptech.glide.disklrucache.DiskLruCache;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskCacheWriteLocker;
import com.bumptech.glide.load.engine.cache.SafeKeyGenerator;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheWrapper
implements DiskCache {
    private static final int APP_VERSION = 1;
    private static final String TAG = "DiskLruCacheWrapper";
    private static final int VALUE_COUNT = 1;
    private static DiskLruCacheWrapper wrapper = null;
    private final File directory;
    private DiskLruCache diskLruCache;
    private final int maxSize;
    private final SafeKeyGenerator safeKeyGenerator;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();

    protected DiskLruCacheWrapper(File file, int n2) {
        this.directory = file;
        this.maxSize = n2;
        this.safeKeyGenerator = new SafeKeyGenerator();
    }

    public static DiskCache get(File object, int n2) {
        synchronized (DiskLruCacheWrapper.class) {
            if (wrapper == null) {
                DiskLruCacheWrapper diskLruCacheWrapper;
                wrapper = diskLruCacheWrapper = new DiskLruCacheWrapper((File)object, n2);
            }
            object = wrapper;
            return object;
        }
    }

    private DiskLruCache getDiskCache() throws IOException {
        synchronized (this) {
            if (this.diskLruCache == null) {
                this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
            }
            DiskLruCache diskLruCache = this.diskLruCache;
            return diskLruCache;
        }
    }

    private void resetDiskCache() {
        synchronized (this) {
            this.diskLruCache = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clear() {
        synchronized (this) {
            block4: {
                try {
                    this.getDiskCache().delete();
                    this.resetDiskCache();
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block4;
                    Log.w((String)TAG, (String)"Unable to clear disk cache", (Throwable)iOException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(Key object) {
        object = this.safeKeyGenerator.getSafeKey((Key)object);
        try {
            this.getDiskCache().remove((String)object);
            return;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable((String)TAG, (int)5)) return;
            Log.w((String)TAG, (String)"Unable to delete from disk cache", (Throwable)iOException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public File get(Key object) {
        DiskLruCache.Value value;
        object = this.safeKeyGenerator.getSafeKey((Key)object);
        Object var2_2 = null;
        try {
            value = this.getDiskCache().get((String)object);
            object = var2_2;
            if (value == null) return object;
        }
        catch (IOException iOException) {
            object = var2_2;
            if (!Log.isLoggable((String)TAG, (int)5)) return object;
            Log.w((String)TAG, (String)"Unable to get from disk cache", (Throwable)iOException);
            return var2_2;
        }
        return value.getFile(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(Key key, DiskCache.Writer writer) {
        block12: {
            block10: {
                Object object;
                block11: {
                    object = this.safeKeyGenerator.getSafeKey(key);
                    this.writeLocker.acquire(key);
                    object = this.getDiskCache().edit((String)object);
                    if (object == null) break block10;
                    try {
                        if (!writer.write(((DiskLruCache.Editor)object).getFile(0))) break block11;
                        ((DiskLruCache.Editor)object).commit();
                    }
                    catch (Throwable throwable) {
                        try {
                            ((DiskLruCache.Editor)object).abortUnlessCommitted();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            if (!Log.isLoggable((String)TAG, (int)5)) break block12;
                            Log.w((String)TAG, (String)"Unable to put to disk cache", (Throwable)iOException);
                            return;
                        }
                    }
                }
                ((DiskLruCache.Editor)object).abortUnlessCommitted();
            }
            this.writeLocker.release(key);
        }
        return;
        finally {
            this.writeLocker.release(key);
            return;
        }
    }
}

