/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.util.Util;

public class BitmapResource
implements Resource<Bitmap> {
    private final Bitmap bitmap;
    private final BitmapPool bitmapPool;

    public BitmapResource(Bitmap bitmap, BitmapPool bitmapPool) {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap must not be null");
        }
        if (bitmapPool == null) {
            throw new NullPointerException("BitmapPool must not be null");
        }
        this.bitmap = bitmap;
        this.bitmapPool = bitmapPool;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BitmapResource obtain(Bitmap object, BitmapPool bitmapPool) {
        void var1_4;
        void var0_2;
        if (object == null) {
            return var0_2;
        }
        BitmapResource bitmapResource = new BitmapResource((Bitmap)object, (BitmapPool)var1_4);
        return var0_2;
    }

    @Override
    public Bitmap get() {
        return this.bitmap;
    }

    @Override
    public int getSize() {
        return Util.getBitmapByteSize((Bitmap)this.bitmap);
    }

    @Override
    public void recycle() {
        if (!this.bitmapPool.put(this.bitmap)) {
            this.bitmap.recycle();
        }
    }
}

